/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.license.com;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.serverux.dataimpl.PPKget1PPInfo;
import sanproject.serverux.dataimpl.PPKgetKeyDetail;
import sanproject.serverux.dataimpl.PPKretFile;
import sanproject.serverux.dataimpl.SetPPKFileInstall;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.com.SJcConst;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrPPLicenseUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.wizard.license.com.SJctr1PPInfo;
import sanproject.sn2.controller.wizard.license.com.SJctrGetKeyFileResult;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.data.SJmoThroughRmiData;

public class SJctrFileInstallCheckExecute {
    private static final String LICENSE_FILE_PATH = "c:\\dkc200\\home\\java\\";
    private String randomFileName = null;
    private String orgFileName = null;
    private String sessionIDPath = null;
    private PPKget1PPInfo[] ppInfoArray = null;
    private List<SJctr1PPInfo> updateList = null;
    private List<SJctr1PPInfo> errorList = null;
    protected PPKget1PPInfo[] resultArray = null;
    private Map<String, Integer> befStatusMap = null;

    public SJctrFileInstallCheckExecute(String randomFileName, String orgFileName, PPKget1PPInfo[] ppInfoArray) {
        this.randomFileName = randomFileName;
        this.orgFileName = orgFileName;
        this.ppInfoArray = ppInfoArray;
        this.befStatusMap = new HashMap<String, Integer>(ppInfoArray.length);
        for (int index = 0; index < ppInfoArray.length; ++index) {
            PPKget1PPInfo ppInfo = ppInfoArray[index];
            this.befStatusMap.put(ppInfo.getPPID(), ppInfo.getStatus());
        }
    }

    public void execute(SJctrDataController dc) {
        this.createSessionIDPath(dc.getOwner());
        this.uploadFile();
        SetPPKFileInstall input = this.makeInputData();
        SJctrGetKeyFileResult kind = new SJctrGetKeyFileResult(input);
        SJmoGetRange_IF range = null;
        List filterList = null;
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        SJctrGetDirectWrapper wrapper = new SJctrGetDirectWrapper(direct, false);
        SJmoThroughRmiData rmiObj = null;
        SJctrPPLicenseUtility.setAuditUserInfo(dc.getOwner());
        try {
            rmiObj = (SJmoThroughRmiData)dc.getModelData(wrapper).get(0);
        }
        catch (Exception exp) {
            SJctrError error = SJctrError.parseError(exp);
            throw error.createException();
        }
        finally {
            this.deleteFile();
            SJctrPPLicenseUtility.modifyUnLock();
        }
        PPKretFile output = (PPKretFile)rmiObj.getObjRmi();
        int err = output.nErrLineCode;
        if (err != 0) {
            SJctrError error = new SJctrError(4, 5, err);
            SJcException exp = error.createException();
            throw exp;
        }
        PPKgetKeyDetail ppkeyDtl = output.ppkgetdetail;
        this.setResult(ppkeyDtl);
    }

    private void setResult(PPKgetKeyDetail retPPKDtl) {
        PPKget1PPInfo[] ppInfoArray = retPPKDtl.getPPKget1PPInfo();
        int ppNum = ppInfoArray.length;
        this.updateList = new ArrayList<SJctr1PPInfo>(ppNum);
        this.errorList = new ArrayList<SJctr1PPInfo>(ppNum);
        for (int index = 0; index < ppNum; ++index) {
            PPKget1PPInfo ppInfo = ppInfoArray[index];
            if (ppInfo.getPreInstall() == 0) {
                int befStatus = this.befStatusMap.get(ppInfo.getPPID());
                if (ppInfo.getUpdate() == 1 || ppInfo.getStatus() != befStatus) {
                    SJctr1PPInfo updateInfo = new SJctr1PPInfo(ppInfo);
                    updateInfo.nUpdate = 0;
                    updateInfo.nErrCode = 0;
                    this.updateList.add(updateInfo);
                }
                if (ppInfo.getErrCode() != 0) {
                    this.errorList.add(new SJctr1PPInfo(ppInfo));
                }
            }
            ppInfo.nUpdate = 0;
            ppInfo.nErrCode = 0;
        }
        this.resultArray = ppInfoArray;
    }

    public PPKget1PPInfo[] getResultArray() {
        return this.resultArray;
    }

    public List<SJctr1PPInfo> getUpDateList() {
        return this.updateList;
    }

    public List<SJctr1PPInfo> getErrorList() {
        return this.errorList;
    }

    private SetPPKFileInstall makeInputData() {
        SetPPKFileInstall ret = new SetPPKFileInstall();
        ret.strFileName = this.sessionIDPath + this.orgFileName;
        ret.nNumOf1PPInfo = this.getPPNum();
        ret.ppkget1ppinfo = this.ppInfoArray;
        return ret;
    }

    private void uploadFile() {
        SJcFileUty.copyInternalToExternal(SJcConst.FILE_UPLOAD_DIRECTORY, new String[]{this.randomFileName}, LICENSE_FILE_PATH, new String[]{this.sessionIDPath + this.orgFileName});
    }

    public void deleteFile() {
        String filePath = LICENSE_FILE_PATH + this.sessionIDPath;
        File delFolder = new File(filePath);
        if (delFolder.exists()) {
            File[] files = delFolder.listFiles();
            for (int index = 0; index < files.length; ++index) {
                files[index].delete();
            }
            delFolder.delete();
        }
    }

    protected int getPPNum() {
        int num = 0;
        for (int index = 0; index < this.ppInfoArray.length && this.ppInfoArray[index] != null; ++index) {
            ++num;
        }
        return num;
    }

    private void createSessionIDPath(SJctrUserController uc) {
        StringBuffer buf = new StringBuffer();
        SJbaseUserSessionInterface userSession = uc.getUserSession();
        int sessionID = userSession.getSessionIdentificationID();
        buf.append(sessionID);
        buf.append("\\");
        this.sessionIDPath = buf.toString();
    }
}

