/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.createaltpaths;

import java.util.ArrayList;
import java.util.List;
import sanproject.common.Robj_interface_RJiWWN;
import sanproject.serverux.dataimpl.AddHostgroup;
import sanproject.serverux.dataimpl.AddLUPath;
import sanproject.serverux.dataimpl.AddWWN;
import sanproject.serverux.dataimpl.RJiWWN;
import sanproject.serverux.dataimpl.SanRmiInputInterface;
import sanproject.serverux.dataimpl.SetHostMode;
import sanproject.sn2.controller.com.SJctrApplyController;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.lu.SJmoPortLunInfo;
import sanproject.sn2.model.data.lu.SJmoWwn;

public class SJctrCreateAltPathsAC
extends SJctrApplyController {
    private static final int LUNM_BASE_TIME = 30;
    private static final int CHECK_TIME = 5;
    private static final double COEFFICIENT = 0.003;
    private boolean noWWNFlg = true;
    List<SJmoPortHostGroupInfo> portHostGroupList = new ArrayList<SJmoPortHostGroupInfo>();
    List<SJmoPortLunInfo> portLunList = new ArrayList<SJmoPortLunInfo>();

    public void setApplyList(List<SJmoPortHostGroupInfo> portHostGroupList, List<SJmoPortLunInfo> portLunList) {
        this.portHostGroupList = portHostGroupList;
        this.portLunList = portLunList;
    }

    @Override
    public ArrayList<?> getSetList() {
        ArrayList<AddHostgroup> addHostgroupList = new ArrayList<AddHostgroup>(this.portHostGroupList.size() * SJctrPortUtility.PORT_HOSTGROUP_MAX);
        ArrayList<SetHostMode> setHostModeList = new ArrayList<SetHostMode>(this.portHostGroupList.size() * SJctrPortUtility.PORT_HOSTGROUP_MAX);
        ArrayList<AddWWN> addWWNList = new ArrayList<AddWWN>(this.portHostGroupList.size() * SJctrPortUtility.PORT_HOSTGROUP_MAX);
        ArrayList<AddLUPath> addLUPathList = new ArrayList<AddLUPath>(this.portHostGroupList.size() * SJctrPortUtility.PORT_HOSTGROUP_MAX * this.portLunList.size());
        for (SJmoPortHostGroupInfo portHostGroup : this.portHostGroupList) {
            ArrayList portLunDetailList;
            ArrayList hostGroupList = portHostGroup.getAlPortHostGroup();
            if (hostGroupList.size() == 0) continue;
            SJmoHostGroupInfo hostGroup = (SJmoHostGroupInfo)hostGroupList.get(0);
            AddHostgroup addHostgroup = this.createAddHostgroup(portHostGroup, hostGroup);
            addHostgroupList.add(addHostgroup);
            SetHostMode setHostMode = this.createSetHostMode(portHostGroup, hostGroup);
            setHostModeList.add(setHostMode);
            AddWWN addWWN = this.createAddWWN(portHostGroup, hostGroup);
            addWWNList.add(addWWN);
            if (this.portLunList.size() != 0) {
                SJmoPortLunInfo portLunInfo = this.portLunList.get(0);
                portLunDetailList = portLunInfo.getAlPortLun();
            } else {
                portLunDetailList = new ArrayList();
            }
            for (Object lunDetailObj : portLunDetailList) {
                SJmoPortLunDetail lunDetail = (SJmoPortLunDetail)lunDetailObj;
                AddLUPath addLUPath = this.createAddLUPath(portHostGroup, hostGroup, lunDetail);
                addLUPathList.add(addLUPath);
            }
        }
        int applySize = addHostgroupList.size() + setHostModeList.size() + addWWNList.size() + addLUPathList.size();
        ArrayList<SanRmiInputInterface> applyList = new ArrayList<SanRmiInputInterface>(applySize);
        applyList.addAll(addHostgroupList);
        applyList.addAll(setHostModeList);
        if (this.noWWNFlg) {
            applyList.addAll(addWWNList);
        }
        applyList.addAll(addLUPathList);
        return applyList;
    }

    private AddHostgroup createAddHostgroup(SJmoPortHostGroupInfo portHostGroup, SJmoHostGroupInfo hostGroup) {
        AddHostgroup addHostgroup = new AddHostgroup();
        addHostgroup.setSPort(portHostGroup.getSPort());
        addHostgroup.setSHostgroupID(hostGroup.getSHostGroup());
        addHostgroup.setStrHostgroupNickName(hostGroup.getStrHostgroupNickName());
        return addHostgroup;
    }

    private SetHostMode createSetHostMode(SJmoPortHostGroupInfo portHostGroup, SJmoHostGroupInfo hostGroup) {
        SetHostMode setHostMode = new SetHostMode();
        setHostMode.setSPort(portHostGroup.getSPort());
        setHostMode.setSHostgroupID(hostGroup.getSHostGroup());
        setHostMode.setByHostMode(hostGroup.getByHostMode());
        setHostMode.setBtOption(hostGroup.getBtOption());
        return setHostMode;
    }

    private AddWWN createAddWWN(SJmoPortHostGroupInfo portHostGroup, SJmoHostGroupInfo hostGroup) {
        AddWWN addWWN = new AddWWN();
        addWWN.setSPort(portHostGroup.getSPort());
        addWWN.setSHostgroupID(hostGroup.getSHostGroup());
        ArrayList alHostGroupWwn = hostGroup.getAlHostGroupWwn();
        if (alHostGroupWwn.size() == 0) {
            this.noWWNFlg = false;
            return addWWN;
        }
        Robj_interface_RJiWWN[] rjiWwnList = new Robj_interface_RJiWWN[alHostGroupWwn.size()];
        for (int i = 0; i < alHostGroupWwn.size(); ++i) {
            SJmoWwn wwn = (SJmoWwn)alHostGroupWwn.get(i);
            rjiWwnList[i] = new RJiWWN();
            rjiWwnList[i].setByWWN(wwn.getByWWN());
            rjiWwnList[i].setStrWWNNickName(wwn.getStrWWNNickName());
        }
        addWWN.setObjWWN(rjiWwnList);
        return addWWN;
    }

    private AddLUPath createAddLUPath(SJmoPortHostGroupInfo portHostGroup, SJmoHostGroupInfo hostGroup, SJmoPortLunDetail lunDetail) {
        AddLUPath addLUPath = new AddLUPath();
        addLUPath.setSPort(portHostGroup.getSPort());
        addLUPath.setSHostGroup(hostGroup.getSHostGroup());
        addLUPath.setSLUN(lunDetail.getSLUN());
        addLUPath.setSLDKC(lunDetail.getSLDKC());
        addLUPath.setSCU(lunDetail.getSCU());
        addLUPath.setSLDEV(lunDetail.getSLDEV());
        return addLUPath;
    }

    @Override
    public int getLeadTime() {
        ArrayList<?> applylist = this.getSetList();
        double leadtime = 30.0 + (double)applylist.size() * 0.003 + 5.0;
        leadtime = Math.ceil(leadtime);
        return (int)leadtime;
    }
}

