/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.edithostiscsi;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrApplyController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrIscsiOperationError;
import sanproject.sn2.datasupplier.SJdsSupplierAgent;
import sanproject.sn2.model.data.lu.SJmoIscsiName;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;
import sanproject.sn2.model.inf.SJmoKeyValueDefine_IF;

public class SJctrEditHostIscsiAC
extends SJctrApplyController
implements SJmoKeyValueDefine_IF {
    private static final int LUNM_BASE_TIME = 30;
    private static final double COEFFICIENT = 0.003;
    List<SJmoIscsiName> iscsiNameList = new ArrayList<SJmoIscsiName>();
    public List<SJmoPortIscsiTargetInfo> portHgKey;
    String newIscsiName = "?";
    private Map<Short, Map<String, SJctrError>> portHostErrorMap = null;
    protected SJctrError representativeError = null;
    List<SJctrError> resultData = null;
    SanResponse result = null;

    public void setApplyList(List<SJmoIscsiName> iscsiNameList, List<SJmoPortIscsiTargetInfo> portHgKey) {
        this.iscsiNameList = iscsiNameList;
        this.portHgKey = portHgKey;
    }

    @Override
    public ArrayList<?> getSetList() {
        ArrayList applyList = new ArrayList(1);
        return applyList;
    }

    @Override
    protected void applyStart(SJdsSupplierAgent supplier) {
        if (supplier == null) {
            SJctrLogUty.info(this.title, "applyStart", "SJdsSupplierAgent is null.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        try {
            SJctrLogUty.info(this.title, "applyStart", "make SanTequest.");
            SanRequest requestIscsiNameData = supplier.newRequest("LUNMupdateiScsiName");
            SanRequest requestNickNameData = supplier.newRequest("LUNMupdateiScsiNickName");
            SanList reqPortList = requestIscsiNameData.newList("iScsiPorts");
            SanList reqPortNickList = requestNickNameData.newList("iScsiPorts");
            for (SJmoPortIscsiTargetInfo portIscsiTarget : this.portHgKey) {
                SJctrLogUty.info(this.title, "applyStart", "inner loop iScsiPorts.");
                SanObject portsParam = reqPortList.addObj();
                SanObject portsNickParam = reqPortNickList.addObj();
                portsParam.putInt("Id", (int)portIscsiTarget.getSPort());
                portsNickParam.putInt("Id", (int)portIscsiTarget.getSPort());
                SanList iScsiNames = portsParam.newList("RemoteiScsiNames");
                SanList iScsiNickNames = portsNickParam.newList("RemoteiScsiNames");
                for (SJmoIscsiTargetInfo iscsiTarget : portIscsiTarget.getAlPortIscsiTarget()) {
                    SJctrLogUty.info(this.title, "applyStart", "inner loop RemoteiScsiNames.");
                    int index = 0;
                    for (SJmoIscsiName addHostsData : iscsiTarget.getAlIscsiName()) {
                        SJctrLogUty.info(this.title, "applyStart", "inner loop RemoteiScsiNames.");
                        SanObject iscsiNameParam = iScsiNames.addObj();
                        iscsiNameParam.putString("Name", this.iscsiNameList.get(index).getStrIscsiName());
                        iscsiNameParam.putString("ChangeName", addHostsData.getStrIscsiName());
                        SJctrLogUty.info(this.title, "applyStart", "iScsiNameParam - Name   : " + this.iscsiNameList.get(index).getStrIscsiName());
                        SJctrLogUty.info(this.title, "applyStart", "iScsiNameParam - Change : " + addHostsData.getStrIscsiName());
                        SanObject iscsiNickNameParam = iScsiNickNames.addObj();
                        iscsiNickNameParam.putString("Name", this.iscsiNameList.get(index).getStrIscsiName());
                        iscsiNickNameParam.putString("NickName", addHostsData.getStrIscsiNickName());
                        SJctrLogUty.info(this.title, "applyStart", "iScsiNickNameParam - Name     : " + this.iscsiNameList.get(index).getStrIscsiName());
                        SJctrLogUty.info(this.title, "applyStart", "iScsiNickNameParam - Nickname : " + addHostsData.getStrIscsiNickName());
                        ++index;
                    }
                }
            }
            ArrayList<SanRequest> applyList2 = new ArrayList<SanRequest>(1);
            applyList2.add(requestNickNameData);
            SJctrLogUty.info(this.title, "applyStart", "Apply Start!! (LUNMupdateiScsiNickName)");
            Object resultObject2 = supplier.applyStart(this.getLockId(), applyList2);
            SJctrLogUty.info(this.title, "applyStart", "Apply End!! (LUNMupdateiScsiNickName)");
            this.getMapPortError(resultObject2);
            ArrayList<SanRequest> applyList = new ArrayList<SanRequest>(1);
            applyList.add(requestIscsiNameData);
            SJctrLogUty.info(this.title, "applyStart", "Apply Start!! (LUNMupdateiScsiName)");
            Object resultObject = supplier.applyStart(this.getLockId(), applyList);
            SJctrLogUty.info(this.title, "applyStart", "Apply End!! (LUNMupdateiScsiName)");
            this.getMapPortError(resultObject);
            this.setApplyResult();
        }
        catch (SJcException se) {
            SJctrLogUty.error(this.title, "applyStart", "SJcException occurred. " + se.getMessage());
            SJctrError error = SJctrError.parseError(se);
            this.setError(error);
        }
        catch (SanDataException sdEx) {
            SJctrLogUty.error(this.title, "applyStart", "The Key-Value interfacd error occurred. " + sdEx.getMessage());
            SJctrError error = SJctrError.parseError((Exception)((Object)sdEx));
            this.setError(error);
        }
        catch (Exception e) {
            SJctrLogUty.info(this.title, "applyStart", "exception", e);
            SJctrError error = SJctrError.parseError(e);
            this.setError(error);
        }
    }

    @Override
    protected List<SJctrError> getResultData() {
        return this.resultData;
    }

    @Override
    public int getLeadTime() {
        ArrayList<?> applylist = this.getSetList();
        double leadtime = 30.0 + (double)applylist.size() * 0.003;
        leadtime = Math.ceil(leadtime);
        return (int)leadtime;
    }

    private void getMapPortError(Object resultObject) throws SanDataException {
        SanList iScsiTargetList;
        SanObject repErrorInfo;
        int[] errMsgId;
        if (!(resultObject instanceof SanResponse)) {
            SJcException error = SJctrIscsiUtility.makeException(107001);
            throw error;
        }
        SanResponse responseData = (SanResponse)resultObject;
        if (this.representativeError == null && 0 != (errMsgId = (repErrorInfo = responseData.getObj("ErrorInfo")).getIntArray("MessageId"))[1]) {
            this.representativeError = new SJctrIscsiOperationError(errMsgId);
        }
        if ((iScsiTargetList = responseData.getList("iScsiPorts")) == null) {
            SJctrLogUty.error(this.title, "getMapPort", "No iScsiTargets.");
            return;
        }
        if (this.portHostErrorMap == null) {
            this.portHostErrorMap = new HashMap<Short, Map<String, SJctrError>>(iScsiTargetList.size());
        }
        for (SanObject iScsiPort : iScsiTargetList) {
            SanList iScsiNameList = iScsiPort.getList("RemoteiScsiNames");
            short portId = (short)iScsiPort.getInt("Id");
            Map<String, SJctrError> errorMap = this.portHostErrorMap.get(portId);
            if (errorMap == null) {
                errorMap = new HashMap<String, SJctrError>(iScsiNameList.size());
                this.portHostErrorMap.put(portId, errorMap);
            }
            for (SanObject iScsiName : iScsiNameList) {
                String strName = iScsiName.getString("Name");
                SJctrError error = errorMap.get(strName);
                if (error != null && error.getError() != 0) continue;
                SanObject errInfo = iScsiName.getObj("ErrorInfo");
                int[] errMsgId2 = errInfo.getIntArray("MessageId");
                SJctrIscsiOperationError iscsiError = new SJctrIscsiOperationError(errMsgId2);
                errorMap.put(strName, iscsiError);
            }
        }
    }

    protected void setApplyResult() {
        super.setApplyResult(null);
        if (this.representativeError != null) {
            this.setError(this.representativeError);
        } else {
            this.setError(SJctrIscsiUtility.makeError(0));
        }
        if (!this.portHostErrorMap.isEmpty()) {
            this.resultData = new ArrayList<SJctrError>(this.iscsiNameList.size());
            for (SJmoIscsiName iSCSINameInfo : this.iscsiNameList) {
                Map<String, SJctrError> errorMap = this.portHostErrorMap.get(iSCSINameInfo.getSPort());
                String iSCSIName = iSCSINameInfo.getStrIscsiName();
                SJctrError error = errorMap.get(iSCSIName);
                this.resultData.add(error);
            }
        }
    }

    @Override
    public boolean hasApplyResult() {
        boolean rtn = false;
        if (this.resultData != null && this.resultData.size() > 0) {
            rtn = true;
        }
        return rtn;
    }
}

