/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.editports;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.com.utility.account.SJcRoleResourceContainer;
import sanproject.sn2.controller.com.SJctrAuthorizeContainer;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLicenseContainer;
import sanproject.sn2.controller.com.SJctrMessageDataController;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrCheckBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.lunm.com.SJctrBaseCheckRadioEnableDisableDataModel;
import sanproject.sn2.controller.wizard.lunm.com.SJctrBaseCheckRadioOnOffDataModel;
import sanproject.sn2.controller.wizard.lunm.editports.SJctrChannelSpeedDataModel;
import sanproject.sn2.controller.wizard.lunm.editports.SJctrEditPortsData;
import sanproject.sn2.controller.wizard.lunm.editports.SJctrEditPortsKindAC;
import sanproject.sn2.controller.wizard.lunm.editports.SJctrEditPortsSelectData;
import sanproject.sn2.controller.wizard.lunm.editports.SJctrFibreAddressDataModel;
import sanproject.sn2.controller.wizard.lunm.editports.SJctrPortAttributeDataModel;
import sanproject.sn2.controller.wizard.lunm.editports.SJctrPortConnectionDataModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetChaDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortAttributeInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortHostGroupInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.device.SJmoChaDetail;
import sanproject.sn2.model.data.device.SJmoPortAttributeInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;

public class SJctrEditPortsDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 0x1100131;
    private static final String KEY_ATTRIBUTEINF = "COM_ATTRIBUTEINF";
    private static final String KEY_SECURITYINF = "COM_SECURITYINF";
    private static final String KEY_SECURITY = "COM_SECURITY";
    private static final String KEY_SPEEDINF = "COM_SPEEDINF";
    private static final String KEY_ADDRESSINF = "COM_ADDRESSINF";
    private static final String KEY_FCSWITCHINF = "COM_FCSWITCHINF";
    private static final String KEY_FCSWITCH = "COM_FCSWITCH";
    private static final String KEY_CONNECTIONINF = "COM_CONNECTIONINF";
    public static final String TITLE = "DISP_DI13S_TITLE";
    List<SJmoPortAttributeInfo> targetPortAttributeInfoList = new ArrayList<SJmoPortAttributeInfo>();
    List<SJmoPortDetail> targetPortDetailList = new ArrayList<SJmoPortDetail>();
    SJctrPortUtility portUtil = null;
    SJctrPortAttributeDataModel portAttributeDataModel = null;
    SJctrBaseCheckRadioEnableDisableDataModel portSecurityDataModel = null;
    SJctrChannelSpeedDataModel channelSpeedDataModel = null;
    SJctrFibreAddressDataModel fibreAddressDataModel = null;
    SJctrBaseCheckRadioOnOffDataModel fcSwitchDataModel = null;
    SJctrPortConnectionDataModel portConnectionDataModel = null;
    List<SJmoChaDetail> modelChaDetailList = null;
    HashMap<Short, SJmoChaDetail> portchaDataMap = null;
    HashSet<String> notDisplayChannelSpeedMap = null;
    public static final String KEY_TABLE = "COM_TABLE";
    private boolean fcoeFlg = false;
    public static final String GUIDE_DISPLAY_ID_LUNM = "LUNM";
    public static final String CHKBOX_GUIDE_SECURITY = "DISP_PORT_SECURITY";
    public static final String CHKBOX_GUIDE_FC_SWITCH = "DISP_FC_SWITCH";
    public static int EDITPORTS_ERR1 = 107003;
    public static int EDITPORTS_ERR2 = 106501;
    public static int EDITPORTS_ERR3 = 105077;
    public static int EDITPORTS_ERR4 = 105079;
    public static int EDITPORTS_ERR_LUN_EXISTS = 105080;
    public static int EDITPORTS_ERR6 = 105081;
    public static int EDITPORTS_ERR8 = 105204;
    public static int EDITPORTS_ERR9 = 106073;
    public static int EDITPORTS_ERR10 = 106074;
    public static int EDITPORTS_ERR11 = 105252;
    public static int EDITPORTS_ERR12 = 105253;
    public static int EDITPORTS_ERR13 = 107002;
    public static int EDITPORTS_ERR14 = 105296;
    public static int EDITPORTS_ERR_16G_FCAL = 205019;
    public static int EDITPORTS_ERR_32G_FCAL = 205230;
    public static int EDITPORTS_ERR_vPort = 205166;
    SJctrDataController parentDC = null;
    SJctrTableDataModel parentTbl = null;

    public SJctrEditPortsDC() throws SJcException {
        super(0x1100131);
        this.initDataModel();
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance(GUIDE_DISPLAY_ID_LUNM, TITLE);
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_ATTRIBUTEINF, new SJctrPortAttributeDataModel());
        SJctrBaseCheckRadioEnableDisableDataModel radioEnableDisable = new SJctrBaseCheckRadioEnableDisableDataModel(KEY_SECURITY);
        radioEnableDisable.setGuidance(GUIDE_DISPLAY_ID_LUNM, CHKBOX_GUIDE_SECURITY);
        this.addDataObjectModel(KEY_SECURITYINF, radioEnableDisable);
        this.addDataObjectModel(KEY_SPEEDINF, new SJctrChannelSpeedDataModel());
        this.addDataObjectModel(KEY_ADDRESSINF, new SJctrFibreAddressDataModel());
        SJctrBaseCheckRadioOnOffDataModel radioOnOff = new SJctrBaseCheckRadioOnOffDataModel(KEY_FCSWITCH);
        radioOnOff.setGuidance(GUIDE_DISPLAY_ID_LUNM, CHKBOX_GUIDE_FC_SWITCH);
        this.addDataObjectModel(KEY_FCSWITCHINF, radioOnOff);
        this.addDataObjectModel(KEY_CONNECTIONINF, new SJctrPortConnectionDataModel());
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    @Override
    public void makeDataModel() {
        super.makeDataModel();
        SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel("COM_FOOTER");
        SJctrButtonDataModel finishButton = footer.getFooterButtonObject(SJctrFooterDataModel.Button.FINISH);
        finishButton.setChangeCheck(false);
    }

    @Override
    public boolean checkStartData() {
        List<?> dat = this.getCache(SJctrEditPortsSelectData.class);
        if (dat == null) {
            SJctrError err = new SJctrError(10, 22, EDITPORTS_ERR1);
            SJcException exp = err.createException();
            throw exp;
        }
        if (dat.size() == 0) {
            SJctrError err = new SJctrError(10, 22, EDITPORTS_ERR1);
            SJcException exp = err.createException();
            throw exp;
        }
        Object selectObj = null;
        selectObj = dat.get(0);
        if (!(selectObj instanceof SJctrEditPortsSelectData)) {
            SJctrError err = new SJctrError(10, 22, EDITPORTS_ERR1);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrEditPortsSelectData selectData = null;
        selectData = selectObj;
        List<SJmoPortIndex> portIndexList = selectData.getPortIndexList();
        if (portIndexList == null) {
            SJctrError err = new SJctrError(10, 22, EDITPORTS_ERR1);
            SJcException exp = err.createException();
            throw exp;
        }
        if (portIndexList.size() == 0) {
            SJctrError err = new SJctrError(10, 22, EDITPORTS_ERR1);
            SJcException exp = err.createException();
            throw exp;
        }
        return true;
    }

    @Override
    public boolean checkConstructData() {
        SJctrErrorColumnData errData;
        SJctrError err;
        boolean result = true;
        SJctrError errInfo = null;
        this.parentDC = this.getWizardWindow().getParentDC();
        this.parentTbl = (SJctrTableDataModel)this.parentDC.getDataObjectModel(KEY_TABLE);
        List<?> rsgDetailList = this.getCache(SJmoGetRSGgetAllRsgs.class);
        if (rsgDetailList == null || rsgDetailList.size() == 0) {
            SJctrError err2 = new SJctrError(10, 22, EDITPORTS_ERR13);
            SJcException exp = err2.createException();
            throw exp;
        }
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), (SJmoRSGgetAllRsgs)rsgDetailList.get(0));
        List<?> dat = this.getCache(SJctrEditPortsSelectData.class);
        SJctrEditPortsSelectData selectData = (SJctrEditPortsSelectData)dat.get(0);
        List<SJmoPortIndex> selectPortIndexList = selectData.getPortIndexList();
        ArrayList<SJctrErrorColumnData> errList = new ArrayList<SJctrErrorColumnData>(selectPortIndexList.size());
        List<?> modelPortDetailList = this.getCache(SJmoGetPortDetail.class);
        if (result) {
            Collections.sort(modelPortDetailList);
            for (SJmoPortIndex selectPortIndex : selectPortIndexList) {
                int portDetailIndex = Collections.binarySearch(modelPortDetailList, selectPortIndex);
                if (portDetailIndex < 0) {
                    result = false;
                    SJctrError err3 = new SJctrError(10, 22, EDITPORTS_ERR2);
                    SJctrErrorColumnData errData2 = new SJctrErrorColumnData(selectPortIndex, err3);
                    errList.add(errData2);
                    continue;
                }
                int rsgId = rsgUtil.getRsgId(selectPortIndex);
                boolean rsgFlg = rsgUtil.chkResourceGroup(rsgId);
                if (!rsgFlg) {
                    result = false;
                    err = new SJctrError(10, 22, EDITPORTS_ERR14);
                    errData = new SJctrErrorColumnData(selectPortIndex, err);
                    errList.add(errData);
                    continue;
                }
                SJmoPortDetail modelPortDetail = (SJmoPortDetail)modelPortDetailList.get(portDetailIndex);
                if (SJctrPortUtility.isHnasPort(modelPortDetail)) {
                    result = false;
                    SJctrError err4 = new SJctrError(10, 22, EDITPORTS_ERR_vPort);
                    SJctrErrorColumnData errData3 = new SJctrErrorColumnData(selectPortIndex, err4);
                    errList.add(errData3);
                    continue;
                }
                this.targetPortDetailList.add(modelPortDetail);
            }
        }
        if (result) {
            List<?> modelPortAttributeInfoList = this.getCache(SJmoGetPortAttributeInfo.class);
            this.portUtil = this.getComUtility().getPortUtility();
            Collections.sort(modelPortAttributeInfoList);
            for (SJmoPortIndex selectPortIndex : selectPortIndexList) {
                int portAttributeInfoIndex = Collections.binarySearch(modelPortAttributeInfoList, selectPortIndex);
                if (portAttributeInfoIndex < 0) {
                    result = false;
                    SJctrError err5 = new SJctrError(10, 22, EDITPORTS_ERR2);
                    SJctrErrorColumnData errData4 = new SJctrErrorColumnData(selectPortIndex, err5);
                    errList.add(errData4);
                    continue;
                }
                SJmoPortAttributeInfo modelPortAttributeInfo = (SJmoPortAttributeInfo)modelPortAttributeInfoList.get(portAttributeInfoIndex);
                if (!this.portUtil.isOpenAttribute(modelPortAttributeInfo.getByPortKind())) {
                    result = false;
                    err = new SJctrError(10, 22, EDITPORTS_ERR3);
                    errData = new SJctrErrorColumnData(selectPortIndex, err);
                    errList.add(errData);
                }
                this.targetPortAttributeInfoList.add(modelPortAttributeInfo);
            }
        }
        if (!result) {
            SJctrRelatedDispDataObject rel = this.createDialog(SJctrErrorDataController.class, null);
            SJctrErrorDataController errDc = (SJctrErrorDataController)this.getOwner().getDataController(rel);
            errDc.setParameter(this.parentTbl, errList);
            errInfo = errDc.getRepresentativeError(errList, 4);
            SJcException exp = errInfo.createException();
            exp.setErrDisp(rel);
            throw exp;
        }
        for (SJmoPortDetail portDetail : this.targetPortDetailList) {
            this.fcoeFlg |= SJctrPortUtility.isFcoePort(portDetail);
        }
        this.portAttributeDataModel = (SJctrPortAttributeDataModel)this.getDataObjectModel(KEY_ATTRIBUTEINF);
        this.portSecurityDataModel = (SJctrBaseCheckRadioEnableDisableDataModel)this.getDataObjectModel(KEY_SECURITYINF);
        this.channelSpeedDataModel = (SJctrChannelSpeedDataModel)this.getDataObjectModel(KEY_SPEEDINF);
        this.fibreAddressDataModel = (SJctrFibreAddressDataModel)this.getDataObjectModel(KEY_ADDRESSINF);
        this.fcSwitchDataModel = (SJctrBaseCheckRadioOnOffDataModel)this.getDataObjectModel(KEY_FCSWITCHINF);
        this.portConnectionDataModel = (SJctrPortConnectionDataModel)this.getDataObjectModel(KEY_CONNECTIONINF);
        this.createPortChaData();
        this.createPortAttributeComboBox();
        this.createChannelSpeedComboBox();
        this.createFibreAddressComboBox();
        this.createPortConnectionComboBox();
        this.selectPortAttributeComboBox();
        this.selectPortKindComboBox();
        return result;
    }

    private void createPortChaData() {
        this.modelChaDetailList = this.getCache(SJmoGetChaDetail.class);
        SJctrComboBoxDataModel channelSpeedComboBox = (SJctrComboBoxDataModel)this.channelSpeedDataModel.getDataModel("COM_SPEED");
        this.portchaDataMap = new HashMap();
        this.notDisplayChannelSpeedMap = new HashSet();
        Iterator<SJmoPortDetail> i$ = this.targetPortDetailList.iterator();
        while (i$.hasNext()) {
            SJmoPortDetail checkPortDetailObj;
            SJmoPortDetail checkPortDetail = checkPortDetailObj = i$.next();
            Iterator<SJmoChaDetail> i$2 = this.modelChaDetailList.iterator();
            while (i$2.hasNext()) {
                SJmoChaDetail checkChaDetailObj;
                SJmoChaDetail modelChaDetail = checkChaDetailObj = i$2.next();
                short sCHAClusterNumber = SJctrPortUtility.getPortToCluster(checkPortDetail.getSPort());
                short sCHANumber = SJctrPortUtility.getPortToCHANumber(checkPortDetail.getSPort());
                if (modelChaDetail.getSCHAClusterNumber() != sCHAClusterNumber || modelChaDetail.getSCHANumber() != sCHANumber) continue;
                this.portchaDataMap.put(checkPortDetail.getSPort(), modelChaDetail);
                byte byPackageType = modelChaDetail.getByCHAPackageType();
                byte sfpDataTransferRate = checkPortDetail.getSFPDataTransferRate();
                List<Byte> notSupportList = SJctrEditPortsKindAC.getNotSupportChannelSpeed(byPackageType, sfpDataTransferRate);
                for (Byte notSupport : notSupportList) {
                    String name = Byte.toString(notSupport);
                    this.notDisplayChannelSpeedMap.add(name);
                }
            }
        }
    }

    private void createPortAttributeComboBox() {
        SJctrComboBoxDataModel portAttributeComboBox = (SJctrComboBoxDataModel)this.portAttributeDataModel.getDataModel("COM_ATTRIBUTE");
        portAttributeComboBox.addItem("");
        portAttributeComboBox.addItem(Byte.toString((byte)9), this.getComUtility().getGuidance("UNIVERSAL"));
        portAttributeComboBox.addItem(Byte.toString((byte)3), this.getComUtility().getGuidance("TARGET"));
        if (!this.fcoeFlg) {
            portAttributeComboBox.addItem(Byte.toString((byte)4), this.getComUtility().getGuidance("RCU_TARGET"));
            portAttributeComboBox.addItem(Byte.toString((byte)5), this.getComUtility().getGuidance("INITIATOR"));
            portAttributeComboBox.addItem(Byte.toString((byte)6), this.getComUtility().getGuidance("EXTERNAL"));
        }
    }

    private void createPortSecurityComboBox() {
        SJctrComboBoxDataModel portSecurityComboBox = (SJctrComboBoxDataModel)this.portSecurityDataModel.getDataModel(KEY_SECURITY);
        portSecurityComboBox.addItem("");
        portSecurityComboBox.addItem("ENABLE", this.getComUtility().getGuidance("ENABLE"));
        portSecurityComboBox.addItem("DISABLE", this.getComUtility().getGuidance("DISABLE"));
    }

    private void createChannelSpeedComboBox() {
        SJctrComboBoxDataModel channelSpeedComboBox = (SJctrComboBoxDataModel)this.channelSpeedDataModel.getDataModel("COM_SPEED");
        String name = "";
        String label = "";
        channelSpeedComboBox.addItem("");
        name = Byte.toString((byte)1);
        label = this.portUtil.toChannelSpeedDisplay((byte)1, (byte)0, false);
        if (!this.notDisplayChannelSpeedMap.contains(name)) {
            channelSpeedComboBox.addItem(name, label);
        }
        name = Byte.toString((byte)2);
        label = this.portUtil.toChannelSpeedDisplay((byte)2, (byte)0, false);
        if (!this.notDisplayChannelSpeedMap.contains(name)) {
            channelSpeedComboBox.addItem(name, label);
        }
        name = Byte.toString((byte)5);
        label = this.portUtil.toChannelSpeedDisplay((byte)5, (byte)0, false);
        if (!this.notDisplayChannelSpeedMap.contains(name)) {
            channelSpeedComboBox.addItem(name, label);
        }
        name = Byte.toString((byte)7);
        label = this.portUtil.toChannelSpeedDisplay((byte)7, (byte)0, false);
        if (!this.notDisplayChannelSpeedMap.contains(name)) {
            channelSpeedComboBox.addItem(name, label);
        }
        name = Byte.toString((byte)10);
        label = this.portUtil.toChannelSpeedDisplay((byte)10, (byte)0, false);
        if (!this.notDisplayChannelSpeedMap.contains(name)) {
            channelSpeedComboBox.addItem(name, label);
        }
        name = Byte.toString((byte)16);
        label = this.portUtil.toChannelSpeedDisplay((byte)16, (byte)0, false);
        if (!this.notDisplayChannelSpeedMap.contains(name)) {
            channelSpeedComboBox.addItem(name, label);
        }
        name = Byte.toString((byte)32);
        label = this.portUtil.toChannelSpeedDisplay((byte)32, (byte)0, false);
        if (!this.notDisplayChannelSpeedMap.contains(name)) {
            channelSpeedComboBox.addItem(name, label);
        }
        name = Byte.toString((byte)3);
        label = this.portUtil.toChannelSpeedDisplay((byte)3, (byte)0, false);
        if (!this.notDisplayChannelSpeedMap.contains(name)) {
            channelSpeedComboBox.addItem(name, label);
        }
    }

    private void createFibreAddressComboBox() {
        SJctrComboBoxDataModel fibreAddressComboBox = (SJctrComboBoxDataModel)this.fibreAddressDataModel.getDataModel("COM_ADDRESS");
        fibreAddressComboBox.addItem("");
        for (int loop = 1; loop <= 126; ++loop) {
            String name = String.valueOf(loop);
            String label = this.getComUtility().getDataChangeTable().ChangeFibreAdr(loop);
            fibreAddressComboBox.addItem(name, label);
        }
    }

    private void createFCSwitchComboBox() {
        SJctrComboBoxDataModel fcSwitchComboBox = (SJctrComboBoxDataModel)this.fcSwitchDataModel.getDataModel(KEY_FCSWITCH);
        fcSwitchComboBox.addItem("");
        fcSwitchComboBox.addItem("ON", this.getComUtility().getGuidance("ON"));
        if (!this.fcoeFlg) {
            fcSwitchComboBox.addItem("OFF", this.getComUtility().getGuidance("OFF"));
        }
    }

    private void createPortConnectionComboBox() {
        SJctrComboBoxDataModel portConnectionComboBox = (SJctrComboBoxDataModel)this.portConnectionDataModel.getDataModel("COM_CONNECTION");
        portConnectionComboBox.addItem("");
        if (!this.fcoeFlg) {
            portConnectionComboBox.addItem("FCAL", this.getComUtility().getGuidance("FCAL"));
        }
        portConnectionComboBox.addItem("P_TO_P", this.getComUtility().getGuidance("P_TO_P"));
    }

    private void selectPortAttributeComboBox() {
        SJctrComboBoxDataModel portAttributeComboBox = (SJctrComboBoxDataModel)this.portAttributeDataModel.getDataModel("COM_ATTRIBUTE");
        SJmoPortAttributeInfo firstPortAttributeInfo = this.targetPortAttributeInfoList.get(0);
        String attributeName = Byte.toString(firstPortAttributeInfo.getByPortKind());
        for (SJmoPortAttributeInfo portAttributeInfo : this.targetPortAttributeInfoList) {
            if (firstPortAttributeInfo.getByPortKind() == portAttributeInfo.getByPortKind()) continue;
            attributeName = "";
            portAttributeComboBox.clearSelection();
        }
        if (attributeName != "") {
            portAttributeComboBox.removeItem("");
        }
        portAttributeComboBox.setSelection(attributeName);
    }

    private void selectPortKindComboBox() {
        SJctrComboBoxDataModel channelSpeedComboBox = (SJctrComboBoxDataModel)this.channelSpeedDataModel.getDataModel("COM_SPEED");
        SJctrComboBoxDataModel fibreAddressComboBox = (SJctrComboBoxDataModel)this.fibreAddressDataModel.getDataModel("COM_ADDRESS");
        SJctrComboBoxDataModel portConnectionComboBox = (SJctrComboBoxDataModel)this.portConnectionDataModel.getDataModel("COM_CONNECTION");
        SJmoPortDetail firstPortDetail = this.targetPortDetailList.get(0);
        boolean securityFlg = firstPortDetail.isBPortSecuritySwitch();
        boolean sameSecurityFlg = true;
        String speedName = Byte.toString(SJctrEditPortsKindAC.getChannelSpeedToRmi(firstPortDetail.getByUserChannelSpeed(), firstPortDetail.getByDKCChannelSpeed()));
        String addressName = String.valueOf(firstPortDetail.getSPortFibreAddress());
        boolean swichFlg = this.portUtil.isBFCSwitch(firstPortDetail.getByPortFibreTopology());
        boolean sameSwichFlg = true;
        String connectionName = "P_TO_P";
        if (this.portUtil.isBFCALConnection(firstPortDetail.getByPortFibreTopology())) {
            connectionName = "FCAL";
        }
        for (SJmoPortDetail portDetail : this.targetPortDetailList) {
            if (firstPortDetail.isBPortSecuritySwitch() != portDetail.isBPortSecuritySwitch()) {
                sameSecurityFlg = false;
            }
            if (firstPortDetail.getByUserChannelSpeed() != portDetail.getByUserChannelSpeed() || firstPortDetail.getByDKCChannelSpeed() != portDetail.getByDKCChannelSpeed()) {
                speedName = "";
                channelSpeedComboBox.clearSelection();
            }
            if (firstPortDetail.getSPortFibreAddress() != portDetail.getSPortFibreAddress()) {
                addressName = "";
                fibreAddressComboBox.clearSelection();
            }
            if (this.portUtil.isBFCSwitch(firstPortDetail.getByPortFibreTopology()) != this.portUtil.isBFCSwitch(portDetail.getByPortFibreTopology())) {
                sameSwichFlg = false;
            }
            if (this.portUtil.isBFCALConnection(firstPortDetail.getByPortFibreTopology()) == this.portUtil.isBFCALConnection(portDetail.getByPortFibreTopology())) continue;
            connectionName = "";
            portConnectionComboBox.clearSelection();
        }
        if (this.targetPortDetailList.size() == 1) {
            if (securityFlg) {
                this.portSecurityDataModel.setSelectRadioEnable();
            } else {
                this.portSecurityDataModel.setSelectRadioDisable();
            }
            if (swichFlg) {
                this.fcSwitchDataModel.setSelectRadioON();
            } else {
                this.fcSwitchDataModel.setSelectRadioOFF();
            }
        } else {
            if (sameSecurityFlg) {
                if (securityFlg) {
                    this.portSecurityDataModel.setSelectRadioEnable();
                } else {
                    this.portSecurityDataModel.setSelectRadioDisable();
                }
            }
            if (sameSwichFlg) {
                if (swichFlg) {
                    this.fcSwitchDataModel.setSelectRadioON();
                } else {
                    this.fcSwitchDataModel.setSelectRadioOFF();
                }
            }
        }
        if (speedName != "") {
            channelSpeedComboBox.removeItem("");
        }
        if (addressName != "") {
            fibreAddressComboBox.removeItem("");
        }
        if (connectionName != "") {
            portConnectionComboBox.removeItem("");
        }
        channelSpeedComboBox.setSelection(speedName);
        fibreAddressComboBox.setSelection(addressName);
        portConnectionComboBox.setSelection(connectionName);
    }

    @Override
    public boolean checkEndData() {
        SJctrErrorColumnData errColumn;
        SJmoPortIndex errKey;
        SJctrError err;
        SJctrCheckBoxDataModel portAttributeCheckBox = (SJctrCheckBoxDataModel)this.portAttributeDataModel.getDataModel("COM_CHECKBOX");
        SJctrCheckBoxDataModel portSecurityCheckBox = this.portSecurityDataModel.getCheckBoxDataModel();
        SJctrCheckBoxDataModel channelSpeedCheckBox = (SJctrCheckBoxDataModel)this.channelSpeedDataModel.getDataModel("COM_CHECKBOX");
        SJctrCheckBoxDataModel fibreAddressCheckBox = (SJctrCheckBoxDataModel)this.fibreAddressDataModel.getDataModel("COM_CHECKBOX");
        SJctrCheckBoxDataModel fcSwitchCheckBox = (SJctrCheckBoxDataModel)this.fcSwitchDataModel.getDataModel("COM_CHECKBOX");
        SJctrCheckBoxDataModel portConnectionCheckBox = (SJctrCheckBoxDataModel)this.portConnectionDataModel.getDataModel("COM_CHECKBOX");
        if (!(portAttributeCheckBox.isSelect() || portSecurityCheckBox.isSelect() || channelSpeedCheckBox.isSelect() || fibreAddressCheckBox.isSelect() || fcSwitchCheckBox.isSelect() || portConnectionCheckBox.isSelect())) {
            return false;
        }
        SJctrComboBoxDataModel portAttributeComboBox = (SJctrComboBoxDataModel)this.portAttributeDataModel.getDataModel("COM_ATTRIBUTE");
        SJctrComboBoxDataModel channelSpeedComboBox = (SJctrComboBoxDataModel)this.channelSpeedDataModel.getDataModel("COM_SPEED");
        SJctrComboBoxDataModel fibreAddressComboBox = (SJctrComboBoxDataModel)this.fibreAddressDataModel.getDataModel("COM_ADDRESS");
        SJctrComboBoxDataModel portConnectionComboBox = (SJctrComboBoxDataModel)this.portConnectionDataModel.getDataModel("COM_CONNECTION");
        SJctrAuthorizeContainer authorizeContainer = this.getOwner().getAuthorizeContainer();
        SJcRoleResourceContainer rolecontainer = authorizeContainer.getRoleResourceContainer();
        SJctrLicenseContainer ppcontainer = authorizeContainer.getLisenceContainer();
        boolean retpp = true;
        if (portAttributeCheckBox.isSelect() && !rolecontainer.checkAuthority(78)) {
            retpp = false;
        }
        if (retpp && portSecurityCheckBox.isSelect()) {
            if (!rolecontainer.checkAuthority(79)) {
                retpp = false;
                SJmoIscsiTargetInfo t = new SJmoIscsiTargetInfo();
                t.getIHostMode();
            }
            if (this.portSecurityDataModel.isSelectedEnable() && !ppcontainer.checkPP(SJctrLicenseContainer.PPID_LUNM)) {
                retpp = false;
            }
        }
        if (retpp && (channelSpeedCheckBox.isSelect() || fibreAddressCheckBox.isSelect() || fcSwitchCheckBox.isSelect() || portConnectionCheckBox.isSelect())) {
            if (!rolecontainer.checkAuthority(80)) {
                retpp = false;
            }
            if (fcSwitchCheckBox.isSelect() && this.fcSwitchDataModel.isSelectedON() && !authorizeContainer.getSystemParamContainer().isLocalHost() && !ppcontainer.checkPP(SJctrLicenseContainer.PPID_LUNM)) {
                retpp = false;
            }
        }
        if (!retpp) {
            SJctrError err2 = new SJctrError(10, 22, EDITPORTS_ERR8);
            SJcException exp = err2.createException();
            throw exp;
        }
        ArrayList<SJmoPortDetail> checkPortDetailList = new ArrayList<SJmoPortDetail>(this.targetPortDetailList.size());
        ArrayList<SJmoPortAttributeInfo> checkPortAttributeInfoList = new ArrayList<SJmoPortAttributeInfo>(this.targetPortAttributeInfoList.size());
        SJmoPortDetail firstPortDetail = this.targetPortDetailList.get(0);
        for (SJmoPortDetail targetPortDetail : this.targetPortDetailList) {
            String selectConnection;
            SJmoPortDetail createPortDetail = null;
            try {
                createPortDetail = (SJmoPortDetail)targetPortDetail.clone();
            }
            catch (CloneNotSupportedException e) {
                this.getLogUty().putlog("editPortsDC", "PortDetail clone fail", e, 40000);
                continue;
            }
            if (portSecurityCheckBox.isSelect()) {
                boolean securityOnOff = this.portSecurityDataModel.isSelectedEnable();
                createPortDetail.setBPortSecuritySwitch(securityOnOff);
            }
            if (channelSpeedCheckBox.isSelect()) {
                String selectSpeed = channelSpeedComboBox.getSelection();
                byte speed = Byte.valueOf(selectSpeed);
                createPortDetail.setByUserChannelSpeed(SJctrEditPortsKindAC.getUserChannelSpeedFromRmi(speed));
                createPortDetail.setByDKCChannelSpeed((byte)0);
            }
            if (fibreAddressCheckBox.isSelect()) {
                String selectAddress = fibreAddressComboBox.getSelection();
                createPortDetail.setSPortFibreAddress(Short.valueOf(selectAddress));
            }
            boolean fcSwitchOnOff = false;
            if (fcSwitchCheckBox.isSelect()) {
                fcSwitchOnOff = this.fcSwitchDataModel.isSelectedON();
            }
            boolean connectionFcal = false;
            if (portConnectionCheckBox.isSelect() && (selectConnection = portConnectionComboBox.getSelection()).equals("FCAL")) {
                connectionFcal = true;
            }
            byte fibreTopology = 0;
            if (portConnectionCheckBox.isSelect() && fcSwitchCheckBox.isSelect()) {
                fibreTopology = this.getTopology(connectionFcal, fcSwitchOnOff);
            } else if (portConnectionCheckBox.isSelect() && !fcSwitchCheckBox.isSelect()) {
                fcSwitchOnOff = this.portUtil.isBFCSwitch(createPortDetail.getByPortFibreTopology());
                fibreTopology = this.getTopology(connectionFcal, fcSwitchOnOff);
            } else if (fcSwitchCheckBox.isSelect() && !portConnectionCheckBox.isSelect()) {
                connectionFcal = this.portUtil.isBFCALConnection(createPortDetail.getByPortFibreTopology());
                fibreTopology = this.getTopology(connectionFcal, fcSwitchOnOff);
            } else {
                fibreTopology = createPortDetail.getByPortFibreTopology();
            }
            createPortDetail.setByPortFibreTopology(fibreTopology);
            checkPortDetailList.add(createPortDetail);
        }
        Collections.sort(checkPortDetailList);
        for (SJmoPortAttributeInfo targetPortAttributeInfo : this.targetPortAttributeInfoList) {
            SJmoPortAttributeInfo createPortAttributeInfo = null;
            try {
                createPortAttributeInfo = (SJmoPortAttributeInfo)targetPortAttributeInfo.clone();
            }
            catch (CloneNotSupportedException e) {
                this.getLogUty().putlog("editPortsDC", "PortAttributeInfo clone fail", e, 40000);
                continue;
            }
            if (portAttributeCheckBox.isSelect()) {
                String selectAttribute = portAttributeComboBox.getSelection();
                byte portAttribute = Byte.valueOf(selectAttribute);
                createPortAttributeInfo.setByPortKind(portAttribute);
            }
            checkPortAttributeInfoList.add(createPortAttributeInfo);
        }
        Collections.sort(checkPortAttributeInfoList);
        List<?> modelPortHgInfoList = this.getCache(SJmoGetPortHostGroupInfo.class);
        Collections.sort(modelPortHgInfoList);
        List<?> modelPortLunInfoList = this.getCache(SJmoGetPortLunInfo.class);
        Collections.sort(modelPortLunInfoList);
        List<?> modelChaDetailList = this.getCache(SJmoGetChaDetail.class);
        ArrayList<SJmoPortDetail> confirmPortDetailList = new ArrayList<SJmoPortDetail>(checkPortDetailList.size());
        ArrayList<SJmoPortAttributeInfo> confirmPortAttributeInfoList = new ArrayList<SJmoPortAttributeInfo>(checkPortAttributeInfoList.size());
        boolean result = true;
        ArrayList<SJctrErrorColumnData> errList = new ArrayList<SJctrErrorColumnData>(this.targetPortAttributeInfoList.size());
        if (portAttributeCheckBox.isSelect()) {
            String sSelectAttr = portAttributeComboBox.getSelection();
            if (sSelectAttr == null || sSelectAttr.length() == 0) {
                SJctrError sJctrError = new SJctrError(10, 22, EDITPORTS_ERR13);
                SJcException exp = sJctrError.createException();
                throw exp;
            }
            byte by = Byte.valueOf(sSelectAttr);
            for (Object e : checkPortAttributeInfoList) {
                SJmoPortLunInfo modelPortLunInfo;
                SJmoPortAttributeInfo checkPortAttributeInfo = (SJmoPortAttributeInfo)e;
                int portLunInfoIndex = Collections.binarySearch(modelPortLunInfoList, checkPortAttributeInfo);
                if (portLunInfoIndex < 0 || (modelPortLunInfo = (SJmoPortLunInfo)modelPortLunInfoList.get(portLunInfoIndex)).getAlPortLun().size() <= 0) continue;
                result = false;
                err = new SJctrError(10, 22, EDITPORTS_ERR_LUN_EXISTS);
                errKey = new SJmoPortIndex();
                errKey.setSPort(checkPortAttributeInfo.getSPort());
                errColumn = new SJctrErrorColumnData(errKey, err);
                errList.add(errColumn);
            }
        }
        if (result) {
            for (Object e : checkPortAttributeInfoList) {
                SJmoPortAttributeInfo checkPortAttributeInfo = (SJmoPortAttributeInfo)e;
                int n = Collections.binarySearch(checkPortDetailList, checkPortAttributeInfo);
                if (n < 0) continue;
                SJmoPortDetail checkPortDetail = (SJmoPortDetail)checkPortDetailList.get(n);
                SJmoChaDetail chaDetail = this.portchaDataMap.get(checkPortDetail.getSPort());
                if (checkPortDetail.getByUserChannelSpeed() != 3) {
                    byte byRmiChannelSpeed = SJctrEditPortsKindAC.getChannelSpeedToRmi(checkPortDetail.getByUserChannelSpeed(), checkPortDetail.getByDKCChannelSpeed());
                    if (!SJctrEditPortsKindAC.isSupportChannelSpeed(chaDetail.getByCHAPackageType(), checkPortDetail.getSFPDataTransferRate(), byRmiChannelSpeed)) {
                        result = false;
                        err = new SJctrError(10, 22, EDITPORTS_ERR6);
                        errKey = new SJmoPortIndex();
                        errKey.setSPort(checkPortDetail.getSPort());
                        errColumn = new SJctrErrorColumnData(errKey, err);
                        errList.add(errColumn);
                        continue;
                    }
                }
                if (!(checkPortDetail.getByUserChannelSpeed() != 16 && checkPortDetail.getByUserChannelSpeed() != 32 || checkPortDetail.getByPortFibreTopology() != 1 && checkPortDetail.getByPortFibreTopology() != 2)) {
                    SJctrError err2;
                    result = false;
                    if (checkPortDetail.getByUserChannelSpeed() == 16) {
                        SJctrError err4 = new SJctrError(10, 22, EDITPORTS_ERR_16G_FCAL);
                    } else {
                        err2 = new SJctrError(10, 22, EDITPORTS_ERR_32G_FCAL);
                    }
                    SJmoPortIndex errKey2 = new SJmoPortIndex();
                    errKey2.setSPort(checkPortDetail.getSPort());
                    SJctrErrorColumnData errColumn2 = new SJctrErrorColumnData(errKey2, err2);
                    errList.add(errColumn2);
                    continue;
                }
                confirmPortDetailList.add(checkPortDetail);
                confirmPortAttributeInfoList.add(checkPortAttributeInfo);
            }
        }
        if (!result) {
            SJctrRelatedDispDataObject rel = this.createDialog(SJctrErrorDataController.class, null);
            SJctrErrorDataController sJctrErrorDataController = (SJctrErrorDataController)this.getOwner().getDataController(rel);
            sJctrErrorDataController.setParameter(this.parentTbl, errList);
            SJctrError errInfo = ((SJctrErrorColumnData)errList.get(0)).getError();
            SJcException sJcException = errInfo.createException();
            sJcException.setErrDisp(rel);
            throw sJcException;
        }
        SJctrEditPortsData confirmData = new SJctrEditPortsData();
        confirmData.setCheckBoxStatus(SJctrEditPortsData.CHECKBOX_ITEM.ATTRIBUTE, portAttributeCheckBox.isSelect());
        confirmData.setCheckBoxStatus(SJctrEditPortsData.CHECKBOX_ITEM.SECURITY, portSecurityCheckBox.isSelect());
        confirmData.setCheckBoxStatus(SJctrEditPortsData.CHECKBOX_ITEM.SPEED, channelSpeedCheckBox.isSelect());
        confirmData.setCheckBoxStatus(SJctrEditPortsData.CHECKBOX_ITEM.ADDRESS, fibreAddressCheckBox.isSelect());
        confirmData.setCheckBoxStatus(SJctrEditPortsData.CHECKBOX_ITEM.FCSWITCH, fcSwitchCheckBox.isSelect());
        confirmData.setCheckBoxStatus(SJctrEditPortsData.CHECKBOX_ITEM.CONNECTION, portConnectionCheckBox.isSelect());
        confirmPortDetailList.trimToSize();
        confirmData.setPortDetailList(confirmPortDetailList);
        confirmPortAttributeInfoList.trimToSize();
        confirmData.setPortAttributeInfoList(confirmPortAttributeInfoList);
        ArrayList<SJctrEditPortsData> arrayList = new ArrayList<SJctrEditPortsData>();
        arrayList.add(confirmData);
        this.putCache(SJctrEditPortsData.class, arrayList);
        return true;
    }

    @Override
    public boolean checkFinishData(final SJctrMessageEvent msgEvent, final SJctrDataObjectModel<?> dstModel) {
        boolean result = false;
        ArrayList checkPortDetailList = new ArrayList(this.targetPortDetailList.size());
        SJctrCheckBoxDataModel portSecurityCheckBox = this.portSecurityDataModel.getCheckBoxDataModel();
        SJctrBaseCheckRadioEnableDisableDataModel portSecurityComboBox = this.portSecurityDataModel;
        boolean securityOnOff = false;
        boolean targetSecurity = false;
        int msgID = 0;
        for (SJmoPortDetail targetPortDetail : this.targetPortDetailList) {
            if (!portSecurityCheckBox.isSelect()) continue;
            securityOnOff = portSecurityComboBox.isSelectedEnable();
            targetSecurity = targetPortDetail.isBPortSecuritySwitch();
            if (targetSecurity == securityOnOff) continue;
            msgID = securityOnOff ? EDITPORTS_ERR9 : EDITPORTS_ERR10;
            String strFuncID = Integer.toString(201);
            String strModuleID = Integer.toString(22);
            String strMsgID = Integer.toString(msgID);
            SJcMessage msg = new SJcMessage(strFuncID, strModuleID, strMsgID);
            SJctrRelatedDispDataObject related = this.createMsgDialog(msg);
            SJctrUserController uc = this.getOwner();
            SJctrMessageDataController msgDC = (SJctrMessageDataController)uc.getDataController(related);
            msgDC.addButton(SJctrMessageDataController.MD_OK, new SJctrItemSelectListener(){

                @Override
                public void selectChanged(SJctrItemSelectEvent<?> event) {
                    SJctrEditPortsDC.this.checkEndData();
                    SJctrEditPortsDC.this.finishEvent(msgEvent, dstModel);
                }
            });
            msgDC.addButton(SJctrMessageDataController.MD_CANCEL);
            this.addUpdateDisp(related);
            result = true;
            break;
        }
        return result;
    }

    private byte getTopology(boolean connectionFcal, boolean fcSwitchOnOff) {
        byte topology = 0;
        topology = connectionFcal ? (fcSwitchOnOff ? (byte)1 : 2) : (fcSwitchOnOff ? (byte)3 : 4);
        return topology;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetPortDetail();
        SJmoGetRange_IF range = null;
        List<Object> filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortAttributeInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetChaDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortHostGroupInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortLunInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = Collections.emptyList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }
}

