/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.editports;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import sanproject.serverux.dataimpl.SanRmiInputInterface;
import sanproject.serverux.dataimpl.SetChannelSpeed;
import sanproject.serverux.dataimpl.SetFibreAddress;
import sanproject.serverux.dataimpl.SetFibreTopology;
import sanproject.serverux.dataimpl.SetSecuritySwitchInfo;
import sanproject.sn2.controller.com.SJctrApplyController;
import sanproject.sn2.controller.com.SJctrError;

public class SJctrEditPortsKindAC
extends SJctrApplyController {
    private static final int LUNM_BASE_TIME = 30;
    private static final int CHECK_TIME = 5;
    private static final double COEFFICIENT = 0.003;
    List<SetSecuritySwitchInfo> mSetSecuritySwitchInfoList = new ArrayList<SetSecuritySwitchInfo>();
    List<SetChannelSpeed> mSetChannelSpeedList = new ArrayList<SetChannelSpeed>();
    List<SetFibreAddress> mSetFibreAddressList = new ArrayList<SetFibreAddress>();
    List<SetFibreTopology> mSetFibreTopologyList = new ArrayList<SetFibreTopology>();
    List<SJctrError> resultData = null;
    public static final byte CHANGEPORT_CHANNEL_SPEED_1GBPS = 1;
    public static final byte CHANGEPORT_CHANNEL_SPEED_2GBPS = 2;
    public static final byte CHANGEPORT_CHANNEL_SPEED_AUTO = 3;
    public static final byte CHANGEPORT_CHANNEL_SPEED_RESERVE = 4;
    public static final byte CHANGEPORT_CHANNEL_SPEED_4GBPS = 5;
    public static final byte CHANGEPORT_CHANNEL_SPEED_8GBPS = 7;
    public static final byte CHANGEPORT_CHANNEL_SPEED_10GBPS = 10;
    public static final byte CHANGEPORT_CHANNEL_SPEED_16GBPS = 16;
    public static final byte CHANGEPORT_CHANNEL_SPEED_32GBPS = 32;
    public static final byte PKGTYPE_ESCON_4PORT = 100;
    public static final byte PKGTYPE_FICON_4PORT_4G = 101;
    public static final byte PKGTYPE_CHT_8PORT_4G = 102;
    public static final byte PKGTYPE_CHT_4PORT_4G = 105;
    public static final byte PKGTYPE_FICON_8PORT_8G = 106;
    public static final byte PKGTYPE_CHT_8PORT_8G = 107;
    public static final byte PKGTYPE_CHT_4PORT_8G = 108;
    public static final byte PKGTYPE_FCOE_4PORT_10G = 110;
    public static final byte PKGTYPE_FC_4PORT_16G = 118;
    public static final byte PKGTYPE_FC_2PORT_16G = 119;
    public static final byte PKGTYPE_ISCSI_2PORT_10G_OPT = 120;
    public static final byte PKGTYPE_ISCSI_2PORT_10G_COP = 121;
    public static final byte PKGTYPE_FC_4PORT_32G = 125;
    public static final byte SFP_SPEED_DO_NOT_CARE = -1;
    public static final byte SFP_SPEED_16G = 16;
    public static final byte SFP_SPEED_32G = 32;
    static byte[][] SupportChannelSpeedData = new byte[][]{{102, -1, 1, 2, 5, 3}, {105, -1, 1, 2, 5, 3}, {107, -1, 2, 5, 7, 3}, {108, -1, 2, 5, 7, 3}, {110, -1, 10}, {118, -1, 5, 7, 16, 3}, {119, -1, 5, 7, 16, 3}, {120, -1, 10}, {121, -1, 1, 10, 3}, {125, 16, 5, 7, 16, 3}, {125, 32, 7, 16, 32, 3}};

    public void setApplyList(List<SetSecuritySwitchInfo> setSecuritySwitchInfoList, List<SetChannelSpeed> setChannelSpeedList, List<SetFibreAddress> setFibreAddressList, List<SetFibreTopology> setFibreTopologyList) {
        this.mSetSecuritySwitchInfoList = setSecuritySwitchInfoList;
        this.mSetChannelSpeedList = setChannelSpeedList;
        this.mSetFibreAddressList = setFibreAddressList;
        this.mSetFibreTopologyList = setFibreTopologyList;
    }

    @Override
    public ArrayList<?> getSetList() {
        int applySize = this.mSetSecuritySwitchInfoList.size() + this.mSetChannelSpeedList.size() + this.mSetFibreAddressList.size() + this.mSetFibreTopologyList.size();
        ArrayList<SanRmiInputInterface> applyList = new ArrayList<SanRmiInputInterface>(applySize);
        applyList.addAll(this.mSetSecuritySwitchInfoList);
        applyList.addAll(this.mSetChannelSpeedList);
        applyList.addAll(this.mSetFibreAddressList);
        applyList.addAll(this.mSetFibreTopologyList);
        return applyList;
    }

    @Override
    protected List<SJctrError> getResultData() {
        return this.resultData;
    }

    @Override
    public int getLeadTime() {
        ArrayList<?> applylist = this.getSetList();
        double leadtime = 30.0 + (double)applylist.size() * 0.003 + 5.0;
        leadtime = Math.ceil(leadtime);
        return (int)leadtime;
    }

    public static byte getChannelSpeedToRmi(byte userSpeed, byte dkcSpeed) {
        int rmiSpeed = 0;
        if (userSpeed == 1) {
            rmiSpeed = 1;
        } else if (userSpeed == 2) {
            rmiSpeed = 2;
        } else if (userSpeed == 5) {
            rmiSpeed = 5;
        } else if (userSpeed == 7) {
            rmiSpeed = 7;
        } else if (userSpeed == 10) {
            rmiSpeed = 10;
        } else if (userSpeed == 16) {
            rmiSpeed = 16;
        } else if (userSpeed == 32) {
            rmiSpeed = 32;
        } else if (userSpeed == 3) {
            if (dkcSpeed == 0 || dkcSpeed == 1 || dkcSpeed == 2 || dkcSpeed == 4 || dkcSpeed == 7 || dkcSpeed == 10 || dkcSpeed == 16 || dkcSpeed == 32) {
                rmiSpeed = 3;
            } else if (dkcSpeed == 5 || dkcSpeed == 6) {
                rmiSpeed = 4;
            }
        }
        return (byte)rmiSpeed;
    }

    public static byte getUserChannelSpeedFromRmi(byte rmiSpeed) {
        int userSpeed = 0;
        if (rmiSpeed == 1) {
            userSpeed = 1;
        } else if (rmiSpeed == 2) {
            userSpeed = 2;
        } else if (rmiSpeed == 5) {
            userSpeed = 5;
        } else if (rmiSpeed == 7) {
            userSpeed = 7;
        } else if (rmiSpeed == 10) {
            userSpeed = 10;
        } else if (rmiSpeed == 16) {
            userSpeed = 16;
        } else if (rmiSpeed == 32) {
            userSpeed = 32;
        } else if (rmiSpeed == 3) {
            userSpeed = 3;
        }
        return (byte)userSpeed;
    }

    public static boolean isSupportChannelSpeed(byte pakageType, byte sfpDataTransferRate, byte speed) {
        boolean result = false;
        List<Byte> dataList = SJctrEditPortsKindAC.getSupportChannelSpeed(pakageType, sfpDataTransferRate);
        for (Byte data : dataList) {
            if (data != speed) continue;
            result = true;
            break;
        }
        return result;
    }

    public static List<Byte> getAllSupportChannelSpeed() {
        ArrayList<Byte> result = new ArrayList<Byte>();
        HashSet<Byte> support = new HashSet<Byte>();
        for (int pkg = 0; pkg < SupportChannelSpeedData.length; ++pkg) {
            for (int speed = 2; speed < SupportChannelSpeedData[pkg].length; ++speed) {
                support.add(SupportChannelSpeedData[pkg][speed]);
            }
        }
        result.addAll(support);
        return result;
    }

    public static List<Byte> getSupportChannelSpeed(byte pakageType, byte sfpDataTransferRate) {
        ArrayList<Byte> result = new ArrayList<Byte>();
        for (int pkg = 0; pkg < SupportChannelSpeedData.length; ++pkg) {
            if (!SJctrEditPortsKindAC.isValidPackageTypeAndSfp(SupportChannelSpeedData[pkg], pakageType, sfpDataTransferRate)) continue;
            for (int speed = 2; speed < SupportChannelSpeedData[pkg].length; ++speed) {
                result.add(SupportChannelSpeedData[pkg][speed]);
            }
        }
        return result;
    }

    private static boolean isValidPackageTypeAndSfp(byte[] candidate, byte packageType, byte sfpDataTransferRate) {
        return candidate[0] == packageType && (candidate[1] == -1 || candidate[1] == sfpDataTransferRate);
    }

    public static List<Byte> getNotSupportChannelSpeed(byte pakageType, byte sfpDataTransferRate) {
        ArrayList<Byte> result = new ArrayList<Byte>();
        List<Byte> allSupList = SJctrEditPortsKindAC.getAllSupportChannelSpeed();
        List<Byte> pkgSupList = SJctrEditPortsKindAC.getSupportChannelSpeed(pakageType, sfpDataTransferRate);
        for (Byte allSup : allSupList) {
            boolean found = false;
            for (Byte pkgSup : pkgSupList) {
                if (allSup.byteValue() != pkgSup.byteValue()) continue;
                found = true;
            }
            if (found) continue;
            result.add(allSup);
        }
        return result;
    }
}

