/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.iscsi.addchapusers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.comparator.SJctrChapUserNameComparator;
import sanproject.sn2.controller.com.comparator.SJctrIscsiTargetAliasComparator;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.lunm.iscsi.addchapusers.SJctrAddChapUsersConfirmData;
import sanproject.sn2.controller.wizard.lunm.iscsi.addchapusers.SJctrAddChapUsersTableDataModel;
import sanproject.sn2.controller.wizard.lunm.iscsi.addnewchapuser.SJctrAddNewChapUserDC;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrChapUserInfoIncludeNewChap;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrChapUserWithTgInfo;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrIscsiDataMacro;
import sanproject.sn2.controller.wizard.lunm.iscsi.editiscsitargets.SJctrEditIscsiTargetsErrorTableModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortAttributeInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortChapUserInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.lu.SJmoChapUserInfo;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetIndex;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortChapUserInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;

public class SJctrAddChapUsersDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 0x1101811;
    private static final String DISP_TITLE = "ADD_CHAP_USERS";
    private static final String KEY_TABLE_AVA_CHAP_USER = "COM_TABLE_AVA_CHAP_USER";
    private static final String KEY_TABLE_SEL_CHAP_USER = "COM_TABLE_SEL_CHAP_USER";
    protected static final String KEY_ADD = "COM_ADD";
    protected static final String KEY_REMOVE = "COM_REMOVE";
    protected static final String KEY_ADD_NEW_CHAP_USER = "COM_ADD_NEW_CHAP";
    private final int NUM_OF_PORTCHAPUSERNAME_THRESHOLD = 1;
    private final Set<String> chapUserNameSetInSelectedIscsiPort = new HashSet<String>();
    private static final String KEY_SELECTED_CHECK_ISCSI_TARGET = "COM_SELECTED_CHECK_ISCSI_TARGET";

    public SJctrAddChapUsersDC() throws SJcException {
        super(0x1101811);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance(DISP_TITLE);
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetPortDetail();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortAttributeInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortIscsiTargetInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortChapUserInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    private void initDataModel() {
        SJctrAddChapUsersTableDataModel availableTable = new SJctrAddChapUsersTableDataModel();
        this.addDataObjectModel(KEY_TABLE_AVA_CHAP_USER, availableTable);
        SJctrAddChapUsersTableDataModel selectedTable = new SJctrAddChapUsersTableDataModel();
        selectedTable.setPaging(false);
        this.addDataObjectModel(KEY_TABLE_SEL_CHAP_USER, selectedTable);
        SJctrButtonDataModel addButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_ADD, addButton);
        addButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrAddChapUsersDC.this.fireMessageEvent(ADD_CHAP_USERS_MSG.SELECT_ADD);
            }
        });
        SJctrButtonDataModel removeButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_REMOVE, removeButton);
        removeButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrAddChapUsersDC.this.fireMessageEvent(ADD_CHAP_USERS_MSG.SELECT_REMOVE);
            }
        });
        SJctrButtonDataModel addNewChapButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_ADD_NEW_CHAP_USER, addNewChapButton);
        addNewChapButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrAddChapUsersDC.this.fireMessageEvent(ADD_CHAP_USERS_MSG.SELECT_ADD_NEW_CHAP_USER);
            }
        });
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    private void initListener() {
        this.addMessageEventListener(ADD_CHAP_USERS_MSG.SELECT_ADD, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAddChapUsersDC.this.pushAddAction(event, dstModel);
                SJctrIscsiUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
        this.addMessageEventListener(ADD_CHAP_USERS_MSG.SELECT_REMOVE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAddChapUsersDC.this.pushRemoveAction(event, dstModel);
                SJctrIscsiUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
        this.addMessageEventListener(ADD_CHAP_USERS_MSG.SELECT_ADD_NEW_CHAP_USER, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAddChapUsersDC.this.pushAddNewChapUsersAction(event, dstModel);
            }
        });
        this.addMessageEventListener(SJctrDialogDataController.DIALOG_MSG.EXIT, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                Object notifyObj = event.getNofifyObject();
                if (notifyObj instanceof Map) {
                    Map map = (Map)notifyObj;
                    SJctrAddChapUsersDC.this.exitAddNewChapUsersAction(map);
                }
            }
        });
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> iscsiTargetList = this.getProxy().getCache("KEY_SELECTED_ISCSI_TARGETS");
        if (iscsiTargetList == null) {
            this.logUty.putlog("checkStartData", "iscsiTargetList list data is null.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        if (iscsiTargetList.size() == 0) {
            this.logUty.putlog("checkStartData", "Size of iscsiTargetList list data is zero.");
            throw SJctrIscsiUtility.makeException(107001);
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        HashSet<Short> selectPort = new HashSet<Short>();
        HashSet<String> allChapListInSelectIscsi = new HashSet<String>();
        HashMap<Short, Set<String>> allPortChapMap = new HashMap<Short, Set<String>>();
        ArrayList<SJmoChapUserInfo> allChapList = new ArrayList<SJmoChapUserInfo>();
        try {
            List<Object> avaChapUserList = new ArrayList();
            List<SJmoIscsiTargetInfo> selectIscsiTargetList = this.getProxy().getCache("KEY_SELECTED_ISCSI_TARGETS");
            List<SJmoPortIscsiTargetInfo> portTargetInfoList = SJctrIscsiUtility.getSJmoPortIscsiTargetInfoList(this);
            List<SJmoPortChapUserInfo> portChapInfoList = SJctrIscsiUtility.getSJmoPortChapUserInfoList(this);
            ArrayList<SJmoIscsiTargetInfo> iscsiTargetList = new ArrayList(selectIscsiTargetList.size());
            iscsiTargetList = this.checkAndGetIscsiTargetInfo(portTargetInfoList, selectIscsiTargetList);
            this.putCache(KEY_SELECTED_CHECK_ISCSI_TARGET, iscsiTargetList);
            this.checkChapAuthentication(iscsiTargetList);
            for (SJmoIscsiTargetInfo iscsiInfo : iscsiTargetList) {
                for (SJmoChapUserInfo chapUserInfo : iscsiInfo.getAlUserInfo()) {
                    allChapListInSelectIscsi.add(chapUserInfo.getStrUserName());
                }
                selectPort.add(iscsiInfo.getSPort());
            }
            for (SJmoPortChapUserInfo portChapUser : portChapInfoList) {
                HashSet<String> chapName = new HashSet<String>();
                for (SJmoChapUserInfo chapInfo : portChapUser.getAlPortChapUser()) {
                    chapName.add(chapInfo.getStrUserName());
                    allChapList.add(chapInfo);
                }
                allPortChapMap.put(portChapUser.getSPort(), chapName);
                if (!selectPort.contains(portChapUser.getSPort())) continue;
                this.chapUserNameSetInSelectedIscsiPort.addAll(chapName);
            }
            avaChapUserList = this.getAvailableChapUserList(selectPort, allChapListInSelectIscsi, allPortChapMap, allChapList);
            Collections.sort(avaChapUserList, new SJctrChapUserNameComparator());
            for (int i = 0; i < avaChapUserList.size(); ++i) {
                ((SJctrChapUserInfoIncludeNewChap)avaChapUserList.get(i)).setUserSeqNo(i);
            }
            SJctrAddChapUsersTableDataModel availableTable = (SJctrAddChapUsersTableDataModel)this.getDataObjectModel(KEY_TABLE_AVA_CHAP_USER);
            availableTable.setBasicDataList(avaChapUserList);
        }
        catch (SJcException e) {
            throw SJctrIscsiUtility.convIscsiLogicErrorException(e, 107002);
        }
        return true;
    }

    @Override
    public boolean checkEndData() {
        try {
            SJctrAddChapUsersConfirmData confirmData = new SJctrAddChapUsersConfirmData();
            SJctrAddChapUsersTableDataModel selectedTable = (SJctrAddChapUsersTableDataModel)this.getDataObjectModel(KEY_TABLE_SEL_CHAP_USER);
            List<Object> selectedChapUserList = selectedTable.getAllRowData();
            List<?> iscsiTargetList = this.getProxy().getCache(KEY_SELECTED_CHECK_ISCSI_TARGET);
            ArrayList<SJctrChapUserWithTgInfo> confirmBasicDataList = new ArrayList<SJctrChapUserWithTgInfo>();
            for (SJmoIscsiTargetInfo iscsiInfo : iscsiTargetList) {
                for (SJctrChapUserInfoIncludeNewChap sJctrChapUserInfoIncludeNewChap : selectedChapUserList) {
                    SJctrChapUserWithTgInfo confirmBasicData = new SJctrChapUserWithTgInfo(sJctrChapUserInfoIncludeNewChap, iscsiInfo);
                    confirmBasicDataList.add(confirmBasicData);
                }
            }
            Collections.sort(confirmBasicDataList, new SJctrChapUserNameComparator());
            confirmData.setAddChapUserInfo(confirmBasicDataList);
            confirmData.setNeedData(this);
            ArrayList<SJctrAddChapUsersConfirmData> confirmDataList = new ArrayList<SJctrAddChapUsersConfirmData>();
            confirmDataList.add(confirmData);
            this.putCache(SJctrAddChapUsersConfirmData.class, confirmDataList);
            SJctrIscsiUtility.setFinishChangeCheck(this, false);
            List<SJmoPortDetail> portDetail = this.getCache(SJmoGetPortDetail.class);
            SJctrIscsiUtility iscsiUtil = this.getComUtility().getIscsiUtility();
            iscsiUtil.checkPortSecurityMsg(portDetail, iscsiTargetList, this);
        }
        catch (SJcException e) {
            throw SJctrIscsiUtility.convIscsiLogicErrorException(e, 107003);
        }
        return true;
    }

    private List<SJmoIscsiTargetInfo> checkAndGetIscsiTargetInfo(List<SJmoPortIscsiTargetInfo> portTargetInfoList, List<SJmoIscsiTargetInfo> selectIscsiTargetList) {
        ArrayList<SJmoIscsiTargetInfo> iscsiTargetList = new ArrayList<SJmoIscsiTargetInfo>(selectIscsiTargetList.size());
        ArrayList<SJmoIscsiTargetInfo> notFoundiscsiTargetList = new ArrayList<SJmoIscsiTargetInfo>(selectIscsiTargetList.size());
        ArrayList<SJctrErrorColumnData> errColumnList = new ArrayList<SJctrErrorColumnData>();
        for (SJmoIscsiTargetInfo checkIscsi : selectIscsiTargetList) {
            SJmoIscsiTargetInfo iscsiInfo = SJctrIscsiUtility.getIscsiTargetInfoByIndex(portTargetInfoList, (SJmoIscsiTargetIndex)checkIscsi);
            if (iscsiInfo != null) {
                iscsiTargetList.add(iscsiInfo);
                continue;
            }
            SJctrLogUty.error("SJctrIscsiUtility", "checkAndGetIscsiTargetInfo", "Not found iSCSI Taget data. Target# : " + checkIscsi.getIndexKey());
            notFoundiscsiTargetList.add(checkIscsi);
        }
        if (notFoundiscsiTargetList.size() > 0) {
            Collections.sort(notFoundiscsiTargetList, new SJctrIscsiTargetAliasComparator());
            for (SJmoIscsiTargetInfo iscsiInfo : notFoundiscsiTargetList) {
                SJctrErrorColumnData errColumnData = new SJctrErrorColumnData(iscsiInfo, SJctrIscsiUtility.makeError(206513));
                errColumnList.add(errColumnData);
            }
            SJctrEditIscsiTargetsErrorTableModel errorTable = new SJctrEditIscsiTargetsErrorTableModel();
            errorTable.setPaging(false);
            errorTable.setDataController(this);
            errorTable.initGuidance(this.getComUtility());
            errorTable.setBasicDataList(notFoundiscsiTargetList);
            errorTable.createModelDirect();
            errorTable.divideModelData(this.getProxy().getModelDataMap());
            errorTable.makeDataModel();
            this.viewErrorTable(errColumnList, errorTable);
        }
        return iscsiTargetList;
    }

    private void pushAddAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrAddChapUsersTableDataModel availableTable = (SJctrAddChapUsersTableDataModel)this.getDataObjectModel(KEY_TABLE_AVA_CHAP_USER);
        SJctrAddChapUsersTableDataModel selectedTable = (SJctrAddChapUsersTableDataModel)this.getDataObjectModel(KEY_TABLE_SEL_CHAP_USER);
        List<Object> availTblSelectRowDataList = availableTable.getSelectedRowData();
        List<Object> selectTblAllRowDataList = selectedTable.getAllRowData();
        List<SJmoIscsiTargetInfo> iscsiTargetList = this.getProxy().getCache(KEY_SELECTED_CHECK_ISCSI_TARGET);
        this.checkAddChapUserNumber(availTblSelectRowDataList, selectTblAllRowDataList, iscsiTargetList);
        HashMap<String, List<SJctrChapUserInfoIncludeNewChap>> availableChapMap = new HashMap<String, List<SJctrChapUserInfoIncludeNewChap>>();
        List<Object> notAddChapUserList = new ArrayList(availTblSelectRowDataList.size());
        notAddChapUserList = this.getNotAddChapListAndsetChapMap(availableChapMap, selectTblAllRowDataList, availTblSelectRowDataList);
        ArrayList<SJctrErrorColumnData> errColumnList = new ArrayList(availTblSelectRowDataList.size());
        ArrayList addChapUserList = new ArrayList(availTblSelectRowDataList.size());
        for (String key : availableChapMap.keySet()) {
            List chapUserList = (List)availableChapMap.get(key);
            if (chapUserList.size() >= 2) {
                notAddChapUserList.addAll(chapUserList);
                continue;
            }
            addChapUserList.addAll(chapUserList);
        }
        if (notAddChapUserList.size() > 0) {
            Collections.sort(notAddChapUserList, new SJctrChapUserNameComparator());
            errColumnList = this.createAddChapErrorColumnDataList(notAddChapUserList);
            this.viewErrorTable(errColumnList, availableTable);
        }
        List<Object> addData = availableTable.removeSelectedRowData();
        selectedTable.addRowDataTop(addData);
        this.updateFooter();
        this.setDirtyAll();
    }

    private List<SJctrChapUserInfoIncludeNewChap> getNotAddChapListAndsetChapMap(Map<String, List<SJctrChapUserInfoIncludeNewChap>> availableChapMap, List<Object> selectTblAllRowDataList, List<Object> availTblSelectRowDataList) {
        ArrayList<SJctrChapUserInfoIncludeNewChap> notAddList = new ArrayList<SJctrChapUserInfoIncludeNewChap>();
        HashSet<String> selectedChapUserName = new HashSet<String>();
        for (Object selectRowData : selectTblAllRowDataList) {
            SJctrChapUserInfoIncludeNewChap selectChapUserInfo = (SJctrChapUserInfoIncludeNewChap)selectRowData;
            selectedChapUserName.add(selectChapUserInfo.getStrUserName());
        }
        for (Object availRowData : availTblSelectRowDataList) {
            ArrayList<SJctrChapUserInfoIncludeNewChap> noEntryChapList = new ArrayList<SJctrChapUserInfoIncludeNewChap>(1);
            SJctrChapUserInfoIncludeNewChap availChapUserInfo = (SJctrChapUserInfoIncludeNewChap)availRowData;
            String key = availChapUserInfo.getStrUserName();
            if (selectedChapUserName.contains(key)) {
                notAddList.add(availChapUserInfo);
                continue;
            }
            List<SJctrChapUserInfoIncludeNewChap> chapUserList = availableChapMap.get(key);
            if (null == chapUserList) {
                noEntryChapList.add(availChapUserInfo);
                availableChapMap.put(key, noEntryChapList);
                continue;
            }
            chapUserList.add(availChapUserInfo);
            availableChapMap.put(key, chapUserList);
        }
        return notAddList;
    }

    private List<SJctrErrorColumnData> createAddChapErrorColumnDataList(List<SJctrChapUserInfoIncludeNewChap> chapUserList) {
        ArrayList<SJctrErrorColumnData> errorColumnDataList = new ArrayList<SJctrErrorColumnData>();
        for (SJctrChapUserInfoIncludeNewChap chapUserInfo : chapUserList) {
            SJctrErrorColumnData errColumnData = new SJctrErrorColumnData(chapUserInfo, SJctrIscsiUtility.makeError(206216));
            this.logUty.putlog("createAddChapErrorColumnDataList", chapUserInfo.getStrUserName() + " is already set in selected table");
            errorColumnDataList.add(errColumnData);
        }
        return errorColumnDataList;
    }

    private void pushRemoveAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrAddChapUsersTableDataModel selectedTable = (SJctrAddChapUsersTableDataModel)this.getDataObjectModel(KEY_TABLE_SEL_CHAP_USER);
        SJctrAddChapUsersTableDataModel availableTable = (SJctrAddChapUsersTableDataModel)this.getDataObjectModel(KEY_TABLE_AVA_CHAP_USER);
        List<Object> addData = selectedTable.removeSelectedRowData();
        availableTable.addRowDataTop(addData);
        this.updateFooter();
        this.setDirtyAll();
    }

    private void pushAddNewChapUsersAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrAddChapUsersTableDataModel availableTable = (SJctrAddChapUsersTableDataModel)this.getDataObjectModel(KEY_TABLE_AVA_CHAP_USER);
        SJctrAddChapUsersTableDataModel selectedTable = (SJctrAddChapUsersTableDataModel)this.getDataObjectModel(KEY_TABLE_SEL_CHAP_USER);
        List<Object> availableTableAllRowData = availableTable.getAllRowData();
        List<Object> selectedTableAllRowData = selectedTable.getAllRowData();
        List<Object> selectedChapUserList = new ArrayList();
        ArrayList<SJctrChapUserInfoIncludeNewChap> addNewChapUserList = new ArrayList<SJctrChapUserInfoIncludeNewChap>();
        HashSet<String> chapUserNameSet = new HashSet<String>();
        ArrayList<Object> allChapUserList = new ArrayList<Object>();
        allChapUserList.addAll(availableTableAllRowData);
        allChapUserList.addAll(selectedTableAllRowData);
        chapUserNameSet.addAll(this.chapUserNameSetInSelectedIscsiPort);
        for (Object e : allChapUserList) {
            SJctrChapUserInfoIncludeNewChap chapUserInfo = (SJctrChapUserInfoIncludeNewChap)e;
            if (!chapUserInfo.isNewChap()) continue;
            addNewChapUserList.add(chapUserInfo);
        }
        selectedChapUserList = availableTable.getSelectedRowData();
        HashMap map = new HashMap();
        ArrayList<HashSet<String>> arrayList = new ArrayList<HashSet<String>>();
        arrayList.add(chapUserNameSet);
        map.put("ADD_NEW_CHAPUSER_DATA_INVALID", arrayList);
        map.put("ADD_NEW_CHAPUSER_DATA_SELECT", selectedChapUserList);
        map.put("ADD_NEW_CHAPUSER_DATA_NEW_LIST", addNewChapUserList);
        SJctrRelatedDispDataObject relatedObj = this.createDialog(SJctrAddNewChapUserDC.class, map);
        this.addUpdateDisp(relatedObj);
    }

    private void exitAddNewChapUsersAction(Map<String, List<?>> carryMap) {
        List<?> carryChapUsersList = carryMap.get("ADD_NEW_CHAPUSER_DATA");
        if (null == carryChapUsersList || 0 == carryChapUsersList.size()) {
            this.logUty.putlog("exitAddNewChapUsersAction", "carryChapUsersList is null or zero.");
            throw SJctrIscsiUtility.makeException(107004);
        }
        SJctrAddChapUsersTableDataModel availableTable = (SJctrAddChapUsersTableDataModel)this.getDataObjectModel(KEY_TABLE_AVA_CHAP_USER);
        SJctrAddChapUsersTableDataModel selectedTable = (SJctrAddChapUsersTableDataModel)this.getDataObjectModel(KEY_TABLE_SEL_CHAP_USER);
        int userLastId = availableTable.getAllRowData().size() + selectedTable.getAllRowData().size();
        ((SJctrChapUserInfoIncludeNewChap)carryChapUsersList.get(0)).setUserSeqNo(userLastId);
        availableTable.addRowDataTop(carryChapUsersList);
        availableTable.setDirty();
    }

    private List<SJctrChapUserInfoIncludeNewChap> getAvailableChapUserList(Set<Short> selectPort, Set<String> allChapListInSelectIscsi, Map<Short, Set<String>> allPortChapMap, List<SJmoChapUserInfo> allChapList) {
        ArrayList<SJctrChapUserInfoIncludeNewChap> availChapUserList = new ArrayList<SJctrChapUserInfoIncludeNewChap>();
        for (SJmoChapUserInfo chapUserInfo : allChapList) {
            SJctrChapUserInfoIncludeNewChap newChapUserInfo;
            String chapUserName = chapUserInfo.getStrUserName();
            if (allChapListInSelectIscsi.contains(chapUserName)) continue;
            int checkNumberThreshold = 1;
            if (selectPort.contains(chapUserInfo.getSPort())) {
                ++checkNumberThreshold;
            }
            if (null == (newChapUserInfo = this.checkAndGetAvailableChapUser(selectPort, allPortChapMap, checkNumberThreshold, chapUserInfo))) continue;
            availChapUserList.add(newChapUserInfo);
        }
        return availChapUserList;
    }

    private void checkAddChapUserNumber(List<Object> availTblSelectRowDataList, List<Object> selectTblAllRowDataList, List<SJmoIscsiTargetInfo> iscsiTargetList) {
        for (SJmoIscsiTargetInfo iscsiInfo : iscsiTargetList) {
            int numOfAllChapUser = availTblSelectRowDataList.size() + selectTblAllRowDataList.size() + iscsiInfo.getAlUserInfo().size();
            if (SJctrIscsiDataMacro.PORT_CHAPUSER_MAX >= numOfAllChapUser) continue;
            this.logUty.putlog("checkAddChapUserNumber", "Number of CHAP User is over 255.");
            throw SJctrIscsiUtility.makeException(206200);
        }
    }

    private SJctrChapUserInfoIncludeNewChap checkAndGetAvailableChapUser(Set<Short> selectPort, Map<Short, Set<String>> allPortChapMap, int threshold, SJmoChapUserInfo checkChapInfo) {
        Short portId;
        Set<String> chapUserNameList;
        SJctrChapUserInfoIncludeNewChap availChapUser = null;
        int count = 0;
        Iterator<Short> i$ = selectPort.iterator();
        while (i$.hasNext() && (null == (chapUserNameList = allPortChapMap.get(portId = i$.next())) || !chapUserNameList.contains(checkChapInfo.getStrUserName()) || ++count != threshold)) {
        }
        if (count < threshold) {
            availChapUser = new SJctrChapUserInfoIncludeNewChap(checkChapInfo, -1, false);
        }
        return availChapUser;
    }

    private void viewErrorTable(List<SJctrErrorColumnData> errorList, Object errorTable) {
        SJctrRelatedDispDataObject rel = this.createDialog(SJctrErrorDataController.class, null);
        SJctrErrorDataController errDc = (SJctrErrorDataController)this.getOwner().getDataController(rel);
        errDc.setParameter(errorTable, errorList);
        SJctrError errInfo = errDc.getRepresentativeError(errorList);
        SJcException exp = errInfo.createException();
        exp.setErrDisp(rel);
        throw exp;
    }

    private void checkChapAuthentication(List<SJmoIscsiTargetInfo> selectIscsiTargetList) {
        for (SJmoIscsiTargetInfo targetinfo : selectIscsiTargetList) {
            if (targetinfo.getiUserAuthentSwitch() != 2) continue;
            this.logUty.putlog("checkChapAuthentication", "CHAP Authentication of iSCSI Target is Disabled.");
            throw SJctrIscsiUtility.makeException(206243);
        }
    }

    public static enum ADD_CHAP_USERS_MSG implements SJctrNotifyState
    {
        SELECT_ADD,
        SELECT_REMOVE,
        SELECT_ADD_NEW_CHAP_USER;

    }
}

