/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.unmapluns;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.controller.com.SJctrActionDefine;
import sanproject.sn2.controller.com.SJctrComCVSUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrMessageDataController;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.comparator.SJctrLdevIndexComparator;
import sanproject.sn2.controller.com.comparator.SJctrPortLunDetailComparator;
import sanproject.sn2.controller.com.comparator.SJctrPortLunDetail_LdevComparator;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrCheckBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.cvs.com.SJctrCVSUtility;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortLunTableKey;
import sanproject.sn2.controller.wizard.lunm.com.SJctrReplaceDataForConfirm;
import sanproject.sn2.controller.wizard.lunm.unmapluns.SJctrUnmapLUNsConfirmData;
import sanproject.sn2.controller.wizard.lunm.unmapluns.SJctrUnmapLUNsFooterModel;
import sanproject.sn2.controller.wizard.lunm.unmapluns.SJctrUnmapLUNsTableModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetHDPRelation;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevGuardInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevLuseInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortHostGroupInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetThinProvisioningVolumesStatus;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.group.SJmoHDPRelation;
import sanproject.sn2.model.data.lu.SJmoHostGroupIndex;
import sanproject.sn2.model.data.lu.SJmoPortHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.lu.SJmoPortLunInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevGuardInfo;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevLuseInfo;
import sanproject.sn2.model.data.volume.SJmoLdevNicknameInfo;
import sanproject.sn2.model.data.volume.SJmoThinProvisioningVolumesStatus;

public class SJctrUnmapLUNsDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 0x1100061;
    public static final String KEY_TABLE = "COM_TABLE";
    public static final String KEY_ALLDEL_PATH = "COM_ALLDEL_PATH";
    public static final String KEY_FOOTER = "COM_FOOTER";
    public static final String KEY_PORTLUN_TO_DELLUN = "KEY_PORTLUN_TO_DELLUN";
    public static final String KEY_LDEVDTL_TO_DELLUN = "KEY_LDEVDTL_TO_DELLUN";
    public static final String KEY_SELECT_LDEV_INDEX = "KEY_SELECT_LDEV_INDEX";
    public static final Class<?> KEY_CLASS_LUPATH_TABLEKEY = SJctrPortLunTableKey.class;
    public static final Class KEY_CLASS_MPORTLUNINFO = SJmoGetPortLunInfo.class;
    public static final Class KEY_CLASS_MGUARDINFO = SJmoGetLdevGuardInfo.class;
    public static final Class KEY_CLASS_MPORTDETAIL = SJmoGetPortDetail.class;
    public static final Class KEY_CLASS_MPORTHGINFO = SJmoGetPortHostGroupInfo.class;
    public static final Class KEY_CLASS_MPORTITINFO = SJmoGetPortIscsiTargetInfo.class;
    public static final Class KEY_CLASS_MLDEVDETAIL = SJmoGetLdevDetail.class;
    public static final Class KEY_CLASS_MLUSEINFO = SJmoGetLdevLuseInfo.class;
    public static final Class KEY_CLASS_MLDEVNICKINFO = SJmoGetLdevNicknameInfo.class;
    public static final Class KEY_CLASS_RSG = SJmoGetRSGgetAllRsgs.class;
    public static final Class KEY_CLASS_HDPRELATION = SJmoGetHDPRelation.class;
    public static final Class KEY_CLASS_DPVOLSTATUS = SJmoGetThinProvisioningVolumesStatus.class;
    public static final String KEY_CLASS_CONFIRM_DATA = "SJctrUnmapLUNsConfirmData";
    public static final String KEY_ALL_DEL_PATH_CHKBOX = "ALL_DEL_PATH_CHKBOX";
    public static final String TITLE = "DISP_DI6S_TITLE";
    public static final String DISP_UNMAP_ALL_LUNS = "DISP_UNMAP_ALL_LUNS";
    public static final int DRU_RESEVED_CHECKMASK = 136;
    public static int UNMAPLUN_ERR1 = 107001;
    public static int UNMAPLUN_ERR2 = 107002;
    public static int UNMAPLUN_ERR3 = 106506;
    public static int UNMAPLUN_ERR4 = 108003;
    public static int UNMAPLUN_ERR5 = 107004;
    public static int UNMAPLUN_ERR6 = 106503;
    public static int UNMAPLUN_ERR7 = 106524;
    public static int UNMAPLUN_ERR8 = 106089;
    public static int UNMAPLUN_ERR9 = 105297;
    public static int UNMAPLUN_ERR10 = 105298;
    public static int UNMAPLUN_ERR11 = 107003;
    public static int UNMAPLUN_ERR12 = 205145;
    public static int UNMAPLUN_ERR_SysRSG_LDEV = 205165;
    public static int UNMAPLUN_ERR_LunPathDel_HnasUser_NotAll = 205167;
    private int checkDataType;
    private static final int LUPATH_TYPE = 1;
    private static final int LDEV_TYPE = 2;
    private SJctrRelatedDispDataObject dialogOmittedLUNPathsMsg;
    private boolean flgShowOmittedLUNPathsMsg = false;
    static final SJctrPortLunDetailComparator PORTLUN_COMP = new SJctrPortLunDetailComparator();

    public SJctrUnmapLUNsDC() throws SJcException {
        super(0x1100061);
        this.initDataModel();
        this.initListener();
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_TABLE, new SJctrUnmapLUNsTableModel());
        this.addDataObjectModel(KEY_ALLDEL_PATH, new SJctrCheckBoxDataModel());
        this.addDataObjectModel(KEY_FOOTER, new SJctrUnmapLUNsFooterModel());
        this.addDataObjectModel("COM_CHILD", new OmittedLUNPathsMsgDataModel());
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        SJctrCheckBoxDataModel chkBox = (SJctrCheckBoxDataModel)this.getDataObjectModel(KEY_ALLDEL_PATH);
        chkBox.setLabel(util.getGuidance("LUNM", DISP_UNMAP_ALL_LUNS));
    }

    @Override
    public boolean checkStartData() {
        boolean bRet = true;
        List<?> targetList = this.getCache(KEY_PORTLUN_TO_DELLUN);
        if (targetList != null && targetList.size() != 0) {
            this.checkDataType = 1;
        } else {
            List<?> anotherTargetList = this.getCache(KEY_LDEVDTL_TO_DELLUN);
            if (anotherTargetList != null && anotherTargetList.size() != 0) {
                this.checkDataType = 2;
            } else {
                bRet = false;
                SJctrError err = new SJctrError(10, 22, UNMAPLUN_ERR1);
                SJcException exp = err.createException();
                throw exp;
            }
        }
        return bRet;
    }

    @Override
    public boolean checkConstructData() {
        boolean bRet = true;
        List<SJctrPortLunTableKey> targetList = this.checkDataType == 1 ? this.getCache(KEY_PORTLUN_TO_DELLUN) : this.getCache(KEY_LDEVDTL_TO_DELLUN);
        SJctrTableDataModel parentTbl = (SJctrTableDataModel)this.getWizardWindow().getParentDC().getDataObjectModel(KEY_TABLE);
        ArrayList<SJctrError> errList = new ArrayList<SJctrError>(targetList.size());
        for (int errpos = 0; errpos < targetList.size(); ++errpos) {
            SJctrError oneError = new SJctrError(0, 0, -1);
            errList.add(oneError);
        }
        if (this.checkDataType == 1) {
            bRet = this.checkConstructDataFromLuPath(targetList, errList);
        } else {
            bRet = this.checkConstructDataFromLdevDetail(targetList, errList);
            if (!this.flgShowOmittedLUNPathsMsg) {
                SJctrCheckBoxDataModel delCheck = (SJctrCheckBoxDataModel)this.getDataObjectModel(KEY_ALLDEL_PATH);
                delCheck.setEnableListener(false);
                delCheck.setSelect(true);
                delCheck.setEnableListener(true);
            }
        }
        if (!bRet) {
            SJctrError firstError = null;
            ArrayList<SJctrErrorColumnData> newErrList = new ArrayList<SJctrErrorColumnData>();
            for (int errpos = 0; errpos < errList.size(); ++errpos) {
                SJctrError errElement = errList.get(errpos);
                if (errElement.getError() == -1) continue;
                SJctrErrorColumnData errData = new SJctrErrorColumnData(targetList.get(errpos), errElement);
                newErrList.add(errData);
                if (firstError != null) continue;
                firstError = errElement;
            }
            SJctrRelatedDispDataObject rel = this.createDialog(SJctrErrorDataController.class, null);
            SJctrErrorDataController errDc = (SJctrErrorDataController)this.getOwner().getDataController(rel);
            errDc.setParameter(parentTbl, newErrList);
            SJctrError error = errDc.getRepresentativeError(newErrList, 5);
            SJcException exp = error.createException();
            exp.setErrDisp(rel);
            throw exp;
        }
        return bRet;
    }

    private boolean checkConstructDataFromLuPath(List<SJctrPortLunTableKey> targetList, List<SJctrError> errlist) {
        boolean bRet = true;
        List<?> getPtLun = this.getCache(KEY_CLASS_MPORTLUNINFO);
        List<SJmoLdevGuardInfo> getgd = this.getCache(KEY_CLASS_MGUARDINFO);
        List<?> rsgDetailList = this.getCache(KEY_CLASS_RSG);
        if (rsgDetailList == null || rsgDetailList.size() == 0) {
            this.logUty.putlog("checkConstructDataFromLuPath", "No ALL RSG");
            SJctrError err = new SJctrError(10, 22, UNMAPLUN_ERR2);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), (SJmoRSGgetAllRsgs)rsgDetailList.get(0));
        SJmoHostGroupIndex hgIndex = new SJmoHostGroupIndex();
        int size = targetList.size();
        ArrayList<SJctrPortLunTableKey> keyList = new ArrayList<SJctrPortLunTableKey>(size);
        for (int errpos = 0; errpos < targetList.size(); ++errpos) {
            SJctrPortLunTableKey portLunKey = null;
            SJctrPortLunTableKey portLunTblKey = targetList.get(errpos);
            SJmoPortIndex portIndex = new SJmoPortIndex();
            portIndex.setSPort(portLunTblKey.getPortLunInfo().getSPort());
            int index = Collections.binarySearch(getPtLun, portIndex);
            if (index < 0) {
                bRet = false;
                SJctrError errElement = errlist.get(errpos);
                errElement.setFunc(10);
                errElement.setModule(22);
                errElement.setError(UNMAPLUN_ERR2);
                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructDataFromLuPath", "Port#= " + portIndex.getSPort() + " Not Found!!!");
                continue;
            }
            SJmoPortLunInfo portLunInfo = (SJmoPortLunInfo)getPtLun.get(index);
            ArrayList portLunDtlList = portLunInfo.getAlPortLun();
            Collections.sort(portLunDtlList, PORTLUN_COMP);
            int dtlIndex = Collections.binarySearch(portLunDtlList, portLunTblKey.getPortLunDetail(), PORTLUN_COMP);
            if (dtlIndex < 0) {
                bRet = false;
                SJctrError errElement = errlist.get(errpos);
                errElement.setFunc(10);
                errElement.setModule(22);
                errElement.setError(UNMAPLUN_ERR3);
                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructDataFromLuPath", "Port#= " + portIndex.getSPort() + ", HostGroup#= " + portLunTblKey.getPortLunDetail().getSHostGroup() + ", Lun= " + portLunTblKey.getPortLunDetail().getSLUN() + " Not Found!!!");
                continue;
            }
            SJmoPortLunDetail ptLunDetail = (SJmoPortLunDetail)portLunDtlList.get(dtlIndex);
            hgIndex.setSPort(ptLunDetail.getSPort());
            hgIndex.setSHostGroup(ptLunDetail.getSHostGroup());
            boolean rsgFlg = SJctrPortUtility.isRsgHostGroupIndex(hgIndex, rsgUtil);
            if (!rsgFlg) {
                SJctrError err = new SJctrError(10, 22, UNMAPLUN_ERR9);
                SJcException exp = err.createException();
                throw exp;
            }
            portLunKey = new SJctrPortLunTableKey(portLunInfo, (SJmoPortLunDetail)portLunDtlList.get(dtlIndex));
            keyList.add(portLunKey);
        }
        if (bRet) {
            ArrayList<SJmoLdevDetail> ldevIndexList = new ArrayList<SJmoLdevDetail>(targetList.size());
            List<?> ldevDetailList = this.getCache(KEY_CLASS_MLDEVDETAIL);
            for (int errpos = 0; errpos < targetList.size(); ++errpos) {
                SJctrPortLunTableKey portLunKey = targetList.get(errpos);
                SJmoPortLunDetail portLunDetail = portLunKey.getPortLunDetail();
                SJmoLdevIndex ldevIndex = new SJmoLdevIndex();
                ldevIndex.setSLdkc(portLunDetail.getSLDKC());
                ldevIndex.setSCu(portLunDetail.getSCU());
                ldevIndex.setSLdev(portLunDetail.getSLDEV());
                int detailIndex = Collections.binarySearch(ldevDetailList, ldevIndex);
                if (detailIndex < 0) {
                    bRet = false;
                    SJctrError errElement = errlist.get(errpos);
                    errElement.setFunc(10);
                    errElement.setModule(22);
                    errElement.setError(UNMAPLUN_ERR2);
                    continue;
                }
                int rsgId = rsgUtil.getRsgId(ldevIndex);
                boolean rsgFlg = SJctrPortUtility.chkResourceGroup(rsgId, rsgUtil);
                if (!rsgFlg) {
                    this.logUty.putlog("checkConstructDataFromLuPath", "extract Impossible LDEV");
                    bRet = false;
                    SJctrError errElement = errlist.get(errpos);
                    errElement.setFunc(10);
                    errElement.setModule(22);
                    errElement.setError(UNMAPLUN_ERR10);
                    continue;
                }
                boolean sysRsgFlg = rsgUtil.isSelRscLdevInSysRsg(ldevIndex);
                if (sysRsgFlg) {
                    bRet = false;
                    SJctrError errElement = errlist.get(errpos);
                    errElement.setFunc(10);
                    errElement.setModule(22);
                    errElement.setError(UNMAPLUN_ERR_SysRSG_LDEV);
                    continue;
                }
                SJmoLdevDetail ldevDetail = (SJmoLdevDetail)ldevDetailList.get(detailIndex);
                ldevIndexList.add(ldevDetail);
            }
            if (bRet) {
                bRet = this.checkGuardReservedVol(getgd, ldevIndexList, errlist);
            }
        }
        if (bRet) {
            this.putCache(KEY_CLASS_LUPATH_TABLEKEY, keyList);
        }
        return bRet;
    }

    private boolean checkConstructDataFromLdevDetail(List<SJmoLdevDetail> targetList, List<SJctrError> errlist) {
        SJctrError errElement;
        boolean bRet = true;
        Collections.sort(targetList);
        List<SJmoPortLunInfo> getPtLun = this.getCache(KEY_CLASS_MPORTLUNINFO);
        List<SJmoLdevGuardInfo> getgd = this.getCache(KEY_CLASS_MGUARDINFO);
        List<?> rsgDetailList = this.getCache(KEY_CLASS_RSG);
        if (rsgDetailList == null || rsgDetailList.size() == 0) {
            this.logUty.putlog("checkConstructDataFromLuPath", "No ALL RSG");
            SJctrError err = new SJctrError(10, 22, UNMAPLUN_ERR2);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), (SJmoRSGgetAllRsgs)rsgDetailList.get(0));
        ArrayList<Boolean> chgErrorList = new ArrayList<Boolean>(targetList.size());
        SJmoLdevIndex ldevIndex = new SJmoLdevIndex();
        for (int index = 0; index < targetList.size(); ++index) {
            SJmoLdevDetail ldevDetail = targetList.get(index);
            ldevIndex.setLdevIndex(ldevDetail.getSLdkc(), ldevDetail.getSCu(), ldevDetail.getSLdev());
            int rsgId = rsgUtil.getRsgId(ldevIndex);
            boolean rsgFlg = SJctrPortUtility.chkResourceGroup(rsgId, rsgUtil);
            if (!rsgFlg) {
                SJctrLogUty.info(this.getClass().getSimpleName(), "checkConstructDataFromLdevDetail", "Extract Impossible Ldev RSG ID = " + rsgId);
                bRet = false;
                errElement = errlist.get(index);
                errElement.setFunc(10);
                errElement.setModule(22);
                errElement.setError(UNMAPLUN_ERR10);
                continue;
            }
            boolean sysRsgFlg = rsgUtil.isSelRscLdevInSysRsg(ldevIndex);
            if (!sysRsgFlg) continue;
            bRet = false;
            SJctrError errElement2 = errlist.get(index);
            errElement2.setFunc(10);
            errElement2.setModule(22);
            errElement2.setError(UNMAPLUN_ERR_SysRSG_LDEV);
        }
        List<SJctrPortLunTableKey> ptLunList = SJctrPortUtility.getPortLunListFromLdevDetail(targetList, getPtLun, chgErrorList);
        ArrayList<SJctrPortLunTableKey> keyList = new ArrayList<SJctrPortLunTableKey>(1);
        SJmoHostGroupIndex hgIndex = new SJmoHostGroupIndex();
        for (SJctrPortLunTableKey portLunKey : ptLunList) {
            short sHostGroup = portLunKey.getPortLunDetail().getSHostGroup();
            short sPort = portLunKey.getPortLunDetail().getSPort();
            hgIndex.setSPort(sPort);
            hgIndex.setSHostGroup(sHostGroup);
            boolean rsgHgFlg = SJctrPortUtility.isRsgHostGroupIndex(hgIndex, rsgUtil);
            if (rsgHgFlg) {
                keyList.add(portLunKey);
                continue;
            }
            this.flgShowOmittedLUNPathsMsg = true;
        }
        for (int errpos = 0; errpos < targetList.size(); ++errpos) {
            if (((Boolean)chgErrorList.get(errpos)).booleanValue()) continue;
            bRet = false;
            errElement = errlist.get(errpos);
            errElement.setFunc(10);
            errElement.setModule(22);
            errElement.setError(UNMAPLUN_ERR7);
        }
        if (bRet) {
            bRet = this.checkGuardReservedVol(getgd, targetList, errlist);
        }
        if (bRet) {
            this.putCache(KEY_CLASS_LUPATH_TABLEKEY, keyList);
        }
        return bRet;
    }

    private boolean checkGuardReservedVol(List<SJmoLdevGuardInfo> mdlGdInfo, List<SJmoLdevDetail> chkLdevList, List<SJctrError> errList) {
        boolean ret = true;
        for (int index = 0; index < chkLdevList.size(); ++index) {
            SJmoLdevDetail ldevDetail;
            SJctrError errElement = errList.get(index);
            if (errElement.getError() != -1 || (ldevDetail = chkLdevList.get(index)).getByVolumeFlag() != 3) continue;
            int gdIndex = Collections.binarySearch(mdlGdInfo, ldevDetail, null);
            if (gdIndex < 0) {
                ret = false;
                errElement.setFunc(10);
                errElement.setModule(22);
                errElement.setError(UNMAPLUN_ERR6);
                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkGuardReservedVol", "LDEV#= " + chkLdevList.get(index).getIndex() + " Not Found!!!");
                continue;
            }
            SJmoLdevGuardInfo gdinfo = mdlGdInfo.get(gdIndex);
            if ((gdinfo.getByLdevGuardStatus() & 0xFFFFFF88) != -120) continue;
            ret = false;
            errElement.setFunc(10);
            errElement.setModule(22);
            errElement.setError(UNMAPLUN_ERR4);
        }
        return ret;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        set.add(this.createModelDirect(KEY_CLASS_MPORTLUNINFO));
        set.add(this.createModelDirect(KEY_CLASS_MGUARDINFO));
        set.add(this.createModelDirect(KEY_CLASS_MPORTDETAIL));
        set.add(this.createModelDirect(KEY_CLASS_MPORTHGINFO));
        set.add(this.createModelDirect(KEY_CLASS_MLDEVDETAIL));
        set.add(this.createModelDirect(KEY_CLASS_MLUSEINFO));
        set.add(this.createModelDirect(KEY_CLASS_RSG));
        set.add(this.createModelDirect(KEY_CLASS_MPORTITINFO));
        set.add(this.createModelDirect(KEY_CLASS_HDPRELATION));
        set.add(this.createModelDirect(KEY_CLASS_DPVOLSTATUS));
        return set;
    }

    private SJctrGetDirectWrapper createModelDirect(Class<? extends SJmoGetKind_IF> kindClass) {
        SJctrGetDirectWrapper retValue = null;
        try {
            SJmoGetKind_IF kind = kindClass.newInstance();
            SJmoGetRange_IF range = null;
            ArrayList filterList = new ArrayList();
            SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
            retValue = new SJctrGetDirectWrapper(direct);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return retValue;
    }

    @Override
    public boolean checkEndData() {
        Boolean prevChkBoxFlg;
        boolean bRet = true;
        SJctrCheckBoxDataModel delCheck = (SJctrCheckBoxDataModel)this.getDataObjectModel(KEY_ALLDEL_PATH);
        List<?> chkboxCache = this.getCache(KEY_ALL_DEL_PATH_CHKBOX);
        if (chkboxCache != null && chkboxCache.size() != 0 && (prevChkBoxFlg = (Boolean)chkboxCache.get(0)).booleanValue() == delCheck.isSelect()) {
            this.checkEndLdevUserLU();
            return bRet;
        }
        this.checkEndRsg();
        this.checkEndLdevUserLU();
        ArrayList<Boolean> newCache = new ArrayList<Boolean>(1);
        Boolean newFlg = delCheck.isSelect();
        newCache.add(newFlg);
        this.putCache(KEY_ALL_DEL_PATH_CHKBOX, newCache);
        return bRet;
    }

    SJctrUnmapLUNsConfirmData createConfirmData(List<SJctrPortLunTableKey> targetList) {
        List<SJmoLdevIndex> ldevList = this.getTargetLdevList(targetList);
        List<SJctrPortLunTableKey> newTargetList = this.makeDelLuPathList(targetList, ldevList);
        TreeSet<SJmoPortLunInfo> portSet = new TreeSet<SJmoPortLunInfo>();
        for (SJctrPortLunTableKey key : newTargetList) {
            portSet.add(key.getPortLunInfo());
        }
        ArrayList<SJmoPortIndex> targetPortList = new ArrayList<SJmoPortIndex>(portSet);
        List<SJmoPortDetail> portDetailList = this.getCache(KEY_CLASS_MPORTDETAIL);
        List<SJmoPortDetail> confirmPortDetailList = SJctrReplaceDataForConfirm.getConfirmPortDetail(targetPortList, portDetailList);
        List<SJmoPortHostGroupInfo> portHgList = this.getCache(KEY_CLASS_MPORTHGINFO);
        List<SJmoPortHostGroupInfo> confirmPortHgList = SJctrReplaceDataForConfirm.getConfirmPortHostGroupInfo(targetPortList, portHgList);
        List<SJmoPortIscsiTargetInfo> portItList = this.getCache(KEY_CLASS_MPORTITINFO);
        List<SJmoPortIscsiTargetInfo> confirmPortItList = SJctrReplaceDataForConfirm.getConfirmPortIscsiTargetInfo(targetPortList, portItList);
        List<SJmoPortLunInfo> portLunList = this.getCache(KEY_CLASS_MPORTLUNINFO);
        List<SJmoPortLunInfo> confirmPortLunList = SJctrReplaceDataForConfirm.getConfirmPortLunInfo(targetPortList, portLunList);
        List<SJmoLdevLuseInfo> luseList = this.getCache(KEY_CLASS_MLUSEINFO);
        List<SJmoLdevLuseInfo> confirmLuseList = SJctrReplaceDataForConfirm.getConfirmLdevLuseInfo(ldevList, luseList);
        List<SJmoLdevDetail> ldevDetailList = this.getCache(KEY_CLASS_MLDEVDETAIL);
        HashSet<SJmoLdevIndex> allLdevs = new HashSet<SJmoLdevIndex>(ldevDetailList.size());
        allLdevs.addAll(ldevList);
        for (SJmoLdevLuseInfo luse : confirmLuseList) {
            ArrayList luseLdevIndexList = luse.getAlLUSELdevIndex();
            for (SJmoLdevIndex ldevIndex : luseLdevIndexList) {
                allLdevs.add(ldevIndex);
            }
        }
        ArrayList<SJmoLdevIndex> allLdevList = new ArrayList<SJmoLdevIndex>(allLdevs);
        Collections.sort(allLdevList);
        List<SJmoLdevDetail> confirmLdevDetailList = SJctrReplaceDataForConfirm.getConfirmLdevDetail(allLdevList, ldevDetailList);
        List<SJmoLdevNicknameInfo> nickList = this.getCache(KEY_CLASS_MLDEVNICKINFO);
        List<SJmoLdevNicknameInfo> confirmNickList = SJctrReplaceDataForConfirm.getConfirmLdevNickname(ldevList, nickList);
        SJctrUnmapLUNsConfirmData confirmData = new SJctrUnmapLUNsConfirmData();
        confirmData.setDelLuPathList(newTargetList);
        confirmData.setPortDetail(confirmPortDetailList);
        confirmData.setPortHostGroupInfo(confirmPortHgList);
        confirmData.setPortIscsiTargetInfo(confirmPortItList);
        confirmData.setPortLunInfo(confirmPortLunList);
        confirmData.setLdevDetail(confirmLdevDetailList);
        confirmData.setLdevLuseInfo(confirmLuseList);
        confirmData.setLdevNickInfo(confirmNickList);
        ArrayList<SJctrUnmapLUNsConfirmData> confirmDataList = new ArrayList<SJctrUnmapLUNsConfirmData>();
        confirmDataList.add(confirmData);
        this.putCache(KEY_CLASS_CONFIRM_DATA, confirmDataList);
        return confirmData;
    }

    private List<SJmoLdevIndex> getTargetLdevList(List<SJctrPortLunTableKey> targetList) {
        TreeSet<SJmoLdevIndex> ldevSet = new TreeSet<SJmoLdevIndex>();
        for (SJctrPortLunTableKey portLunKey : targetList) {
            SJmoLdevIndex ldevIndex = new SJmoLdevIndex();
            ldevIndex.setLdevIndex(portLunKey.getPortLunDetail().getSLDKC(), portLunKey.getPortLunDetail().getSCU(), portLunKey.getPortLunDetail().getSLDEV());
            ldevSet.add(ldevIndex);
        }
        ArrayList<SJmoLdevIndex> ldevList = new ArrayList<SJmoLdevIndex>(ldevSet);
        return ldevList;
    }

    private List<SJctrPortLunTableKey> makeDelLuPathList(List<SJctrPortLunTableKey> targetList, List<SJmoLdevIndex> ldevList) {
        ArrayList<SJctrPortLunTableKey> retList = new ArrayList<SJctrPortLunTableKey>(targetList.size());
        SJctrCheckBoxDataModel delCheck = (SJctrCheckBoxDataModel)this.getDataObjectModel(KEY_ALLDEL_PATH);
        if (delCheck.isSelect()) {
            List<?> mdlPortLunList = this.getCache(SJmoGetPortLunInfo.class);
            for (SJmoPortLunInfo mdlPortLun : mdlPortLunList) {
                ArrayList mdlLunDetailList = mdlPortLun.getAlPortLun();
                for (SJmoPortLunDetail mdlLunDetail : mdlLunDetailList) {
                    SJmoLdevIndex hgLunIndex = new SJmoLdevIndex();
                    hgLunIndex.setLdevIndex(mdlLunDetail.getSLDKC(), mdlLunDetail.getSCU(), mdlLunDetail.getSLDEV());
                    int result = Collections.binarySearch(ldevList, hgLunIndex);
                    if (result < 0) continue;
                    SJctrPortLunTableKey putData = new SJctrPortLunTableKey(mdlPortLun, mdlLunDetail);
                    retList.add(putData);
                }
            }
        } else {
            retList.addAll(targetList);
        }
        return retList;
    }

    private void checkEndRsg() {
        SJctrCheckBoxDataModel delCheck = (SJctrCheckBoxDataModel)this.getDataObjectModel(KEY_ALLDEL_PATH);
        List<?> rsgDetailList = this.getCache(KEY_CLASS_RSG);
        if (rsgDetailList == null || rsgDetailList.size() == 0) {
            this.logUty.putlog("checkConstructDataFromLuPath", "No ALL RSG");
            SJctrError err = new SJctrError(10, 22, UNMAPLUN_ERR11);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), (SJmoRSGgetAllRsgs)rsgDetailList.get(0));
        SJmoHostGroupIndex hgIndex = new SJmoHostGroupIndex();
        if (delCheck.isSelect()) {
            List<?> mdlPortLunList = this.getCache(SJmoGetPortLunInfo.class);
            List<?> tableRowList = this.getCache(KEY_CLASS_LUPATH_TABLEKEY);
            for (SJctrPortLunTableKey tableRowData : tableRowList) {
                SJmoPortLunDetail lunDetail = tableRowData.getPortLunDetail();
                SJmoLdevIndex target = new SJmoLdevIndex();
                target.setLdevIndex(lunDetail.getSLDKC(), lunDetail.getSCU(), lunDetail.getSLDEV());
                for (SJmoPortLunInfo mdlPortLun : mdlPortLunList) {
                    ArrayList mdlLunDetailList = mdlPortLun.getAlPortLun();
                    for (SJmoPortLunDetail mdlLunDetail : mdlLunDetailList) {
                        SJmoLdevIndex model = new SJmoLdevIndex();
                        model.setLdevIndex(mdlLunDetail.getSLDKC(), mdlLunDetail.getSCU(), mdlLunDetail.getSLDEV());
                        if (0 != model.compareTo(target)) continue;
                        hgIndex.setSPort(mdlLunDetail.getSPort());
                        hgIndex.setSHostGroup(mdlLunDetail.getSHostGroup());
                        boolean rsgFlg = SJctrPortUtility.isRsgHostGroupIndex(hgIndex, rsgUtil);
                        if (!rsgFlg) {
                            SJctrError err = new SJctrError(10, 22, UNMAPLUN_ERR12);
                            SJcException exp = err.createException();
                            throw exp;
                        }
                        boolean sysRsgFlg = rsgUtil.isSelRscLdevInSysRsg(model);
                        if (!sysRsgFlg) continue;
                        SJctrError err = new SJctrError(10, 22, UNMAPLUN_ERR_SysRSG_LDEV);
                        SJcException exp = err.createException();
                        throw exp;
                    }
                }
            }
        }
    }

    private void checkEndLdevUserLU() {
        SJctrCheckBoxDataModel delCheck = (SJctrCheckBoxDataModel)this.getDataObjectModel(KEY_ALLDEL_PATH);
        if (delCheck.isSelect()) {
            return;
        }
        List<?> mdlPortLunList = this.getCache(SJmoGetPortLunInfo.class);
        List<?> portDetailList = this.getCache(SJmoGetPortDetail.class);
        ArrayList<SJmoPortLunInfo> userLunList = new ArrayList<SJmoPortLunInfo>(2);
        SJmoPortLunInfo lunInfo = null;
        for (SJmoPortDetail portDetail : portDetailList) {
            int portLunInfoIndex;
            if (!SJctrPortUtility.isHnasUserPort(portDetail) || (portLunInfoIndex = Collections.binarySearch(mdlPortLunList, portDetail)) < 0 || userLunList.indexOf(lunInfo = (SJmoPortLunInfo)mdlPortLunList.get(portLunInfoIndex)) >= 0) continue;
            userLunList.add(lunInfo);
        }
        SJctrPortLunDetail_LdevComparator portLunDetail_LdevComparator = new SJctrPortLunDetail_LdevComparator();
        SJctrLdevIndexComparator ldevIndexComparator = new SJctrLdevIndexComparator();
        List<?> tableRowList = this.getCache(KEY_CLASS_LUPATH_TABLEKEY);
        for (SJctrPortLunTableKey tableRowData : tableRowList) {
            SJmoPortLunDetail portLunDetail = tableRowData.getPortLunDetail();
            if (!this.isUserLu_PortLunDetail(userLunList, portLunDetail)) continue;
            SJmoLdevIndex ldevIndex = new SJmoLdevIndex();
            ldevIndex.setLdevIndex(portLunDetail.getSLDKC(), portLunDetail.getSCU(), portLunDetail.getSLDEV());
            for (SJmoPortLunInfo UserLunInfo : userLunList) {
                ArrayList userPortLunList = UserLunInfo.getAlPortLun();
                for (int i = 0; i < userPortLunList.size(); ++i) {
                    SJmoPortLunDetail lunDetail = (SJmoPortLunDetail)userPortLunList.get(i);
                    if (ldevIndexComparator.compare(lunDetail, ldevIndex) != 0) continue;
                    boolean selectFlag = false;
                    for (SJctrPortLunTableKey checkTableRowData : tableRowList) {
                        SJmoPortLunDetail checkPortLunDetail = checkTableRowData.getPortLunDetail();
                        if (portLunDetail_LdevComparator.compare(checkPortLunDetail, lunDetail) != 0 || checkPortLunDetail.getSPort() != lunDetail.getSPort()) continue;
                        selectFlag = true;
                        break;
                    }
                    if (selectFlag) continue;
                    SJctrError err = new SJctrError(10, 22, UNMAPLUN_ERR_LunPathDel_HnasUser_NotAll);
                    SJcException exp = err.createException();
                    throw exp;
                }
            }
        }
    }

    private boolean isUserLu_PortLunDetail(List<SJmoPortLunInfo> userLunList, SJmoPortLunDetail portLunDetail) {
        SJctrPortLunDetail_LdevComparator portLunDetail_LdevComparator = new SJctrPortLunDetail_LdevComparator();
        for (SJmoPortLunInfo UserLunInfo : userLunList) {
            ArrayList userPortLunList = UserLunInfo.getAlPortLun();
            for (int j = 0; j < userPortLunList.size(); ++j) {
                SJmoPortLunDetail userPortLun = (SJmoPortLunDetail)userPortLunList.get(j);
                if (portLunDetail_LdevComparator.compare(portLunDetail, userPortLun) != 0 || portLunDetail.getSPort() != userPortLun.getSPort()) continue;
                return true;
            }
        }
        return false;
    }

    private void initListener() {
        this.addMessageEventListener(NOTIFY_UNMAP_LUNS.DELETE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrTableDataModel targetTable = (SJctrTableDataModel)SJctrUnmapLUNsDC.this.getDataObjectModel(SJctrUnmapLUNsDC.KEY_TABLE);
                List<Object> list = targetTable.removeSelectedRowData();
                List<?> selectList = SJctrUnmapLUNsDC.this.getCache(KEY_CLASS_LUPATH_TABLEKEY);
                ArrayList newList = new ArrayList(selectList.size());
                newList.addAll(selectList);
                newList.removeAll(list);
                ArrayList setList = new ArrayList(newList);
                SJctrUnmapLUNsDC.this.putCache(KEY_CLASS_LUPATH_TABLEKEY, setList);
                SJctrCheckBoxDataModel delCheck = (SJctrCheckBoxDataModel)SJctrUnmapLUNsDC.this.getDataObjectModel(SJctrUnmapLUNsDC.KEY_ALLDEL_PATH);
                delCheck.setEnableListener(false);
                delCheck.setSelect(false);
                delCheck.setEnableListener(true);
                SJctrUnmapLUNsDC.this.updateFooter();
            }
        });
        SJctrCheckBoxDataModel chkBox = (SJctrCheckBoxDataModel)this.getDataObjectModel(KEY_ALLDEL_PATH);
        chkBox.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrUnmapLUNsDC.this.updateFooter();
            }
        });
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance("LUNM", TITLE);
    }

    @Override
    protected void updateFooter() {
        super.updateFooter();
        SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel(KEY_FOOTER);
        List<?> targetList = this.getCache(KEY_CLASS_LUPATH_TABLEKEY);
        if (targetList == null || targetList.size() == 0) {
            footer.setEnableButton(SJctrFooterDataModel.Button.FINISH, false);
            footer.setEnableButton(SJctrFooterDataModel.Button.NEXT, false);
        } else {
            List<SJmoLdevIndex> notDRDVolList = this.getNotDRDVolLdevList(targetList);
            if (notDRDVolList == null || notDRDVolList.size() == 0) {
                footer.setEnableButton(SJctrFooterDataModel.Button.NEXT, false);
            } else {
                SJctrCheckBoxDataModel delCheck = (SJctrCheckBoxDataModel)this.getDataObjectModel(KEY_ALLDEL_PATH);
                footer.setEnableButton(SJctrFooterDataModel.Button.NEXT, delCheck.isSelect());
            }
        }
    }

    @Override
    public void selectNextTask(SJctrActionDefine action) {
        switch (action) {
            case ACT_SHREDLDEV: {
                this.logUty.putlog("selectNextTask", "Delete Lu Paths -> Shred Ldevs");
                List<?> targetList = this.getCache(KEY_CLASS_LUPATH_TABLEKEY);
                if (targetList == null || targetList.size() == 0) {
                    this.logUty.putlog("selectNextTask", "No Port-LUN Table Data!! Can't make KEY_SELECT_LDEV_INDEX...");
                    SJctrError err = new SJctrError(10, 22, UNMAPLUN_ERR5);
                    SJcException exp = err.createException();
                    throw exp;
                }
                List<SJmoLdevIndex> ldevList = this.getNotDRDVolLdevList(targetList);
                this.putCache(KEY_SELECT_LDEV_INDEX, ldevList);
                ArrayList<Integer> delLuSign = new ArrayList<Integer>();
                delLuSign.add(0x1100061);
                this.putCache("KEY_SHRED_TASKCOMBINATION", delLuSign);
            }
        }
    }

    @Override
    protected boolean preNextEvent(final SJctrMessageEvent msgEvent, final SJctrDataObjectModel<?> dstModel) {
        String strFuncID = Integer.toString(201);
        String strModuleID = Integer.toString(22);
        String strMsgID = Integer.toString(UNMAPLUN_ERR8);
        SJcMessage msg = new SJcMessage(strFuncID, strModuleID, strMsgID);
        SJctrRelatedDispDataObject related = this.createMsgDialog(msg);
        SJctrUserController uc = this.getOwner();
        SJctrMessageDataController msgDC = (SJctrMessageDataController)uc.getDataController(related);
        final SJctrUnmapLUNsDC wizDC = this;
        msgDC.addButton(SJctrMessageDataController.MD_OK, new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                boolean simStatusFlg = SJctrCVSUtility.checkSubSystemStatus();
                if (!simStatusFlg) {
                    SJctrItemSelectListener listner = new SJctrItemSelectListener(){

                        @Override
                        public void selectChanged(SJctrItemSelectEvent<?> event) {
                            SJctrUnmapLUNsDC.this.nextEvent(msgEvent, dstModel);
                        }
                    };
                    SJctrRelatedDispDataObject related = SJctrCVSUtility.createOkCancelMsgDialog(205422, listner, wizDC);
                    SJctrUnmapLUNsDC.this.addUpdateDisp(related);
                } else {
                    SJctrUnmapLUNsDC.this.nextEvent(msgEvent, dstModel);
                }
            }
        });
        msgDC.addButton(SJctrMessageDataController.MD_CANCEL);
        this.addUpdateDisp(related);
        return false;
    }

    private void createDialogOmittedLUNPathsMsg() {
        if (this.dialogOmittedLUNPathsMsg == null) {
            SJcMessage msg = new SJcMessage(Integer.toString(10), Integer.toString(22), Integer.toString(105425));
            this.dialogOmittedLUNPathsMsg = this.createMsgDialog(msg);
        }
    }

    public List<SJmoLdevIndex> getNotDRDVolLdevList(List<?> targetList) {
        List<?> ldevDetailList = this.getCache(KEY_CLASS_MLDEVDETAIL);
        List<SJmoHDPRelation> hdpRelationList = this.getCache(KEY_CLASS_HDPRELATION);
        List<SJmoThinProvisioningVolumesStatus> dpVolStatusList = this.getCache(KEY_CLASS_DPVOLSTATUS);
        ArrayList<SJmoLdevIndex> ldevIndexList = new ArrayList<SJmoLdevIndex>();
        for (int errpos = 0; errpos < targetList.size(); ++errpos) {
            SJmoLdevDetail ldevDetail;
            SJctrPortLunTableKey portLunKey = (SJctrPortLunTableKey)targetList.get(errpos);
            SJmoPortLunDetail portLunDetail = portLunKey.getPortLunDetail();
            SJmoLdevIndex ldevIndex = new SJmoLdevIndex();
            ldevIndex.setSLdkc(portLunDetail.getSLDKC());
            ldevIndex.setSCu(portLunDetail.getSCU());
            ldevIndex.setSLdev(portLunDetail.getSLDEV());
            int detailIndex = Collections.binarySearch(ldevDetailList, ldevIndex);
            if (detailIndex < 0 || SJctrComCVSUtility.isDRDVol(ldevDetail = (SJmoLdevDetail)ldevDetailList.get(detailIndex), hdpRelationList, dpVolStatusList)) continue;
            ldevIndexList.add(ldevIndex);
        }
        return ldevIndexList;
    }

    class OmittedLUNPathsMsgDataModel
    extends SJctrSimpleDataModel {
        OmittedLUNPathsMsgDataModel() {
        }

        @Override
        public Object getDataObject(SJctrDataObject inputObject) {
            ArrayList<SJctrRelatedDispDataObject> retList = new ArrayList<SJctrRelatedDispDataObject>();
            if (SJctrUnmapLUNsDC.this.flgShowOmittedLUNPathsMsg) {
                SJctrUnmapLUNsDC.this.createDialogOmittedLUNPathsMsg();
                retList.add(SJctrUnmapLUNsDC.this.dialogOmittedLUNPathsMsg);
                SJctrUnmapLUNsDC.this.flgShowOmittedLUNPathsMsg = false;
            }
            return retList;
        }
    }

    public static enum NOTIFY_UNMAP_LUNS implements SJctrNotifyState
    {
        DELETE;

    }
}

