/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.monitor.optmon.editmonswitch;

import java.util.ArrayList;
import java.util.List;
import sanproject.serverux.data.MonMonitoringInfoLDKC;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrRadioButtonGroupDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrOptionMonitorUtility;
import sanproject.sn2.controller.wizard.monitor.optmon.editmonswitch.SJctrEditMonitoringSwitchDC;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetMonMonitoringInfoLDKC;
import sanproject.sn2.model.data.SJmoThroughRmiData;

public class SJctrEditMonitoringSwitchDataModel
extends SJctrSimpleDataModel {
    public static final String KEY_MONITORING_SWITCH = "COM_MONITORING_SWITCH";
    public static final String KEY_ENABLE = "COM_ENABLE";
    public static final String KEY_DISABLE = "COM_DISABLE";
    public static final String KEY_INTERVAL = "COM_INTERVAL";
    public static final String KEY_INTERVAL_MIN = "COM_INTERVAL_MIN";
    public static final String KEY_INTERVAL_MIN_SPLIT = "_";
    public static final String KEY_INTERVAL_MIN_EMPTY = "COM_INTERVAL_MIN_EMPTY";

    public SJctrEditMonitoringSwitchDataModel() {
        this.initMonSwitchRadio();
        this.initMonIntervalCombo();
    }

    public void initMonSwitchRadio() {
        SJctrRadioButtonGroupDataModel radio = new SJctrRadioButtonGroupDataModel();
        this.addDataModel(KEY_MONITORING_SWITCH, radio);
        radio.add(KEY_ENABLE);
        radio.add(KEY_DISABLE);
        radio.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrEditMonitoringSwitchDataModel.this.refreshIntervalCombo();
                SJctrEditMonitoringSwitchDataModel.this.fireMessageEvent(SJctrEditMonitoringSwitchDC.EDIT_MON_SW_MSG.RADIO_CHANGED);
            }
        });
    }

    public void initMonIntervalCombo() {
        SJctrComboBoxDataModel combo = new SJctrComboBoxDataModel();
        this.addDataModel(KEY_INTERVAL, combo);
        combo.addItem(KEY_INTERVAL_MIN_EMPTY, "");
        combo.setSelection(KEY_INTERVAL_MIN_EMPTY);
        combo.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrEditMonitoringSwitchDataModel.this.fireMessageEvent(SJctrEditMonitoringSwitchDC.EDIT_MON_SW_MSG.COMBO_CHANGED);
            }
        });
    }

    @Override
    protected void makeModelDirect() {
        SJmoGetMonMonitoringInfoLDKC kind = new SJmoGetMonMonitoringInfoLDKC();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
    }

    @Override
    public void makeDataObject() {
        List<?> rmiData = this.getBasicDataMap().get(SJmoGetMonMonitoringInfoLDKC.class);
        if (null == rmiData) {
            this.logUty.putlog("makeDataObject", "Data of monitor options is null.");
            SJctrError err = new SJctrError(51, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == rmiData.size()) {
            this.logUty.putlog("makeDataObject", "Size of RMIData data list is zero.");
            SJctrError err = new SJctrError(51, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        MonMonitoringInfoLDKC monInfo = (MonMonitoringInfoLDKC)((SJmoThroughRmiData)rmiData.get(0)).getObjRmi();
        if (null == monInfo) {
            this.logUty.putlog("makeDataObject", "Information of monitor options is null.");
            SJctrError err = new SJctrError(51, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrRadioButtonGroupDataModel radio = (SJctrRadioButtonGroupDataModel)this.getDataModel(KEY_MONITORING_SWITCH);
        if (monInfo.isStatus()) {
            radio.setSelect(KEY_ENABLE);
            this.refreshIntervalCombo();
            SJctrComboBoxDataModel combo = (SJctrComboBoxDataModel)this.getDataModel(KEY_INTERVAL);
            int interval = monInfo.getInterval() / 60;
            combo.setSelection("COM_INTERVAL_MIN_" + interval);
        } else {
            radio.setSelect(KEY_DISABLE);
        }
    }

    private void refreshIntervalCombo() {
        List<SJmoGetMonMonitoringInfoLDKC> rmiData = this.getBasicDataList(SJmoGetMonMonitoringInfoLDKC.class);
        MonMonitoringInfoLDKC monInfo = (MonMonitoringInfoLDKC)((SJmoThroughRmiData)((Object)rmiData.get(0))).getObjRmi();
        SJctrComboBoxDataModel combo = (SJctrComboBoxDataModel)this.getDataModel(KEY_INTERVAL);
        combo.removeAllItems();
        combo.addItem(KEY_INTERVAL_MIN_EMPTY, "");
        combo.setSelection(KEY_INTERVAL_MIN_EMPTY);
        SJctrRadioButtonGroupDataModel radio = (SJctrRadioButtonGroupDataModel)this.getDataModel(KEY_MONITORING_SWITCH);
        boolean enableSelected = radio.isSelect(KEY_ENABLE);
        if (enableSelected) {
            int monCUsCount = SJctrOptionMonitorUtility.getMonitoringCUCount(monInfo);
            int increment = 1;
            if (SJctrOptionMonitorUtility.getMonitoringCUBoundary() < monCUsCount) {
                increment = 5;
            }
            for (int interval = 0 + increment; interval <= 15; interval += increment) {
                combo.addItem("COM_INTERVAL_MIN_" + interval, Integer.toString(interval));
            }
            combo.setEnable(true);
        } else {
            combo.setEnable(false);
        }
        combo.setDirty();
    }
}

