/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.pool.editpools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.controller.com.SJctrAuthorizeContainer;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLicenseContainer;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrMessageDataController;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrCheckBoxAreaDataModel;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrRadioButtonGroupDataModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.pool.editpools.SJctrEditPoolsDataDirectMapping;
import sanproject.sn2.controller.wizard.pool.editpools.SJctrEditPoolsDedDataModel;
import sanproject.sn2.controller.wizard.pool.editpools.SJctrEditPoolsDepletionThresholdArea;
import sanproject.sn2.controller.wizard.pool.editpools.SJctrEditPoolsPoolNameArea;
import sanproject.sn2.controller.wizard.pool.editpools.SJctrEditPoolsSubscriptionArea;
import sanproject.sn2.controller.wizard.pool.editpools.SJctrEditPoolsSystemOptionArea;
import sanproject.sn2.controller.wizard.pool.editpools.SJctrEditPoolsThresholdArea;
import sanproject.sn2.controller.wizard.pool.editpools.SJctrEditPoolsTiPairSuspendArea;
import sanproject.sn2.controller.wizard.pool.editpools.SJctrEditPoolsTierArea;
import sanproject.sn2.controller.wizard.pool.editpools.SJctrEditPoolsTierBufNewPageArea;
import sanproject.sn2.controller.wizard.pool.editpools.SJctrEditPoolsTierBufRelocationArea;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.data.group.SJmoHDPRelation;
import sanproject.sn2.model.data.group.SJmoHDPRelationByPool;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolNameInfo;
import sanproject.sn2.model.data.group.SJmoPoolPgKindInfo;
import sanproject.sn2.model.data.group.SJmoPoolSummary;
import sanproject.sn2.model.data.group.SJmoPoolTierInfo;
import sanproject.sn2.model.data.group.SJmoPoolVolDetail;
import sanproject.sn2.model.data.group.SJmoPoolVolInfo;
import sanproject.sn2.model.data.util.SJmoDataUtility;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public class SJctrEditPoolsDC
extends SJctrWizardDataController {
    protected static final int DISP_ID = 17826657;
    public static final String KEY_CLASS_EDIT_DATA = "KEY_CLASS_EDIT_DATA";
    public static final String KEY_CLASS_EDIT_POOLNAME = "KEY_CLASS_EDIT_POOLNAME";
    public static final String KEY_CLASS_CHK_EDIT_POOLDTL = "KEY_CLASS_CHK_EDIT_POOLDTL";
    public static final int STS_DATA = 0;
    public static final int STS_ENABLEPOOL_ON = 1;
    public static final int STS_DISABLEPOOL_ON = 2;
    public static final int STS_ALLDISABLE = 3;
    public SJctrEditPoolsTierArea edPTierArea;
    private SJctrEditPoolsThresholdArea edPThresholdArea;
    private SJctrEditPoolsSubscriptionArea edPSubscriptionArea;
    private SJctrEditPoolsPoolNameArea edPPoolNameArea;
    private SJctrEditPoolsDepletionThresholdArea edPDepThresholdArea = null;
    private SJctrEditPoolsTierBufNewPageArea edPTierBufNewPageArea = null;
    private SJctrEditPoolsTierBufRelocationArea edPTierBufRelocationArea = null;
    private SJmoPoolSummary poolSummaryInfo = null;
    private static final long[] edpPoolStatusList = new long[]{4101L, 2147487750L, 1073745926L, 3221229574L, 2684358662L, 1073745922L, 2147487746L, 2684358658L, 3221229570L, 4098L};
    private SJctrEditPoolsTiPairSuspendArea edpTiPairSuspend = null;
    private SJctrEditPoolsSystemOptionArea edpBlockadePoolVols = null;
    private SJctrEditPoolsSystemOptionArea edpPoolFull = null;
    private SJctrEditPoolsDataDirectMapping edpDataDirectMapping = null;
    public static final String EDIT_PL = "EDIT_PL";
    public boolean enaFlg = true;
    public boolean disFlg = true;
    public boolean statusFlg = true;
    private boolean openOnlyflg = true;
    private String defaultMulutiTier = null;
    private boolean iDpLicenseFlg = true;
    private boolean iPbTSMLicenseFlg = true;
    private boolean iMfPbTSMLicenseFlg = true;
    private boolean bHrtLicenseFlg = true;
    private boolean iDRULicenseFlg = true;
    protected boolean checkEndFlg = true;
    private boolean hasSSDAll = true;
    private List<SJmoPoolDetail> hrtList = Collections.emptyList();
    private boolean selectedTiFlg = false;
    private boolean dmPoolVolFlg = false;
    private boolean normalDpRelationFlg = false;
    private Set<Boolean> dmPoolSet = Collections.emptySet();

    public SJctrEditPoolsDC() {
        super(17826657);
        this.initDataModel();
        this.initListener();
    }

    protected void initDataModel() {
        this.edPTierBufNewPageArea = new SJctrEditPoolsTierBufNewPageArea();
        this.addDataObjectModel("COM_BUFFER_NEW_PAGE", this.edPTierBufNewPageArea);
        this.edPTierBufRelocationArea = new SJctrEditPoolsTierBufRelocationArea();
        this.addDataObjectModel("COM_BUFFER_RELOCATION", this.edPTierBufRelocationArea);
        this.edPThresholdArea = new SJctrEditPoolsThresholdArea();
        this.addDataObjectModel("COM_THRESHOLD_GRP", this.edPThresholdArea);
        this.edPDepThresholdArea = new SJctrEditPoolsDepletionThresholdArea();
        this.addDataObjectModel("COM_DEPLE_THRESHOLD_GRP", this.edPDepThresholdArea);
        this.edpDataDirectMapping = new SJctrEditPoolsDataDirectMapping();
        this.addDataObjectModel("COM_MAPPING_DATA", this.edpDataDirectMapping);
        this.addDataObjectModel(SJctrPoolUtility.KEY_POOL_DED, new SJctrEditPoolsDedDataModel());
        this.edpTiPairSuspend = new SJctrEditPoolsTiPairSuspendArea();
        this.addDataObjectModel("COM_TI_PAIR_SUSPEND_DEP_EXC", this.edpTiPairSuspend);
        this.edPTierArea = new SJctrEditPoolsTierArea();
        this.addDataObjectModel("COM_TIER", this.edPTierArea);
        this.edPSubscriptionArea = new SJctrEditPoolsSubscriptionArea();
        this.addDataObjectModel("COM_SUBSCRPT", this.edPSubscriptionArea);
        this.edPPoolNameArea = new SJctrEditPoolsPoolNameArea();
        this.addDataObjectModel("COM_POOLNAME", this.edPPoolNameArea);
        this.edpBlockadePoolVols = new SJctrEditPoolsSystemOptionArea();
        this.addDataObjectModel("COM_BLOCKADE_POOL", this.edpBlockadePoolVols);
        this.edpPoolFull = new SJctrEditPoolsSystemOptionArea();
        this.addDataObjectModel("COM_POOL_FULL", this.edpPoolFull);
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    protected void initListener() {
        this.addMessageEventListener(SELECT_ED_MSG.TIERINFO, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEditPoolsDC.this.tierEvent();
            }
        });
        this.addMessageEventListener(SELECT_ED_MSG.TIERTYPE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEditPoolsDC.this.tierTypeEvent();
            }
        });
        this.addMessageEventListener(SELECT_ED_MSG.EXEINT, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEditPoolsDC.this.executionEvent();
            }
        });
        this.addMessageEventListener(SELECT_ED_MSG.DATADIRECTMAPPING, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEditPoolsDC.this.dataDirectMappingEvent();
            }
        });
        this.addMessageEventListener(SELECT_ED_MSG.TIPAIRSUSPEND, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEditPoolsDC.this.tiPairSuspendEvent();
            }
        });
    }

    @Override
    public boolean checkStartData() {
        boolean bRtn = true;
        List<Object> transDataList = new ArrayList();
        transDataList = this.getCache("KEY_CLASS_POOL_INDEX");
        if (transDataList.size() == 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkStartData", "transDataList size0");
            SJctrPoolUtility.SJctrErrorDialog(107008);
        }
        return bRtn;
    }

    @Override
    public boolean checkConstructData() {
        SJctrCapacityUtility.UNIT unitDefaultUnitSelect;
        List<SJmoLdevDetail> ldevDetailList;
        Object obj;
        boolean bRtn = true;
        ArrayList<Object> poolDetailList = new ArrayList();
        SJmoPoolDetail poolDetail = null;
        ArrayList<Object> poolNameInfList = new ArrayList();
        SJmoPoolNameInfo poolNameInf = null;
        List<Object> transDataList = new ArrayList();
        SJmoPoolDetail transData = null;
        ArrayList<SJmoPoolDetail> editDataList = new ArrayList<SJmoPoolDetail>();
        ArrayList<SJmoPoolNameInfo> editPoolNameList = new ArrayList<SJmoPoolNameInfo>();
        SJmoPoolDetail poolDetailClone = null;
        SJmoPoolNameInfo poolNameInfClone = null;
        int iCnt = 0;
        int iIndex = 0;
        int iIndexName = 0;
        ArrayList<SJmoPoolDetail> chkPoolDtlList = new ArrayList<SJmoPoolDetail>();
        SJmoPoolDetail chkPoolDtlClone = null;
        transDataList = this.getCache("KEY_CLASS_POOL_INDEX");
        poolDetailList = new ArrayList(this.getCache(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL));
        poolNameInfList = new ArrayList(this.getCache(SJctrPoolUtility.KEY_CLASS_POOLNAME_INFO));
        List<?> poolSummaryList = this.getCache(SJctrPoolUtility.KEY_CLASS_POOL_SUMMARY);
        if (poolSummaryList == null || poolSummaryList.isEmpty()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "poolSummaryInfo notFound");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        if (!((obj = poolSummaryList.get(0)) instanceof SJmoPoolSummary)) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "poolSummaryInfo notFound");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        this.poolSummaryInfo = (SJmoPoolSummary)obj;
        Collections.sort(poolDetailList);
        Collections.sort(poolNameInfList);
        for (iCnt = 0; iCnt < transDataList.size(); ++iCnt) {
            transData = (SJmoPoolDetail)transDataList.get(iCnt);
            iIndex = Collections.binarySearch(poolDetailList, transData);
            iIndexName = Collections.binarySearch(poolNameInfList, transData);
            if (iIndex < 0) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "poolDetailList notFound");
                SJctrPoolUtility.SJctrErrorDialog(107023);
            }
            if (iIndexName < 0) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "poolNameInfList notFound");
                SJctrPoolUtility.SJctrErrorDialog(107023);
            }
            poolDetail = (SJmoPoolDetail)poolDetailList.get(iIndex);
            poolNameInf = (SJmoPoolNameInfo)poolNameInfList.get(iIndexName);
            try {
                poolDetailClone = (SJmoPoolDetail)poolDetail.clone();
                poolNameInfClone = (SJmoPoolNameInfo)poolNameInf.clone();
                chkPoolDtlClone = (SJmoPoolDetail)poolDetail.clone();
            }
            catch (CloneNotSupportedException e) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "poolDetail or poolNameInf cloneError");
                SJctrPoolUtility.SJctrErrorDialog(107007);
                poolDetailClone = new SJmoPoolDetail();
            }
            editDataList.add(poolDetailClone);
            editPoolNameList.add(poolNameInfClone);
            chkPoolDtlList.add(chkPoolDtlClone);
        }
        List<SJmoPoolVolDetail> poolVolDetailList = this.getCache(SJctrPoolUtility.KEY_CLASS_POOLVOL_DETAIL);
        if (poolVolDetailList == null || poolVolDetailList.isEmpty()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "poolVolDetailList notFound");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        if ((ldevDetailList = this.getCache(SJctrPoolUtility.KEY_CLASS_LDEV_DETAIL)) == null || ldevDetailList.isEmpty()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "ldevDetailList notFound");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        this.checkHrtPool(editDataList, poolVolDetailList, ldevDetailList);
        bRtn = this.checkPoolStat(editDataList);
        this.putCache(KEY_CLASS_EDIT_DATA, editDataList);
        this.putCache(KEY_CLASS_EDIT_POOLNAME, editPoolNameList);
        this.putCache(KEY_CLASS_CHK_EDIT_POOLDTL, chkPoolDtlList);
        boolean bMFFlg = false;
        boolean bOpenFlg = false;
        SJctrCapacityUtility util = this.getComUtility().getCapacityUtility();
        for (iCnt = 0; !(iCnt >= editDataList.size() || bOpenFlg && bMFFlg); ++iCnt) {
            SJmoPoolDetail editPoolDetail = (SJmoPoolDetail)editDataList.get(iCnt);
            if (SJctrPoolUtility.isOpenPool(editPoolDetail)) {
                bOpenFlg = true;
                continue;
            }
            if (!SJctrPoolUtility.isMainframePool(editPoolDetail)) continue;
            bMFFlg = true;
        }
        if (!bOpenFlg && bMFFlg && !(unitDefaultUnitSelect = SJctrCapacityUtility.UNIT.valueOf(this.getTopWizard().getParentDC().getUnitSelect())).equals((Object)SJctrCapacityUtility.UNIT.PAGE)) {
            this.setUnitSelect(util.getUnitString(SJctrCapacityUtility.UNIT.CYL));
        }
        return bRtn;
    }

    private boolean checkPoolStat(List<SJmoPoolDetail> editDataList) {
        boolean bRtn = true;
        boolean bResult = false;
        int iCnt = 0;
        int iCount = 0;
        SJmoPoolDetail poolDetail = null;
        long lPoolStatus = 0L;
        int iErrorCode = 107007;
        SJctrError repErrorData = null;
        SJctrError errorData = null;
        SJctrErrorColumnData errorColumn = null;
        ArrayList<SJctrErrorColumnData> errorColumnList = new ArrayList<SJctrErrorColumnData>();
        SJctrRelatedDispDataObject errObj = null;
        SJctrErrorDataController errDC = null;
        SJctrDataController beginDC = null;
        SJctrTableDataModel begintable = null;
        SJcException exception = null;
        for (iCnt = 0; iCnt < editDataList.size(); ++iCnt) {
            poolDetail = editDataList.get(iCnt);
            lPoolStatus = poolDetail.getPoolStatus();
            bResult = false;
            for (iCount = 0; iCount < edpPoolStatusList.length; ++iCount) {
                if (edpPoolStatusList[iCount] != lPoolStatus) continue;
                bResult = true;
                break;
            }
            if (bResult) continue;
            iErrorCode = this.getErrorCode(lPoolStatus);
            errorData = new SJctrError(31, 22, iErrorCode);
            errorColumn = new SJctrErrorColumnData(poolDetail, errorData);
            errorColumnList.add(errorColumn);
            editDataList.remove(iCnt);
            --iCnt;
            bRtn = false;
        }
        if (!bRtn) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkPoolStat", "EditPools PoolStatusError");
            beginDC = this.getWizardWindow().getParentDC();
            begintable = (SJctrTableDataModel)beginDC.getDataObjectModel("COM_TABLE");
            errObj = this.createDialog(SJctrErrorDataController.class, null);
            errDC = (SJctrErrorDataController)this.getOwner().getDataController(errObj);
            errDC.setParameter(begintable, errorColumnList);
            repErrorData = errDC.getRepresentativeError(errorColumnList, 5);
            exception = repErrorData.createException();
            exception.setErrDisp(errObj);
            throw exception;
        }
        return bRtn;
    }

    private int getErrorCode(long lPoolStatus) {
        int iErrorCode = 107007;
        long lPoolStatusValue = 0L;
        lPoolStatusValue = lPoolStatus & 0xFFFFL;
        if ((lPoolStatus & 0x800000L) != 0L) {
            iErrorCode = 106028;
        }
        if ((lPoolStatus & 0x10000L) != 0L) {
            iErrorCode = 106026;
        }
        if (lPoolStatusValue == 4096L) {
            iErrorCode = 106025;
        } else if (lPoolStatusValue == 4097L) {
            iErrorCode = 106024;
        }
        SJctrLogUty.warn(this.getClass().getSimpleName(), "getErrorCode", "Pool Status Error:" + lPoolStatus);
        return iErrorCode;
    }

    @Override
    public void makeDataModel() {
        ArrayList<SJmoPoolDetail> editData = new ArrayList();
        this.disFlg = true;
        this.enaFlg = true;
        this.statusFlg = true;
        this.edPTierArea.setTierEventListner(false);
        this.edPTierArea.setTierTypeEventListner(false);
        this.edPTierArea.setExeIntEventListner(false);
        this.edpDataDirectMapping.setDataDirectMappingEventListner(false);
        super.makeDataModel();
        editData = this.getCache(KEY_CLASS_EDIT_DATA);
        this.checkPoolType(editData);
        this.checkEdpLicenseAuthorize();
        if (this.openOnlyflg) {
            if (!this.iPbTSMLicenseFlg) {
                this.enaFlg = false;
            }
        } else if (!this.iMfPbTSMLicenseFlg) {
            this.enaFlg = false;
        }
        if (this.dmPoolSet.size() == 1) {
            Boolean[] selectArray = this.dmPoolSet.toArray(new Boolean[1]);
            if (selectArray[0].booleanValue()) {
                this.enaFlg = false;
            }
        } else if (this.dmPoolSet.size() == 2) {
            this.enaFlg = false;
        }
        if (!this.disFlg && !this.enaFlg) {
            this.statusFlg = false;
        }
        this.edPTierArea.initTierTypeArea(this.enaFlg, this.disFlg, this.statusFlg);
        this.edPTierArea.initHrtCheckBox(this.statusFlg, this.bHrtLicenseFlg, this.hrtList, this.hasSSDAll);
        this.defaultMulutiTier = this.edPTierArea.getStrTierSelct();
        this.edPTierBufNewPageArea.initTierBufNewPageArea(this.statusFlg, this.edPTierArea.getStrTierSelct());
        this.edPTierBufRelocationArea.initTierBufRelocationArea(this.statusFlg, this.edPTierArea.getStrTierSelct());
        this.edpDataDirectMapping.initDataDirectMapping(this.statusFlg, this.openOnlyflg, this.dmPoolVolFlg, this.normalDpRelationFlg, this.edPTierArea.getMultiTier().getSelect(), this.dmPoolSet, this.defaultMulutiTier);
        this.edPDepThresholdArea.initDepThreshold();
        this.edPThresholdArea.initWarningThreshold(this.edPDepThresholdArea.isDepEnable());
        if (this.dmPoolSet.contains(Boolean.TRUE)) {
            if (!this.selectedTiFlg) {
                this.edPDepThresholdArea.setDepletionThresholdMax("100");
                this.edPDepThresholdArea.setDepletionThresholdMin("100");
                this.edPThresholdArea.setWarningThresholdMax("100");
                this.edPThresholdArea.setWarningThresholdMin("100");
            } else {
                this.edPDepThresholdArea.disableDepThresholdText();
                this.edPThresholdArea.disableWarThresholdText();
            }
        }
        this.edPSubscriptionArea.initSubscriptionText();
        this.edPPoolNameArea.initPoolNameText();
        this.edpTiPairSuspend.refData();
        this.chkPoolSystemOption(editData);
        this.edPTierArea.setTierEventListner(true);
        this.edPTierArea.setTierTypeEventListner(true);
        this.edPTierArea.setExeIntEventListner(true);
        this.edpDataDirectMapping.setDataDirectMappingEventListner(true);
    }

    @Override
    public boolean checkEndData() {
        boolean bRtn = true;
        boolean bChk = true;
        if (this.checkEndFlg) {
            bChk = this.edPTierArea.getEdTierManagementCheckBoxArea().isSelectCheckBox();
            if (bChk) {
                bRtn = this.checkMonitorPeriod();
            }
            if (bChk = this.edPSubscriptionArea.getSelCheckBox()) {
                bRtn = this.checkSubscription();
            }
            if (bChk = this.edPPoolNameArea.getSelCheckBox()) {
                bRtn = this.checkPoolName();
            }
            bRtn = this.checkThreshold();
            this.createEditData();
        }
        return bRtn;
    }

    public boolean checkSubscription() {
        boolean bRtn = true;
        String strSubscription = "";
        int iMin = 0;
        int iMax = 0;
        strSubscription = this.edPSubscriptionArea.getStrTextBox();
        iMin = this.edPSubscriptionArea.getTextMin();
        iMax = this.edPSubscriptionArea.getTextMax();
        bRtn = this.getComUtility().getPoolUtility().checkStrProp(strSubscription, iMin, iMax);
        if (!bRtn) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkSubscription", "strSubscript OutProper");
            SJctrPoolUtility.SJctrErrorDialog(106010);
        }
        return bRtn;
    }

    public boolean checkPoolName() {
        boolean bRtn = true;
        ArrayList<SJmoPoolNameInfo> noEditDataList = new ArrayList<SJmoPoolNameInfo>();
        ArrayList editDataList = null;
        List<?> poolNameInfList = null;
        SJmoPoolNameInfo poolNameInf = null;
        String strFix = "";
        String strStart = "";
        int iCnt = 0;
        int iIndex = 0;
        int iSetNum = 0;
        strFix = this.edPPoolNameArea.getStrFixCharText();
        strStart = this.edPPoolNameArea.getStrStartNumText();
        editDataList = new ArrayList(this.getCache(KEY_CLASS_EDIT_DATA));
        poolNameInfList = this.getCache(SJctrPoolUtility.KEY_CLASS_POOLNAME_INFO);
        Collections.sort(editDataList);
        iSetNum = editDataList.size();
        for (iCnt = 0; iCnt < poolNameInfList.size(); ++iCnt) {
            poolNameInf = (SJmoPoolNameInfo)poolNameInfList.get(iCnt);
            iIndex = Collections.binarySearch(editDataList, poolNameInf);
            if (iIndex >= 0) continue;
            noEditDataList.add(poolNameInf);
        }
        bRtn = this.getComUtility().getPoolUtility().checkPoolName(strFix, strStart, iSetNum, noEditDataList);
        return bRtn;
    }

    public boolean checkMonitorPeriod() {
        boolean bRtn = true;
        String strStart = "";
        String strEnd = "";
        strStart = this.edPTierArea.getStrStartTimeTextBox();
        strEnd = this.edPTierArea.getStrEndTimeTextBox();
        bRtn = this.getComUtility().getPoolUtility().checkMonPeriod(strStart, strEnd);
        return bRtn;
    }

    private boolean checkThreshold() {
        boolean bRet = true;
        int iUserWarningThreshold = 0;
        int iUserDepletionThreshold = 0;
        int iWarningThreshold = 100;
        int iDepletionThreshold = 100;
        boolean bOver = false;
        boolean bDpEnable = false;
        ArrayList poolDtlList = new ArrayList(this.getCache(KEY_CLASS_CHK_EDIT_POOLDTL));
        for (int iCnt = 0; iCnt < poolDtlList.size(); ++iCnt) {
            short iCompWarThreshold = 0;
            short iCompDepThreshold = 0;
            iCompWarThreshold = this.getComUtility().getPoolUtility().isSysThresChangeWarThres((SJmoPoolDetail)poolDtlList.get(iCnt)) ? ((SJmoPoolDetail)poolDtlList.get(iCnt)).getPoolFixThreshold() : ((SJmoPoolDetail)poolDtlList.get(iCnt)).getPoolThreshold();
            if (iCompWarThreshold < iWarningThreshold) {
                iWarningThreshold = iCompWarThreshold;
            }
            if (((SJmoPoolDetail)poolDtlList.get(iCnt)).getPoolKind() != 2) continue;
            bDpEnable = true;
            iCompDepThreshold = ((SJmoPoolDetail)poolDtlList.get(iCnt)).getSPoolThresholdMode() == SJctrPoolUtility.THRESHOLD_MODE_DEPLETION_ON ? ((SJmoPoolDetail)poolDtlList.get(iCnt)).getSPoolDepletionThreshold() : (this.getComUtility().getPoolUtility().isSysThresChangeDepThres((SJmoPoolDetail)poolDtlList.get(iCnt)) ? ((SJmoPoolDetail)poolDtlList.get(iCnt)).getPoolFixThreshold() : ((SJmoPoolDetail)poolDtlList.get(iCnt)).getPoolThreshold());
            if (iCompDepThreshold >= iDepletionThreshold) continue;
            iDepletionThreshold = iCompDepThreshold;
        }
        if (this.edPThresholdArea.getSelCheckBox()) {
            if (this.edPThresholdArea.getStrWarThreshold().length() == 0) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkThreshold", "Warning Threshold is blank.");
                SJctrPoolUtility.SJctrErrorDialog(106091);
            } else {
                iUserWarningThreshold = Integer.parseInt(this.edPThresholdArea.getStrWarThreshold());
            }
        }
        if (this.edPDepThresholdArea.getSelCheckBox()) {
            if (this.edPDepThresholdArea.getStrDepThreshold().length() == 0) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkThreshold", "Depletion Threshold is blank.");
                SJctrPoolUtility.SJctrErrorDialog(106093);
            } else {
                iUserDepletionThreshold = Integer.parseInt(this.edPDepThresholdArea.getStrDepThreshold());
            }
        }
        if (this.edPDepThresholdArea.getSelCheckBox()) {
            if (this.edPThresholdArea.getSelCheckBox()) {
                if (iUserWarningThreshold > iUserDepletionThreshold) {
                    bOver = true;
                }
            } else if (iWarningThreshold > iUserDepletionThreshold) {
                bOver = true;
            }
        } else if (this.edPThresholdArea.getSelCheckBox() && bDpEnable && iUserWarningThreshold > iDepletionThreshold) {
            bOver = true;
        }
        if (bOver) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkThreshold", "Warning Threshold is over Depletion Threshold");
            SJctrPoolUtility.SJctrErrorDialog(106090);
        }
        return bRet;
    }

    public void createEditData() {
        List<?> editDataList = null;
        List<?> editPoolNameList = null;
        SJmoPoolDetail editData = null;
        SJmoPoolNameInfo editPoolName = null;
        boolean bThresholdChk = true;
        boolean bSubscriptChk = true;
        boolean bPoolNameChk = true;
        String strFixChar = "";
        String strStart = "";
        List<Object> strStartList = new ArrayList();
        int iCnt = 0;
        SJmoPoolDetail poolDtlCln = null;
        boolean bTiPairSuspendChk = true;
        boolean bBlockadePoolChk = true;
        boolean bPoolFullChk = true;
        long lPoolOption = 0L;
        editDataList = this.getCache(KEY_CLASS_EDIT_DATA);
        editPoolNameList = this.getCache(KEY_CLASS_EDIT_POOLNAME);
        bThresholdChk = this.edPThresholdArea.getSelCheckBox();
        boolean bDepThresholdChk = this.edPDepThresholdArea.getSelCheckBox();
        bSubscriptChk = this.edPSubscriptionArea.getSelCheckBox();
        bPoolNameChk = this.edPPoolNameArea.getSelCheckBox();
        ArrayList<SJmoPoolDetail> alDefPool = new ArrayList<SJmoPoolDetail>(this.getCache(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL));
        ArrayList alDefPoolName = new ArrayList(this.getCache(SJctrPoolUtility.KEY_CLASS_POOLNAME_INFO));
        bTiPairSuspendChk = this.edpTiPairSuspend.getSelCheckBox();
        bBlockadePoolChk = this.edpBlockadePoolVols.getSelCheckBox();
        bPoolFullChk = this.edpPoolFull.getSelCheckBox();
        if (bPoolNameChk) {
            strFixChar = this.edPPoolNameArea.getStrFixCharText();
            strStart = this.edPPoolNameArea.getStrStartNumText();
            strStartList = this.getComUtility().getPoolUtility().getStartatNumberList(strStart, editDataList.size());
        }
        for (iCnt = 0; iCnt < editDataList.size(); ++iCnt) {
            String selection;
            editData = (SJmoPoolDetail)editDataList.get(iCnt);
            editPoolName = (SJmoPoolNameInfo)editPoolNameList.get(iCnt);
            Collections.sort(alDefPool);
            int iIndex = Collections.binarySearch(alDefPool, editData);
            if (iIndex < 0) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "createEditData", "editData notFound");
                SJctrPoolUtility.SJctrErrorDialog(107007);
            }
            try {
                poolDtlCln = (SJmoPoolDetail)((SJmoPoolDetail)alDefPool.get(iIndex)).clone();
            }
            catch (CloneNotSupportedException e) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "createEditData", "SJmoPoolDetail cloneError");
                SJctrPoolUtility.SJctrErrorDialog(107007);
            }
            boolean bTierChkFlg = this.edPTierArea.getSelCheckBox();
            boolean bTierMngFlg = this.edPTierArea.getEdTierManagementCheckBoxArea().isSelectCheckBox();
            boolean bMonModeFlg = this.edPTierArea.getEdMonModeCheckBoxArea().isSelectCheckBox();
            boolean bRelocationSpeedFlg = this.edPTierArea.getEdRelocationSpeedCheckBoxArea().isSelectCheckBox();
            boolean bNewBuffFlg = this.edPTierBufNewPageArea.isSelectCheckBox();
            boolean bRelocationFlg = this.edPTierBufRelocationArea.isSelectCheckBox();
            this.restoreEditTier(editData, alDefPool);
            this.restoreEditExecutInterval(editData, alDefPool);
            this.restoreEditMonitorPeriod(editData, alDefPool);
            this.restoreEditMonMode(editData, alDefPool);
            this.restoreEditRelocationSpeed(editData, alDefPool);
            this.restoreEditTierInfoList(editData, alDefPool);
            if (bTierChkFlg) {
                if (this.edPTierArea.getMultiTier().isSelect("COM_ENABLE")) {
                    if (this.edPTierArea.getHrtSelCheckBox() && !this.bHrtLicenseFlg) {
                        SJctrLogUty.warn(this.getClass().getSimpleName(), "createEditData", "No HRT License");
                        SJctrPoolUtility.SJctrErrorDialog(SJctrPoolUtility.ERR_NO_LICENSE_POOL_HRT_EDIT);
                    }
                    if (this.edPTierArea.getHrtSelCheckBox() && !this.hasSSDAll) {
                        SJctrLogUty.warn(this.getClass().getSimpleName(), "createEditData", "No SSD pool edit HRT");
                        SJctrPoolUtility.SJctrErrorDialog(SJctrPoolUtility.ERR_NO_SSD_POOL_HRT_EDIT);
                    }
                    if (!(bTierMngFlg && bMonModeFlg && bRelocationSpeedFlg && bNewBuffFlg && bRelocationFlg || this.defaultMulutiTier != null && !"COM_DISABLE".equals(this.defaultMulutiTier))) {
                        SJctrLogUty.warn(this.getClass().getSimpleName(), "createEditData", "There is no check item");
                        SJctrPoolUtility.SJctrErrorDialog(106111);
                    }
                    this.createEditMultiTierPool(editData);
                    this.createMultiTierAreaData(bTierMngFlg, bMonModeFlg, bRelocationSpeedFlg, bNewBuffFlg, bRelocationFlg, editData, poolDtlCln);
                } else if (this.edPTierArea.getMultiTier().isSelect("COM_DISABLE")) {
                    this.createEditMultiTierPool(editData);
                }
            } else if (!this.edPTierArea.getMultiTier().isSelect("COM_DISABLE")) {
                if ((bTierMngFlg || bMonModeFlg || bRelocationSpeedFlg || bNewBuffFlg || bRelocationFlg) && (this.defaultMulutiTier == null || "COM_DISABLE".equals(this.defaultMulutiTier))) {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "createEditData", "Multi-Tier Pool not check");
                    SJctrPoolUtility.SJctrErrorDialog(106112);
                }
                this.createMultiTierAreaData(bTierMngFlg, bMonModeFlg, bRelocationSpeedFlg, bNewBuffFlg, bRelocationFlg, editData, poolDtlCln);
            }
            this.setThresholdData(bThresholdChk, bDepThresholdChk, editData, poolDtlCln, alDefPool);
            if (bSubscriptChk) {
                this.createEditSubscription(editData);
            } else {
                this.restoreEditSubscription(editData, alDefPool);
            }
            if (bPoolNameChk) {
                strStart = (String)strStartList.get(iCnt);
                this.createEditPoolName(editPoolName, strFixChar, strStart);
            } else {
                this.restoreEditPoolName(editPoolName, alDefPoolName);
            }
            lPoolOption = 0L;
            if (this.edpDataDirectMapping.getSelCheckBox()) {
                if (!bTierChkFlg && (this.defaultMulutiTier == null || "COM_ENABLE".equals(this.defaultMulutiTier))) {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "createEditData", "Multi-Tier Pool not check and DM Enable");
                    SJctrPoolUtility.SJctrErrorDialog(106112);
                }
                lPoolOption |= this.createEditDataDirectMapping(this.edpDataDirectMapping);
            } else {
                lPoolOption |= this.restoreEditPoolOption(editData, alDefPool, 0x20000000L);
            }
            if (bTiPairSuspendChk) {
                selection = this.edpTiPairSuspend.getSelection();
                if (selection == null || selection.length() == 0) {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "createEditData", "Suspend TI pairs when depletion threshold is exceeded not check");
                } else {
                    lPoolOption |= this.createEditTiPairSuspend(this.edpTiPairSuspend);
                }
            } else {
                lPoolOption |= this.restoreEditTiPairSuspend(editData, alDefPool, 0x10000000L);
            }
            if (bBlockadePoolChk) {
                selection = this.edpBlockadePoolVols.getSelection();
                if (selection == null || selection.length() == 0) {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "createEditData", "Protect V-VOLs when I/O fails to Blocked Pool VOL not check");
                    SJctrPoolUtility.SJctrErrorDialog(205133);
                } else {
                    lPoolOption |= this.createEditPoolOption(bBlockadePoolChk, editData, 0x40000000L, this.edpBlockadePoolVols);
                }
            } else {
                lPoolOption |= this.restoreEditPoolOption(editData, alDefPool, 0x40000000L);
            }
            if (bPoolFullChk) {
                selection = this.edpPoolFull.getSelection();
                if (selection == null || selection.length() == 0) {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "createEditData", "Protect V-VOLs when I/O fails to Full Pool not check");
                    SJctrPoolUtility.SJctrErrorDialog(205134);
                } else {
                    lPoolOption |= this.createEditPoolOption(bPoolFullChk, editData, 0x80000000L, this.edpPoolFull);
                }
            } else {
                lPoolOption |= this.restoreEditPoolOption(editData, alDefPool, 0x80000000L);
            }
            editData.setLPoolOptionFlag(lPoolOption);
            if ((lPoolOption & 0x20000000L) == 0L) continue;
            short warningThreshold = editData.getPoolThreshold();
            short DepletionThreshold = editData.getSPoolDepletionThreshold();
            if (warningThreshold == 100 && DepletionThreshold == 100) continue;
            if (!this.edpDataDirectMapping.getSelCheckBox()) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "createEditData", "Data Direct Mapping not check");
                SJctrPoolUtility.SJctrErrorDialog(SJctrPoolUtility.ERR_EDITDMPOOL_CHANGE_THRESHOLD);
                continue;
            }
            SJctrLogUty.warn(this.getClass().getSimpleName(), "createEditData", "WarningThreshold or DepletionThreshold not check");
            SJctrPoolUtility.SJctrErrorDialog(SJctrPoolUtility.ERR_DMPOOL_INVALID_THRESHOLD);
        }
        this.putCache(KEY_CLASS_EDIT_DATA, editDataList);
        ArrayList<Boolean> druFlagnList = new ArrayList<Boolean>();
        druFlagnList.add(this.iDRULicenseFlg);
        this.putCache(SJctrPoolUtility.KEY_DRU_FLAG.getName(), druFlagnList);
    }

    public void createMultiTierAreaData(boolean bTierMngFlg, boolean bMonModeFlg, boolean bRelocationSpeedFlg, boolean bNewBuffFlg, boolean bRelocationFlg, SJmoPoolDetail editData, SJmoPoolDetail poolDtlCln) {
        if (bTierMngFlg) {
            this.createEditTierManagement(editData);
            this.createEditExecutInterval(editData);
            this.createEditMonitorPeriod(editData);
        }
        if (bMonModeFlg) {
            this.createEditMonMode(editData);
        }
        if (bRelocationSpeedFlg) {
            this.createEditRelocationSpeed(editData);
        }
        if (bNewBuffFlg) {
            this.createEditBufNewPage(editData, poolDtlCln);
        }
        if (bRelocationFlg) {
            this.createEditBufRelocation(editData, poolDtlCln);
        }
    }

    public void createEditThreshold(SJmoPoolDetail editData) {
        short sThreshold = 0;
        sThreshold = Short.parseShort(this.edPThresholdArea.getStrWarThreshold());
        editData.setPoolThreshold(sThreshold);
    }

    public void restoreEditThreshold(SJmoPoolDetail editData, List poolDetailList) {
        short sThreshold = 0;
        int iIndex = 0;
        SJmoPoolDetail poolDetail = null;
        Collections.sort(poolDetailList);
        iIndex = Collections.binarySearch(poolDetailList, editData);
        if (iIndex < 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "restoreEditThreshold", "poolDetailList notFound");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        poolDetail = (SJmoPoolDetail)poolDetailList.get(iIndex);
        sThreshold = poolDetail.getPoolThreshold();
        editData.setPoolThreshold(sThreshold);
    }

    public void createEditDepThreshold(SJmoPoolDetail editData) {
        editData.setSPoolDepletionThreshold(Short.parseShort(this.edPDepThresholdArea.getStrDepThreshold()));
    }

    public void restoreEditDepThreshold(SJmoPoolDetail editData, List poolDetailList) {
        Collections.sort(poolDetailList);
        int iIndex = Collections.binarySearch(poolDetailList, editData);
        if (iIndex < 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "restoreEditDepThreshold", "poolDetailList notFound");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        SJmoPoolDetail poolDetail = (SJmoPoolDetail)poolDetailList.get(iIndex);
        editData.setSPoolDepletionThreshold(poolDetail.getSPoolDepletionThreshold());
    }

    public void restoreEditThresholdMode(SJmoPoolDetail editData, List poolDetailList) {
        Collections.sort(poolDetailList);
        int iIndex = Collections.binarySearch(poolDetailList, editData);
        if (iIndex < 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "restoreEditDepThreshold", "poolDetailList notFound");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        SJmoPoolDetail poolDetail = (SJmoPoolDetail)poolDetailList.get(iIndex);
        editData.setSPoolThresholdMode(poolDetail.getSPoolThresholdMode());
    }

    public void createEditSubscription(SJmoPoolDetail editData) {
        String strSubscription = "";
        int iSubscription = 0;
        strSubscription = this.edPSubscriptionArea.getStrTextBox();
        iSubscription = strSubscription.length() == 0 ? 65535 : Integer.valueOf(strSubscription);
        editData.setMaxSubscription(iSubscription);
    }

    public void restoreEditSubscription(SJmoPoolDetail editData, List poolDetailList) {
        int iSubscription = 0;
        int iIndex = 0;
        SJmoPoolDetail poolDetail = null;
        Collections.sort(poolDetailList);
        iIndex = Collections.binarySearch(poolDetailList, editData);
        if (iIndex < 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "restoreEditSubscription", "poolDetailList notFound");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        poolDetail = (SJmoPoolDetail)poolDetailList.get(iIndex);
        iSubscription = poolDetail.getMaxSubscription();
        editData.setMaxSubscription(iSubscription);
    }

    public void createEditPoolName(SJmoPoolNameInfo editData, String strFix, String strStart) {
        String strPoolName = "";
        strPoolName = strFix + strStart;
        editData.setStrName(strPoolName);
    }

    public void restoreEditPoolName(SJmoPoolNameInfo editData, List poolNameInfList) {
        int iIndex = 0;
        Collections.sort(poolNameInfList);
        iIndex = Collections.binarySearch(poolNameInfList, editData);
        if (iIndex < 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "restoreEditPoolName", "poolNameInfList notFound");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        SJmoPoolNameInfo poolNameInf = (SJmoPoolNameInfo)poolNameInfList.get(iIndex);
        String strPoolName = poolNameInf.getStrName();
        editData.setStrName(strPoolName);
    }

    public void createEditMultiTierPool(SJmoPoolDetail editData) {
        SJctrPoolUtility poolUtil = this.getComUtility().getPoolUtility();
        String strMultiTierPool = this.edPTierArea.getStrTierSelct();
        int iTierControl = poolUtil.getIMultiTierPool(strMultiTierPool, editData.getITierControlInfo());
        boolean bHrt = this.edPTierArea.getHrtSelCheckBox();
        iTierControl = poolUtil.getIHrt(bHrt, iTierControl);
        editData.setITierControlInfo(iTierControl);
    }

    public void createEditTierManagement(SJmoPoolDetail editData) {
        String strTierManagement = this.edPTierArea.getStrTierTypeSelct();
        int iTierControl = this.getComUtility().getPoolUtility().getITierManagement(strTierManagement, editData.getITierControlInfo());
        editData.setITierControlInfo(iTierControl);
    }

    public void restoreEditTier(SJmoPoolDetail editData, List poolDetailList) {
        int iTierControlInfo = 0;
        int iIndex = 0;
        SJmoPoolDetail poolDetail = null;
        Collections.sort(poolDetailList);
        iIndex = Collections.binarySearch(poolDetailList, editData);
        if (iIndex < 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "restoreEditTier", "poolDetailList notFound");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        poolDetail = (SJmoPoolDetail)poolDetailList.get(iIndex);
        iTierControlInfo = poolDetail.getITierControlInfo();
        editData.setITierControlInfo(iTierControlInfo);
    }

    public void createEditExecutInterval(SJmoPoolDetail editData) {
        String strExeInt = "";
        int iExecutionCycle = 0;
        strExeInt = this.edPTierArea.getStrExeInt();
        iExecutionCycle = this.getComUtility().getPoolUtility().getExecutInterval(strExeInt);
        editData.setIExecutionCycle(iExecutionCycle);
    }

    public void restoreEditExecutInterval(SJmoPoolDetail editData, List poolDetailList) {
        int iExecutInterval = 0;
        int iIndex = 0;
        SJmoPoolDetail poolDetail = null;
        Collections.sort(poolDetailList);
        iIndex = Collections.binarySearch(poolDetailList, editData);
        if (iIndex < 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "restoreEditExecutInterval", "poolDetailList notFound");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        poolDetail = (SJmoPoolDetail)poolDetailList.get(iIndex);
        iExecutInterval = poolDetail.getIExecutionCycle();
        editData.setIExecutionCycle(iExecutInterval);
    }

    public void createEditMonitorPeriod(SJmoPoolDetail editData) {
        String strStart = "";
        String strEnd = "";
        boolean iExecutionCycle = false;
        byte byMonStartPeriodHour = 0;
        byte byMonStartPeriodMin = 0;
        byte byMonEndPeriodHour = 0;
        byte byMonEndPeriodMin = 0;
        strStart = this.edPTierArea.getStrStartTimeTextBox();
        strEnd = this.edPTierArea.getStrEndTimeTextBox();
        byMonStartPeriodHour = this.getComUtility().getPoolUtility().getMonPeriod(strStart, 0);
        byMonStartPeriodMin = this.getComUtility().getPoolUtility().getMonPeriod(strStart, 1);
        byMonEndPeriodHour = this.getComUtility().getPoolUtility().getMonPeriod(strEnd, 0);
        byMonEndPeriodMin = this.getComUtility().getPoolUtility().getMonPeriod(strEnd, 1);
        editData.setByMonStartPeriodHour(byMonStartPeriodHour);
        editData.setByMonStartPeriodMin(byMonStartPeriodMin);
        editData.setByMonEndPeriodHour(byMonEndPeriodHour);
        editData.setByMonEndPeriodMin(byMonEndPeriodMin);
    }

    public void restoreEditMonitorPeriod(SJmoPoolDetail editData, List poolDetailList) {
        byte byMonStartPeriodHour = 0;
        byte byMonStartPeriodMin = 0;
        byte byMonEndPeriodHour = 0;
        byte byMonEndPeriodMin = 0;
        int iIndex = 0;
        SJmoPoolDetail poolDetail = null;
        Collections.sort(poolDetailList);
        iIndex = Collections.binarySearch(poolDetailList, editData);
        if (iIndex < 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "restoreEditMonitorPeriod", "poolDetailList notFound");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        poolDetail = (SJmoPoolDetail)poolDetailList.get(iIndex);
        byMonStartPeriodHour = poolDetail.getByMonStartPeriodHour();
        byMonStartPeriodMin = poolDetail.getByMonStartPeriodMin();
        byMonEndPeriodHour = poolDetail.getByMonEndPeriodHour();
        byMonEndPeriodMin = poolDetail.getByMonEndPeriodMin();
        editData.setByMonStartPeriodHour(byMonStartPeriodHour);
        editData.setByMonStartPeriodMin(byMonStartPeriodMin);
        editData.setByMonEndPeriodHour(byMonEndPeriodHour);
        editData.setByMonEndPeriodMin(byMonEndPeriodMin);
    }

    public void createEditMonMode(SJmoPoolDetail editData) {
        editData.setITierRelocatePolicy(this.getComUtility().getPoolUtility().getMonMode(this.edPTierArea.getStrMonMode()));
    }

    public void restoreEditMonMode(SJmoPoolDetail editData, List poolDetailList) {
        Collections.sort(poolDetailList);
        int iIndex = Collections.binarySearch(poolDetailList, editData);
        if (iIndex < 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "restoreEditMonMode", "poolDetailList notFound");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        SJmoPoolDetail poolDtl = (SJmoPoolDetail)poolDetailList.get(iIndex);
        editData.setITierRelocatePolicy(poolDtl.getITierRelocatePolicy());
    }

    public void createEditRelocationSpeed(SJmoPoolDetail editData) {
        byte setRelocationSpeed = this.edPTierArea.getRelocationSpeed();
        if (setRelocationSpeed >= 0) {
            editData.setByRelocationSpeed(setRelocationSpeed);
        }
    }

    public void restoreEditRelocationSpeed(SJmoPoolDetail editData, List poolDetailList) {
        Collections.sort(poolDetailList);
        int iIndex = Collections.binarySearch(poolDetailList, editData);
        if (iIndex < 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "restoreEditRelocationSpeed", "poolDetailList notFound");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        SJmoPoolDetail poolDtl = (SJmoPoolDetail)poolDetailList.get(iIndex);
        editData.setByRelocationSpeed(poolDtl.getByRelocationSpeed());
    }

    public void createEditBufNewPage(SJmoPoolDetail editData, SJmoPoolDetail chkData) {
        if (chkData.getPoolKind() == 2) {
            if (0 != (chkData.getITierControlInfo() & 0x80)) {
                this.createEditBufNewPageTierEnablePool(editData);
            } else {
                this.createEditBufNewPageTierDisablePool(editData);
            }
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "createEditBufNewPage", "Pool kind Error");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
    }

    public void createEditBufNewPageTierEnablePool(SJmoPoolDetail editData) {
        ArrayList<SJmoPoolTierInfo> alPoolTier = editData.getAlTierInfo();
        Collections.sort(alPoolTier);
        ArrayList alDeepCocyTier = SJmoDataUtility.alDeepCopy(alPoolTier);
        for (int iCnt = 0; iCnt < 3; ++iCnt) {
            int iTierNum = iCnt + 1;
            if (!this.edPTierBufNewPageArea.isTextBoxEnable(iTierNum)) continue;
            short sTierNewPage = Short.parseShort(this.edPTierBufNewPageArea.getStrTierBufNewPageText(iTierNum));
            SJmoPoolTierInfo poolTier = new SJmoPoolTierInfo();
            poolTier.setSTierNum((short)iTierNum);
            int iIndex = Collections.binarySearch(alDeepCocyTier, poolTier);
            if (iIndex < 0) continue;
            ((SJmoPoolTierInfo)alDeepCocyTier.get(iIndex)).setSTierAlocateCapa(sTierNewPage);
        }
        editData.setAlTierInfo(alDeepCocyTier);
    }

    public void createEditBufNewPageTierDisablePool(SJmoPoolDetail editData) {
        ArrayList<SJmoPoolPgKindInfo> alPgInfo = editData.getAlPoolPgKind();
        ArrayList<SJmoPoolTierInfo> alPoolTier = editData.getAlTierInfo();
        Collections.sort(alPoolTier);
        ArrayList alDeepCocyTier = SJmoDataUtility.alDeepCopy(alPoolTier);
        HashSet poolDriveTypeSet = this.getComUtility().getPoolUtility().getDriveTypeRpminPool(alPgInfo);
        int iCountMax = poolDriveTypeSet.size();
        if (iCountMax > 3) {
            iCountMax = 3;
        }
        for (int iCnt = 0; iCnt < iCountMax; ++iCnt) {
            short sTierNewPage = 8;
            int iTierNum = iCnt + 1;
            SJmoPoolTierInfo poolTier = new SJmoPoolTierInfo();
            poolTier.setSTierNum((short)iTierNum);
            int iIndex = Collections.binarySearch(alDeepCocyTier, poolTier);
            if (iIndex >= 0) {
                poolTier = (SJmoPoolTierInfo)alDeepCocyTier.get(iIndex);
                alDeepCocyTier.remove(iIndex);
            } else {
                iIndex = -iIndex - 1;
            }
            if (this.edPTierBufNewPageArea.isTextBoxEnable(iTierNum)) {
                sTierNewPage = Short.parseShort(this.edPTierBufNewPageArea.getStrTierBufNewPageText(iTierNum));
            } else if (iTierNum == 1 && this.getComUtility().getPoolUtility().checkSsdDrive(alPgInfo)) {
                sTierNewPage = 0;
            }
            poolTier.setSTierAlocateCapa(sTierNewPage);
            alDeepCocyTier.add(iIndex, poolTier);
        }
        editData.setAlTierInfo(alDeepCocyTier);
    }

    public void createEditBufRelocation(SJmoPoolDetail editData, SJmoPoolDetail chkData) {
        if (chkData.getPoolKind() == 2) {
            if (0 != (chkData.getITierControlInfo() & 0x80)) {
                this.createEditBufRelocationTierEnablePool(editData);
            } else {
                this.createEditBufRelocationTierDisablePool(editData);
            }
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "createEditBufRelocation", "Pool kind Error");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
    }

    public void createEditBufRelocationTierEnablePool(SJmoPoolDetail editData) {
        ArrayList<SJmoPoolTierInfo> alPoolTier = editData.getAlTierInfo();
        Collections.sort(alPoolTier);
        ArrayList alDeepCocyTier = SJmoDataUtility.alDeepCopy(alPoolTier);
        for (int iCnt = 0; iCnt < 3; ++iCnt) {
            int iTierNum = iCnt + 1;
            if (!this.edPTierBufRelocationArea.isTextBoxEnable(iTierNum)) continue;
            short sTierRelocation = Short.parseShort(this.edPTierBufRelocationArea.getStrTierBufRelocationText(iTierNum));
            SJmoPoolTierInfo poolTier = new SJmoPoolTierInfo();
            poolTier.setSTierNum((short)iTierNum);
            int iIndex = Collections.binarySearch(alDeepCocyTier, poolTier);
            if (iIndex < 0) continue;
            ((SJmoPoolTierInfo)alDeepCocyTier.get(iIndex)).setSTierRelocateCapa(sTierRelocation);
        }
        editData.setAlTierInfo(alDeepCocyTier);
    }

    public void createEditBufRelocationTierDisablePool(SJmoPoolDetail editData) {
        ArrayList<SJmoPoolPgKindInfo> alPgInfo = editData.getAlPoolPgKind();
        ArrayList<SJmoPoolTierInfo> alPoolTier = editData.getAlTierInfo();
        ArrayList alDeepCocyTier = SJmoDataUtility.alDeepCopy(alPoolTier);
        HashSet poolDriveTypeSet = this.getComUtility().getPoolUtility().getDriveTypeRpminPool(alPgInfo);
        int iCountMax = poolDriveTypeSet.size();
        if (iCountMax > 3) {
            iCountMax = 3;
        }
        for (int iCnt = 0; iCnt < iCountMax; ++iCnt) {
            short sTierRelocation = 2;
            int iTierNum = iCnt + 1;
            SJmoPoolTierInfo poolTier = new SJmoPoolTierInfo();
            poolTier.setSTierNum((short)iTierNum);
            int iIndex = Collections.binarySearch(alDeepCocyTier, poolTier);
            if (iIndex >= 0) {
                poolTier = (SJmoPoolTierInfo)alDeepCocyTier.get(iIndex);
                alDeepCocyTier.remove(iIndex);
            } else {
                iIndex = -iIndex - 1;
            }
            if (this.edPTierBufRelocationArea.isTextBoxEnable(iTierNum)) {
                sTierRelocation = Short.parseShort(this.edPTierBufRelocationArea.getStrTierBufRelocationText(iTierNum));
            }
            poolTier.setSTierRelocateCapa(sTierRelocation);
            alDeepCocyTier.add(iIndex, poolTier);
        }
        editData.setAlTierInfo(alDeepCocyTier);
    }

    public void restoreEditTierInfoList(SJmoPoolDetail editData, List poolDetailList) {
        Collections.sort(poolDetailList);
        int iIndex = Collections.binarySearch(poolDetailList, editData);
        if (iIndex < 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "restoreEditTierInfoList", "poolDetailList notFound");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        SJmoPoolDetail poolDtl = (SJmoPoolDetail)poolDetailList.get(iIndex);
        editData.setAlTierInfo(SJmoDataUtility.alDeepCopy(poolDtl.getAlTierInfo()));
    }

    @Override
    public String getDispName() {
        String strPos = "";
        strPos = this.getComUtility().getGuidance(EDIT_PL);
        return strPos;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        set.add(this.createModelDirect(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL));
        set.add(this.createModelDirect(SJctrPoolUtility.KEY_CLASS_POOLNAME_INFO));
        set.add(this.createModelDirect(SJctrPoolUtility.KEY_CLASS_LDEV_DETAIL));
        set.add(this.createModelDirect(SJctrPoolUtility.KEY_CLASS_POOLVOL_DETAIL));
        set.add(this.createModelDirect(SJctrPoolUtility.KEY_CLASS_HDP_RELATION_BY_POOL));
        set.add(this.createModelDirect(SJctrPoolUtility.KEY_CLASS_POOL_SUMMARY));
        set.add(this.createModelDirect(SJctrPoolUtility.KEY_CLASS_TIPAIR_PVOL_STATUS));
        return set;
    }

    protected SJctrGetDirectWrapper createModelDirect(Class<? extends SJmoGetKind_IF> reqClass) {
        SJctrGetDirectWrapper directWrapper = null;
        SJmoGetKind_IF kind = null;
        SJmoGetRange_IF range = null;
        ArrayList filterList = null;
        SJmoGetDirect direct = null;
        try {
            kind = reqClass.newInstance();
            range = null;
            filterList = new ArrayList();
            direct = new SJmoGetDirect(kind, range, filterList);
            directWrapper = new SJctrGetDirectWrapper(direct);
        }
        catch (InstantiationException insExp) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "SJctrGetDirectWrapper", "InstantiationException");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        catch (IllegalAccessException illExp) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "SJctrGetDirectWrapper", "IllegalAccessException");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        return directWrapper;
    }

    private void checkPoolType(List<SJmoPoolDetail> editDataList) {
        int iCnt = 0;
        byte byKind = 0;
        int iRaidLevel = 0;
        int iEmu = 0;
        boolean byVolumeType = false;
        boolean bCacheMode = true;
        SJmoPoolVolDetail PoolVolDtl = null;
        ArrayList tierDataList = new ArrayList();
        SJmoPoolDetail editData = new SJmoPoolDetail();
        ArrayList<SJmoLdevDetail> ldevDetailList = new ArrayList<SJmoLdevDetail>(this.getCache(SJctrPoolUtility.KEY_CLASS_LDEV_DETAIL));
        if (ldevDetailList == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkPoolType", "getLdevDetail null");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        List<?> PoolVolDetailList = this.getCache(SJctrPoolUtility.KEY_CLASS_POOLVOL_DETAIL);
        List<SJmoHDPRelationByPool> hdpRelationByPoolList = this.getCache(SJctrPoolUtility.KEY_CLASS_HDP_RELATION_BY_POOL);
        Collections.sort(ldevDetailList);
        Collections.sort(PoolVolDetailList);
        this.dmPoolSet = new HashSet<Boolean>();
        for (iCnt = 0; iCnt < editDataList.size(); ++iCnt) {
            editData = editDataList.get(iCnt);
            byKind = editData.getPoolKind();
            int iIndex = Collections.binarySearch(PoolVolDetailList, editData);
            if (iIndex < 0) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkPoolType", "PoolVol Index Error");
                SJctrPoolUtility.SJctrErrorDialog(107007);
            } else {
                PoolVolDtl = (SJmoPoolVolDetail)PoolVolDetailList.get(iIndex);
            }
            iEmu = editData.getEmulationType();
            if (iEmu != 0) {
                this.openOnlyflg = false;
            }
            if (byKind == 8) {
                this.statusFlg = false;
                this.selectedTiFlg = true;
                continue;
            }
            if (this.enaFlg) {
                this.enaFlg = this.checkTSEVolume(editData, hdpRelationByPoolList, ldevDetailList);
            }
            iRaidLevel = editData.getRaidLevel();
            int iChkRaidLevel = this.getComUtility().getPoolUtility().getPoolRaidLevel(iRaidLevel, SJctrPoolUtility.POOL_RAID_LEVEL_ALLMASK);
            boolean directMappingFlg = 0L != (editData.getLPoolOptionFlag() & 0x20000000L);
            this.dmPoolSet.add(directMappingFlg);
            if (directMappingFlg) {
                this.dmPoolVolFlg |= this.checkDmAttributePoolVol(PoolVolDtl.getAlPoolInfo(), ldevDetailList);
                continue;
            }
            this.normalDpRelationFlg |= this.checkDpVolume(editData, hdpRelationByPoolList, ldevDetailList);
        }
    }

    public void tierEvent() {
        SJctrRadioButtonGroupDataModel multiTierRadio = null;
        SJctrRadioButtonGroupDataModel tierManageRadio = null;
        SJctrComboBoxDataModel cycleCombo = null;
        SJctrTextBoxDataModel startTimeText = null;
        SJctrTextBoxDataModel endTimeText = null;
        SJctrCheckBoxAreaDataModel edMonModeCheckBoxArea = null;
        SJctrCheckBoxAreaDataModel edRelocationSpeedCheckBoxArea = null;
        SJctrCheckBoxAreaDataModel edTierManagementCheckBoxArea = null;
        this.edPTierArea.setTierTypeEventListner(false);
        this.edPTierArea.setExeIntEventListner(false);
        multiTierRadio = this.edPTierArea.getMultiTier();
        tierManageRadio = this.edPTierArea.getTierManagement();
        cycleCombo = this.edPTierArea.getCycleTime();
        startTimeText = this.edPTierArea.getStartMonitoringPeriod();
        endTimeText = this.edPTierArea.getEndMonitoringPeriod();
        edMonModeCheckBoxArea = this.edPTierArea.getEdMonModeCheckBoxArea();
        edRelocationSpeedCheckBoxArea = this.edPTierArea.getEdRelocationSpeedCheckBoxArea();
        edTierManagementCheckBoxArea = this.edPTierArea.getEdTierManagementCheckBoxArea();
        this.edpDataDirectMapping.refDataDirectMapping(multiTierRadio.getSelect());
        this.edpTiPairSuspend.refData();
        if (multiTierRadio.isSelect("COM_ENABLE")) {
            this.edPTierArea.initHrtCheckBox(this.statusFlg, this.bHrtLicenseFlg, this.hrtList, this.hasSSDAll);
            edTierManagementCheckBoxArea.setEnableCheckBox(true);
            edTierManagementCheckBoxArea.setSelectCheckBox(true);
            tierManageRadio.setEnable(true);
            this.edPTierArea.refCycleTime();
            this.edPTierArea.refMonitoringPeriod();
            edMonModeCheckBoxArea.setEnableCheckBox(true);
            edMonModeCheckBoxArea.setSelectCheckBox(true);
            this.edPTierArea.getMonModeCombo().setEnable(true);
            edRelocationSpeedCheckBoxArea.setEnableCheckBox(true);
            edRelocationSpeedCheckBoxArea.setSelectCheckBox(true);
            this.edPTierArea.getRelocationSpeedCombo().setEnable(true);
            this.edPTierBufNewPageArea.setEnableCheckBox(true);
            this.edPTierBufNewPageArea.setSelectCheckBox(true);
            this.edPTierBufNewPageArea.refTierBufNewPageArea(multiTierRadio.getSelect());
            this.edPTierBufRelocationArea.setEnableCheckBox(true);
            this.edPTierBufRelocationArea.setSelectCheckBox(true);
            this.edPTierBufRelocationArea.refTierBufRelocationArea(multiTierRadio.getSelect());
        } else if (multiTierRadio.isSelect("COM_DISABLE")) {
            this.edPTierArea.initHrtCheckBox(this.statusFlg, this.bHrtLicenseFlg, this.hrtList, this.hasSSDAll);
            edTierManagementCheckBoxArea.setEnableCheckBox(false);
            edTierManagementCheckBoxArea.setSelectCheckBox(false);
            tierManageRadio.setEnable(false);
            cycleCombo.setEnable(false);
            startTimeText.setEnable(false);
            endTimeText.setEnable(false);
            edMonModeCheckBoxArea.setEnableCheckBox(false);
            edMonModeCheckBoxArea.setSelectCheckBox(false);
            this.edPTierArea.getMonModeCombo().setEnable(false);
            edRelocationSpeedCheckBoxArea.setEnableCheckBox(false);
            edRelocationSpeedCheckBoxArea.setSelectCheckBox(false);
            this.edPTierArea.getRelocationSpeedCombo().setEnable(false);
            this.edPTierBufNewPageArea.setEnableCheckBox(false);
            this.edPTierBufNewPageArea.setSelectCheckBox(false);
            this.edPTierBufNewPageArea.refTierBufNewPageArea(multiTierRadio.getSelect());
            this.edPTierBufRelocationArea.setEnableCheckBox(false);
            this.edPTierBufRelocationArea.setSelectCheckBox(false);
            this.edPTierBufRelocationArea.refTierBufRelocationArea(multiTierRadio.getSelect());
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "tierEvent", "multiTierRadio Error");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        if (!this.checkDefaultMulutiTier()) {
            this.getComUtility().getPoolUtility();
            SJcMessage msg = SJctrPoolUtility.getWarningMsg(31, 22, 106140);
            SJctrRelatedDispDataObject related = this.createMsgDialog(msg);
            SJctrUserController uc = this.getOwner();
            SJctrMessageDataController msgDC = (SJctrMessageDataController)uc.getDataController(related);
            msgDC.addButton(SJctrMessageDataController.MD_OK);
            this.addUpdateDisp(related);
        }
        this.setDirtyAll();
        this.edPTierArea.setTierTypeEventListner(true);
        this.edPTierArea.setExeIntEventListner(true);
    }

    public void dataDirectMappingEvent() {
        if (this.edpDataDirectMapping.isSelectEnable()) {
            this.edPDepThresholdArea.setDepletionThresholdMax("100");
            this.edPDepThresholdArea.setDepletionThresholdMin("100");
            this.edPDepThresholdArea.setDepletionThresholdValue("100");
            this.edPDepThresholdArea.setSelectDepletionThresholdCheckBox(true);
            this.edPThresholdArea.setWarningThresholdMax("100");
            this.edPThresholdArea.setWarningThresholdMin("100");
            this.edPThresholdArea.setWarningThresholdValue("100");
            this.edPThresholdArea.setSelectWarningThresholdCheckBox(true);
        } else if (this.edpDataDirectMapping.isSelectDisable()) {
            this.edPDepThresholdArea.initDepThreshold();
            this.edPThresholdArea.initWarningThreshold(this.edPDepThresholdArea.isDepEnable());
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "dataDirectMappingEvent", "dataDirectMappingRadio Error");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        this.edpTiPairSuspend.refData();
        this.setDirtyAll();
    }

    public void tierTypeEvent() {
        SJctrRadioButtonGroupDataModel tierManageRadio = null;
        tierManageRadio = this.edPTierArea.getTierManagement();
        this.edPTierArea.setExeIntEventListner(false);
        if (tierManageRadio.isSelect("COM_AUTO") || tierManageRadio.isSelect("COM_MANUAL")) {
            this.edPTierArea.refCycleTime();
            this.edPTierArea.refMonitoringPeriod();
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "tierEvent", "multiTierRadio Error");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        this.setDirtyAll();
        this.edPTierArea.setExeIntEventListner(true);
    }

    public void executionEvent() {
        this.edPTierArea.refMonitoringPeriod();
        this.setDirtyAll();
    }

    public void tiPairSuspendEvent() {
        SJctrRadioButtonGroupDataModel multiTierRadio = null;
        multiTierRadio = this.edPTierArea.getMultiTier();
        if (this.edpTiPairSuspend.isSelectEnable()) {
            this.edpDataDirectMapping.button.setEnable("COM_ENABLE", false);
            multiTierRadio.setEnable("COM_ENABLE", false);
        } else if (this.edpTiPairSuspend.isSelectEnable()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "dataDirectMappingEvent", "dataDirectMappingRadio Error");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        this.setDirtyAll();
    }

    private void checkEdpLicenseAuthorize() {
        SJctrAuthorizeContainer AuthorizeContainer = this.getOwner().getAuthorizeContainer();
        SJctrLicenseContainer licensecontainer = AuthorizeContainer.getLisenceContainer();
        this.iDpLicenseFlg = licensecontainer.checkPP(SJctrLicenseContainer.PPID_DP);
        this.iPbTSMLicenseFlg = this.iDpLicenseFlg & licensecontainer.checkPP(SJctrLicenseContainer.PPID_HDTPM);
        this.iMfPbTSMLicenseFlg = this.iPbTSMLicenseFlg & licensecontainer.checkPP(SJctrLicenseContainer.PPID_DPFM) & licensecontainer.checkPP(SJctrLicenseContainer.PPID_MFDT);
        this.bHrtLicenseFlg = this.iPbTSMLicenseFlg & licensecontainer.checkPP(SJctrLicenseContainer.PPID_HRT);
        this.iDRULicenseFlg = licensecontainer.checkPP(SJctrLicenseContainer.PPID_DRU);
    }

    private boolean checkTSEVolume(SJmoPoolDetail editData, List<SJmoHDPRelationByPool> hdpRelationByPoolList, List<SJmoLdevDetail> ldevDetailList) {
        boolean returnValue = true;
        SJmoHDPRelationByPool hdpRelationByPool = null;
        SJmoLdevDetail ldevDetail = null;
        int relationIndex = Collections.binarySearch(hdpRelationByPoolList, editData);
        if (relationIndex < 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkTSEVolume", "HDP Relation By Pool not found");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        } else {
            hdpRelationByPool = hdpRelationByPoolList.get(relationIndex);
        }
        ArrayList hdpRelationList = hdpRelationByPool.getAlDPVOLInfo();
        Iterator iteHDPRelation = hdpRelationList.iterator();
        while (returnValue && iteHDPRelation.hasNext()) {
            SJmoHDPRelation hdpRelationObj = (SJmoHDPRelation)iteHDPRelation.next();
            int ldevDetailIndex = Collections.binarySearch(ldevDetailList, hdpRelationObj);
            if (ldevDetailIndex < 0) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkTSEVolume", "LdevDetail not found");
                SJctrPoolUtility.SJctrErrorDialog(107007);
            } else {
                ldevDetail = ldevDetailList.get(ldevDetailIndex);
            }
            returnValue = !ldevDetail.getbTseVol();
        }
        return returnValue;
    }

    private void setThresholdData(boolean bThresholdChk, boolean bDepThresholdChk, SJmoPoolDetail editData, SJmoPoolDetail poolDtlCln, ArrayList<SJmoPoolDetail> alDefPool) {
        if (bThresholdChk) {
            this.createEditThreshold(editData);
            editData.setSPoolThresholdMode((short)SJctrPoolUtility.THRESHOLD_MODE_DEPLETION_ON);
            if (bDepThresholdChk) {
                this.createEditDepThreshold(editData);
            } else if (poolDtlCln.getPoolKind() == 8) {
                editData.setSPoolDepletionThreshold((short)0);
                editData.setSPoolThresholdMode((short)1);
            } else if (poolDtlCln.getSPoolThresholdMode() == 1) {
                if (this.getComUtility().getPoolUtility().isSysThresChangeDepThres(poolDtlCln)) {
                    editData.setSPoolDepletionThreshold(poolDtlCln.getPoolFixThreshold());
                } else {
                    editData.setSPoolDepletionThreshold(poolDtlCln.getPoolThreshold());
                }
            } else {
                this.restoreEditDepThreshold(editData, alDefPool);
                this.restoreEditThresholdMode(editData, alDefPool);
            }
        } else if (bDepThresholdChk) {
            this.createEditDepThreshold(editData);
            editData.setSPoolThresholdMode((short)SJctrPoolUtility.THRESHOLD_MODE_DEPLETION_ON);
            if (this.getComUtility().getPoolUtility().isSysThresChangeWarThres(poolDtlCln)) {
                editData.setPoolThreshold(poolDtlCln.getPoolFixThreshold());
            } else {
                editData.setPoolThreshold(poolDtlCln.getPoolThreshold());
            }
        } else {
            this.restoreEditThreshold(editData, alDefPool);
            this.restoreEditDepThreshold(editData, alDefPool);
            this.restoreEditThresholdMode(editData, alDefPool);
        }
    }

    @Override
    public boolean checkFinishData(final SJctrMessageEvent msgEvent, final SJctrDataObjectModel<?> dstModel) {
        boolean bReturn;
        block4: {
            block5: {
                bReturn = false;
                this.checkEndFlg = true;
                SJctrRadioButtonGroupDataModel multiTierRadio = this.edPTierArea.getMultiTier();
                if (this.checkEndFlg) {
                    this.checkEndData();
                    this.checkEndFlg = false;
                }
                if (this.checkDefaultMulutiTier() || this.checkEndFlg) break block4;
                if (multiTierRadio.isSelect("COM_DISABLE")) break block5;
                if (!multiTierRadio.isSelect("COM_ENABLE")) break block4;
                if (!this.poolSummaryInfo.chkBPoolControl(0x40000000)) break block4;
            }
            this.getComUtility().getPoolUtility();
            SJcMessage msg = SJctrPoolUtility.getWarningMsg(31, 22, 106139);
            SJctrRelatedDispDataObject related = this.createMsgDialog(msg);
            SJctrUserController uc = this.getOwner();
            SJctrMessageDataController msgDC = (SJctrMessageDataController)uc.getDataController(related);
            msgDC.addButton(SJctrMessageDataController.MD_OK, new SJctrItemSelectListener(){

                @Override
                public void selectChanged(SJctrItemSelectEvent<?> event) {
                    SJctrEditPoolsDC.this.finishEvent(msgEvent, dstModel);
                }
            });
            this.addUpdateDisp(related);
            bReturn = true;
        }
        return bReturn;
    }

    private boolean checkDefaultMulutiTier() {
        boolean bresult = true;
        SJctrRadioButtonGroupDataModel multiTierRadio = this.edPTierArea.getMultiTier();
        String strSelectMultiTierRadio = multiTierRadio.getSelect();
        if (strSelectMultiTierRadio != null) {
            bresult = this.defaultMulutiTier != null && this.defaultMulutiTier.equals(strSelectMultiTierRadio);
        }
        return bresult;
    }

    private void checkHrtPool(List<SJmoPoolDetail> selectPoolDetailList, List<SJmoPoolVolDetail> poolVolDetailList, List<SJmoLdevDetail> ldevDetailList) {
        SJctrPoolUtility poolUtil = this.getComUtility().getPoolUtility();
        this.hrtList = new ArrayList<SJmoPoolDetail>(selectPoolDetailList.size());
        Iterator<SJmoPoolDetail> i$ = selectPoolDetailList.iterator();
        while (i$.hasNext()) {
            SJmoPoolVolDetail poolVolDetail;
            ArrayList poolVolList;
            List<SJmoLdevDetail> ssdList;
            int index;
            boolean hrtFlg;
            SJmoPoolDetail obj;
            SJmoPoolDetail poolDetail = obj = i$.next();
            byte poolKind = poolDetail.getPoolKind();
            int iTierControlInfo = poolDetail.getITierControlInfo();
            boolean bl = hrtFlg = 144 == (iTierControlInfo & 0x90);
            if (poolKind == 2 && hrtFlg) {
                this.hrtList.add(poolDetail);
            }
            if ((index = Collections.binarySearch(poolVolDetailList, poolDetail)) < 0) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkHrtPool", "ldevDetailList Search Error");
                SJctrPoolUtility.SJctrErrorDialog(107007);
            }
            this.hasSSDAll &= !(ssdList = poolUtil.serchSSDVol(poolVolList = (poolVolDetail = poolVolDetailList.get(index)).getAlPoolInfo(), ldevDetailList)).isEmpty();
        }
    }

    private void chkPoolSystemOption(List editData) {
        this.edpBlockadePoolVols.setCheckBox(true);
        this.edpBlockadePoolVols.setDisEnable(true);
        this.edpBlockadePoolVols.setDisDisable(true);
        this.edpPoolFull.setCheckBox(true);
        this.edpPoolFull.setDisEnable(true);
        this.edpPoolFull.setDisDisable(true);
        boolean chkLicenseFlg = true;
        chkLicenseFlg = this.chkPoolSystemOptionLisence();
        if (chkLicenseFlg) {
            this.setPoolOpetion(editData, 0x40000000L, this.edpBlockadePoolVols);
            this.setPoolOpetion(editData, 0x80000000L, this.edpPoolFull);
        } else {
            this.edpBlockadePoolVols.setCheckBox(false);
            this.edpBlockadePoolVols.setDisEnable(false);
            this.edpBlockadePoolVols.setDisDisable(false);
            this.edpPoolFull.setCheckBox(false);
            this.edpPoolFull.setDisEnable(false);
            this.edpPoolFull.setDisDisable(false);
        }
    }

    private void setPoolOpetion(List editData, long poolOptionKey, SJctrEditPoolsSystemOptionArea edpSystemOptionArea) {
        SJmoPoolDetail poolDetail = null;
        int iCnt = 0;
        long lPoolOpt = 0L;
        long lDefaultPoolOpt = 0L;
        boolean bPoolOptFlg = true;
        poolDetail = (SJmoPoolDetail)editData.get(0);
        lDefaultPoolOpt = poolDetail.getLPoolOptionFlag() & poolOptionKey;
        for (iCnt = 0; iCnt < editData.size(); ++iCnt) {
            poolDetail = (SJmoPoolDetail)editData.get(iCnt);
            lPoolOpt = poolDetail.getLPoolOptionFlag() & poolOptionKey;
            if (lPoolOpt == lDefaultPoolOpt) continue;
            bPoolOptFlg = false;
            break;
        }
        if (bPoolOptFlg) {
            if (poolOptionKey == lDefaultPoolOpt) {
                edpSystemOptionArea.selectEnable();
            } else {
                edpSystemOptionArea.selectDisable();
            }
        }
    }

    private boolean chkPoolSystemOptionLisence() {
        boolean licenseFlg = false;
        if (this.openOnlyflg) {
            licenseFlg = this.iDRULicenseFlg;
        }
        return this.statusFlg & licenseFlg;
    }

    public long createEditDataDirectMapping(SJctrEditPoolsDataDirectMapping edpDataDirectMapping) {
        long lPoolOption = 0L;
        if (edpDataDirectMapping.getSelCheckBox() && edpDataDirectMapping.isSelectEnable()) {
            lPoolOption |= 0x20000000L;
        }
        return lPoolOption;
    }

    public long createEditPoolOption(boolean bChkBox, SJmoPoolDetail editData, long poolOptionKey, SJctrEditPoolsSystemOptionArea edpSystemOptionArea) {
        long lPoolOption = 0L;
        if (bChkBox) {
            lPoolOption = edpSystemOptionArea.isSelectEnable() ? (lPoolOption |= poolOptionKey) : (lPoolOption &= poolOptionKey ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return lPoolOption;
    }

    public long restoreEditPoolOption(SJmoPoolDetail editData, List poolDetailList, long poolOptionKey) {
        long lPoolOption = 0L;
        int iIndex = 0;
        SJmoPoolDetail poolDetail = null;
        Collections.sort(poolDetailList);
        iIndex = Collections.binarySearch(poolDetailList, editData);
        if (iIndex < 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "restoreEditProtect V-VOLs", "poolDetailList notFound");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        poolDetail = (SJmoPoolDetail)poolDetailList.get(iIndex);
        lPoolOption = poolDetail.getLPoolOptionFlag() & poolOptionKey;
        return lPoolOption;
    }

    public long createEditTiPairSuspend(SJctrEditPoolsTiPairSuspendArea edpTiPairSuspend) {
        long lPoolOption = 0L;
        if (edpTiPairSuspend.getSelCheckBox() && !edpTiPairSuspend.isSelectEnable()) {
            lPoolOption |= 0x10000000L;
        }
        return lPoolOption;
    }

    public long restoreEditTiPairSuspend(SJmoPoolDetail editData, List poolDetailList, long poolOptionKey) {
        long lPoolOption = 0L;
        int iIndex = 0;
        SJmoPoolDetail poolDetail = null;
        Collections.sort(poolDetailList);
        iIndex = Collections.binarySearch(poolDetailList, editData);
        if (iIndex < 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "restoreEditTiPairSuspend", "poolDetailList notFound");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        poolDetail = (SJmoPoolDetail)poolDetailList.get(iIndex);
        lPoolOption = poolDetail.getLPoolOptionFlag() & poolOptionKey;
        return lPoolOption;
    }

    private boolean checkDpVolume(SJmoPoolDetail editData, List<SJmoHDPRelationByPool> hdpRelationByPoolList, List<SJmoLdevDetail> ldevDetailList) {
        boolean returnValue = false;
        SJmoHDPRelationByPool hdpRelationByPool = null;
        Object ldevDetail = null;
        int relationIndex = Collections.binarySearch(hdpRelationByPoolList, editData);
        if (relationIndex < 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkDpVolume", "HDP Relation By Pool not found");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        } else {
            hdpRelationByPool = hdpRelationByPoolList.get(relationIndex);
        }
        ArrayList hdpRelationList = hdpRelationByPool.getAlDPVOLInfo();
        returnValue = !hdpRelationList.isEmpty();
        return returnValue;
    }

    private boolean checkDmAttributePoolVol(List<SJmoPoolVolInfo> poolVolInfList, List<SJmoLdevDetail> ldevDetailList) {
        boolean returnValue = false;
        for (SJmoPoolVolInfo obj : poolVolInfList) {
            SJmoLdevDetail ldevDetail;
            SJmoPoolVolInfo poolVolInfo = obj;
            int ldevIndex = Collections.binarySearch(ldevDetailList, poolVolInfo);
            if (ldevIndex < 0) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkDmAttributePoolVol", "ldevDetail not found");
                SJctrPoolUtility.SJctrErrorDialog(107007);
            }
            if (!(ldevDetail = ldevDetailList.get(ldevIndex)).getBDM()) continue;
            returnValue = true;
            break;
        }
        return returnValue;
    }

    public static enum SELECT_ED_MSG implements SJctrNotifyState
    {
        TIERINFO,
        TIERTYPE,
        EXEINT,
        DATADIRECTMAPPING,
        EDIT_FPTL,
        CHG_DED,
        TIPAIRSUSPEND;

    }
}

