/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.pool.expandpool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.column.SJctrArrayGroupFromLdevDetailColumn;
import sanproject.sn2.controller.com.column.SJctrCacheModeFromLdevDetailColumn;
import sanproject.sn2.controller.com.column.SJctrCapacityColumnFromLdevDetail;
import sanproject.sn2.controller.com.column.SJctrEmulationTypeFromLdevDetailColumn;
import sanproject.sn2.controller.com.column.SJctrLdevAttributeFromLdevDetailColumn;
import sanproject.sn2.controller.com.column.SJctrLdevIdColumnFromLdevDetail;
import sanproject.sn2.controller.com.column.SJctrLdevNameFromLdevDetailColumn;
import sanproject.sn2.controller.com.column.SJctrRaidLevelFromLdevDetailColumn;
import sanproject.sn2.controller.com.column.SJctrVirtualizationModeColumnFromLdevDetail;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.wizard.pool.com.SJctrExpandPoolDriveTypeFromLdevDetailColumn;
import sanproject.sn2.controller.wizard.pool.expandpool.SJctrExpandPoolConfirmDC;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.inf.SJmoSearchTerm_IF;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public class SJctrExpandPoolConfirmTableModel
extends SJctrTableDataModel {
    public SJctrExpandPoolConfirmTableModel() {
        super(false);
    }

    @Override
    protected void initTable() {
        this.addColumn(new SJctrLdevIdColumnFromLdevDetail("COM_COL_LDEVID"));
        this.addColumn(new SJctrLdevNameFromLdevDetailColumn("COM_COL_LDEVNAME"));
        this.addColumn(new SJctrCapacityColumnFromLdevDetail("COM_COL_LDEVCAP"));
        this.addColumn(new SJctrArrayGroupFromLdevDetailColumn("COM_COL_ARYGRP"));
        this.addColumn(new SJctrRaidLevelFromLdevDetailColumn("COM_COL_RAIDLEV"));
        this.addColumn(new SJctrExpandPoolDriveTypeFromLdevDetailColumn("COM_COL_DRIVETYPE", true));
        SJctrEmulationTypeFromLdevDetailColumn emuTypeCulm = new SJctrEmulationTypeFromLdevDetailColumn("COM_COL_EMUTYPE");
        if (SJctrDataController.isHM()) {
            emuTypeCulm.setSupportColumn(false);
        }
        this.addColumn(emuTypeCulm);
        this.addColumn(new SJctrCacheModeFromLdevDetailColumn("COM_COL_CACHEMODE"));
        this.addColumn(new SJctrLdevAttributeFromLdevDetailColumn("COM_COL_ATTR"));
        this.addColumn(new SJctrVirtualizationModeColumnFromLdevDetail("COM_COL_VIRTUAL_MODE"));
    }

    @Override
    public List<?> getBasicDataList(Class<?> cls) {
        ArrayList<Object> mainKeyList = new ArrayList();
        SJctrExpandPoolConfirmDC expConfDC = (SJctrExpandPoolConfirmDC)this.getDataController();
        ArrayList selectPoolVolDataList = new ArrayList(expConfDC.getCache("KEY_CLASS_SELECT_POOLVOL"));
        if (null == selectPoolVolDataList || 0 == selectPoolVolDataList.size()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getBasicDataList", "CacheData is null or size 0");
            SJctrError ctrErr = new SJctrError(31, 22, 107007);
            SJcException ctrExp = ctrErr.createException();
            throw ctrExp;
        }
        Collections.sort(selectPoolVolDataList);
        mainKeyList = selectPoolVolDataList;
        boolean bMFFlg = false;
        boolean bOpenFlg = false;
        SJctrCapacityUtility util = this.getComUtility().getCapacityUtility();
        for (int iCnt = 0; iCnt < mainKeyList.size(); ++iCnt) {
            SJmoLdevDetail ldevDtl = (SJmoLdevDetail)mainKeyList.get(iCnt);
            if (SJctrLdevUtility.isOpenVolume(ldevDtl)) {
                bOpenFlg = true;
                break;
            }
            if (!SJctrLdevUtility.isMFVolume(ldevDtl)) continue;
            bMFFlg = true;
            break;
        }
        this.setCapacityFlg(true);
        this.setMainframeVolumeFlg(bMFFlg);
        this.setOpenVolumeFlg(bOpenFlg);
        return mainKeyList;
    }

    @Override
    protected List<SJmoSearchTerm_IF> createModelFilter(Class<? extends SJmoGetKind_IF> kindClass) {
        ArrayList<SJmoSearchTerm_IF> retList = new ArrayList<SJmoSearchTerm_IF>();
        return retList;
    }

    @Override
    protected SJmoGetRange_IF createModelRange(Class<? extends SJmoGetKind_IF> kindClass) {
        return null;
    }

    @Override
    protected void setModelData(Map<SJctrGetDirectWrapper, List<?>> models) {
        HashMap map = new HashMap();
        super.setModelData(map);
        ArrayList pdevDtlList = new ArrayList(this.getDataController().getProxy().getCache(SJctrPoolUtility.KEY_CLASS_PDEV_DETAIL));
        ArrayList ldevNameInfList = new ArrayList(this.getDataController().getProxy().getCache(SJctrPoolUtility.KEY_CLASS_LDEVNAME_INFO));
        List<?> versionList = this.getDataController().getProxy().getCache(SJctrPoolUtility.KEY_CLASS_POOL_TASK_VERSION.getName());
        ArrayList<Object> selExtLdevPerformanceList = null;
        List<?> ExtPerforList = this.getDataController().getProxy().getCache("KEY_SEL_POOLVOL_EXT_DRIVE");
        if (null != ExtPerforList) {
            selExtLdevPerformanceList = new ArrayList(ExtPerforList);
        } else {
            HashMap SelectExtLdevPerfomance = new HashMap();
            selExtLdevPerformanceList = new ArrayList();
            selExtLdevPerformanceList.add(SelectExtLdevPerfomance);
        }
        if (null == pdevDtlList || 0 == pdevDtlList.size() || null == ldevNameInfList || 0 == ldevNameInfList.size() || null == selExtLdevPerformanceList || 0 == selExtLdevPerformanceList.size() || null == versionList || versionList.isEmpty()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "setModelData", "CacheData is null or size 0");
        }
        this.setBasicData(SJctrPoolUtility.KEY_CLASS_PDEV_DETAIL, pdevDtlList);
        this.setBasicData(SJctrPoolUtility.KEY_CLASS_LDEVNAME_INFO, ldevNameInfList);
        this.setBasicData(SJctrPoolUtility.KEY_CLASS_POOL_TASK_VERSION, versionList);
        this.setBasicData(SJctrPoolUtility.KEY_CLASS_EXT_LDEV_PERFORMANCE, selExtLdevPerformanceList);
    }

    @Override
    protected void makeCapacityUnitInfo() {
    }
}

