/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.local.createpairs.selectpaircofig;

import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.wizard.replication.local.createpairs.SJctrCreatePairPVOLInfo;
import sanproject.sn2.controller.wizard.replication.local.createpairs.SJctrCreatePairUtility;
import sanproject.sn2.controller.wizard.replication.local.createpairs.selectpaircofig.SJctrSelectPairConfigDC;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public class SJctrSVOLNumDataModel
extends SJctrSimpleDataModel {
    public static final String KEY_NUMOFSECVOLCMB = "COM_NUMOFSECVOLCMB";
    public static final String KEY_MAX = "COM_MAX";
    public static final String KEY_MIN = "COM_MIN";
    private SJctrComboBoxDataModel sVOLNum = null;
    private BitSet numBitSet = null;
    private BitSet mgNumBitSet = null;
    private SJctrItemSelectListener itemSelectListener = null;

    public SJctrSVOLNumDataModel() {
        this.initDataModel();
    }

    protected void initDataModel() {
        this.sVOLNum = new SJctrComboBoxDataModel();
        this.addDataModel(KEY_NUMOFSECVOLCMB, this.sVOLNum);
        this.numBitSet = new BitSet(1025);
        this.mgNumBitSet = new BitSet(1025);
    }

    @Override
    public void makeDataModel() {
        super.makeDataModel();
    }

    public void refSVOLNum(List<SJctrCreatePairPVOLInfo> pVolList, List<SJctrCreatePairPVOLInfo> mgPVolList, int cpType, int emuType) {
        int max;
        int min;
        int sVolNum;
        int pairNum;
        SJmoLdevDetail pVol;
        int maxPairNum;
        this.sVOLNum.removeAllItems();
        this.numBitSet.clear();
        this.mgNumBitSet.clear();
        for (SJctrCreatePairPVOLInfo pVolInfo : pVolList) {
            maxPairNum = SJctrCreatePairUtility.getMaxPairNum(cpType, pVolInfo.isSVol());
            pVol = pVolInfo.getPVol();
            if (pVol.getIEmulationType() != emuType || (pairNum = pVolInfo.getPairNum()) >= maxPairNum || (sVolNum = pVolInfo.getSVOLNum()) <= 0) continue;
            min = pVolInfo.getMinSVolNum();
            max = pVolInfo.getMaxSVolNum();
            this.numBitSet.set(min, max + 1);
        }
        if (cpType == 0) {
            for (SJctrCreatePairPVOLInfo pVolInfo : mgPVolList) {
                maxPairNum = SJctrCreatePairUtility.getMaxPairNum(cpType, pVolInfo.isSVol());
                pVol = pVolInfo.getPVol();
                if (pVol.getIEmulationType() != emuType || (pairNum = pVolInfo.getPairNum()) >= maxPairNum || (sVolNum = pVolInfo.getSVOLNum()) <= 0) continue;
                min = pVolInfo.getMinSVolNum();
                max = pVolInfo.getMaxSVolNum();
                this.mgNumBitSet.set(min, max + 1);
            }
        }
        BitSet availableNumBitSet = new BitSet(1025);
        availableNumBitSet.or(this.numBitSet);
        availableNumBitSet.or(this.mgNumBitSet);
        int bitNo = availableNumBitSet.nextSetBit(1);
        while (bitNo >= 0) {
            this.sVOLNum.addItem(Integer.toString(bitNo), Integer.toString(bitNo));
            bitNo = availableNumBitSet.nextSetBit(bitNo + 1);
        }
        Object mgrData = this.getManageData();
        ((SJctrDataObject)mgrData).setData(KEY_MIN, Integer.toString(1));
        ((SJctrDataObject)mgrData).setData(KEY_MAX, Integer.toString(SJctrCreatePairUtility.getMaxPairNum(cpType, false)));
        this.sVOLNum.setSelectedIndex(0);
    }

    public boolean isCreateSVolNum(int sVONum) {
        boolean ret = false;
        if (this.numBitSet != null) {
            ret = this.numBitSet.get(sVONum);
        }
        if (this.numBitSet != null) {
            ret |= this.mgNumBitSet.get(sVONum);
        }
        return ret;
    }

    public short getSelectSVOLNum() {
        short ret = -1;
        String selection = this.sVOLNum.getSelection();
        if (selection != null) {
            if (selection.length() != 0) {
                ret = Short.valueOf(selection);
            } else {
                HashMap<String, Object> item = this.sVOLNum.getItem(selection);
                String label = (String)item.get("label");
                this.sVOLNum.setSelection(label);
                ret = Short.valueOf(label);
            }
        }
        return ret;
    }

    public void setSelectSVOLNum(int num) {
        this.sVOLNum.setSelection(Integer.toString(num));
    }

    public void initListener() {
        if (this.itemSelectListener == null) {
            this.itemSelectListener = new SJctrItemSelectListener(){

                @Override
                public void selectChanged(SJctrItemSelectEvent<?> event) {
                    if (event.isSelect()) {
                        SJctrSVOLNumDataModel.this.fireMessageEvent(SJctrSelectPairConfigDC.CREATEPAIR_MSG.CHG_SVOLNUM);
                    }
                }
            };
            this.sVOLNum.addItemSelectListener(this.itemSelectListener);
        }
    }

    public boolean isUseNormalVol() {
        short num = this.getSelectSVOLNum();
        return this.numBitSet.get(num);
    }

    public boolean isUseFiconUVMVol() {
        short num = this.getSelectSVOLNum();
        return this.mgNumBitSet.get(num);
    }
}

