/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.local.createpairs.selectprimaryvols;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.model.SJctrRadioButtonGroupDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;

public class SJctrSelectionObjectRadioDataModel
extends SJctrRadioButtonGroupDataModel {
    private static final String KEY_FIBRE = "COM_FIBRE";
    private static final String KEY_ISCSI = "COM_ISCSI";
    private static final String KEY_HNAS_USER = "COM_HNAS_USER";
    private List<SJmoPortDetail> portDtlList = Collections.emptyList();
    private Map<Short, Set<Short>> portHGMap_Fibre = Collections.emptyMap();
    private Map<Short, Set<Short>> portHGMap_iSCSI = Collections.emptyMap();
    private Map<Short, Set<Short>> portHGMap_NAS = Collections.emptyMap();
    private SJctrItemSelectListener itemSelectListener = null;

    public SJctrSelectionObjectRadioDataModel() {
        this.add(KEY_FIBRE);
        this.add(KEY_ISCSI);
        this.add(KEY_HNAS_USER);
        this.initListener();
    }

    public void initListener() {
        if (this.itemSelectListener != null) {
            return;
        }
        this.itemSelectListener = new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrSelectionObjectRadioDataModel.this.fireMessageEvent(CHGSELOBJ_MSG.CHG_SELOBJ);
                }
            }
        };
        this.addItemSelectListener(this.itemSelectListener);
    }

    public void initSelectionObject(List<SJmoPortDetail> portDtlList, Map<Short, Set<Short>> portHGMap, boolean hasHFB) {
        this.portDtlList = portDtlList;
        this.refSelectionObject(portHGMap, hasHFB);
    }

    public void refSelectionObject(Map<Short, Set<Short>> portHGMap, boolean hasHFB) {
        if (portHGMap == null || portHGMap.isEmpty()) {
            return;
        }
        this.portHGMap_Fibre = new HashMap<Short, Set<Short>>(portHGMap.size());
        this.portHGMap_iSCSI = new HashMap<Short, Set<Short>>(portHGMap.size());
        this.portHGMap_NAS = new HashMap<Short, Set<Short>>(portHGMap.size());
        SJmoPortIndex searchPort = new SJmoPortIndex();
        for (Short portId : portHGMap.keySet()) {
            searchPort.setSPort(portId);
            Set<Short> hgSet = portHGMap.get(portId);
            int index = Collections.binarySearch(this.portDtlList, searchPort);
            if (index < 0) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "refSelectionObject", "SJmoPortDetail Not Found. PortID : " + portId);
                continue;
            }
            SJmoPortDetail portDtl = this.portDtlList.get(index);
            if (SJctrPortUtility.isFibrePort(portDtl) || SJctrPortUtility.isFcoePort(portDtl)) {
                this.portHGMap_Fibre.put(portId, hgSet);
            }
            if (SJctrPortUtility.isIscsiPort(portDtl)) {
                this.portHGMap_iSCSI.put(portId, hgSet);
            }
            if (portDtl.getByPortKindNo() != 7) continue;
            this.portHGMap_NAS.put(portId, hgSet);
        }
        this.setEnable(KEY_FIBRE, !this.portHGMap_Fibre.isEmpty());
        this.setEnable(KEY_ISCSI, !this.portHGMap_iSCSI.isEmpty());
        this.setEnable(KEY_HNAS_USER, !this.portHGMap_NAS.isEmpty());
        if (!hasHFB) {
            this.setVisible(KEY_HNAS_USER, false);
        }
        if (this.isEnable(KEY_FIBRE)) {
            this.setSelect(KEY_FIBRE);
        } else if (this.isEnable(KEY_ISCSI)) {
            this.setSelect(KEY_ISCSI);
        } else if (this.isEnable(KEY_HNAS_USER)) {
            this.setSelect(KEY_HNAS_USER);
        }
    }

    public Map<Short, Set<Short>> getPortHGMap() {
        Map<Short, Set<Short>> ret = Collections.emptyMap();
        if (this.isSelect(KEY_FIBRE)) {
            ret = this.portHGMap_Fibre;
        } else if (this.isSelect(KEY_ISCSI)) {
            ret = this.portHGMap_iSCSI;
        } else if (this.isSelect(KEY_HNAS_USER)) {
            ret = this.portHGMap_NAS;
        }
        return ret;
    }

    public static enum CHGSELOBJ_MSG implements SJctrNotifyState
    {
        CHG_SELOBJ;

    }
}

