/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.local.createtipairs.column;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.com.comparator.SJctrHGInfoComparator;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;

public class SJctrIscsiTargetNameColumnFromPortLunDetail
extends SJctrColumn {
    private SJmoHostGroupInfo searchHgInfo = new SJmoHostGroupInfo();
    private SJctrHGInfoComparator HGID_COMP = new SJctrHGInfoComparator();

    public SJctrIscsiTargetNameColumnFromPortLunDetail(String key) {
        super(key);
        this.setPartsId("ISCSI_TARGET_NAME");
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetPortLunInfo.class);
        list.add(SJmoGetPortDetail.class);
        list.add(SJmoGetPortIscsiTargetInfo.class);
        return list;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<SJmoPortIndex> list = new ArrayList<SJmoPortIndex>();
        SJmoPortLunDetail luPathInfo = (SJmoPortLunDetail)index;
        SJmoPortDetail portDtl = this.getPortDetail(luPathInfo, modelData);
        list.add(portDtl);
        if (portDtl != null && SJctrPortUtility.isIscsiPort(portDtl)) {
            SJmoIscsiTargetInfo itInfo = this.getIscsiTargetInfo(luPathInfo, modelData);
            list.add(itInfo);
        }
        return list;
    }

    protected SJmoPortDetail getPortDetail(SJmoPortIndex portIndex, Map<Class<?>, List<?>> modelData) {
        SJmoPortDetail portDtl = null;
        List<?> portDtlList = modelData.get(SJmoGetPortDetail.class);
        int search = Collections.binarySearch(portDtlList, portIndex);
        if (search >= 0) {
            portDtl = (SJmoPortDetail)portDtlList.get(search);
        }
        return portDtl;
    }

    protected SJmoIscsiTargetInfo getIscsiTargetInfo(SJmoPortLunDetail luPathInfo, Map<Class<?>, List<?>> modelData) {
        int searchPort;
        SJmoIscsiTargetInfo iscsiTgInfo = null;
        List<?> iscsiTargetInfoList = modelData.get(SJmoGetPortIscsiTargetInfo.class);
        if (iscsiTargetInfoList != null && (searchPort = Collections.binarySearch(iscsiTargetInfoList, luPathInfo)) >= 0) {
            SJmoPortIscsiTargetInfo iscsiTargetInfo = (SJmoPortIscsiTargetInfo)iscsiTargetInfoList.get(searchPort);
            ArrayList<SJmoIscsiTargetInfo> iscsiTargetList = iscsiTargetInfo.getAlPortIscsiTarget();
            this.searchHgInfo.setSHostGroup(luPathInfo.getSHostGroup());
            int searchId = Collections.binarySearch(iscsiTargetList, this.searchHgInfo, this.HGID_COMP);
            if (searchId >= 0) {
                iscsiTgInfo = iscsiTargetList.get(searchId);
            }
        }
        return iscsiTgInfo;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String ret = "";
        if (!dataList.isEmpty()) {
            SJmoPortDetail portDtl = (SJmoPortDetail)dataList.get(0);
            if (portDtl == null) {
                ret = "?";
            } else if (SJctrPortUtility.isIscsiPort(portDtl)) {
                SJmoIscsiTargetInfo itInfo;
                String itname = "?";
                if (dataList.size() >= 2 && (itInfo = (SJmoIscsiTargetInfo)dataList.get(1)) != null) {
                    itname = itInfo.getStrIscsiTargetName();
                }
                ret = itname;
            } else {
                ret = SJctrPortUtility.STR_HYPHEN;
            }
        }
        return ret;
    }
}

