/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.local.createtipairs.column;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.wizard.replication.local.createtipairs.SJctrSnapshotGroupInfoMgr;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetSnapshotSetInfoMgr;
import sanproject.sn2.model.data.replication.local.SJmoSnapshotSetIndex;
import sanproject.sn2.model.data.replication.local.SJmoSnapshotSetInfo;

public class SJctrPairNumColumnFromSnapshotSetInfo
extends SJctrColumn {
    private Map<SJmoSnapshotSetIndex, Integer> pairNumMap = Collections.emptyMap();

    public SJctrPairNumColumnFromSnapshotSetInfo(String key) {
        super(key);
        this.setPartsId("NUM_OF_PAIRS");
    }

    @Override
    public int getSortType() {
        return 1;
    }

    @Override
    public int getFilterType() {
        return 0;
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetSnapshotSetInfoMgr.class);
        return list;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        List<?> retList = super.getNeedModelData(index, modelData);
        List<?> ssgrpMgrList = modelData.get(SJctrSnapshotGroupInfoMgr.class);
        if (ssgrpMgrList != null && !ssgrpMgrList.isEmpty()) {
            retList.add(ssgrpMgrList.get(0));
        }
        return retList;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String ret = "?";
        if (dataList.size() >= 2) {
            if (this.pairNumMap.isEmpty()) {
                this.pairNumMap = new HashMap<SJmoSnapshotSetIndex, Integer>(4096);
            }
            SJmoSnapshotSetInfo ssGrpInfo = (SJmoSnapshotSetInfo)dataList.get(0);
            SJctrSnapshotGroupInfoMgr ssGrpMgr = (SJctrSnapshotGroupInfoMgr)dataList.get(1);
            int pairNum = ssGrpMgr.getSnapshotDataNum(ssGrpInfo.getIndex());
            this.pairNumMap.put(ssGrpInfo, pairNum);
            ret = SJctrComUtility.toDecString(pairNum);
        }
        return ret;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        int num = -1;
        SJmoSnapshotSetInfo ssGrpInfo = (SJmoSnapshotSetInfo)this.getPrimaryKeyObject(dat);
        Integer pairNum = this.pairNumMap.get(ssGrpInfo);
        if (pairNum != null) {
            num = pairNum;
        }
        return num;
    }
}

