/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.local.createtipairs.selectsvol;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrSelObjCmbDataModel
extends SJctrComboBoxDataModel {
    private HashMap<String, Object> ITEM_FIBRE = null;
    private HashMap<String, Object> ITEM_ISCSI = null;
    private HashMap<String, Object> ITEM_NAS = null;
    private Map<Long, TreeSet<HashMap<String, Object>>> dispItemMap = Collections.emptyMap();
    private itemComparator itemCmp = null;
    private SJctrItemSelectListener itemSelectListener = null;

    @Override
    public void initGuidance(SJctrComUtility util) {
        this.ITEM_FIBRE = this.createItem("COM_FIBRE", util.getGuidance("FIBRE"));
        this.ITEM_ISCSI = this.createItem("COM_ISCSI", util.getGuidance("ISCSI"));
        this.ITEM_NAS = this.createItem("COM_HNAS_USER", util.getGuidance("HNAS_USER_LU"));
        this.itemCmp = new itemComparator();
        super.initGuidance(util);
    }

    public void initListener() {
        if (this.itemSelectListener != null) {
            return;
        }
        this.itemSelectListener = new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrSelObjCmbDataModel.this.fireMessageEvent(CHGSELOBJ_MSG.CHG_SELOBJ);
                }
            }
        };
        this.addItemSelectListener(this.itemSelectListener);
    }

    public void initSelObjCmb(List<SJmoPortDetail> portDtlList, List<SJmoPortLunDetail> availableList, Map<Integer, Long> ldevCapMap, long selectCap) {
        this.initItemSet(portDtlList, availableList, ldevCapMap);
        this.refSelObjCmb(selectCap);
    }

    private void initItemSet(List<SJmoPortDetail> portDtlList, List<SJmoPortLunDetail> availableList, Map<Integer, Long> ldevCapMap) {
        SJmoLdevIndex searchLdev = new SJmoLdevIndex();
        this.dispItemMap = new HashMap<Long, TreeSet<HashMap<String, Object>>>(availableList.size());
        TreeSet<HashMap<String, Object>> allItemSet = new TreeSet<HashMap<String, Object>>(this.itemCmp);
        for (SJmoPortLunDetail luPath : availableList) {
            int index;
            int ldevKey = SJctrReplicationUtility.getLdevIndexKey(luPath);
            Long ldevCap = ldevCapMap.get(ldevKey);
            if (ldevCap == null) continue;
            TreeSet<HashMap<String, Object>> itemSet = this.dispItemMap.get((long)ldevCap);
            if (itemSet == null) {
                itemSet = new TreeSet<HashMap<String, Object>>(this.itemCmp);
                this.dispItemMap.put((long)ldevCap, itemSet);
            }
            if ((index = Collections.binarySearch(portDtlList, luPath)) < 0) continue;
            SJmoPortDetail portDtl = portDtlList.get(index);
            if (SJctrPortUtility.isFibrePort(portDtl) || SJctrPortUtility.isFcoePort(portDtl)) {
                itemSet.add(this.ITEM_FIBRE);
                allItemSet.add(this.ITEM_FIBRE);
            }
            if (SJctrPortUtility.isIscsiPort(portDtl)) {
                itemSet.add(this.ITEM_ISCSI);
                allItemSet.add(this.ITEM_ISCSI);
            }
            if (portDtl.getByPortKindNo() != 7) continue;
            itemSet.add(this.ITEM_NAS);
            allItemSet.add(this.ITEM_NAS);
        }
        this.dispItemMap.put(-1L, allItemSet);
    }

    public void refSelObjCmb(long selectCap) {
        this.clearSelection();
        this.removeAllItems();
        TreeSet<HashMap<String, Object>> itemSet = this.dispItemMap.get(selectCap);
        if (itemSet != null && !itemSet.isEmpty()) {
            for (HashMap<String, Object> item : itemSet) {
                this.addItem(item);
            }
            this.setSelectedIndex(0);
        }
    }

    public static enum CHGSELOBJ_MSG implements SJctrNotifyState
    {
        CHG_SELOBJ;

    }

    private class itemComparator
    implements Comparator<HashMap<String, Object>> {
        private Map<Object, Integer> sortTbl = new HashMap<Object, Integer>();

        public itemComparator() {
            this.sortTbl.put("COM_FIBRE", 0);
            this.sortTbl.put("COM_ISCSI", 1);
            this.sortTbl.put("COM_HNAS_USER", 2);
        }

        @Override
        public int compare(HashMap<String, Object> item0, HashMap<String, Object> item1) {
            int ret = 0;
            String name0 = (String)item0.get("name");
            String name1 = (String)item1.get("name");
            if (name0 != null && name1 != null) {
                ret = this.sortTbl.get(name0) - this.sortTbl.get(name1);
            }
            return ret;
        }
    }
}

