/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.local.ctgproperties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrTiReplicationUtility;
import sanproject.sn2.controller.com.comparator.SJctrLocalPairInfoComparator;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.replication.com.SJctrCTGInfo;
import sanproject.sn2.controller.wizard.replication.local.ctgproperties.SJctrCTGPropertiesSummaryModel;
import sanproject.sn2.controller.wizard.replication.local.ctgproperties.SJctrCTGPropertiesTableModel;
import sanproject.sn2.controller.wizard.replication.local.viewpairproperties.SJctrViewPairPropertiesDC;
import sanproject.sn2.controller.wizard.replication.local.viewpairproperties.SJctrViewTIPairPropertiesDC;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLocalReplicationPairVolInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetSnapshotSetInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetTiPvolStatus;
import sanproject.sn2.model.connector.kind.SJmoGetTiSnapshotPairList;
import sanproject.sn2.model.data.replication.local.SJmoLocalReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.local.SJmoTiPvolInfo;
import sanproject.sn2.model.data.replication.local.SJmoTiPvolMu;
import sanproject.sn2.model.data.replication.local.SJmoTiPvolStatus;
import sanproject.sn2.model.data.replication.local.SJmoTiSnapshotPairList;
import sanproject.sn2.model.data.replication.local.manager.SJmoLocalReplicationPairVolInfoMgr;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrCTGPropertiesDC
extends SJctrDialogDataController {
    private static final int DISP_ID = 34664497;
    private static final String KEY_SUMMARY = "COM_SUMMARY";
    private static final String KEY_TABLE = "COM_TABLE";
    private static final String KEY_TABLE_SELECTED_CTG = "KEY_SELECTED_CTG";
    private static final String KEY_SELECTED_SVOL = "KEY_SELECTED_SVOL";
    private static final String KEY_DETAIL = "COM_DETAIL";

    public SJctrCTGPropertiesDC() throws SJcException {
        super(34664497);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> infoList = this.getProxy().getCache(KEY_TABLE_SELECTED_CTG);
        if (null == infoList) {
            this.logUty.putlog("checkStartData", "Information of data list is null.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == infoList.size()) {
            this.logUty.putlog("checkStartData", "Size of data list is zero.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrCTGInfo selectedInfo = (SJctrCTGInfo)infoList.get(0);
        if (null == selectedInfo) {
            this.logUty.putlog("checkStartData", "Information of selected data is null.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        try {
            SJmoLocalReplicationPairVolInfoMgr allPairInfo = SJctrReplicationUtility.getSJmoLocalReplicationPairVolInfoMgr(this);
            List<SJmoLocalReplicationPairVolInfo> pairVolInfoArray = Arrays.asList(allPairInfo.getLocalReplicationPairVolInfoList());
            List<SJmoLdevDetail> ldevlist = SJctrReplicationUtility.getSJmoLdevDetail(this);
            List<?> infoList = this.getProxy().getCache(KEY_TABLE_SELECTED_CTG);
            SJctrCTGInfo selectedInfo = (SJctrCTGInfo)infoList.get(0);
            List<SJmoRSGgetAllRsgs> allRsgs = SJctrReplicationUtility.getSJmoRSGgetAllRsgs(this);
            SJctrResourceGroupUtility rsgUty = new SJctrResourceGroupUtility(this.getOwner(), allRsgs.get(0));
            SJmoTiSnapshotPairList ssPairList = (SJmoTiSnapshotPairList)this.getProxy().getCache(SJmoGetTiSnapshotPairList.class).get(0);
            SJmoTiPvolStatus tiPvolStatus = (SJmoTiPvolStatus)this.getProxy().getCache(SJmoGetTiPvolStatus.class).get(0);
            SJmoTiPvolInfo[] pvolInfoList = tiPvolStatus.getTiPvolInfo();
            List<SJmoLocalReplicationPairVolInfo> selPairInfo = this.selectedPairVolInfoWithCtgIdExcludingTI(pairVolInfoArray, selectedInfo);
            if (selectedInfo.isCtgStatus((short)228)) {
                ArrayList generatedTiPairVolInfoList = (ArrayList)SJctrTiReplicationUtility.generatetLocalReplicationPairVolInfoListFromCtgId(selectedInfo.getICtgId(), ssPairList, pvolInfoList);
                if (selectedInfo.getINumberOfPairs() != generatedTiPairVolInfoList.size()) {
                    SJctrError err = new SJctrError(209, 22, 106534);
                    SJcException exp = err.createException();
                    throw exp;
                }
                selPairInfo.addAll(generatedTiPairVolInfoList);
            }
            SJmoLocalReplicationPairVolInfoMgr ctgPairInfo = new SJmoLocalReplicationPairVolInfoMgr(selPairInfo.toArray(new SJmoLocalReplicationPairVolInfo[0]));
            List<SJmoLocalReplicationPairVolInfo> maskedPairList = SJctrReplicationUtility.getLocalPairVolViewList(ctgPairInfo, rsgUty, ldevlist);
            SJctrCTGPropertiesTableModel ctgPropTable = (SJctrCTGPropertiesTableModel)this.getDataObjectModel(KEY_TABLE);
            Collections.sort(maskedPairList, new SJctrLocalPairInfoComparator());
            ctgPropTable.setBasicDataList(maskedPairList);
            this.setSummaryData(selectedInfo, selectedInfo.getINumberOfPairs());
            return true;
        }
        catch (SJcException e) {
            throw SJctrReplicationUtility.convLReplicaLogicalErr(e, 107002);
        }
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_SUMMARY, new SJctrCTGPropertiesSummaryModel());
        SJctrCTGPropertiesTableModel ctgPropTable = new SJctrCTGPropertiesTableModel();
        ctgPropTable.setPaging(true);
        this.addDataObjectModel(KEY_TABLE, ctgPropTable);
        SJctrButtonDataModel detailButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_DETAIL, detailButton);
        detailButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrCTGPropertiesDC.this.fireMessageEvent(CTGP_MSG.SELECT_DETAIL);
            }
        });
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(SJctrFooterDataModel.BGO_CLOSE));
    }

    private void initListener() {
        this.addMessageEventListener(CTGP_MSG.SELECT_DETAIL, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCTGPropertiesDC.this.makeDetailAction(event, dstModel);
            }
        });
    }

    private void makeDetailAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrCTGPropertiesTableModel table = (SJctrCTGPropertiesTableModel)this.getDataObjectModel(KEY_TABLE);
        List<Object> selectedRowList = table.getSelectedRowData();
        if (selectedRowList.size() == 0) {
            this.getLogUty().putlog("makeDetailAction", "not selected");
            return;
        }
        ArrayList<SJmoLocalReplicationPairVolInfo> selectedList = new ArrayList<SJmoLocalReplicationPairVolInfo>();
        for (Object rowObj : selectedRowList) {
            selectedList.add((SJmoLocalReplicationPairVolInfo)rowObj);
        }
        SJctrRelatedDispDataObject wizardRelated = null;
        SJmoLocalReplicationPairVolInfo pair = (SJmoLocalReplicationPairVolInfo)selectedList.get(0);
        if (pair.isVolPos(0x400000) || pair.isVolPos(0x800000)) {
            HashMap param = new HashMap();
            ArrayList<SJmoTiPvolMu> pvolMuList = new ArrayList<SJmoTiPvolMu>();
            for (SJmoLocalReplicationPairVolInfo pairInfo : selectedList) {
                SJmoLdevIndex pvolIndex = pairInfo.getPVolIndex();
                short ldkc = pvolIndex.getSLdkc();
                short cu = pvolIndex.getSCu();
                short ldev = pvolIndex.getSLdev();
                short mu = pairInfo.getSMuNum();
                SJmoTiPvolMu pvolMu = SJctrTiReplicationUtility.createTiPVolMuInfo(ldkc, cu, ldev, mu);
                pvolMuList.add(pvolMu);
            }
            param.put("KEY_SELECTED_PVOL_MU", pvolMuList);
            wizardRelated = this.createDialog(SJctrViewTIPairPropertiesDC.class, param);
        } else {
            HashMap param = new HashMap();
            param.put(KEY_SELECTED_SVOL, selectedList);
            wizardRelated = this.createDialog(SJctrViewPairPropertiesDC.class, param);
        }
        this.addUpdateDisp(wizardRelated);
    }

    private void setSummaryData(SJctrCTGInfo selectedInfo, int numofpairs) {
        SJctrCTGPropertiesSummaryModel summary = (SJctrCTGPropertiesSummaryModel)this.getDataObjectModel(KEY_SUMMARY);
        summary.setCTGID(selectedInfo.getICtgId(), this);
        summary.setStatus(this.getOwner().getComUtility().getReplicationUtility().getCtgStatusString(selectedInfo.getCtgInfo()));
        summary.setNumberOfPairs(numofpairs);
    }

    private List<SJmoLocalReplicationPairVolInfo> selectedPairVolInfoWithCtgIdExcludingTI(List<SJmoLocalReplicationPairVolInfo> pairInfoList, SJctrCTGInfo summaryInfo) {
        int sctgId = summaryInfo.getICtgId();
        ArrayList<SJmoLocalReplicationPairVolInfo> infoList = new ArrayList<SJmoLocalReplicationPairVolInfo>();
        if (pairInfoList == null || pairInfoList.size() == 0) {
            return infoList;
        }
        for (SJmoLocalReplicationPairVolInfo pairInfo : pairInfoList) {
            if (pairInfo == null || pairInfo.isVolPos(0x800000) || pairInfo.getSCtgId() != sctgId) continue;
            infoList.add(pairInfo);
        }
        return infoList;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetLocalReplicationPairVolInfoMgr();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetSnapshotSetInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetTiPvolStatus();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetTiSnapshotPairList();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    public static enum CTGP_MSG implements SJctrNotifyState
    {
        SELECT_DETAIL;

    }
}

