/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.local.resyncpairs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrTiReplicationUtility;
import sanproject.sn2.controller.com.comparator.SJctrLocalPairErrorColumnDataComparator;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.wizard.SJctrConfirmDataController;
import sanproject.sn2.controller.wizard.replication.com.SJctrLReplicaOperationError;
import sanproject.sn2.controller.wizard.replication.local.resyncpairs.SJctrResyncPairsConfirmData;
import sanproject.sn2.controller.wizard.replication.local.resyncpairs.SJctrResyncPairsConfirmErrorTableModel;
import sanproject.sn2.controller.wizard.replication.local.resyncpairs.SJctrResyncPairsConfirmTableModel;
import sanproject.sn2.model.connector.kind.SJmoGetClprInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevLuseInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLocalReplicationPairVolInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetPoolDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPoolNameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetSnapshotSetInfoMgr;
import sanproject.sn2.model.data.replication.local.SJmoLocalReplicationPairVolInfo;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrResyncPairsConfirmDC
extends SJctrConfirmDataController {
    private static final int DISP_ID = 17830703;
    private static final String KEY_TABLE = "COM_TABLE";

    public SJctrResyncPairsConfirmDC() throws SJcException {
        super(17830703);
        this.initDataModel();
    }

    private void initDataModel() {
        SJctrResyncPairsConfirmTableModel confirmTable = new SJctrResyncPairsConfirmTableModel();
        confirmTable.setPaging(false);
        this.addDataObjectModel(KEY_TABLE, confirmTable);
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        SJctrResyncPairsConfirmData confirmData = null;
        List<?> confirmDataList = this.getCache(SJctrResyncPairsConfirmData.class);
        if (null == confirmDataList) {
            this.logUty.putlog("checkStartData", "Confirmation data list is null.");
            SJctrError err = new SJctrError(209, 22, 107005);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == confirmDataList.size()) {
            this.logUty.putlog("checkStartData", "Size of confirmation data list is zero.");
            SJctrError err = new SJctrError(209, 22, 107005);
            SJcException exp = err.createException();
            throw exp;
        }
        confirmData = (SJctrResyncPairsConfirmData)confirmDataList.get(0);
        if (null == confirmData) {
            this.logUty.putlog("checkStartData", "Confirmation data is null.");
            SJctrError err = new SJctrError(209, 22, 107005);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    @Override
    protected void makeDataObjectModel(Collection<String> keyList) throws SJcException {
        List<?> confirmDataList = this.getCache(SJctrResyncPairsConfirmData.class);
        SJctrResyncPairsConfirmData confirmData = (SJctrResyncPairsConfirmData)confirmDataList.get(0);
        this.getProxy().getCacheMap().putAll(confirmData.getNeedDataMap());
        super.makeDataObjectModel(keyList);
    }

    @Override
    public boolean checkConstructData() {
        SJctrTableDataModel confirmTable = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE);
        if (confirmTable instanceof SJctrResyncPairsConfirmTableModel) {
            SJctrResyncPairsConfirmData confirmData = (SJctrResyncPairsConfirmData)this.getProxy().getCache(SJctrResyncPairsConfirmData.class).get(0);
            ((SJctrResyncPairsConfirmTableModel)confirmTable).setBasicDataList(confirmData.getPairsInfo());
            ((SJctrResyncPairsConfirmTableModel)confirmTable).setResynctype(confirmData.getResynctype());
            ((SJctrResyncPairsConfirmTableModel)confirmTable).setCopytype(confirmData.getCopytype());
        }
        return true;
    }

    @Override
    public Map<String, List<?>> getConfirmData() {
        HashMap retMap = new HashMap();
        List<?> confirmDataList = this.getCache(SJctrResyncPairsConfirmData.class);
        retMap.put(SJctrResyncPairsConfirmData.class.getName(), confirmDataList);
        return retMap;
    }

    @Override
    public void getConfirmWithStatus(List<Object> result) throws SJcException {
        SJctrResyncPairsConfirmData confirmData = (SJctrResyncPairsConfirmData)this.getProxy().getCache(SJctrResyncPairsConfirmData.class).get(0);
        SJctrResyncPairsConfirmTableModel confirmTable = (SJctrResyncPairsConfirmTableModel)this.getDataObjectModel(KEY_TABLE);
        confirmTable.setBasicDataList(confirmData.getPairsInfo());
        confirmTable.setResynctype(confirmData.getResynctype());
        confirmTable.setCopytype(confirmData.getCopytype());
        confirmTable.setBasicData(SJmoGetLocalReplicationPairVolInfoMgr.class, confirmData.getNeedDataMap().get(SJmoGetLocalReplicationPairVolInfoMgr.class.getName()));
        confirmTable.setBasicData(SJmoGetLdevDetail.class, confirmData.getNeedDataMap().get(SJmoGetLdevDetail.class.getName()));
        confirmTable.setBasicData(SJmoGetLdevNicknameInfo.class, confirmData.getNeedDataMap().get(SJmoGetLdevNicknameInfo.class.getName()));
        confirmTable.setBasicData(SJmoGetPoolNameInfo.class, confirmData.getNeedDataMap().get(SJmoGetPoolNameInfo.class.getName()));
        confirmTable.setBasicData(SJmoGetClprInfo.class, confirmData.getNeedDataMap().get(SJmoGetClprInfo.class.getName()));
        confirmTable.setBasicData(SJmoGetLdevLuseInfo.class, confirmData.getNeedDataMap().get(SJmoGetLdevLuseInfo.class.getName()));
        confirmTable.setBasicData(SJmoGetPoolDetail.class, confirmData.getNeedDataMap().get(SJmoGetPoolDetail.class.getName()));
        confirmTable.setBasicData(SJmoGetSnapshotSetInfoMgr.class, confirmData.getNeedDataMap().get(SJmoGetSnapshotSetInfoMgr.class.getName()));
        confirmTable.makeDataModel();
        List tempList = (List)result.get(0);
        List errorList = (List)tempList.get(0);
        ArrayList<SJctrErrorColumnData> errColumnList = new ArrayList<SJctrErrorColumnData>(errorList.size());
        List<SJmoLocalReplicationPairVolInfo> rowDataList = confirmData.getPairsInfo();
        Collections.sort(rowDataList);
        for (SJctrLReplicaOperationError error : errorList) {
            int index;
            short muNum;
            SJmoLdevIndex pvolIndex = error.getPvolIndex();
            SJmoLocalReplicationPairVolInfo pairInfo = SJctrTiReplicationUtility.searchLocalReplicationPairVolInfo(rowDataList, pvolIndex, muNum = error.getMuNum());
            if (pairInfo == null && 0 <= (index = Collections.binarySearch(rowDataList, error.getSvolIndex()))) {
                pairInfo = rowDataList.get(index);
            }
            if (pairInfo == null) continue;
            SJctrErrorColumnData errColumn = new SJctrErrorColumnData(pairInfo, error);
            errColumnList.add(errColumn);
        }
        SJctrResyncPairsConfirmErrorTableModel errTable = new SJctrResyncPairsConfirmErrorTableModel();
        errTable.setResynctype(confirmData.getResynctype());
        errTable.setCopytype(confirmData.getCopytype());
        this.addDataObjectModel(KEY_TABLE, errTable);
        errTable.initialize(confirmTable, errColumnList, new SJctrLocalPairErrorColumnDataComparator());
    }
}

