/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.local.viewpairsyncrate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sanproject.serverux.dataimpl.MRCFgetPairRateDetail;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.comparator.SJctrLocalPairInfoComparator;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.replication.com.SJctrViewPairSyncrateInfoMsgFlagData;
import sanproject.sn2.controller.wizard.replication.local.viewpairsyncrate.SJctrViewPairSyncRateInfo;
import sanproject.sn2.controller.wizard.replication.local.viewpairsyncrate.SJctrViewPairSyncRateTableModel;
import sanproject.sn2.controller.wizard.replication.local.viewpairsyncrate.SJctrViewSsPairSyncRateTableModel;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetClprInfo;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualDkc;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualLdev;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLocalReplicationPairVolInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetPoolDetail;
import sanproject.sn2.model.connector.kind.SJmoGetSnapshotSetInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetTiPvolStatus;
import sanproject.sn2.model.connector.kind.SJmoGetTiSnapshotPairList;
import sanproject.sn2.model.data.replication.local.SJmoLocalReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.local.SJmoTiPvolStatus;
import sanproject.sn2.model.data.replication.local.SJmoTiSnapshotPairList;
import sanproject.sn2.model.data.replication.local.manager.SJmoLocalReplicationPairVolInfoMgr;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrViewPairSyncRateDialogDC
extends SJctrDialogDataController {
    private static final int DISP_ID = 34664501;
    private static final String KEY_TABLE = "COM_TABLE";
    private static final String KEY_SSTABLE = "COM_SSTABLE";
    private static final String KEY_REFRESH = "COM_REFRESH";
    private static final String KEY_VIEWMSG = "COM_VIEWMSG";
    private boolean visibleSiSimfPairFlag = false;
    private boolean visibleTiPairFlag = false;
    private static final String KEY_SET_TABLE = "COM_SET_TABLE";
    private static final String KEY_SET_SITABLE = "COM_SET_SITABLE";
    private static final String KEY_SET_SSTABLE = "COM_SET_SSTABLE";

    public SJctrViewPairSyncRateDialogDC() {
        super(34664501);
        this.initDataModel();
        this.initListner();
    }

    private void initDataModel() {
        SJctrViewPairSyncRateTableModel viewPairSyncRateTableModel = new SJctrViewPairSyncRateTableModel();
        this.addDataObjectModel(KEY_TABLE, viewPairSyncRateTableModel);
        SJctrViewSsPairSyncRateTableModel viewPairSyncRateSsTableModel = new SJctrViewSsPairSyncRateTableModel();
        this.addDataObjectModel(KEY_SSTABLE, viewPairSyncRateSsTableModel);
        SJctrButtonDataModel refreshButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_REFRESH, refreshButton);
        refreshButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrViewPairSyncRateDialogDC.this.fireMessageEvent(SYNC_RATE_MSG.SELECT_REFRESH);
            }
        });
        this.addDataObjectModel(KEY_VIEWMSG, new SJctrViewPairSyncrateInfoMsgFlagData());
        this.addDataObjectModel(KEY_SET_TABLE, new SJctrSimpleDataModel());
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(SJctrFooterDataModel.BGO_CLOSE));
    }

    private void initListner() {
        this.addMessageEventListener(SYNC_RATE_MSG.SELECT_REFRESH, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrViewPairSyncRateDialogDC.this.refreshTableAction(event, dstModel);
            }
        });
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> inheritedList = this.getProxy().getCache("KEY_SELECTED_SVOL");
        if (null == inheritedList) {
            this.logUty.putlog("checkStartData", "Inherited list data is null.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == inheritedList.size()) {
            this.logUty.putlog("checkStartData", "Size of inherited list data is zero.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        boolean ret = true;
        try {
            List<SJmoLocalReplicationPairVolInfo> inheritedList = this.getProxy().getCache("KEY_SELECTED_SVOL");
            List<SJmoLocalReplicationPairVolInfoMgr> allPairInfoMgrList = this.getSJmoLocalReplicationPairVolInfoMgrNotUsedCache();
            SJctrViewPairSyncrateInfoMsgFlagData informationFlagModel = (SJctrViewPairSyncrateInfoMsgFlagData)this.getDataObjectModel(KEY_VIEWMSG);
            if (informationFlagModel == null) {
                this.logUty.putlog("checkConstructData", "informationFlagModel is null.");
                SJctrError err = new SJctrError(209, 22, 107002);
                SJcException exp = err.createException();
                throw exp;
            }
            List<SJmoLocalReplicationPairVolInfo> pairList = this.checkModelData(inheritedList, allPairInfoMgrList.get(0));
            List<SJctrViewPairSyncRateInfo> rmiDataList = this.getPairSyncRate(pairList);
            if (0 == (pairList = this.checkAndGetDispPairList(pairList, rmiDataList)).size()) {
                this.logUty.putlog("checkConstructData", "Size of local replication pair list is zero.");
                SJctrError err = new SJctrError(209, 22, 106534);
                SJcException exp = err.createException();
                throw exp;
            }
            if (pairList.size() < inheritedList.size()) {
                informationFlagModel.setInformationFlag(1);
            } else {
                informationFlagModel.setInformationFlag(0);
            }
            SJctrViewPairSyncRateTableModel pairTable = this.createTblAndSetVisibleFlag(pairList);
            pairTable.setBasicDataList(pairList);
            Collections.sort(pairList, new SJctrLocalPairInfoComparator());
            pairTable.setRmiData(rmiDataList);
            pairTable.setInfoLdev(this.getSpecifiedModelInfoNotUsedCache(new SJmoGetLdevDetail()));
            pairTable.setInfoLdevNickname(this.getSpecifiedModelInfoNotUsedCache(new SJmoGetLdevNicknameInfo()));
            pairTable.setInfoClpr(this.getSpecifiedModelInfoNotUsedCache(new SJmoGetClprInfo()));
            pairTable.setInfoPool(this.getSpecifiedModelInfoNotUsedCache(new SJmoGetPoolDetail()));
            pairTable.setInfoSnapshotSet(this.getSpecifiedModelInfoNotUsedCache(new SJmoGetSnapshotSetInfoMgr()));
            pairTable.setInfoVirtualLdev(this.getSpecifiedModelInfoNotUsedCache(new SJmoGetHUVMVirtualLdev()));
            pairTable.setInfoVirtualDkc(this.getSpecifiedModelInfoNotUsedCache(new SJmoGetHUVMVirtualDkc()));
            pairTable.setAllPairInfoMgr(allPairInfoMgrList);
        }
        catch (SJcException exp) {
            throw SJctrReplicationUtility.convLReplicaLogicalErr(exp, 107002);
        }
        return ret;
    }

    public List<SJmoLocalReplicationPairVolInfo> checkModelData(List<SJmoLocalReplicationPairVolInfo> inheritedList, SJmoLocalReplicationPairVolInfoMgr manager) {
        return SJctrReplicationUtility.checkAndGetExistPairVolInfo(inheritedList, manager);
    }

    public List<SJctrViewPairSyncRateInfo> getPairSyncRate(List<SJmoLocalReplicationPairVolInfo> pairList) {
        MRCFgetPairRateDetail[] syncRateDetail = SJctrReplicationUtility.getPairSynchRateInfo(this, pairList);
        List<SJctrViewPairSyncRateInfo> rmiDataList = this.makeDataList(syncRateDetail);
        return rmiDataList;
    }

    protected List<SJctrViewPairSyncRateInfo> makeDataList(MRCFgetPairRateDetail[] pairDetail) {
        if (null == pairDetail) {
            this.logUty.putlog("makeDataList", "Parameter is null.");
            SJctrError err = new SJctrError(209, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == pairDetail.length) {
            this.logUty.putlog("makeDataList", "Size of parameter is zero.");
            SJctrError err = new SJctrError(209, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        ArrayList<SJctrViewPairSyncRateInfo> rtnList = new ArrayList<SJctrViewPairSyncRateInfo>();
        for (int i = 0; i < pairDetail.length; ++i) {
            if (null == pairDetail[i]) continue;
            SJctrViewPairSyncRateInfo syncrate = new SJctrViewPairSyncRateInfo();
            SJmoLdevIndex pvolIndex = new SJmoLdevIndex();
            short pLdkc = pairDetail[i].getPVolIndex().getSLDKC();
            short pCu = pairDetail[i].getPVolIndex().getSCU();
            short pLdev = pairDetail[i].getPVolIndex().getSLDEV();
            pvolIndex.setLdevIndex(pLdkc, pCu, pLdev);
            syncrate.setPvolIndex(pvolIndex);
            syncrate.setMuNum(pairDetail[i].getMuNum());
            short sLdkc = pairDetail[i].getSVolIndex().getSLDKC();
            short sCu = pairDetail[i].getSVolIndex().getSCU();
            short sLdev = pairDetail[i].getSVolIndex().getSLDEV();
            syncrate.setLdevIndex(sLdkc, sCu, sLdev);
            if (-1 == pairDetail[i].getPairRate() || -1 == pairDetail[i].getPairStatus()) {
                this.logUty.putlog("makeDataList", "pairDetail[" + i + "] is invalid data.");
                continue;
            }
            syncrate.setPairstatus(pairDetail[i].getPairStatus());
            syncrate.setPairrate(pairDetail[i].getPairRate());
            syncrate.setPairCopyPace(pairDetail[i].getCopyPace());
            rtnList.add(syncrate);
        }
        return rtnList;
    }

    public void refreshTableAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        try {
            List<Object> basicDataList = null;
            SJctrViewPairSyncRateTableModel pairTable = null;
            if (this.visibleSiSimfPairFlag) {
                pairTable = (SJctrViewPairSyncRateTableModel)this.getDataObjectModel(KEY_TABLE);
                basicDataList = pairTable.getAllRowData();
            } else if (this.visibleTiPairFlag) {
                pairTable = (SJctrViewSsPairSyncRateTableModel)this.getDataObjectModel(KEY_SSTABLE);
                basicDataList = pairTable.getAllRowData();
            }
            List<SJmoLocalReplicationPairVolInfoMgr> allPairInfoMgrList = this.getSJmoLocalReplicationPairVolInfoMgrNotUsedCache();
            List<SJmoTiSnapshotPairList> allTiPairInfoMgrList = this.getSJmoTiSnapshotPairListMgrNotUsedCache();
            List<SJmoTiPvolStatus> allTiPvolInfoMgrList = this.getSJmoTiPvolStatusMgrNotUsedCache();
            SJctrViewPairSyncrateInfoMsgFlagData informationFlagModel = (SJctrViewPairSyncrateInfoMsgFlagData)this.getDataObjectModel(KEY_VIEWMSG);
            if (informationFlagModel == null) {
                this.logUty.putlog("refreshTableAction", "informationFlagModel is null.");
                SJctrError err = new SJctrError(209, 22, 107002);
                SJcException exp = err.createException();
                throw exp;
            }
            List<SJmoLocalReplicationPairVolInfo> pairList = SJctrReplicationUtility.checkAndGetAllExistPairVolInfo(basicDataList, allPairInfoMgrList.get(0), allTiPairInfoMgrList.get(0), allTiPvolInfoMgrList.get(0));
            List<SJctrViewPairSyncRateInfo> rmiDataList = this.getPairSyncRate(pairList);
            if (0 == (pairList = this.checkAndGetDispPairList(pairList, rmiDataList)).size()) {
                this.logUty.putlog("refreshTableAction", "Size of local replication pair list is zero.");
                SJctrError err = new SJctrError(209, 22, 106534);
                SJcException exp = err.createException();
                throw exp;
            }
            if (pairList.size() < basicDataList.size()) {
                informationFlagModel.setInformationFlag(1);
            } else {
                informationFlagModel.setInformationFlag(0);
            }
            this.setVisibleTblFlag(pairList);
            pairTable.setBasicDataList(pairList);
            Collections.sort(pairList, new SJctrLocalPairInfoComparator());
            pairTable.setRmiData(rmiDataList);
            pairTable.setAllPairInfoMgr(allPairInfoMgrList);
            pairTable.setInfoLdev(this.getSpecifiedModelInfoNotUsedCache(new SJmoGetLdevDetail()));
            pairTable.setInfoLdevNickname(this.getSpecifiedModelInfoNotUsedCache(new SJmoGetLdevNicknameInfo()));
            pairTable.setInfoClpr(this.getSpecifiedModelInfoNotUsedCache(new SJmoGetClprInfo()));
            pairTable.setInfoPool(this.getSpecifiedModelInfoNotUsedCache(new SJmoGetPoolDetail()));
            pairTable.setInfoSnapshotSet(this.getSpecifiedModelInfoNotUsedCache(new SJmoGetSnapshotSetInfoMgr()));
            pairTable.setInfoVirtualLdev(this.getSpecifiedModelInfoNotUsedCache(new SJmoGetHUVMVirtualLdev()));
            pairTable.setInfoVirtualDkc(this.getSpecifiedModelInfoNotUsedCache(new SJmoGetHUVMVirtualDkc()));
            List<Object> selectedRowList = pairTable.getSelectedRowData();
            pairTable.doRefresh();
            informationFlagModel.setDirty();
            pairTable.addRowSelectionList(selectedRowList);
        }
        catch (SJcException exp) {
            throw SJctrReplicationUtility.convLReplicaLogicalErr(exp, 107002);
        }
    }

    private List<SJmoLocalReplicationPairVolInfoMgr> getSJmoLocalReplicationPairVolInfoMgrNotUsedCache() {
        List<Object> retInfoList = SJctrReplicationUtility.getModelInfoNotUsedCache(this, new SJmoGetLocalReplicationPairVolInfoMgr());
        if (null == retInfoList) {
            this.logUty.putlog("getSJmoLocalReplicationPairVolInfoMgrNotUsedCache", "Information of Local Replication pair List is null.");
            SJctrError err = new SJctrError(209, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == retInfoList.size()) {
            this.logUty.putlog("getSJmoLocalReplicationPairVolInfoMgrNotUsedCache", "Size of Local Replication pair List is zero.");
            SJctrError err = new SJctrError(209, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoLocalReplicationPairVolInfoMgr retInfo = (SJmoLocalReplicationPairVolInfoMgr)retInfoList.get(0);
        if (null == retInfo) {
            this.logUty.putlog("getSJmoLocalReplicationPairVolInfoMgrNotUsedCache", "Information of Local Replication pairs is null.");
            SJctrError err = new SJctrError(209, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        return retInfoList;
    }

    protected List<SJmoTiSnapshotPairList> getSJmoTiSnapshotPairListMgrNotUsedCache() {
        List<Object> retInfoList = SJctrReplicationUtility.getModelInfoNotUsedCache(this, new SJmoGetTiSnapshotPairList());
        if (null == retInfoList) {
            this.logUty.putlog("getSJmoLocalReplicationPairVolInfoMgrNotUsedCache", "Information of TI Snapshot pair List is null.");
            SJctrError err = new SJctrError(209, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == retInfoList.size()) {
            this.logUty.putlog("getSJmoLocalReplicationPairVolInfoMgrNotUsedCache", "Size of TI Snapshot pair List is zero.");
            SJctrError err = new SJctrError(209, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoTiSnapshotPairList retInfo = (SJmoTiSnapshotPairList)retInfoList.get(0);
        if (null == retInfo) {
            this.logUty.putlog("getSJmoLocalReplicationPairVolInfoMgrNotUsedCache", "Information of TI Snapshot pairs is null.");
            SJctrError err = new SJctrError(209, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        return retInfoList;
    }

    protected List<SJmoTiPvolStatus> getSJmoTiPvolStatusMgrNotUsedCache() {
        List<Object> retInfoList = SJctrReplicationUtility.getModelInfoNotUsedCache(this, new SJmoGetTiPvolStatus());
        if (null == retInfoList) {
            this.logUty.putlog("getSJmoLocalReplicationPairVolInfoMgrNotUsedCache", "Information of TI P-VOL Status List is null.");
            SJctrError err = new SJctrError(209, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == retInfoList.size()) {
            this.logUty.putlog("getSJmoLocalReplicationPairVolInfoMgrNotUsedCache", "Size of TI P-VOL Status List is zero.");
            SJctrError err = new SJctrError(209, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoTiPvolStatus retInfo = (SJmoTiPvolStatus)retInfoList.get(0);
        if (null == retInfo) {
            this.logUty.putlog("getSJmoLocalReplicationPairVolInfoMgrNotUsedCache", "Information of TI P-VOL Status is null.");
            SJctrError err = new SJctrError(209, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        return retInfoList;
    }

    private List<?> getSpecifiedModelInfoNotUsedCache(SJmoGetKind_IF kind) {
        List<Object> retInfoList = SJctrReplicationUtility.getModelInfoNotUsedCache(this, kind);
        if (null == retInfoList) {
            this.getLogUty().putlog("getSpecifiedModelInfoNotUsedCache", "Information of " + kind.getClass().getName() + " is null.");
            SJctrError err = new SJctrError(209, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        return retInfoList;
    }

    protected List<SJmoLocalReplicationPairVolInfo> checkAndGetDispPairList(List<SJmoLocalReplicationPairVolInfo> pairList, List<SJctrViewPairSyncRateInfo> rmiDataList) {
        ArrayList<SJmoLocalReplicationPairVolInfo> dispPairList = new ArrayList<SJmoLocalReplicationPairVolInfo>(pairList.size());
        Collections.sort(rmiDataList);
        for (SJmoLocalReplicationPairVolInfo pairInfo : pairList) {
            int index = Collections.binarySearch(rmiDataList, pairInfo);
            if (0 > index) continue;
            dispPairList.add(pairInfo);
        }
        return dispPairList;
    }

    private SJctrViewPairSyncRateTableModel createTblAndSetVisibleFlag(List<SJmoLocalReplicationPairVolInfo> pairList) {
        SJctrViewPairSyncRateTableModel syncTableData = new SJctrViewPairSyncRateTableModel();
        this.setVisibleTblFlag(pairList);
        if (this.visibleSiSimfPairFlag) {
            syncTableData = (SJctrViewPairSyncRateTableModel)this.getDataObjectModel(KEY_TABLE);
        } else if (this.visibleTiPairFlag) {
            syncTableData = (SJctrViewSsPairSyncRateTableModel)this.getDataObjectModel(KEY_SSTABLE);
        }
        return syncTableData;
    }

    private void setVisibleTblFlag(List<SJmoLocalReplicationPairVolInfo> pairList) {
        for (SJmoLocalReplicationPairVolInfo pairInfo : pairList) {
            if (pairInfo.isVolPos(256)) {
                this.setVisibleFlagByCopyType(0);
                continue;
            }
            if (pairInfo.isVolPos(8)) {
                this.setVisibleFlagByCopyType(1);
                continue;
            }
            if (pairInfo.isVolPos(0x800000) && pairInfo.isExSnapshotInfo(1)) {
                this.setVisibleFlagByCopyType(3);
                continue;
            }
            this.logUty.putlog("checkSelectedPairCopyTypeMix", "Selected pairs copytype is not SI, SIMF or TI.");
            SJctrError err = new SJctrError(209, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrSimpleDataModel settingTblKey = (SJctrSimpleDataModel)this.getDataObjectModel(KEY_SET_TABLE);
        ((SJctrDataObject)settingTblKey.getManageData()).setData(KEY_SET_SITABLE, new Boolean(this.visibleSiSimfPairFlag));
        ((SJctrDataObject)settingTblKey.getManageData()).setData(KEY_SET_SSTABLE, new Boolean(this.visibleTiPairFlag));
        settingTblKey.setDirty();
    }

    private void setVisibleFlagByCopyType(int copytype) {
        switch (copytype) {
            case 0: 
            case 1: {
                this.visibleSiSimfPairFlag = true;
                break;
            }
            case 3: {
                this.visibleTiPairFlag = true;
                break;
            }
        }
        if (this.visibleSiSimfPairFlag && this.visibleTiPairFlag) {
            this.logUty.putlog("checkCopyTypeMix", "Selected pairs copytype is mix.");
            SJctrError err = new SJctrError(209, 22, 205022);
            SJcException exp = err.createException();
            throw exp;
        }
    }

    public static enum SYNC_RATE_MSG implements SJctrNotifyState
    {
        SELECT_REFRESH;

    }
}

