/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.createpairs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrRadioButtonGroupDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortLunTableKey;
import sanproject.sn2.controller.wizard.replication.remote.createpairs.model.SJctrBaseSecondaryVolumeDataModel;
import sanproject.sn2.controller.wizard.replication.remote.createpairs.model.SJctrGetUniversalReplicatorPairVolInfo;
import sanproject.sn2.model.data.lu.SJmoLuIndex;
import sanproject.sn2.model.data.replication.SJmoMirrorIndex;
import sanproject.sn2.model.data.replication.SJmoReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorJnlGrp;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorJnlGrpMirror;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorPairVolInfo;
import sanproject.sn2.model.data.replication.remote.manager.SJmoUniversalReplicatorJnlGrpMgr;
import sanproject.sn2.model.data.replication.remote.manager.SJmoUniversalReplicatorPairVolInfoMgr;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.inf.SJmoDataMacro_IF;

public class SJctrCreateRemotePairUtility {
    private static final int PT_SFT_CONST = (SJmoDataMacro_IF.NUM_MAX_HTG + 1) * (SJmoDataMacro_IF.NUM_MAX_LUN + 1);

    public static SJcException createRemoteReplicationException(int err) {
        return new SJctrError(210, 22, err).createException();
    }

    private static void checkDataController(SJctrDataController dc, String methodName) {
        if (null == dc) {
            SJctrLogUty.error(SJctrCreateRemotePairUtility.class.getSimpleName(), methodName, "DataController is null.");
            throw SJctrCreateRemotePairUtility.createRemoteReplicationException(107004);
        }
    }

    public static void initCopyPaceTextBoxDataModel(SJctrDataController dc) {
        SJctrCreateRemotePairUtility.checkDataController(dc, "initCopyPaceTextBoxDataModel");
        SJctrDataObjectModel<? extends SJctrDataObject> dataModel = dc.getDataObjectModel("COM_COPY_PACE_TXT");
        if (dataModel instanceof SJctrTextBoxDataModel) {
            SJctrTextBoxDataModel copyPaceTextBoxModel = (SJctrTextBoxDataModel)dataModel;
            copyPaceTextBoxModel.setValue(String.valueOf(15));
            copyPaceTextBoxModel.setMin(String.valueOf(1));
            copyPaceTextBoxModel.setMax(String.valueOf(15));
        }
    }

    public static void initCopyPacePllDownListDataModel(SJctrDataController dc) {
        SJctrCreateRemotePairUtility.checkDataController(dc, "initCopyPacePllDownListDataModel");
        SJctrDataObjectModel<? extends SJctrDataObject> dataModel = dc.getDataObjectModel("COM_COPY_PACE_LIST");
        if (dataModel instanceof SJctrComboBoxDataModel) {
            SJctrComboBoxDataModel copyPacePulldownList = (SJctrComboBoxDataModel)dataModel;
            copyPacePulldownList.addItem(String.valueOf(1), "3");
            copyPacePulldownList.addItem(String.valueOf(2), "15");
            copyPacePulldownList.setSelection(String.valueOf(2));
        }
    }

    public static void initInitCopyPriorityModel(SJctrDataController dc) {
        SJctrCreateRemotePairUtility.checkDataController(dc, "initInitCopyPriorityModel");
        SJctrDataObjectModel<? extends SJctrDataObject> dataModel = dc.getDataObjectModel("COM_INITIAL_COPY_PRIORITY");
        if (dataModel instanceof SJctrTextBoxDataModel) {
            SJctrTextBoxDataModel initCopyPriorityTextBoxModel = (SJctrTextBoxDataModel)dataModel;
            initCopyPriorityTextBoxModel.setValue(String.valueOf(32));
            initCopyPriorityTextBoxModel.setMin(String.valueOf(1));
            initCopyPriorityTextBoxModel.setMax(String.valueOf(256));
        }
    }

    public static void initCfwDataModel(SJctrDataController dc) {
        SJctrCreateRemotePairUtility.checkDataController(dc, "initCfwDataModel");
        SJctrDataObjectModel<? extends SJctrDataObject> dataModel = dc.getDataObjectModel("COM_CFW_DATA");
        SJctrComUtility comUty = dc.getOwner().getComUtility();
        if (dataModel instanceof SJctrComboBoxDataModel) {
            SJctrComboBoxDataModel cfwDataModel = (SJctrComboBoxDataModel)dataModel;
            cfwDataModel.addItem(String.valueOf(1), comUty.getGuidance("CFW_PVOL_ONLY"));
            cfwDataModel.addItem(String.valueOf(0), comUty.getGuidance("CFW_SVOL_COPY"));
            cfwDataModel.setSelection(String.valueOf(1));
        }
    }

    public static void initDfwToSvol(SJctrDataController dc) {
        SJctrCreateRemotePairUtility.checkDataController(dc, "initDfwToSvol");
        SJctrDataObjectModel<? extends SJctrDataObject> dataModel = dc.getDataObjectModel("COM_DFW_TO_SVOL");
        SJctrComUtility comUty = dc.getOwner().getComUtility();
        if (dataModel instanceof SJctrComboBoxDataModel) {
            SJctrComboBoxDataModel dfwToSvolModel = (SJctrComboBoxDataModel)dataModel;
            dfwToSvolModel.addItem(String.valueOf(0), comUty.getGuidance("DFW_NOT_REQUIRE"));
            dfwToSvolModel.addItem(String.valueOf(1), comUty.getGuidance("DFW_REQUIRE"));
            dfwToSvolModel.setSelection(String.valueOf(0));
        }
    }

    public static void initHioTimeStampTransferModel(SJctrDataController dc) {
        SJctrCreateRemotePairUtility.checkDataController(dc, "initHioTimeStampTransferModel");
        SJctrDataObjectModel<? extends SJctrDataObject> dataModel = dc.getDataObjectModel("COM_HIO_TIME_STAMP_TRANS");
        if (dataModel instanceof SJctrRadioButtonGroupDataModel) {
            SJctrRadioButtonGroupDataModel hioTimeStampTransferModel = (SJctrRadioButtonGroupDataModel)dataModel;
            hioTimeStampTransferModel.add("COM_ENABLE");
            hioTimeStampTransferModel.add("COM_DISABLE");
        }
    }

    public static void initCfwModel(SJctrDataController dc) {
        SJctrCreateRemotePairUtility.checkDataController(dc, "initCfwModel");
        SJctrDataObjectModel<? extends SJctrDataObject> dataModel = dc.getDataObjectModel("COM_CFW");
        if (dataModel instanceof SJctrComboBoxDataModel) {
            SJctrComboBoxDataModel cfwModel = (SJctrComboBoxDataModel)dataModel;
            SJctrComUtility comUty = dc.getOwner().getComUtility();
            cfwModel.addItem(String.valueOf(0), comUty.getGuidance("CFW_PVOL_ONLY"));
            cfwModel.addItem(String.valueOf(1), comUty.getGuidance("CFW_SVOL_COPY"));
            cfwModel.setSelection(String.valueOf(0));
        }
    }

    public static void initIntervalValueModel(SJctrComboBoxDataModel intervalPullDownModel, int copyType) {
        if (null == intervalPullDownModel) {
            throw SJctrCreateRemotePairUtility.createRemoteReplicationException(107004);
        }
        int maxIntervalValue = -1;
        switch (copyType) {
            case 0: 
            case 2: {
                maxIntervalValue = SJmoDataMacro_IF.NUM_MAX_LUN;
                break;
            }
            case 1: {
                maxIntervalValue = SJmoDataMacro_IF.NUM_MAX_LDEV_CU - 1;
                break;
            }
            case 3: {
                maxIntervalValue = SJmoDataMacro_IF.NUM_MAX_LDEV_CU;
                break;
            }
        }
        for (int i = 0; i <= maxIntervalValue; ++i) {
            intervalPullDownModel.addItem(String.valueOf(i));
        }
        if (maxIntervalValue != -1) {
            intervalPullDownModel.setSelectedIndex(0);
        }
    }

    public static void initPvolFenceLevelModel(SJctrDataController dc, int copyType) {
        SJctrCreateRemotePairUtility.checkDataController(dc, "initPvolFenceLevelModel");
        SJctrDataObjectModel<? extends SJctrDataObject> dataModel = dc.getDataObjectModel("COM_PVOL_FENCE_LEVEL");
        if (dataModel instanceof SJctrComboBoxDataModel) {
            SJctrComboBoxDataModel pvolFenceLevelModel = (SJctrComboBoxDataModel)dataModel;
            SJctrComUtility comUty = dc.getOwner().getComUtility();
            switch (copyType) {
                case 0: 
                case 1: {
                    pvolFenceLevelModel.addItem(String.valueOf(0), comUty.getGuidance("FENCE_LV_NEVER"));
                    pvolFenceLevelModel.addItem(String.valueOf(1), comUty.getGuidance("FENCE_LV_DATA"));
                    pvolFenceLevelModel.addItem(String.valueOf(2), comUty.getGuidance("FENCE_LV_STATUS"));
                    pvolFenceLevelModel.setSelection(String.valueOf(0));
                    break;
                }
            }
        }
    }

    public static void initErrorLevelModel(SJctrDataController dc, int copyType) {
        SJctrCreateRemotePairUtility.checkDataController(dc, "initErrorLevelModel");
        SJctrDataObjectModel<? extends SJctrDataObject> dataModel = dc.getDataObjectModel("COM_ERROR_LEVEL");
        SJctrComUtility comUty = dc.getOwner().getComUtility();
        if (dataModel instanceof SJctrComboBoxDataModel) {
            SJctrComboBoxDataModel errorLevelModel = (SJctrComboBoxDataModel)dataModel;
            String dispErrorLevelLu = null;
            switch (copyType) {
                case 2: {
                    dispErrorLevelLu = comUty.getGuidance("ERROR_LEVEL_LU");
                    break;
                }
                case 3: {
                    dispErrorLevelLu = comUty.getGuidance("ERROR_LEVEL_VOLUME");
                    break;
                }
                default: {
                    dispErrorLevelLu = "?";
                }
            }
            errorLevelModel.addItem(String.valueOf(1), dispErrorLevelLu);
            errorLevelModel.addItem(String.valueOf(0), comUty.getGuidance("ERROR_LEVEL_MIRROR"));
            errorLevelModel.setSelection(String.valueOf(0));
        }
    }

    public static void initInitCopyTypeModel(SJctrDataController dc, int copyType, int controllerId) {
        SJctrCreateRemotePairUtility.checkDataController(dc, "initInitCopyTypeModel");
        SJctrDataObjectModel<? extends SJctrDataObject> dataModel = dc.getDataObjectModel("COM_INITIAL_COPY_TYPE");
        SJctrComUtility comUty = dc.getOwner().getComUtility();
        if (dataModel instanceof SJctrComboBoxDataModel) {
            SJctrComboBoxDataModel initCopyTypeModel = (SJctrComboBoxDataModel)dataModel;
            switch (copyType) {
                case 0: 
                case 1: {
                    initCopyTypeModel.addItem(String.valueOf(1), comUty.getGuidance("INIT_CP_TYPE_ENTIRE_VOL"));
                    initCopyTypeModel.addItem(String.valueOf(0), comUty.getGuidance("NONE"));
                    initCopyTypeModel.setSelection(String.valueOf(1));
                    break;
                }
                case 2: {
                    initCopyTypeModel.addItem(String.valueOf(0), comUty.getGuidance("INIT_CP_TYPE_ENTIRE"));
                    initCopyTypeModel.addItem(String.valueOf(1), comUty.getGuidance("NONE"));
                    initCopyTypeModel.addItem(String.valueOf(2), comUty.getGuidance("INIT_CP_TYPE_DELTA"));
                    initCopyTypeModel.setSelection(String.valueOf(0));
                    break;
                }
                case 3: {
                    initCopyTypeModel.addItem(String.valueOf(0), comUty.getGuidance("INIT_CP_TYPE_ENTIRE"));
                    initCopyTypeModel.addItem(String.valueOf(1), comUty.getGuidance("NONE"));
                    initCopyTypeModel.addItem(String.valueOf(2), comUty.getGuidance("INIT_CP_TYPE_DELTA"));
                    initCopyTypeModel.setSelection(String.valueOf(0));
                    break;
                }
            }
        }
    }

    public static List<SJmoLuIndex> getSvolLunList(List<SJctrPortLunTableKey> pvolList, List<Integer> usedSvolIndexList, int pvolSize, int modelId, SJctrBaseSecondaryVolumeDataModel svolModel, boolean isRelative, int selectedInterval) {
        if (null == svolModel || null == usedSvolIndexList || isRelative && null == pvolList || null != pvolList && pvolList.size() < pvolSize || pvolSize <= 0) {
            throw SJctrCreateRemotePairUtility.createRemoteReplicationException(107004);
        }
        ArrayList<SJmoLuIndex> luIndexList = new ArrayList<SJmoLuIndex>(pvolSize);
        usedSvolIndexList = new ArrayList<Integer>(usedSvolIndexList);
        int selectPtIndex = svolModel.getPortIdModel().getSelectedIndex();
        int hgId = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(svolModel.getHgIdModel());
        int lun = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(svolModel.getLunIdModel());
        int basePtHgLun = SJctrCreateRemotePairUtility.getPtHgLun(selectPtIndex, hgId, lun);
        ArrayList<Short> remotePtList = new ArrayList<Short>(SJctrRemoteReplicationUtility.getPortNameMap(modelId).keySet());
        int maxPortIndex = svolModel.getPortIdModel().getItemMap().size() - 1;
        int maxPtHgLun = SJctrCreateRemotePairUtility.getPtHgLun(maxPortIndex, SJmoDataMacro_IF.NUM_MAX_HTG, SJmoDataMacro_IF.NUM_MAX_LUN);
        int interval = 0;
        int beforePtHgLun = 0;
        if (isRelative) {
            beforePtHgLun = SJctrCreateRemotePairUtility.getPtHgLun(selectPtIndex, pvolList.get(0).getPortLunDetail().getSHostGroup(), pvolList.get(0).getPortLunDetail().getSLUN());
        } else {
            interval = selectedInterval + 1;
            basePtHgLun -= interval;
        }
        for (int i = 0; i < pvolSize; ++i) {
            if (isRelative) {
                int currentPtHgLun = SJctrCreateRemotePairUtility.getPtHgLun(selectPtIndex, pvolList.get(i).getPortLunDetail().getSHostGroup(), pvolList.get(i).getPortLunDetail().getSLUN());
                interval = SJctrCreateRemotePairUtility.getNextInterval(currentPtHgLun, beforePtHgLun, maxPtHgLun);
                beforePtHgLun = currentPtHgLun;
            }
            basePtHgLun = SJctrCreateRemotePairUtility.getNextIndex(basePtHgLun, maxPtHgLun, interval, usedSvolIndexList);
            SJmoLuIndex luIndex = new SJmoLuIndex();
            int pt = basePtHgLun / PT_SFT_CONST;
            luIndex.setSPort((Short)remotePtList.get(pt));
            int ptHg = basePtHgLun / (SJmoDataMacro_IF.NUM_MAX_LUN + 1);
            luIndex.setSHostGroup((short)(ptHg % (SJmoDataMacro_IF.NUM_MAX_HTG + 1)));
            luIndex.setILUN(basePtHgLun % (SJmoDataMacro_IF.NUM_MAX_LUN + 1));
            luIndexList.add(luIndex);
        }
        return luIndexList;
    }

    public static List<SJmoLdevIndex> getSvolLdevList(List<SJmoLdevIndex> pvolList, List<Integer> usedLdevIndexList, int pvolSize, int copyType, int controllerId, SJctrBaseSecondaryVolumeDataModel svolDataModel, boolean isRelative, int selectedInterval) {
        if (null == svolDataModel || null == usedLdevIndexList || isRelative && null == pvolList || null != pvolList && pvolList.size() < pvolSize || pvolSize <= 0) {
            SJctrLogUty.error(SJctrCreateRemotePairUtility.class.getSimpleName(), "getSvolLdevList", "Invalit arguments.");
            throw SJctrCreateRemotePairUtility.createRemoteReplicationException(107004);
        }
        int maxCuLdev = -1;
        int baseCuLdev = -1;
        int ldev = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(svolDataModel.getLdevModel());
        int cu = -1;
        if (1 == copyType) {
            maxCuLdev = SJmoDataMacro_IF.NUM_MAX_LDEV_CU;
            String cuStr = svolDataModel.getCuTextModel().getValue();
            try {
                cu = Integer.parseInt(cuStr, 16);
            }
            catch (NumberFormatException e) {
                SJctrLogUty.error(SJctrCreateRemotePairUtility.class.getSimpleName(), "getSvolLdevList", "Failed to CU number format. CU :" + cuStr);
            }
            baseCuLdev = SJctrCreateRemotePairUtility.getCuLdev(0, ldev);
        } else if (3 == copyType) {
            int cuMax = SJctrRemoteReplicationUtility.getMaxCuNum(controllerId);
            maxCuLdev = SJctrCreateRemotePairUtility.getCuLdev(cuMax, SJmoDataMacro_IF.NUM_MAX_LDEV_CU);
            cu = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(svolDataModel.getCuListModel());
            baseCuLdev = SJctrCreateRemotePairUtility.getCuLdev(cu, ldev);
        } else {
            throw SJctrCreateRemotePairUtility.createRemoteReplicationException(107004);
        }
        ArrayList<SJmoLdevIndex> ldevIndexList = new ArrayList<SJmoLdevIndex>(pvolSize);
        usedLdevIndexList = new ArrayList<Integer>(usedLdevIndexList);
        boolean ldkc = false;
        int interval = 0;
        int beforeCuLdev = 0;
        if (isRelative) {
            beforeCuLdev = SJctrCreateRemotePairUtility.getCuLdev(pvolList.get(0).getSCu(), pvolList.get(0).getSLdev());
        } else {
            interval = selectedInterval + 1;
            baseCuLdev -= interval;
        }
        for (int i = 0; i < pvolSize; ++i) {
            if (isRelative) {
                int currentCuLdev = SJctrCreateRemotePairUtility.getCuLdev(pvolList.get(i).getSCu(), pvolList.get(i).getSLdev());
                interval = SJctrCreateRemotePairUtility.getNextInterval(currentCuLdev, beforeCuLdev, maxCuLdev);
                beforeCuLdev = currentCuLdev;
            }
            baseCuLdev = SJctrCreateRemotePairUtility.getNextIndex(baseCuLdev, maxCuLdev, interval, usedLdevIndexList);
            SJmoLdevIndex ldevIndex = new SJmoLdevIndex();
            ldevIndex.setSLdkc((short)(ldkc ? 1 : 0));
            ldev = baseCuLdev % (SJmoDataMacro_IF.NUM_MAX_LDEV_CU + 1);
            if (copyType == 1) {
                baseCuLdev = SJctrCreateRemotePairUtility.getCuLdev(cu, ldev);
            }
            ldevIndex.setSCu((short)(baseCuLdev / (SJmoDataMacro_IF.NUM_MAX_LDEV_CU + 1)));
            ldevIndex.setSLdev((short)ldev);
            ldevIndexList.add(ldevIndex);
        }
        return ldevIndexList;
    }

    private static int getNextInterval(int current, int before, int max) {
        int interval = current - before;
        if (interval < 0) {
            interval %= max + 1;
            interval += max + 1;
        }
        return interval;
    }

    private static int getNextIndex(int baseIndex, int maxIndex, int interval, List<Integer> usedSvolIndexList) {
        baseIndex += interval;
        for (int i = 0; i < maxIndex; ++i) {
            if (baseIndex > maxIndex) {
                baseIndex -= maxIndex + 1;
            }
            if (!usedSvolIndexList.contains(baseIndex)) break;
            ++baseIndex;
        }
        usedSvolIndexList.add(baseIndex);
        return baseIndex;
    }

    public static int getCuLdev(int cu, int ldev) {
        return cu * (SJmoDataMacro_IF.NUM_MAX_LDEV_CU + 1) + ldev;
    }

    public static int getPtHgLun(int port, int hg, int lun) {
        return port * PT_SFT_CONST + hg * (SJmoDataMacro_IF.NUM_MAX_LUN + 1) + lun;
    }

    public static void checkJnlStatus(SJmoUniversalReplicatorJnlGrpMgr jnlMgr, int initCopyType, int mjnl, int mirror) {
        SJmoUniversalReplicatorJnlGrp jnlInfo = jnlMgr.getJnlGroup(mjnl);
        if (null != jnlInfo) {
            ArrayList<SJmoUniversalReplicatorJnlGrpMirror> jnlMirrorList = jnlInfo.getMirrors();
            SJmoMirrorIndex mirrorIndex = new SJmoMirrorIndex();
            mirrorIndex.setIJnlGroupId(mjnl);
            mirrorIndex.setIMirrorId(mirror);
            int index = Collections.binarySearch(jnlMirrorList, mirrorIndex);
            if (index >= 0) {
                int deltaState = ((SJmoUniversalReplicatorJnlGrpMirror)jnlMirrorList.get(index)).getDelta();
                switch (initCopyType) {
                    case 0: 
                    case 1: {
                        if (deltaState != 1 && deltaState != 2 && deltaState != 3) break;
                        throw SJctrCreateRemotePairUtility.createRemoteReplicationException(206034);
                    }
                    case 2: {
                        if (((SJmoUniversalReplicatorJnlGrpMirror)jnlMirrorList.get(index)).getStatus() == 0 || deltaState == 1 || deltaState == 3) break;
                        throw SJctrCreateRemotePairUtility.createRemoteReplicationException(206033);
                    }
                }
            }
        }
    }

    public static List<SJmoUniversalReplicatorPairVolInfo> getUrPairVolInfoList(SJmoReplicationPairVolInfo pairVolInfo) {
        ArrayList<SJmoUniversalReplicatorPairVolInfo> retList = new ArrayList<SJmoUniversalReplicatorPairVolInfo>();
        ArrayList<? extends SJmoLdevIndex> pRemotePairInfoList = pairVolInfo.getAlPVolIndex();
        for (SJmoLdevIndex sJmoLdevIndex : pRemotePairInfoList) {
            retList.add((SJmoUniversalReplicatorPairVolInfo)sJmoLdevIndex);
        }
        ArrayList<? extends SJmoLdevIndex> sRemotePairInfoList = pairVolInfo.getAlSVolIndex();
        for (SJmoLdevIndex sJmoLdevIndex : sRemotePairInfoList) {
            retList.add((SJmoUniversalReplicatorPairVolInfo)sJmoLdevIndex);
        }
        return retList;
    }

    public static Map<Integer, SJmoUniversalReplicatorPairVolInfo> getSingleUrPairMapFromLdevIndex(SJmoUniversalReplicatorPairVolInfoMgr urPairVolInfoMgr, List<SJmoLdevDetail> ldevList) {
        HashMap<Integer, SJmoUniversalReplicatorPairVolInfo> basicDataForMultiPair = new HashMap<Integer, SJmoUniversalReplicatorPairVolInfo>();
        for (SJmoLdevDetail ldevDetail : ldevList) {
            List<SJmoUniversalReplicatorPairVolInfo> urPair;
            SJmoReplicationPairVolInfo pairVolInfo = urPairVolInfoMgr.getPairVolInfo(ldevDetail);
            if (pairVolInfo == null || (urPair = SJctrCreateRemotePairUtility.getUrPairVolInfoList(pairVolInfo)).size() != 1) continue;
            basicDataForMultiPair.put(ldevDetail.getIndex(), urPair.get(0));
        }
        return basicDataForMultiPair;
    }

    public static List<SJmoUniversalReplicatorPairVolInfo> getUrPairListFromUrPairMap(SJmoLdevIndex index, Map<Class<?>, List<?>> basicData) {
        Map urPairMap;
        SJmoUniversalReplicatorPairVolInfo urPair;
        ArrayList<SJmoUniversalReplicatorPairVolInfo> urPairList = new ArrayList<SJmoUniversalReplicatorPairVolInfo>();
        List<?> urPairMapList = basicData.get(SJctrGetUniversalReplicatorPairVolInfo.class);
        if (urPairMapList != null && urPairMapList.size() > 0 && (urPair = (SJmoUniversalReplicatorPairVolInfo)(urPairMap = (Map)urPairMapList.get(0)).get(index.getIndex())) != null) {
            urPairList.add(urPair);
        }
        return urPairList;
    }
}

