/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.editjournalopts.model;

import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.data.SJctrSelectableDataObject;
import sanproject.sn2.controller.com.model.SJctrCheckBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrRadioButtonGroupDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrTextBoxEvent;
import sanproject.sn2.controller.com.model.event.SJctrTextChangeListener;
import sanproject.sn2.controller.wizard.replication.remote.editjournalopts.SJctrEditJournalOptionsDC;

public class SJctrInflowControlDataModel
extends SJctrSimpleDataModel {
    public static final String KEY_INFLOW_CONTROL_INF = "COM_INFLOW_CONTROL_INF";
    public static final String KEY_INFLOW_CONTROL_RADIOBUTTON = "COM_INFLOW_CONTROL_RADIOBUTTON";
    public static final String KEY_DATA_OVERFLOW_WATCH_INF = "COM_DATA_OVERFLOW_WATCH_INF";
    public static final String KEY_DATA_OVERFLOW_WATCH_TEXTBOX = "COM_DATA_OVERFLOW_WATCH_TEXTBOX";
    public static final String KEY_CHECKBOX = "COM_CHECKBOX";
    public static final String KEY_ENABLE = "COM_ENABLE";
    public static final String KEY_DISABLE = "COM_DISABLE";
    private static final String KEY_DISPSTATE = "COM_DISPSTATE";
    private static final String KEY_VISIBLE = "COM_VISIBLE";
    private static final int CHECKBOX_OFF = 1;
    private static final int VISIBLE_ACTIVE = SJctrSelectableDataObject.VISIBLE_ACTIVE;
    private static final int VISIBLE_INACTIVE = SJctrSelectableDataObject.VISIBLE_INACTIVE;

    public SJctrInflowControlDataModel() {
        this.initDataModel();
        this.initListener();
    }

    private void initDataModel() {
        SJctrCheckBoxDataModel inflowCheckBox = new SJctrCheckBoxDataModel();
        this.addDataModel(KEY_CHECKBOX, inflowCheckBox);
        SJctrRadioButtonGroupDataModel inflowRadioGroup = new SJctrRadioButtonGroupDataModel();
        inflowRadioGroup.add(KEY_ENABLE);
        inflowRadioGroup.add(KEY_DISABLE);
        this.addDataModel(KEY_INFLOW_CONTROL_RADIOBUTTON, inflowRadioGroup);
        SJctrSimpleDataModel dataOverflowTitle = new SJctrSimpleDataModel();
        dataOverflowTitle.addDataModel(KEY_CHECKBOX, new SJctrCheckBoxDataModel());
        this.addDataModel(KEY_DATA_OVERFLOW_WATCH_INF, dataOverflowTitle);
        SJctrTextBoxDataModel dataOverflowTextBox = new SJctrTextBoxDataModel();
        this.addDataModel(KEY_DATA_OVERFLOW_WATCH_TEXTBOX, dataOverflowTextBox);
    }

    private void initListener() {
        SJctrCheckBoxDataModel inflowCheckBox = this.getInflowControlCheckBox();
        SJctrRadioButtonGroupDataModel inflowRadioGroup = this.getInflowControlRadioButton();
        SJctrTextBoxDataModel dataOverflowTextBox = this.getDataOverflowWatchTextBox();
        inflowCheckBox.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
        inflowRadioGroup.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
                if (event.isSelect()) {
                    SJctrInflowControlDataModel.this.fireMessageEvent(SJctrEditJournalOptionsDC.EDIT_JOURNAL_OPTIONS_MSG.SELECT_INFLOW_CONTROL);
                }
            }
        });
        dataOverflowTextBox.addTextChangeListener(new SJctrTextChangeListener(){

            @Override
            public void textChanged(SJctrTextBoxEvent event) {
                SJctrReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
    }

    @Override
    public void makeDataObject() {
        this.setSelectCheckBox(false);
        this.changeInflowControlTextBoxType(this.getSelect());
        SJctrSimpleDataModel dataOverflowTitle = this.getDataOverflowWatchTitle();
        ((SJctrDataObject)dataOverflowTitle.getManageData()).setData(KEY_DISPSTATE, 1);
    }

    public void setSelectCheckBox(boolean flg) {
        SJctrCheckBoxDataModel inflowCheckBox = this.getInflowControlCheckBox();
        inflowCheckBox.setSelect(flg);
    }

    public boolean isSelectCheckBox() {
        SJctrCheckBoxDataModel inflowCheckBox = this.getInflowControlCheckBox();
        return inflowCheckBox.isSelect();
    }

    public void setSelect(int value) {
        String key = "";
        SJctrRadioButtonGroupDataModel inflowRadioGroup = this.getInflowControlRadioButton();
        if (0 == value) {
            key = KEY_ENABLE;
        } else if (1 == value) {
            key = KEY_DISABLE;
        }
        inflowRadioGroup.setSelect(key);
    }

    public int getSelect() {
        int value = -1;
        SJctrRadioButtonGroupDataModel inflowRadioGroup = this.getInflowControlRadioButton();
        String selectString = inflowRadioGroup.getSelect();
        if (selectString != null) {
            if (selectString.equals(KEY_ENABLE)) {
                value = 0;
            } else if (selectString.equals(KEY_DISABLE)) {
                value = 1;
            }
        }
        return value;
    }

    public String getDisplayDataOverflowWatch() {
        SJctrTextBoxDataModel dataOverflowTextBox = this.getDataOverflowWatchTextBox();
        return dataOverflowTextBox.getValue();
    }

    public void setDisplayDataOverflowWatch(String value) {
        SJctrTextBoxDataModel dataOverflowTextBox = this.getDataOverflowWatchTextBox();
        dataOverflowTextBox.setValue(value);
    }

    public void setMax(String max) {
        SJctrTextBoxDataModel dataOverflowTextBox = this.getDataOverflowWatchTextBox();
        dataOverflowTextBox.setMax(max);
    }

    public void setMin(String min) {
        SJctrTextBoxDataModel dataOverflowTextBox = this.getDataOverflowWatchTextBox();
        dataOverflowTextBox.setMin(min);
    }

    public void changeInflowControlTextBoxType(int inflowControl) {
        String inflowControlMin = "";
        String inflowControlMax = "";
        if (inflowControl == 0) {
            inflowControlMin = String.valueOf(0);
            inflowControlMax = String.valueOf(600);
        }
        this.setMin(inflowControlMin);
        this.setMax(inflowControlMax);
    }

    public void setDataOverflowWatchEnable(boolean flg) {
        SJctrTextBoxDataModel dataOverflowTextBox = this.getDataOverflowWatchTextBox();
        dataOverflowTextBox.setEnable(flg);
    }

    public void setEnable(boolean flg) {
        SJctrCheckBoxDataModel inflowControlCheckBox = this.getInflowControlCheckBox();
        SJctrRadioButtonGroupDataModel inflowControlRadioGroup = this.getInflowControlRadioButton();
        SJctrCheckBoxDataModel dataOverflowCheckBox = this.getDataOverflowWatchCheckBox();
        SJctrTextBoxDataModel dataOverflowTextBox = this.getDataOverflowWatchTextBox();
        inflowControlCheckBox.setEnable(flg);
        inflowControlRadioGroup.setEnable(flg);
        dataOverflowTextBox.setEnable(flg);
        if (flg) {
            ((SJctrSelectableDataObject)dataOverflowCheckBox.getManageData()).setData(KEY_VISIBLE, VISIBLE_ACTIVE);
        } else {
            ((SJctrSelectableDataObject)dataOverflowCheckBox.getManageData()).setData(KEY_VISIBLE, VISIBLE_INACTIVE);
        }
    }

    public void setDirty(String key) {
        SJctrDataObjectModel<SJctrDataObject> dataModel = this.getDataModel(key);
        if (dataModel != null) {
            dataModel.setDirty();
        }
    }

    private SJctrCheckBoxDataModel getInflowControlCheckBox() {
        return (SJctrCheckBoxDataModel)this.getDataModel(KEY_CHECKBOX);
    }

    private SJctrRadioButtonGroupDataModel getInflowControlRadioButton() {
        return (SJctrRadioButtonGroupDataModel)this.getDataModel(KEY_INFLOW_CONTROL_RADIOBUTTON);
    }

    private SJctrSimpleDataModel getDataOverflowWatchTitle() {
        return (SJctrSimpleDataModel)this.getDataModel(KEY_DATA_OVERFLOW_WATCH_INF);
    }

    private SJctrCheckBoxDataModel getDataOverflowWatchCheckBox() {
        return (SJctrCheckBoxDataModel)this.getDataOverflowWatchTitle().getDataModel(KEY_CHECKBOX);
    }

    private SJctrTextBoxDataModel getDataOverflowWatchTextBox() {
        return (SJctrTextBoxDataModel)this.getDataModel(KEY_DATA_OVERFLOW_WATCH_TEXTBOX);
    }
}

