/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.edittcpairopts;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.comparator.SJctrTrueCopyPairInfoComparator;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrCheckBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.replication.com.SJctrRemoteReplicationDataMacro;
import sanproject.sn2.controller.wizard.replication.remote.edittcpairopts.SJctrCfwDataDataModel;
import sanproject.sn2.controller.wizard.replication.remote.edittcpairopts.SJctrEditTcPairOptionsConfirmData;
import sanproject.sn2.controller.wizard.replication.remote.edittcpairopts.SJctrFenceLvDataModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetClprInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevLuseInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.connector.kind.SJmoGetTrueCopyPairVolInfoMgr;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.lu.SJmoPortLunInfo;
import sanproject.sn2.model.data.replication.remote.SJmoTrueCopyPairVolInfo;
import sanproject.sn2.model.data.replication.remote.manager.SJmoTrueCopyPairVolInfoMgr;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public class SJctrEditTcPairOptionsDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 17831009;
    private static final String DISP_TITLE = "EDIT_PAIR_OPTION";
    private static final String KEY_FENCE_LEVEL_INF = "COM_FENCE_LEVEL_INF";
    private static final String KEY_CFW_DATA_INF = "COM_CFW_DATA_INF";
    private static final String KEY_COPY_TYPE_INF = "COM_COPY_TYPE_INF";
    private static final String KEY_COPY_TYPE = "COM_COPY_TYPE";

    public SJctrEditTcPairOptionsDC() {
        super(17831009);
        this.initDataModel();
    }

    @Override
    public String getDispName() {
        String dispName = this.getComUtility().getGuidance(DISP_TITLE);
        return dispName;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetTrueCopyPairVolInfoMgr();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevNicknameInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetClprInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevLuseInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortLunInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_COPY_TYPE_INF, new SJctrSimpleDataModel());
        this.addDataObjectModel(KEY_FENCE_LEVEL_INF, new SJctrFenceLvDataModel());
        this.addDataObjectModel(KEY_CFW_DATA_INF, new SJctrCfwDataDataModel());
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> viewDataList = this.getProxy().getCache("KEY_SELECTED_REMOTE_VOL");
        if (null == viewDataList) {
            this.logUty.putlog("checkStartData", "Inherited list data is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == viewDataList.size()) {
            this.logUty.putlog("checkStartData", "Size of inherited list data is zero.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoTrueCopyPairVolInfo viewData = (SJmoTrueCopyPairVolInfo)viewDataList.get(0);
        if (null == viewData) {
            this.logUty.putlog("checkStartData", "Information of selected Pair is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        try {
            SJmoTrueCopyPairVolInfoMgr allTCPairInfo = SJctrRemoteReplicationUtility.getSJmoTrueCopyPairVolInfoMgr(this);
            List<SJmoTrueCopyPairVolInfo> viewData = this.getProxy().getCache("KEY_SELECTED_REMOTE_VOL");
            SJctrRemoteReplicationUtility.chkCacheTrueCopyPairsDetailData(this);
            List<SJmoTrueCopyPairVolInfo> pairlist = SJctrRemoteReplicationUtility.checkAndGetExistTCPairVolInfo(viewData, allTCPairInfo);
            int copytype = SJctrRemoteReplicationUtility.checkCopyTypeForTcPairVol(pairlist);
            if (copytype == -1) {
                this.logUty.putlog("checkConstructData", "Mixed copytype.");
                SJctrError err = new SJctrError(210, 22, 206008);
                SJcException exp = err.createException();
                throw exp;
            }
            for (SJmoTrueCopyPairVolInfo pairInfo : pairlist) {
                this.checkPairPosition(pairInfo);
                this.checkPairStatus(pairInfo);
            }
            this.initialSetupDataModel(pairlist, copytype);
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107002);
        }
        return true;
    }

    private void checkPairPosition(SJmoTrueCopyPairVolInfo pairInfo) {
        if (SJctrRemoteReplicationUtility.getPairPos(pairInfo) != 0) {
            this.logUty.putlog("checkPairPosition", "Contained SVOL.");
            SJctrError err = new SJctrError(210, 22, 206004);
            SJcException exp = err.createException();
            throw exp;
        }
    }

    private void checkPairStatus(SJmoTrueCopyPairVolInfo pairInfo) {
        if (!SJctrRemoteReplicationUtility.checkEditTCPairOptionsStatus(pairInfo)) {
            this.logUty.putlog("checkPairStatus", "Contained invalid Status.");
            SJctrError err = new SJctrError(210, 22, 206013);
            SJcException exp = err.createException();
            throw exp;
        }
    }

    @Override
    public boolean checkEndData() {
        try {
            SJctrEditTcPairOptionsConfirmData confirmData = new SJctrEditTcPairOptionsConfirmData();
            ArrayList<SJmoTrueCopyPairVolInfo> sendPairList = new ArrayList<SJmoTrueCopyPairVolInfo>();
            List<SJmoTrueCopyPairVolInfo> selectedPairList = this.getProxy().getCache("COM_EDIT_PAIR_OPTIONS_CACHE_PAIR_VOL_INFORMATION");
            List<?> originalPairList = this.getProxy().getCache("COM_EDIT_PAIR_OPTIONS_CACHE_PAIR_VOL_INFORMATION_ORIGINAL");
            List<SJmoPortLunInfo> portLunList = SJctrReplicationUtility.getSJmoPortLunInfo(this);
            List<SJmoLdevDetail> ldevDetailList = SJctrReplicationUtility.getSJmoLdevDetail(this);
            Map<Integer, List<SJmoPortLunDetail>> ldevLUPathMap = SJctrReplicationUtility.createLDEVLUPathMap(portLunList, ldevDetailList);
            int copytype = SJctrRemoteReplicationUtility.checkCopyTypeForTcPairVol(selectedPairList);
            SJctrSimpleDataModel fenceLevelInf = (SJctrSimpleDataModel)this.getDataObjectModel(KEY_FENCE_LEVEL_INF);
            SJctrCheckBoxDataModel fenceLevelCheckBox = (SJctrCheckBoxDataModel)fenceLevelInf.getDataModel("COM_CHECKBOX");
            SJctrComboBoxDataModel fenceLevelComboBox = (SJctrComboBoxDataModel)fenceLevelInf.getDataModel("COM_FENCE_LEVEL_COMBOBOX");
            boolean fenceLevelCheck = fenceLevelCheckBox.isSelect();
            int fenceLevelSelectKey = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(fenceLevelComboBox);
            BitSet fenceLevelBitSet = this.convertIntToBitSetFenceLevel(fenceLevelSelectKey);
            boolean cfwDataCheck = false;
            int cfwDataSelectKey = -1;
            if (copytype == 0) {
                SJctrSimpleDataModel cfwDataInf = (SJctrSimpleDataModel)this.getDataObjectModel(KEY_CFW_DATA_INF);
                SJctrCheckBoxDataModel cfwDataCheckBox = (SJctrCheckBoxDataModel)cfwDataInf.getDataModel("COM_CHECKBOX");
                SJctrComboBoxDataModel cfwDataComboBox = (SJctrComboBoxDataModel)cfwDataInf.getDataModel("COM_CFW_DATA_COMBOBOX");
                cfwDataCheck = cfwDataCheckBox.isSelect();
                cfwDataSelectKey = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(cfwDataComboBox);
            }
            for (int i = 0; i < selectedPairList.size(); ++i) {
                SJmoTrueCopyPairVolInfo sendPairInfo = selectedPairList.get(i);
                SJmoTrueCopyPairVolInfo savePairInfo = (SJmoTrueCopyPairVolInfo)originalPairList.get(i);
                BitSet sendBehaviorBitSet = new BitSet(32);
                BitSet saveBehaviorBitSet = new BitSet(32);
                sendBehaviorBitSet = sendPairInfo.getBehaviorBitSet();
                saveBehaviorBitSet = savePairInfo.getBehaviorBitSet();
                this.updateFenceLevel(sendBehaviorBitSet, saveBehaviorBitSet, copytype, fenceLevelCheck, fenceLevelBitSet);
                this.updateCFWData(sendBehaviorBitSet, saveBehaviorBitSet, copytype, cfwDataCheck, cfwDataSelectKey);
                sendPairList.add(sendPairInfo);
            }
            Collections.sort(sendPairList, new SJctrTrueCopyPairInfoComparator());
            confirmData.setPairInfoList(sendPairList);
            confirmData.setCopyType(copytype);
            confirmData.setLUPathMap(ldevLUPathMap);
            confirmData.setNeedData(this);
            ArrayList<SJctrEditTcPairOptionsConfirmData> confirmDataList = new ArrayList<SJctrEditTcPairOptionsConfirmData>();
            confirmDataList.add(confirmData);
            this.putCache(SJctrEditTcPairOptionsConfirmData.class, confirmDataList);
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107003);
        }
        SJctrRemoteReplicationUtility.setFinishChangeCheck(this, false);
        return true;
    }

    private void updateFenceLevel(BitSet sendBehaviorBitSet, BitSet saveBehaviorBitSet, int copytype, boolean fenceLevelCheck, BitSet fenceLevelBitSet) {
        if (copytype == 1 || fenceLevelCheck) {
            sendBehaviorBitSet.set(2, fenceLevelBitSet.get(0));
            sendBehaviorBitSet.set(3, fenceLevelBitSet.get(1));
            sendBehaviorBitSet.set(4, fenceLevelBitSet.get(2));
        } else {
            sendBehaviorBitSet.set(2, saveBehaviorBitSet.get(2));
            sendBehaviorBitSet.set(3, saveBehaviorBitSet.get(3));
            sendBehaviorBitSet.set(4, saveBehaviorBitSet.get(4));
        }
    }

    private void updateCFWData(BitSet sendBehaviorBitSet, BitSet saveBehaviorBitSet, int copytype, boolean cfwDataCheck, int cfwDataSelectKey) {
        if (copytype == 0) {
            if (cfwDataCheck) {
                switch (cfwDataSelectKey) {
                    case 1: {
                        sendBehaviorBitSet.set(0, true);
                        break;
                    }
                    case 0: {
                        sendBehaviorBitSet.set(0, false);
                        break;
                    }
                }
            } else {
                sendBehaviorBitSet.set(0, saveBehaviorBitSet.get(0));
            }
        }
    }

    private void initialSetupDataModel(List<SJmoTrueCopyPairVolInfo> pairList, int copytype) {
        SJctrFenceLvDataModel fenceLevelInf = (SJctrFenceLvDataModel)this.getDataObjectModel(KEY_FENCE_LEVEL_INF);
        fenceLevelInf.createFenceLevelItem();
        SJctrComboBoxDataModel fenceLevelComboBox = (SJctrComboBoxDataModel)fenceLevelInf.getDataModel("COM_FENCE_LEVEL_COMBOBOX");
        SJctrCfwDataDataModel cfwDataInf = (SJctrCfwDataDataModel)this.getDataObjectModel(KEY_CFW_DATA_INF);
        cfwDataInf.createCfwDataItem();
        SJctrComboBoxDataModel cfwDataComboBox = (SJctrComboBoxDataModel)cfwDataInf.getDataModel("COM_CFW_DATA_COMBOBOX");
        SJmoTrueCopyPairVolInfo firstPairInfo = pairList.get(0);
        BitSet firstOptionInfo = firstPairInfo.getBehaviorBitSet();
        BitSet firstFenceLevel = firstOptionInfo.get(2, 4);
        boolean firstCFWData = firstOptionInfo.get(0);
        boolean fenceLevelMixFlg = false;
        boolean cfwDataMixFlg = false;
        for (SJmoTrueCopyPairVolInfo pairInfo : pairList) {
            BitSet optionInfo = pairInfo.getBehaviorBitSet();
            BitSet onotherFenceLevel = optionInfo.get(2, 4);
            if (!firstFenceLevel.equals(onotherFenceLevel)) {
                fenceLevelMixFlg = true;
                if (copytype == 1) break;
            }
            if (copytype != 0) continue;
            boolean cfwdata = optionInfo.get(0);
            if (firstCFWData != cfwdata) {
                cfwDataMixFlg = true;
            }
            if (!fenceLevelMixFlg || !cfwDataMixFlg) continue;
            break;
        }
        if (!fenceLevelMixFlg) {
            fenceLevelComboBox.removeItem("-1");
            int fencelevel = this.convertBitSetToIntFenceLevel(firstFenceLevel);
            switch (fencelevel) {
                case 0: {
                    fenceLevelComboBox.setSelection(String.valueOf(0));
                    break;
                }
                case 1: {
                    fenceLevelComboBox.setSelection(String.valueOf(1));
                    break;
                }
                case 2: {
                    fenceLevelComboBox.setSelection(String.valueOf(2));
                    break;
                }
            }
        } else {
            fenceLevelComboBox.setSelection(String.valueOf("-1"));
        }
        if (!cfwDataMixFlg) {
            cfwDataComboBox.removeItem("-1");
            if (firstCFWData) {
                cfwDataComboBox.setSelection(String.valueOf(1));
            } else {
                cfwDataComboBox.setSelection(String.valueOf(0));
            }
        } else {
            cfwDataComboBox.setSelection(String.valueOf("-1"));
        }
        SJctrSimpleDataModel copyType = (SJctrSimpleDataModel)this.getDataObjectModel(KEY_COPY_TYPE_INF);
        ((SJctrDataObject)copyType.getManageData()).setData(KEY_COPY_TYPE, copytype);
        this.putCache("COM_EDIT_PAIR_OPTIONS_CACHE_PAIR_VOL_INFORMATION", pairList);
        ArrayList<SJmoTrueCopyPairVolInfo> pairListCopy = new ArrayList<SJmoTrueCopyPairVolInfo>(pairList.size());
        for (SJmoTrueCopyPairVolInfo pairInfo : pairList) {
            try {
                pairListCopy.add((SJmoTrueCopyPairVolInfo)pairInfo.clone());
            }
            catch (CloneNotSupportedException e) {
                this.logUty.putlog("initialSetupDataModel", "catch CloneNotSupportedException");
                SJctrError err = new SJctrError(210, 22, 107002);
                SJcException exp = err.createException();
                throw exp;
            }
        }
        this.putCache("COM_EDIT_PAIR_OPTIONS_CACHE_PAIR_VOL_INFORMATION_ORIGINAL", pairListCopy);
    }

    private int convertBitSetToIntFenceLevel(BitSet firstFenceLevel) {
        int fencelevel = -1;
        if (firstFenceLevel.equals(SJctrRemoteReplicationDataMacro.bsNever)) {
            fencelevel = 0;
        } else if (firstFenceLevel.equals(SJctrRemoteReplicationDataMacro.bsSVolData)) {
            fencelevel = 1;
        } else if (firstFenceLevel.equals(SJctrRemoteReplicationDataMacro.bsSVolStatus)) {
            fencelevel = 2;
        }
        return fencelevel;
    }

    private BitSet convertIntToBitSetFenceLevel(int fenceLevel) {
        BitSet ret = new BitSet(3);
        switch (fenceLevel) {
            case 0: {
                ret = SJctrRemoteReplicationDataMacro.bsNever;
                break;
            }
            case 1: {
                ret = SJctrRemoteReplicationDataMacro.bsSVolData;
                break;
            }
            case 2: {
                ret = SJctrRemoteReplicationDataMacro.bsSVolStatus;
                break;
            }
        }
        return ret;
    }
}

