/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.releasercmddevs;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrGuidance;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.wizard.SJctrSubWizard;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.replication.remote.releasercmddevs.SJctrReleaseRcmdDevsAC;
import sanproject.sn2.controller.wizard.replication.remote.releasercmddevs.SJctrReleaseRcmdDevsConfirmDC;
import sanproject.sn2.controller.wizard.replication.remote.releasercmddevs.SJctrReleaseRcmdDevsConfirmData;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetUniversalReplicatorJnlGrpMgr;
import sanproject.sn2.model.connector.kind.SJmoGetUniversalReplicatorPairVolInfoMgr;
import sanproject.sn2.model.data.replication.SJmoMirrorIndex;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorJnlGrpMirror;
import sanproject.sn2.model.data.replication.remote.manager.SJmoUniversalReplicatorJnlGrpMgr;

public class SJctrReleaseRcmdDevsSubWizard
extends SJctrSubWizard {
    public static final String TITLE = "RELEASE_RCMD_DEV";
    private static final Class<?> CONFIRM_DC = SJctrReleaseRcmdDevsConfirmDC.class;

    @Override
    public void constructConfirmData(SJctrWizardWindowDC wizard) {
        try {
            SJctrUserController uc = wizard.getOwner();
            SJctrRelatedDispDataObject related = uc.getRelatedDispData(CONFIRM_DC);
            SJctrRelatedDispDataObject wizardWindowRelateDisp = uc.getRelatedDispData(SJctrWizardWindowDC.class);
            SJctrWizardWindowDC dc = (SJctrWizardWindowDC)uc.getDataController(wizardWindowRelateDisp);
            List<SJmoMirrorIndex> selectedMirrorList = dc.getProxy().getCache("KEY_SELECTED_MIRROR");
            if (null == selectedMirrorList) {
                dc.getLogUty().putlog("constructConfirmData", "Inherited data list is null.");
                SJctrError err = new SJctrError(210, 22, 107002);
                SJcException exp = err.createException();
                throw exp;
            }
            if (0 == selectedMirrorList.size()) {
                dc.getLogUty().putlog("constructConfirmData", "Size of inherited data list is zero.");
                SJctrError err = new SJctrError(210, 22, 107002);
                SJcException exp = err.createException();
                throw exp;
            }
            SJmoUniversalReplicatorJnlGrpMgr allJnlInfo = SJctrRemoteReplicationUtility.getSJmoUniversalReplicatorJnlGrpMgr(dc);
            List<SJmoUniversalReplicatorJnlGrpMirror> mirrorExist = SJctrRemoteReplicationUtility.checkAndGetExistMirrorInfo(selectedMirrorList, allJnlInfo);
            SJctrRemoteReplicationUtility.checkTopJnlVolRsSelectedMirror(dc, mirrorExist);
            SJctrRemoteReplicationUtility.checkRcmdDevRs(mirrorExist, allJnlInfo, dc);
            int copytype = SJctrRemoteReplicationUtility.checkCopyTypeForMirror(mirrorExist, allJnlInfo);
            if (copytype == -1) {
                dc.getLogUty().putlog("constructConfirmData", "Copy type is mixed.");
                SJctrError err = new SJctrError(210, 22, 206010);
                SJcException exp = err.createException();
                throw exp;
            }
            int iRtn = SJctrRemoteReplicationUtility.checkReleaseRCmdDevs(mirrorExist, allJnlInfo);
            if (iRtn == 1) {
                uc.getLogUty().putlog("constructConfirmData", "Remote Command Device is unallocated.");
                SJctrError err = new SJctrError(210, 22, 206064);
                SJcException exp = err.createException();
                throw exp;
            }
            if (iRtn == -1) {
                uc.getLogUty().putlog("constructConfirmData", "Remote Command Device Data is invalid.");
                SJctrError err = new SJctrError(210, 22, 107002);
                SJcException exp = err.createException();
                throw exp;
            }
            SJctrReleaseRcmdDevsConfirmData confirmData = new SJctrReleaseRcmdDevsConfirmData();
            ArrayList<SJctrReleaseRcmdDevsConfirmData> confirmDataList = new ArrayList<SJctrReleaseRcmdDevsConfirmData>();
            confirmData.setMirrorsInfo(mirrorExist);
            confirmData.setJnalGrpMgrInfo(allJnlInfo);
            confirmData.setCopyType(copytype);
            confirmData.setNeedData(dc);
            confirmDataList.add(confirmData);
            dc.getProxy().putCache(SJctrReleaseRcmdDevsConfirmData.class, confirmDataList);
            SJctrReleaseRcmdDevsAC applyCntl = new SJctrReleaseRcmdDevsAC();
            applyCntl.setApplyData(confirmData);
            wizard.addConfirmData(applyCntl, related);
        }
        catch (SJcException exp) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(exp, 107002);
        }
    }

    @Override
    public Class<?>[] getClassList() {
        Class[] Class2 = new Class[]{};
        return Class2;
    }

    @Override
    public SJctrGuidance getTaskNameGuidance() {
        SJctrGuidance guidance = new SJctrGuidance("COMMON", TITLE);
        return guidance;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        HashSet<SJctrGetDirectWrapper> set = new HashSet<SJctrGetDirectWrapper>();
        SJmoGetKind_IF kind = new SJmoGetUniversalReplicatorJnlGrpMgr();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetUniversalReplicatorPairVolInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    @Override
    public Class<?> getConfirmClass() {
        return CONFIRM_DC;
    }
}

