/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.removeremoteconn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorTableModel;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.comparator.SJctrErrorColumnDataComparator;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.wizard.SJctrConfirmDataController;
import sanproject.sn2.controller.wizard.replication.com.SJctrRcOperationError;
import sanproject.sn2.controller.wizard.replication.remote.removeremoteconn.SJctrRemoveRemoteConnectionConfirmData;
import sanproject.sn2.controller.wizard.replication.remote.removeremoteconn.model.SJctrSelectedRemoveRemoteConnectTableModel;
import sanproject.sn2.controller.wizard.replication.remote.viewremoteconnprops.SJctrViewRemoteConnPropsDC;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetPathInfo;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationRCUInfo;

public class SJctrRemoveRemoteConnectionConfirmDC
extends SJctrConfirmDataController {
    private static final int DISP_ID = 0x110B101;
    private static final String KEY_DETAIL = "COM_DETAIL";

    public SJctrRemoveRemoteConnectionConfirmDC() throws SJcException {
        super(0x110B101);
        this.initDataModel();
    }

    private void initDataModel() {
        SJctrSelectedRemoveRemoteConnectTableModel selRMConnTable = new SJctrSelectedRemoveRemoteConnectTableModel();
        selRMConnTable.setPaging(false);
        this.addDataObjectModel("COM_TABLE", selRMConnTable);
        SJctrButtonDataModel detailButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_DETAIL, detailButton);
        detailButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrRemoveRemoteConnectionConfirmDC.this.makeDetailAction(event);
            }
        });
    }

    private void makeDetailAction(SJctrItemSelectEvent<?> event) {
        try {
            SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel("COM_TABLE");
            List<Object> selectedRowList = table.getSelectedRowData();
            if (selectedRowList.size() == 0) {
                this.getLogUty().putlog("makeDetailAction", "not selected");
                return;
            }
            ArrayList<SJmoRemoteReplicationRCUInfo> selectedRCU = new ArrayList<SJmoRemoteReplicationRCUInfo>();
            for (Object rowObj : selectedRowList) {
                selectedRCU.add((SJmoRemoteReplicationRCUInfo)rowObj);
            }
            HashMap param = new HashMap();
            param.put("KEY_REMOTE_SELECTED_CONNECTION", selectedRCU);
            param.put(SJmoGetPortDetail.class.getName(), SJctrReplicationUtility.getSJmoPortDetail(this));
            List<?> info = this.getProxy().getCache(SJmoGetPortIscsiTargetPathInfo.class);
            if (info == null) {
                info = new ArrayList();
            }
            param.put(SJmoGetPortIscsiTargetPathInfo.class.getName(), info);
            ArrayList<Integer> attributeList = new ArrayList<Integer>(1);
            attributeList.add(5);
            param.put("KEY_REMOTE_SELECTED_CONNECTION_ATTRIBUTE", attributeList);
            SJctrRelatedDispDataObject wizardRelated = this.createDialog(SJctrViewRemoteConnPropsDC.class, param);
            this.addUpdateDisp(wizardRelated);
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107004);
        }
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        SJctrRemoveRemoteConnectionConfirmData confirmData = null;
        List<?> confirmDataList = this.getCache(SJctrRemoveRemoteConnectionConfirmData.class);
        if (null == confirmDataList) {
            this.logUty.putlog("checkStartData", "Confirmation data list is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == confirmDataList.size()) {
            this.logUty.putlog("checkStartData", "Size of confirmation data list is zero.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        confirmData = (SJctrRemoveRemoteConnectionConfirmData)confirmDataList.get(0);
        if (null == confirmData) {
            this.logUty.putlog("checkStartData", "Confirmation data is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        SJctrTableDataModel confirmConTable = (SJctrTableDataModel)this.getDataObjectModel("COM_TABLE");
        SJctrRemoveRemoteConnectionConfirmData confirmData = (SJctrRemoveRemoteConnectionConfirmData)this.getProxy().getCache(SJctrRemoveRemoteConnectionConfirmData.class).get(0);
        if (confirmConTable instanceof SJctrSelectedRemoveRemoteConnectTableModel) {
            ((SJctrSelectedRemoveRemoteConnectTableModel)confirmConTable).setBasicDataList(confirmData.getRCUInfo());
        }
        return true;
    }

    @Override
    protected void makeDataObjectModel(Collection<String> keyList) throws SJcException {
        List<?> confirmDataList = this.getCache(SJctrRemoveRemoteConnectionConfirmData.class);
        SJctrRemoveRemoteConnectionConfirmData confirmData = (SJctrRemoveRemoteConnectionConfirmData)confirmDataList.get(0);
        this.getProxy().getCacheMap().putAll(confirmData.getNeedDataMap());
        super.makeDataObjectModel(keyList);
    }

    @Override
    public Map<String, List<?>> getConfirmData() {
        HashMap retMap = new HashMap();
        List<?> confirmDataList = this.getCache(SJctrRemoveRemoteConnectionConfirmData.class);
        retMap.put(SJctrRemoveRemoteConnectionConfirmData.class.getName(), confirmDataList);
        return retMap;
    }

    @Override
    public void getConfirmWithStatus(List<Object> result) throws SJcException {
        SJctrRemoveRemoteConnectionConfirmData confirmData = (SJctrRemoveRemoteConnectionConfirmData)this.getProxy().getCache(SJctrRemoveRemoteConnectionConfirmData.class).get(0);
        SJctrSelectedRemoveRemoteConnectTableModel confirmConTable = (SJctrSelectedRemoveRemoteConnectTableModel)this.getDataObjectModel("COM_TABLE");
        List<SJmoRemoteReplicationRCUInfo> rmvRCUList = confirmData.getRCUInfo();
        confirmConTable.setBasicDataList(rmvRCUList);
        confirmConTable.setBasicData(SJmoGetPortDetail.class, confirmData.getNeedDataMap().get(SJmoGetPortDetail.class.getName()));
        confirmConTable.makeDataModel();
        List tempList = (List)result.get(0);
        List errorList = (List)tempList.get(0);
        ArrayList<SJctrErrorColumnData> errColumnList = new ArrayList<SJctrErrorColumnData>(rmvRCUList.size());
        int erroSsidCount = errorList.size();
        int erroIndex = 0;
        int totalSSIDs = 0;
        int rcuIndex = 0;
        boolean bAdded = false;
        SJmoRemoteReplicationRCUInfo rcuInfo = null;
        while (rcuIndex < rmvRCUList.size() && erroIndex < erroSsidCount) {
            SJctrRcOperationError error;
            int index;
            if (!bAdded) {
                rcuInfo = rmvRCUList.get(rcuIndex);
                totalSSIDs = rcuInfo.getICUFree() == 0 ? (totalSSIDs += rcuInfo.getINumofSSID()) : ++totalSSIDs;
            }
            if ((index = (error = (SJctrRcOperationError)errorList.get(erroIndex)).getIndex()) < totalSSIDs) {
                if (!bAdded) {
                    SJctrErrorColumnData errColumn = new SJctrErrorColumnData(rcuInfo, error);
                    errColumnList.add(errColumn);
                    bAdded = true;
                }
                ++erroIndex;
                continue;
            }
            ++rcuIndex;
            bAdded = false;
        }
        SJctrErrorTableModel errTable = new SJctrErrorTableModel();
        this.addDataObjectModel("COM_TABLE", errTable);
        errTable.initialize(confirmConTable, errColumnList, new SJctrErrorColumnDataComparator());
    }
}

