/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.resynchactgs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorTableModel;
import sanproject.sn2.controller.com.SJctrHaUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.comparator.SJctrErrorColumnDataComparator;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.wizard.SJctrConfirmDataController;
import sanproject.sn2.controller.wizard.replication.com.SJctrHaCtgInfo;
import sanproject.sn2.controller.wizard.replication.com.SJctrRcOperationError;
import sanproject.sn2.controller.wizard.replication.com.SJctrRcOperationErrorForCtg;
import sanproject.sn2.controller.wizard.replication.remote.hactgprops.SJctrHaCtgPropsDC;
import sanproject.sn2.controller.wizard.replication.remote.resynchactgs.SJctrResyncHaCtgsConfirmData;
import sanproject.sn2.controller.wizard.replication.remote.resynchactgs.SJctrResyncHaCtgsConfirmTableModel;
import sanproject.sn2.controller.wizard.replication.remote.resynchactgs.SJctrResyncHaCtgsConfirmTableModelErrorDetail;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualDkc;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualLdev;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;

public class SJctrResyncHaCtgsConfirmDC
extends SJctrConfirmDataController {
    private static final int DISP_ID = 17834031;
    private static final String KEY_TABLE = "COM_TABLE";
    private static final String KEY_DETAIL = "COM_DETAIL";
    public static final String KEY_DETAIL_DISP = "COM_DETAIL_DISP";
    public static final int DETAIL_HIDE = 0;
    public static final int DETAIL_SHOW = 1;
    private static final String LOG_TITLE = SJctrResyncHaCtgsConfirmDC.class.getSimpleName();

    public SJctrResyncHaCtgsConfirmDC() {
        super(17834031);
        this.initDataModel();
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        SJctrResyncHaCtgsConfirmData confirmData = null;
        List<?> confirmDataList = this.getCache(SJctrResyncHaCtgsConfirmData.class);
        if (null == confirmDataList) {
            SJctrLogUty.error(LOG_TITLE, "checkStartData", "Confirmation data is null.");
            throw SJctrHaUtility.createRemoteReplicationException(107001);
        }
        if (0 == confirmDataList.size()) {
            SJctrLogUty.error(LOG_TITLE, "checkStartData", "Size of confirmation data list is zero.");
            throw SJctrHaUtility.createRemoteReplicationException(107001);
        }
        confirmData = (SJctrResyncHaCtgsConfirmData)confirmDataList.get(0);
        if (null == confirmData) {
            SJctrLogUty.error(LOG_TITLE, "checkStartData", "Confirmation data is null.");
            throw SJctrHaUtility.createRemoteReplicationException(107001);
        }
        return ret;
    }

    private void initDataModel() {
        SJctrResyncHaCtgsConfirmTableModel confirmTable = new SJctrResyncHaCtgsConfirmTableModel();
        confirmTable.setPaging(false);
        this.addDataObjectModel(KEY_TABLE, confirmTable);
        SJctrButtonDataModel detailButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_DETAIL, detailButton);
        detailButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrResyncHaCtgsConfirmDC.this.makeDetailAction(event);
            }
        });
    }

    private void makeDetailAction(SJctrItemSelectEvent<?> event) {
        SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE);
        List<Object> selectedRowList = table.getSelectedRowData();
        if (selectedRowList.size() == 0) {
            this.getLogUty().putlog("makeDetailAction", "not selected");
            return;
        }
        HashMap param = new HashMap();
        param.put("KEY_SELECTED_CTG", selectedRowList);
        param.put("COM_ALL_HA_PAIRS", ((SJctrResyncHaCtgsConfirmTableModel)table).getAllHaPairs());
        param.put(SJmoGetLdevDetail.class.getName(), ((SJctrResyncHaCtgsConfirmTableModel)table).getConfirmLdevDetails());
        param.put(SJmoGetHUVMVirtualDkc.class.getName(), this.getProxy().getCache(SJmoGetHUVMVirtualDkc.class));
        param.put(SJmoGetHUVMVirtualLdev.class.getName(), this.getProxy().getCache(SJmoGetHUVMVirtualLdev.class));
        ArrayList<Integer> fromDisp = new ArrayList<Integer>(1);
        fromDisp.add(1);
        param.put("COM_FROM_DISP", fromDisp);
        SJctrRelatedDispDataObject dialogRelated = this.createDialog(SJctrHaCtgPropsDC.class, param);
        this.addUpdateDisp(dialogRelated);
    }

    @Override
    protected void makeDataObjectModel(Collection<String> keyList) throws SJcException {
        List<?> confirmDataList = this.getCache(SJctrResyncHaCtgsConfirmData.class);
        SJctrResyncHaCtgsConfirmData confirmData = (SJctrResyncHaCtgsConfirmData)confirmDataList.get(0);
        this.getProxy().getCacheMap().putAll(confirmData.getNeedDataMap());
        super.makeDataObjectModel(keyList);
    }

    @Override
    public boolean checkConstructData() {
        SJctrTableDataModel confirmTable = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE);
        if (confirmTable instanceof SJctrResyncHaCtgsConfirmTableModel) {
            SJctrResyncHaCtgsConfirmData confirmData = (SJctrResyncHaCtgsConfirmData)this.getProxy().getCache(SJctrResyncHaCtgsConfirmData.class).get(0);
            ((SJctrResyncHaCtgsConfirmTableModel)confirmTable).setBasicDataList(confirmData.getCtgsInfo());
            ((SJctrResyncHaCtgsConfirmTableModel)confirmTable).setAllHaPairs(confirmData.getAllHaPairs());
            if (confirmData.getConfirmLdevDetails() == null) {
                this.getManageData().setData(KEY_DETAIL_DISP, 0);
            } else {
                this.getManageData().setData(KEY_DETAIL_DISP, 1);
                ((SJctrResyncHaCtgsConfirmTableModel)confirmTable).setConfirmLdevDetails(confirmData.getConfirmLdevDetails());
            }
        }
        return true;
    }

    @Override
    public Map<String, List<?>> getConfirmData() {
        HashMap retMap = new HashMap();
        List<?> confirmDataList = this.getCache(SJctrResyncHaCtgsConfirmData.class);
        retMap.put(SJctrResyncHaCtgsConfirmData.class.getName(), confirmDataList);
        return retMap;
    }

    @Override
    public void getConfirmWithStatus(List<Object> result) throws SJcException {
        SJctrResyncHaCtgsConfirmData confirmData = (SJctrResyncHaCtgsConfirmData)this.getProxy().getCache(SJctrResyncHaCtgsConfirmData.class).get(0);
        SJctrResyncHaCtgsConfirmTableModel confirmTable = (SJctrResyncHaCtgsConfirmTableModel)this.getDataObjectModel(KEY_TABLE);
        confirmTable.setBasicDataList(confirmData.getCtgsInfo());
        List list = (List)result.get(0);
        List errList = (List)list.get(0);
        Object err = errList.get(0);
        if (err instanceof SJctrRcOperationError) {
            confirmTable.makeDataModel();
            List tempList = (List)result.get(0);
            List errorList = (List)tempList.get(0);
            ArrayList<SJctrErrorColumnData> errColumnList = new ArrayList<SJctrErrorColumnData>(errorList.size());
            List<SJctrHaCtgInfo> rowDataList = confirmData.getCtgsInfo();
            for (SJctrRcOperationError error : errorList) {
                int index = error.getIndex();
                if (0 > index || rowDataList.size() <= index) continue;
                SJctrHaCtgInfo haCtgInfo = rowDataList.get(index);
                SJctrErrorColumnData errColumn = new SJctrErrorColumnData(haCtgInfo, error);
                errColumnList.add(errColumn);
            }
            SJctrErrorTableModel errTable = new SJctrErrorTableModel();
            this.addDataObjectModel(KEY_TABLE, errTable);
            errTable.initialize(confirmTable, errColumnList, new SJctrErrorColumnDataComparator());
        } else if (err instanceof SJctrRcOperationErrorForCtg) {
            List tempList = (List)result.get(0);
            List errorList = (List)tempList.get(0);
            ArrayList<SJctrErrorColumnData> errColumnList = new ArrayList<SJctrErrorColumnData>(errorList.size());
            List<SJctrHaCtgInfo> rowDataList = confirmData.getCtgsInfo();
            for (SJctrRcOperationErrorForCtg error : errorList) {
                int index = error.getIndex();
                if (0 > index || rowDataList.size() <= index) continue;
                SJctrHaCtgInfo haCtgInfo = rowDataList.get(index);
                SJctrErrorColumnData errColumn = new SJctrErrorColumnData(haCtgInfo, error);
                errColumnList.add(errColumn);
            }
            SJctrResyncHaCtgsConfirmTableModelErrorDetail errTable = new SJctrResyncHaCtgsConfirmTableModelErrorDetail(errColumnList);
            errTable.setBasicDataList(confirmData.getCtgsInfo());
            errTable.initGuidance(this.getComUtility());
            this.addDataObjectModel(KEY_TABLE, errTable);
            errTable.makeDataModel();
        } else {
            SJctrLogUty.error(LOG_TITLE, "getConfirmWithStatus", "Instance of error is invalid.");
            throw SJctrHaUtility.createRemoteReplicationException(107001);
        }
    }
}

