/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.splittcpairs;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sanproject.serverux.dataimpl.RMCPSupend1Pair;
import sanproject.serverux.dataimpl.RMCPSupendPair;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.wizard.replication.com.SJctrOperationTcPairBaseAC;
import sanproject.sn2.controller.wizard.replication.remote.splittcpairs.SJctrSplitTCPairsConfirmData;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.replication.SJmoReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.remote.SJmoTrueCopyPairVolInfo;

public class SJctrSplitTCPairsAC
extends SJctrOperationTcPairBaseAC {
    private static final long serialVersionUID = -4079866773891709393L;
    private int svolwrite = -1;
    private int pvolwrite = -1;
    private int ssb = -1;
    private Map<Integer, List<SJmoPortLunDetail>> portLunMap = null;
    private final int SHIFT_COPY_TYPE = 0;
    private final int SHIFT_P_WRITE = 1;
    private final int SHIFT_PAIRPOS = 2;
    private final int SHIFT_SSB = 3;
    private final int SHIFT_S_WRITE = 4;

    public void setApplyData(SJctrSplitTCPairsConfirmData confirmData) {
        this.applyInfo = confirmData.getPairsInfo();
        this.copyType = confirmData.getCopyType();
        this.pvolwrite = confirmData.getPvolWrite();
        this.portLunMap = confirmData.getLUPathMap();
        if (this.copyType == 1) {
            this.svolwrite = confirmData.getSvolWrite();
        } else if (this.copyType == 0) {
            this.ssb = confirmData.getSSBTransfer();
        }
    }

    @Override
    public ArrayList<?> getSetList() {
        ArrayList<RMCPSupendPair> applyList = null;
        ArrayList<RMCPSupendPair> applyData = new ArrayList<RMCPSupendPair>();
        RMCPSupend1Pair[] suspendPairList = new RMCPSupend1Pair[this.applyInfo.size()];
        for (int i = 0; i < this.applyInfo.size(); ++i) {
            SJmoTrueCopyPairVolInfo pairInfo = (SJmoTrueCopyPairVolInfo)this.applyInfo.get(i);
            RMCPSupend1Pair suspend1Pair = new RMCPSupend1Pair();
            int localPairPos = SJctrRemoteReplicationUtility.getPairPos(pairInfo);
            SJmoReplicationPairVolInfo localVol = SJctrRemoteReplicationUtility.getLocalVolumeForTcPair(pairInfo);
            suspend1Pair.CUNo = localVol.getSCu();
            suspend1Pair.LDEVNo = localVol.getSLdev();
            suspend1Pair.LDKC = localVol.getSLdkc();
            suspend1Pair.PairLDEVNo = this.getPairLDEVNo(pairInfo);
            if (localPairPos == 0) {
                suspend1Pair.PLU = SJctrRemoteReplicationUtility.getLocalRMCPHorcLU(localVol, this.copyType, this.portLunMap);
                suspend1Pair.SLU = SJctrRemoteReplicationUtility.getRemoteRMCPHorcLU(pairInfo, this.copyType);
            } else {
                suspend1Pair.PLU = SJctrRemoteReplicationUtility.getRemoteRMCPHorcLU(pairInfo, this.copyType);
                suspend1Pair.SLU = SJctrRemoteReplicationUtility.getLocalRMCPHorcLU(localVol, this.copyType, this.portLunMap);
            }
            suspend1Pair.SN = pairInfo.getStrPairSN();
            suspend1Pair.SSID = this.getPairSSID(pairInfo);
            suspend1Pair.Mode = this.getMode(pairInfo, localPairPos);
            suspendPairList[i] = suspend1Pair;
        }
        RMCPSupendPair suspendPair = new RMCPSupendPair();
        suspendPair.Suspend1Pair = suspendPairList;
        suspendPair.NumofPair = suspendPairList.length;
        applyData.add(suspendPair);
        applyList = applyData;
        return applyList;
    }

    private int getMode(SJmoTrueCopyPairVolInfo pairInfo, int localPairPos) {
        int rtn = 0;
        rtn |= this.copyType << 0;
        rtn = localPairPos == 0 ? (rtn |= this.pvolwrite << 1) : (rtn |= 2);
        rtn |= localPairPos << 2;
        rtn = localPairPos == 0 && this.copyType == 0 ? (rtn |= this.ssb << 3) : (rtn |= 8);
        if (localPairPos == 0 && this.copyType == 1) {
            rtn |= this.svolwrite << 4;
        }
        return rtn;
    }

    private int getPairLDEVNo(SJmoTrueCopyPairVolInfo pairInfo) {
        int rtn = 0;
        if (this.copyType == 0) {
            rtn = pairInfo.getSLdev();
        }
        return rtn;
    }

    private int getPairSSID(SJmoTrueCopyPairVolInfo pairInfo) {
        int rtn = 0;
        if (pairInfo.getICUFree() != 1) {
            rtn = pairInfo.getIPairSSID();
        }
        return rtn;
    }
}

