/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.viewpairprops;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import sanproject.serverux.dataimpl.HURget1PairDetail;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.account.com.SJctrTextLabelDataModel;
import sanproject.sn2.controller.wizard.replication.com.SJctrRcMessageEventListener;
import sanproject.sn2.controller.wizard.replication.com.SJctrRemoteReplicationDataMacro;
import sanproject.sn2.controller.wizard.replication.remote.viewpairprops.SJctrGetHurPairDetail;
import sanproject.sn2.controller.wizard.replication.remote.viewpairprops.SJctrUrViewPairPropertiesDetailDataModel;
import sanproject.sn2.controller.wizard.replication.remote.viewpairprops.SJctrUrViewPairPropertiesPropertiesDataModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetClprInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevLuseInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortHostGroupInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRemoteReplicationMRCUInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetSubsystemInfo;
import sanproject.sn2.model.connector.kind.SJmoGetUniversalReplicatorJnlGrpMgr;
import sanproject.sn2.model.connector.kind.SJmoGetUniversalReplicatorPairVolInfoMgr;
import sanproject.sn2.model.data.replication.SJmoReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorPairVolInfo;
import sanproject.sn2.model.data.replication.remote.manager.SJmoUniversalReplicatorPairVolInfoMgr;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrUrViewPairPropertiesDC
extends SJctrDialogDataController {
    private static final int DISP_ID = 35319880;
    private List<SJmoUniversalReplicatorPairVolInfo> urPairList = new ArrayList<SJmoUniversalReplicatorPairVolInfo>();
    private int currentIndex = -1;
    private SJmoUniversalReplicatorPairVolInfoMgr allPairMgr = null;
    List<HURget1PairDetail> rmiPairDetail = null;
    private List<SJmoReplicationPairVolInfo> selectedPairLocalVolList = new ArrayList<SJmoReplicationPairVolInfo>();

    public SJctrUrViewPairPropertiesDC() {
        super(35319880);
        this.initDataModel();
        this.initListener();
    }

    private void initDataModel() {
        this.addDataObjectModel("COM_PAIR_PROPERTIES_INF", new SJctrUrViewPairPropertiesPropertiesDataModel());
        this.addDataObjectModel("COM_PAIR_DETAIL_INF", new SJctrUrViewPairPropertiesDetailDataModel());
        this.addDataObjectModel("COM_PAGE_NUM", new SJctrTextLabelDataModel());
        Set<SJctrFooterDataModel.Button> footerButton = Collections.unmodifiableSet(EnumSet.of(SJctrFooterDataModel.Button.BACK, SJctrFooterDataModel.Button.NEXT, SJctrFooterDataModel.Button.CLOSE));
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(footerButton));
    }

    private void initListener() {
        this.addMessageEventListener(SJctrWizardDataController.WIZ_MSG.BACK, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrUrViewPairPropertiesDC.this.backAction();
            }
        });
        this.addMessageEventListener(SJctrWizardDataController.WIZ_MSG.NEXT, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrUrViewPairPropertiesDC.this.nextAction();
            }
        });
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetUniversalReplicatorPairVolInfoMgr();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevNicknameInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetClprInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevLuseInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortLunInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortHostGroupInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetUniversalReplicatorJnlGrpMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRemoteReplicationMRCUInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetSubsystemInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    @Override
    public boolean checkStartData() {
        List<?> infoList = this.getProxy().getCache("KEY_SELECTED_REMOTE_VOL");
        if (null == infoList) {
            this.logUty.putlog("checkStartData", "Information of data list is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (infoList.isEmpty()) {
            this.logUty.putlog("checkStartData", "Size of data list is zero.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return true;
    }

    @Override
    public boolean checkConstructData() {
        try {
            SJcException exp;
            SJctrError err;
            this.allPairMgr = SJctrRemoteReplicationUtility.getSJmoUniversalReplicatorPairVolInfoMgr(this);
            SJctrReplicationUtility.getSJmoLdevDetail(this);
            SJctrReplicationUtility.getSJmoLdevNicknameInfo(this);
            SJctrReplicationUtility.getSJmoClprInfo(this);
            SJctrReplicationUtility.getSJmoLdevLuseInfo(this);
            SJctrReplicationUtility.getSJmoPortLunInfo(this);
            SJctrRemoteReplicationUtility.getSJmoRemoteReplicationMRCUInfoMgr(this);
            SJctrRemoteReplicationUtility.getSJmoSubsystemInfo(this);
            List<SJmoUniversalReplicatorPairVolInfo> selectedPairList = this.getProxy().getCache("KEY_SELECTED_REMOTE_VOL");
            List<SJmoUniversalReplicatorPairVolInfo> selectedPairRemoteVolList = SJctrRemoteReplicationUtility.getExistUrPairVolInfo(selectedPairList, this.allPairMgr);
            if (selectedPairRemoteVolList.isEmpty()) {
                this.logUty.putlog("checkConstructData", "Pair List is empty.");
                SJctrError err2 = new SJctrError(210, 22, 206502);
                SJcException exp2 = err2.createException();
                throw exp2;
            }
            this.urPairList = SJctrRemoteReplicationUtility.getExistUrPairVolInfoViewPairProps(selectedPairList, this.allPairMgr);
            if (this.urPairList.isEmpty()) {
                this.logUty.putlog("checkConstructData", "Pair List is empty in Model.");
                SJctrError err3 = new SJctrError(210, 22, 206502);
                SJcException exp3 = err3.createException();
                throw exp3;
            }
            this.rmiPairDetail = SJctrRemoteReplicationUtility.getHURgetPairDetail(this, this.urPairList);
            Iterator<HURget1PairDetail> it = this.rmiPairDetail.iterator();
            while (it.hasNext()) {
                HURget1PairDetail rmiPair = it.next();
                if (rmiPair.valid != 0) continue;
                it.remove();
            }
            for (HURget1PairDetail pairdetail : this.rmiPairDetail) {
                SJctrLogUty.info("SJctrUrViewPairPropertiesDC", "checkConstructData### HURget1PairDetail Info ###", "Hurget1PairDetail.pvol.culdev=0x" + Integer.toString(pairdetail.pvol.culdev, 16) + ":Hurget1PairDetail.svol.culdev=0x" + Integer.toString(pairdetail.svol.culdev, 16) + ":Hurget1PairDetail.status=" + pairdetail.status + ":Hurget1PairDetail.volType=" + pairdetail.volType + ":Hurget1PairDetail.mirrorID=" + pairdetail.mirrorID);
            }
            this.removeInvalidStatusPair(this.rmiPairDetail);
            if (this.rmiPairDetail.isEmpty()) {
                this.logUty.putlog("checkConstructData", "All Pair Information is Invalid.");
                err = new SJctrError(210, 22, 206502);
                exp = err.createException();
                throw exp;
            }
            this.checkSelectedPairExist(selectedPairRemoteVolList);
            if (selectedPairRemoteVolList.isEmpty()) {
                this.logUty.putlog("checkConstructData", "Pair List is empty in RMI.");
                err = new SJctrError(210, 22, 206502);
                exp = err.createException();
                throw exp;
            }
            boolean warnFlg = selectedPairList.size() != selectedPairRemoteVolList.size();
            for (SJmoUniversalReplicatorPairVolInfo selectedPairRemoteVol : selectedPairRemoteVolList) {
                this.selectedPairLocalVolList.add(SJctrRemoteReplicationUtility.getLocalVolume(selectedPairRemoteVol));
            }
            this.getManageData().setData("COM_WARN_INFO_FLG", warnFlg);
            this.getProxy().putCache(SJctrGetHurPairDetail.class, this.rmiPairDetail);
            this.updateModelPairInfo(this.rmiPairDetail);
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107002);
        }
        return true;
    }

    private void removeInvalidStatusPair(List<HURget1PairDetail> rmiPairList) {
        Iterator<HURget1PairDetail> ite = rmiPairList.iterator();
        while (ite.hasNext()) {
            HURget1PairDetail rmiPair = ite.next();
            if (this.checkViewPairPropUrStatus(rmiPair.delta, rmiPair.status)) continue;
            ite.remove();
        }
    }

    private boolean checkViewPairPropUrStatus(int iDelta, int pairStatus) {
        boolean rtn = false;
        rtn = iDelta == 0 ? SJctrRemoteReplicationDataMacro.EFFECTIVE_STATUS_OF_VIEW_PAIR_PROP_UR_URMF.contains(pairStatus) : true;
        return rtn;
    }

    @Override
    public void makeDataModel() {
        try {
            super.makeDataModel();
            this.currentIndex = 0;
            this.refDataModel();
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107002);
        }
    }

    private void refDataModel() {
        if (0 <= this.currentIndex && this.currentIndex < this.selectedPairLocalVolList.size()) {
            SJmoReplicationPairVolInfo localVol = this.selectedPairLocalVolList.get(this.currentIndex);
            List<SJmoUniversalReplicatorPairVolInfo> remoteVolList = this.getRemoteVolExistRMI(localVol);
            SJctrUrViewPairPropertiesPropertiesDataModel prop = (SJctrUrViewPairPropertiesPropertiesDataModel)this.getDataObjectModel("COM_PAIR_PROPERTIES_INF");
            prop.makeProperties(localVol, remoteVolList, this);
            SJctrUrViewPairPropertiesDetailDataModel detail = (SJctrUrViewPairPropertiesDetailDataModel)this.getDataObjectModel("COM_PAIR_DETAIL_INF");
            detail.makeSummary(remoteVolList);
            this.makePageLabel();
        }
        this.setDirtyAll();
    }

    private void makePageLabel() {
        String pageLabelString = String.valueOf(this.currentIndex + 1) + " / " + this.selectedPairLocalVolList.size();
        SJctrTextLabelDataModel pageLabel = (SJctrTextLabelDataModel)this.getDataObjectModel("COM_PAGE_NUM");
        pageLabel.setLabel(pageLabelString);
    }

    private void backAction() {
        if (0 < this.currentIndex) {
            --this.currentIndex;
        }
        this.refDataModel();
        this.updateFooter();
    }

    private void nextAction() {
        if (this.currentIndex < this.selectedPairLocalVolList.size() - 1) {
            ++this.currentIndex;
        }
        this.refDataModel();
        this.updateFooter();
    }

    @Override
    protected void updateFooter() {
        super.updateFooter();
        SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel("COM_FOOTER");
        footer.setEnableButton(SJctrFooterDataModel.Button.BACK, 0 < this.currentIndex && this.currentIndex < this.selectedPairLocalVolList.size());
        footer.setEnableButton(SJctrFooterDataModel.Button.NEXT, 0 <= this.currentIndex && this.currentIndex < this.selectedPairLocalVolList.size() - 1);
    }

    private void checkSelectedPairExist(List<SJmoUniversalReplicatorPairVolInfo> selectedPairRemoteVolList) {
        Iterator<SJmoUniversalReplicatorPairVolInfo> ite = selectedPairRemoteVolList.iterator();
        while (ite.hasNext()) {
            SJmoUniversalReplicatorPairVolInfo selectedPairRemoteVol = ite.next();
            HURget1PairDetail rmiPair = SJctrRemoteReplicationUtility.getRmiPairRelatedModelPair(this.rmiPairDetail, selectedPairRemoteVol);
            if (null != rmiPair) continue;
            ite.remove();
        }
    }

    private List<SJmoUniversalReplicatorPairVolInfo> getRemoteVolExistRMI(SJmoReplicationPairVolInfo localVol) {
        SJmoReplicationPairVolInfo modelLocalVol = this.allPairMgr.getPairVolInfo(localVol);
        SJmoReplicationPairVolInfo modelLocalVolClone = new SJmoReplicationPairVolInfo();
        try {
            modelLocalVolClone = (SJmoReplicationPairVolInfo)modelLocalVol.clone();
        }
        catch (CloneNotSupportedException e) {
            this.logUty.putlog("refDataModel", "CloneNotSupportedException occured.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        List<? extends SJmoLdevIndex> remoteVolList = SJctrRemoteReplicationUtility.getRemoteVolumeInfoList(modelLocalVolClone);
        Iterator<? extends SJmoLdevIndex> ite = remoteVolList.iterator();
        while (ite.hasNext()) {
            SJmoUniversalReplicatorPairVolInfo remotePair = (SJmoUniversalReplicatorPairVolInfo)ite.next();
            HURget1PairDetail rmiPair = SJctrRemoteReplicationUtility.getRmiPairRelatedModelPair(this.rmiPairDetail, remotePair);
            if (null != rmiPair) continue;
            ite.remove();
        }
        return remoteVolList;
    }

    private void updateModelPairInfo(List<HURget1PairDetail> rmiPairList) {
        for (SJmoUniversalReplicatorPairVolInfo remoteVol : this.urPairList) {
            HURget1PairDetail rmiPair = SJctrRemoteReplicationUtility.getRmiPairRelatedModelPair(rmiPairList, remoteVol);
            if (null == rmiPair) continue;
            remoteVol.setPairStatus(rmiPair.status);
            remoteVol.setProgress(rmiPair.progress);
            remoteVol.setPairKind(rmiPair.volType);
            remoteVol.setErrLv(rmiPair.errLevel);
            remoteVol.setExternal(rmiPair.external);
            remoteVol.setSeqChk(rmiPair.seqchk);
            remoteVol.setCTAgree(rmiPair.agree);
            remoteVol.setDelta(rmiPair.delta);
            remoteVol.setInterMix(rmiPair.intermix);
            remoteVol.setCFW(rmiPair.cfw);
            remoteVol.setCopyPriority(rmiPair.priority);
            long copyTime = SJctrRemoteReplicationUtility.getCopyTimeNumber(rmiPair.copyTime);
            remoteVol.setCopyTime(copyTime);
            remoteVol.setCtgId(rmiPair.ctGrp);
            remoteVol.setMJnlGrpId(rmiPair.mjnlGrp);
            remoteVol.setRJnlGrpId(rmiPair.rjnlGrp);
            remoteVol.setMirrorId(rmiPair.mirrorID);
            remoteVol.setPathType(rmiPair.pathType);
            remoteVol.setModelId(rmiPair.modelID);
            remoteVol.setPairSN(rmiPair.pairSN);
            remoteVol.setCtgEnable(rmiPair.ctgEnable);
            remoteVol.setMultiJnl(rmiPair.multiJNL);
            remoteVol.setHostPairEnable(rmiPair.hostPairEnable);
            remoteVol.setHostPairStatus(rmiPair.hostPairStatus);
            remoteVol.setCopyQueue(rmiPair.queu);
        }
    }
}

