/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.viewpairsyncrate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import sanproject.serverux.dataimpl.RJiHAget1PairSummary;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrHaUtility;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.comparator.SJctrHAPairInfoComparator;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.replication.com.SJctrHaDataMacro;
import sanproject.sn2.controller.wizard.replication.com.SJctrRcMessageEventListener;
import sanproject.sn2.controller.wizard.replication.com.SJctrViewPairSyncrateInfoMsgFlagData;
import sanproject.sn2.controller.wizard.replication.remote.viewpairsyncrate.SJctrViewPairSyncRateHaInfo;
import sanproject.sn2.controller.wizard.replication.remote.viewpairsyncrate.SJctrViewPairSyncRateHaTableDataModel;
import sanproject.sn2.model.connector.kind.SJmoGetClprInfo;
import sanproject.sn2.model.connector.kind.SJmoGetHAPairVolInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualDkc;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualLdev;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.replication.SJmoReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.remote.SJmoHAPairVolInfo;
import sanproject.sn2.model.data.replication.remote.manager.SJmoHAPairVolInfoMgr;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrViewPairSyncRateHaDC
extends SJctrDialogDataController {
    private static final int DISP_ID = 35450933;
    private static final String KEY_TABLE = "COM_TABLE";
    private static final String KEY_TABLE_VIEW_INFO = "COM_TABLE_VIEW_INFO";
    private static final String KEY_TABLE_HA = "COM_TABLE_HA";
    private static final String KEY_REFRESH = "COM_REFRESH";
    private static final String KEY_VIEWMSG = "COM_VIEWMSG";

    public SJctrViewPairSyncRateHaDC() throws SJcException {
        super(35450933);
        this.initDataModel();
        this.initListener();
    }

    private void initDataModel() {
        SJctrViewPairSyncRateHaTableDataModel sysncRateTblModel = new SJctrViewPairSyncRateHaTableDataModel();
        this.addDataObjectModel(KEY_TABLE, sysncRateTblModel);
        SJctrButtonDataModel refreshButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_REFRESH, refreshButton);
        this.addDataObjectModel(KEY_VIEWMSG, new SJctrViewPairSyncrateInfoMsgFlagData());
        this.getManageData().setData(KEY_TABLE_VIEW_INFO, KEY_TABLE_HA);
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(SJctrFooterDataModel.BGO_CLOSE));
    }

    private void initListener() {
        SJctrButtonDataModel refreshButton = (SJctrButtonDataModel)this.getDataObjectModel(KEY_REFRESH);
        refreshButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrViewPairSyncRateHaDC.this.fireMessageEvent(SYNC_RATE_MSG.SELECT_REFRESH);
            }
        });
        this.addMessageEventListener(SYNC_RATE_MSG.SELECT_REFRESH, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrViewPairSyncRateHaDC.this.refreshTableAction(event, dstModel);
            }
        });
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> haPairDataList = this.getProxy().getCache("KEY_SELECTED_REMOTE_VOL");
        if (null == haPairDataList) {
            this.logUty.putlog("checkStartData", "HA pair information list data is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        if (0 == haPairDataList.size()) {
            this.logUty.putlog("checkStartData", "Size of HA pair information data is zero.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJmoHAPairVolInfo haPairinfo = (SJmoHAPairVolInfo)haPairDataList.get(0);
        if (null == haPairinfo) {
            this.logUty.putlog("checkStartData", "Size of HA pair information data is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        boolean ret = true;
        try {
            List<SJmoHAPairVolInfo> viewData = this.getProxy().getCache("KEY_SELECTED_REMOTE_VOL");
            List<?> mgrDataList = SJctrRemoteReplicationUtility.getSpecifiedModelInfoMgrNotUsedCache(this, new SJmoGetHAPairVolInfoMgr());
            List<SJctrViewPairSyncRateHaInfo> rmiDataList = this.createConstructData(viewData, (SJmoHAPairVolInfoMgr)mgrDataList.get(0));
            this.setViewInfoFlag(viewData, rmiDataList);
            SJctrViewPairSyncRateHaTableDataModel pairTable = this.getPairTable();
            pairTable.setBasicDataList(rmiDataList);
            this.setTableDataNotUsedCacheNeedModelInfo(pairTable);
        }
        catch (SJcException exp) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(exp, 107002);
        }
        return ret;
    }

    public void refreshTableAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        try {
            SJctrViewPairSyncRateHaTableDataModel pairTable = this.getPairTable();
            List<Object> inheritedList = pairTable.getAllRowData();
            List<?> mgrDataList = SJctrRemoteReplicationUtility.getSpecifiedModelInfoMgrNotUsedCache(this, new SJmoGetHAPairVolInfoMgr());
            List<SJctrViewPairSyncRateHaInfo> rmiDataList = this.createConstructData(inheritedList, (SJmoHAPairVolInfoMgr)mgrDataList.get(0));
            this.setViewInfoFlag(inheritedList, rmiDataList);
            pairTable.setBasicDataList(rmiDataList);
            this.setTableDataNotUsedCacheNeedModelInfo(pairTable);
            List<Object> selectData = pairTable.getSelectedRowData();
            pairTable.doRefresh();
            pairTable.addRowSelectionList(selectData);
        }
        catch (SJcException exp) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(exp, 107004);
        }
    }

    private List<SJctrViewPairSyncRateHaInfo> createConstructData(List<SJmoHAPairVolInfo> viewData, SJmoHAPairVolInfoMgr mgrData) {
        ArrayList<SJctrViewPairSyncRateHaInfo> retList = new ArrayList();
        List<SJmoHAPairVolInfo> checkedPairList = this.getExistHaPairInfoIntoCheckPair(viewData, mgrData);
        if (checkedPairList.isEmpty()) {
            this.logUty.putlog("createConstructData", "Size of checkPairList is zero.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206502);
        }
        RJiHAget1PairSummary[] summaryInfo = SJctrHaUtility.getHAPairSummaryInfo(this, checkedPairList);
        List<SJctrViewPairSyncRateHaInfo> hapairList = this.makeDataList(summaryInfo);
        retList = this.getCheckRmiDataList(hapairList, checkedPairList);
        this.removeInvalidStatusPair(retList);
        Collections.sort(retList, new SJctrHAPairInfoComparator());
        if (0 == retList.size()) {
            this.logUty.putlog("createConstructData", "Size of ha pair list is zero.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206502);
        }
        return retList;
    }

    private List<SJctrViewPairSyncRateHaInfo> makeDataList(RJiHAget1PairSummary[] pairSummary) {
        ArrayList<SJctrViewPairSyncRateHaInfo> rtnList = new ArrayList<SJctrViewPairSyncRateHaInfo>();
        for (int i = 0; i < pairSummary.length; ++i) {
            RJiHAget1PairSummary pairDetail = pairSummary[i];
            if (null == pairDetail) continue;
            SJctrViewPairSyncRateHaInfo basicData = new SJctrViewPairSyncRateHaInfo(pairDetail);
            SJmoReplicationPairVolInfo localVolIndex = new SJmoReplicationPairVolInfo();
            basicData.setIPairVolPos(this.getPairVolPosInfoFromPairSummary(pairDetail));
            ArrayList<SJmoReplicationPairVolInfo> localVolIndexList = new ArrayList<SJmoReplicationPairVolInfo>(1);
            int ldevValue = pairDetail.getLDEV();
            localVolIndex.setLdevIndex((short)((ldevValue & 0xFF0000) >>> 16), (short)((ldevValue & 0xFF00) >>> 8), (short)(ldevValue & 0xFF));
            localVolIndexList.add(localVolIndex);
            if (SJctrHaUtility.isSvol(basicData)) {
                basicData.setAlPVolIndex(localVolIndexList);
            } else if (SJctrHaUtility.isPvol(basicData)) {
                basicData.setAlSVolIndex(localVolIndexList);
            } else {
                this.logUty.putlog("makeDataList", "Pair attribute is invalid.");
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
            }
            rtnList.add(basicData);
        }
        return rtnList;
    }

    private List<SJctrViewPairSyncRateHaInfo> getCheckRmiDataList(List<SJctrViewPairSyncRateHaInfo> rmiList, List<SJmoHAPairVolInfo> checkPairList) {
        ArrayList<SJctrViewPairSyncRateHaInfo> rtnList = new ArrayList<SJctrViewPairSyncRateHaInfo>();
        Collections.sort(rmiList);
        for (SJmoHAPairVolInfo selectedPair : checkPairList) {
            int index = Collections.binarySearch(rmiList, selectedPair);
            if (index < 0) continue;
            rtnList.add(rmiList.get(index));
        }
        return rtnList;
    }

    private void removeInvalidStatusPair(List<SJctrViewPairSyncRateHaInfo> rmiPairList) {
        Iterator<SJctrViewPairSyncRateHaInfo> ite = rmiPairList.iterator();
        while (ite.hasNext()) {
            SJctrViewPairSyncRateHaInfo rmiPair = ite.next();
            if (this.checkViewPairSyncRateHaStatus(rmiPair.getIPairStatus())) continue;
            ite.remove();
        }
    }

    private boolean checkViewPairSyncRateHaStatus(int pairStatus) {
        boolean rtn = SJctrHaDataMacro.VIEW_SYNC_RATE_STATUS_HA.contains(pairStatus);
        return rtn;
    }

    private List<SJmoHAPairVolInfo> getExistHaPairInfoIntoCheckPair(List<SJmoHAPairVolInfo> checkList, SJmoHAPairVolInfoMgr haPairInfoMgr) {
        if (checkList == null || haPairInfoMgr == null) {
            this.logUty.putlog("getExistHaPairInfoIntoCheckPair", "Argument is invalid");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        ArrayList<SJmoHAPairVolInfo> retList = new ArrayList<SJmoHAPairVolInfo>(checkList.size());
        for (SJmoHAPairVolInfo remoteVol : checkList) {
            SJmoReplicationPairVolInfo localVol = SJctrHaUtility.getLocalVolume(remoteVol);
            if (localVol == null) {
                this.logUty.putlog("getExistHaPairInfoIntoCheckPair", "Local volume is null");
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206502);
            }
            SJmoReplicationPairVolInfo modelLocalVol = haPairInfoMgr.getHAPairVolInfo(localVol);
            if (modelLocalVol != null) {
                ArrayList<? extends SJmoLdevIndex> modelRemoteVolList = null;
                modelRemoteVolList = SJctrHaUtility.isPvol(remoteVol) ? modelLocalVol.getAlPVolIndex() : modelLocalVol.getAlSVolIndex();
                Collections.sort(modelRemoteVolList);
                int index = Collections.binarySearch(modelRemoteVolList, remoteVol);
                if (index < 0) {
                    this.logUty.putlog("getExistHaPairInfoIntoCheckPair", "Selected Remote VOL is not Exist.");
                    continue;
                }
                SJmoHAPairVolInfo modelRemoteVol = (SJmoHAPairVolInfo)modelRemoteVolList.get(index);
                try {
                    retList.add((SJmoHAPairVolInfo)modelRemoteVol.clone());
                    continue;
                }
                catch (CloneNotSupportedException e) {
                    this.logUty.putlog("getExistHaPairInfoIntoCheckPair", "Catch CloneNotSupportedException.");
                    throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
                }
            }
            this.logUty.putlog("getExistHaPairInfoIntoCheckPair", "Selected Remote VOL is not Exist.");
        }
        return retList;
    }

    private void setViewInfoFlag(List<SJmoHAPairVolInfo> viewData, List<SJctrViewPairSyncRateHaInfo> checkedList) {
        SJctrViewPairSyncrateInfoMsgFlagData infoFlagModel = this.getInfoFlagModel();
        if (checkedList.size() < viewData.size()) {
            infoFlagModel.setInformationFlag(1);
        } else {
            infoFlagModel.setInformationFlag(0);
        }
        infoFlagModel.setDirty();
    }

    private void setTableDataNotUsedCacheNeedModelInfo(SJctrViewPairSyncRateHaTableDataModel pairTable) {
        pairTable.setInfoLdev(SJctrRemoteReplicationUtility.getSpecifiedModelInfoNotUsedCache(this, new SJmoGetLdevDetail()));
        pairTable.setInfoLdevNickname(SJctrRemoteReplicationUtility.getSpecifiedModelInfoNotUsedCache(this, new SJmoGetLdevNicknameInfo()));
        pairTable.setInfoClpr(SJctrRemoteReplicationUtility.getSpecifiedModelInfoNotUsedCache(this, new SJmoGetClprInfo()));
        pairTable.setInfoRsg(SJctrRemoteReplicationUtility.getSpecifiedModelInfoNotUsedCache(this, new SJmoGetRSGgetAllRsgs()));
        pairTable.setInfoHuvmDkc(SJctrRemoteReplicationUtility.getSpecifiedModelInfoNotUsedCache(this, new SJmoGetHUVMVirtualDkc()));
        pairTable.setInfoHuvmLdev(SJctrRemoteReplicationUtility.getSpecifiedModelInfoNotUsedCache(this, new SJmoGetHUVMVirtualLdev()));
    }

    private SJctrViewPairSyncRateHaTableDataModel getPairTable() {
        return (SJctrViewPairSyncRateHaTableDataModel)this.getDataObjectModel(KEY_TABLE);
    }

    private SJctrViewPairSyncrateInfoMsgFlagData getInfoFlagModel() {
        return (SJctrViewPairSyncrateInfoMsgFlagData)this.getDataObjectModel(KEY_VIEWMSG);
    }

    private int getPairVolPosInfoFromPairSummary(RJiHAget1PairSummary rmiData) {
        int pairVolPosInfo = -1;
        if (rmiData.getAttr() == 2) {
            pairVolPosInfo = 1024;
        } else if (rmiData.getAttr() == 1) {
            pairVolPosInfo = 2048;
        } else {
            this.logUty.putlog("getPairVolPosInfoFromPairSummary", "Attribute is invalid");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        return pairVolPosInfo;
    }

    public static enum SYNC_RATE_MSG implements SJctrNotifyState
    {
        SELECT_REFRESH;

    }
}

