/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.tabmanage.dc;

import flex.messaging.io.ArrayCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.data.SJctrNestedListDataObject;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.tabmanage.model.SJctrMultiInheritedData;
import sanproject.sn2.controller.wizard.tabmanage.model.SJctrSwitchingTabModel;
import sanproject.sn2.controller.wizard.tabmanage.sub.SJctrTabManageSubDC;

public abstract class SJctrTabManageDataController
extends SJctrWizardDataController {
    public static final String KEY_TAB = "COM_TAB";
    public static final String KEY_FOOTER = "COM_FOOTER";
    public static final String KEY_LIST = "COM_LIST_DATA";
    public static final String KEY_SELECTED = "COM_SELECTED";
    public static final String KEY_NAME = "name";
    private static final int INDEX_ZERO = 0;
    private List<SJctrTabManageSubDC> managedSubDCs = new ArrayList<SJctrTabManageSubDC>();
    private SJctrTabManageSubDC currentSubDC;

    public SJctrTabManageDataController(int dispId) throws SJcException {
        super(dispId);
        this.addManagedSubDCs();
        this.initDataModel();
        this.initListener();
    }

    public void addManagedSubDC(SJctrTabManageSubDC subDC) {
        this.managedSubDCs.add(subDC);
    }

    protected void initDataModel() {
        for (SJctrTabManageSubDC subDC : this.managedSubDCs) {
            this.addSubDataObject(subDC.getDataObjects());
        }
        this.addDataObjectModel(KEY_TAB, new SJctrSwitchingTabModel());
        this.addDataObjectModel(KEY_FOOTER, new SJctrFooterDataModel());
    }

    private void addSubDataObject(Map<String, SJctrDataObjectModel<?>> dataObjectMap) {
        if (dataObjectMap == null || dataObjectMap.size() == 0) {
            return;
        }
        for (Map.Entry<String, SJctrDataObjectModel<?>> entry : dataObjectMap.entrySet()) {
            String key = entry.getKey();
            this.addDataObjectModel(key, entry.getValue());
        }
    }

    protected void initListener() {
        this.addMessageEventListener(NOTIFY_TAB_MANAGED.SELECT_TAB, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrTabManageDataController.this.doActionTabChanged();
            }
        });
        this.addMessageEventListener(SJctrDialogDataController.DIALOG_MSG.EXIT, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrTabManageDataController.this.doActionDialogClosed(event, dstModel);
            }
        });
        this.addMessageEventListener(SJctrWizardDataController.WIZ_MSG.CLOSE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrTabManageDataController.this.doActionMessageClosed(event, dstModel);
            }
        });
    }

    private void doActionTabChanged() {
        SJctrSwitchingTabModel tabModel = (SJctrSwitchingTabModel)this.getDataObjectModel(KEY_TAB);
        try {
            SJctrDataObject viewInfo = this.getViewInfo();
            if (viewInfo != null && viewInfo.containsKey(KEY_TAB)) {
                viewInfo.getDataMap().remove(KEY_TAB);
            }
            this.currentSubDC.checkEndData();
            this.changeCurrentSubDC(tabModel.getSelection());
        }
        catch (SJcException e) {
            this.rollbackTabStatus(tabModel);
            throw e;
        }
        finally {
            this.setDirtyAll();
        }
    }

    private void rollbackTabStatus(SJctrSwitchingTabModel tabModel) {
        String preName = this.currentSubDC.getTabName();
        tabModel.setEnableListener(false);
        tabModel.setSelection(preName);
        tabModel.setEnableListener(true);
        SJctrDataObject viewInfo = this.getViewInfo();
        if (viewInfo != null && viewInfo.containsKey(KEY_TAB)) {
            viewInfo.getDataMap().remove(KEY_TAB);
        }
    }

    @Override
    public boolean checkStartData() {
        for (SJctrTabManageSubDC subDC : this.managedSubDCs) {
            subDC.checkStartData();
        }
        return true;
    }

    @Override
    public boolean checkConstructData() {
        this.initTabModel();
        super.updateFooter();
        for (SJctrTabManageSubDC subDC : this.managedSubDCs) {
            subDC.checkConstructData();
        }
        return true;
    }

    private void initTabModel() {
        SJctrSwitchingTabModel tabModel = (SJctrSwitchingTabModel)this.getDataObjectModel(KEY_TAB);
        for (SJctrTabManageSubDC subDC : this.managedSubDCs) {
            tabModel.addItem(subDC.getTabName(), subDC.getTabName());
        }
        if (this.managedSubDCs.size() != 0) {
            tabModel.setEnableListener(false);
            String tabName = this.changeCurrentSubDC(this.getInitialSelection());
            tabModel.setSelection(tabName);
            tabModel.setEnableListener(true);
        }
        tabModel.setDirty();
    }

    private String getInitialSelection() {
        SJctrDataObject viewInfo = this.getViewInfo();
        String tabName = "";
        if (viewInfo != null && viewInfo.containsKey(KEY_TAB)) {
            SJctrNestedListDataObject preTab = (SJctrNestedListDataObject)viewInfo.getData(KEY_TAB);
            ArrayCollection listData = (ArrayCollection)preTab.getData(KEY_LIST);
            if (listData == null) {
                return tabName;
            }
            for (int i = 0; i < listData.size(); ++i) {
                Map map = (Map)listData.get(i);
                Object obj = map.get(KEY_SELECTED);
                if (obj == null || !((Boolean)obj).booleanValue()) continue;
                tabName = (String)map.get(KEY_NAME);
                break;
            }
            viewInfo.getDataMap().remove(KEY_TAB);
        }
        return tabName;
    }

    @Override
    public boolean checkEndData() {
        this.checkOwnData();
        for (SJctrTabManageSubDC subDC : this.managedSubDCs) {
            subDC.checkEndData();
        }
        SJctrMultiInheritedData confirmData = this.createInheritedData();
        if (confirmData != null) {
            for (SJctrTabManageSubDC subDC : this.managedSubDCs) {
                subDC.createInheritedData(confirmData);
            }
        }
        return true;
    }

    protected boolean checkOwnData() {
        return true;
    }

    private String changeCurrentSubDC(String tabName) {
        if (tabName != null) {
            for (SJctrTabManageSubDC subDC : this.managedSubDCs) {
                if (!tabName.equals(subDC.getTabName())) continue;
                this.currentSubDC = subDC;
                return tabName;
            }
        }
        this.currentSubDC = this.managedSubDCs.get(0);
        return this.currentSubDC.getTabName();
    }

    protected SJctrDataObject getViewInfo() {
        SJctrWizardWindowDC dc = this.getWizardWindow();
        if (dc == null) {
            return null;
        }
        SJctrUserController user = dc.getOwner();
        if (user == null) {
            return null;
        }
        HashMap<String, Object> map = user.getControlData(this.getDisplayId());
        if (map == null) {
            return null;
        }
        Object obj = map.get("COM_VIEWINFO");
        if (obj == null) {
            return null;
        }
        return (SJctrDataObject)obj;
    }

    protected abstract void addManagedSubDCs();

    protected abstract SJctrMultiInheritedData createInheritedData();

    public void doActionDialogClosed(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        this.currentSubDC.doActionDialogClosed(event, dstModel);
    }

    public void doActionMessageClosed(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        this.currentSubDC.doActionMessageClosed(event, dstModel);
    }

    public static enum NOTIFY_TAB_MANAGED implements SJctrNotifyState
    {
        SELECT_TAB;

    }
}

