/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.uvm.com.column;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.serverux.dataimpl.EXDExternalVolume;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.com.comparator.SJctrLdevIndexComparator;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrVpgManager;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetExDVirtualPgInfo;
import sanproject.sn2.model.connector.kind.SJmoGetExdVolumeInfoMgr;
import sanproject.sn2.model.data.exdevice.SJmoExDPgInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdVolumeInfo;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrTopLdevIDColumnFromExdVolumeInfo
extends SJctrColumn {
    protected Map<SJmoExdVolumeInfo, SJmoExDPgInfo> exdPgMap = null;

    public SJctrTopLdevIDColumnFromExdVolumeInfo(String key) {
        super(key);
        this.setPartsId("TOP_LDEV_ID");
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetExdVolumeInfoMgr.class);
        list.add(SJmoGetExDVirtualPgInfo.class);
        return list;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<SJmoExDPgInfo> list = new ArrayList<SJmoExDPgInfo>();
        SJmoExdVolumeInfo volumeInfo = (SJmoExdVolumeInfo)index;
        SJctrVpgManager vpgMgr = (SJctrVpgManager)modelData.get(SJctrVpgManager.class).get(0);
        EXDExternalVolume rmiExdVol = volumeInfo.getRmiExdVolumeInfo();
        SJmoExDPgInfo pgInfo = vpgMgr.getVpgInfo(rmiExdVol.getIFB4(), rmiExdVol.getIPG());
        if (this.exdPgMap == null) {
            this.exdPgMap = new HashMap<SJmoExdVolumeInfo, SJmoExDPgInfo>(this.getTable().getRowCount());
        }
        this.exdPgMap.put(volumeInfo, pgInfo);
        list.add(pgInfo);
        return list;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String ret = "";
        SJmoLdevIndex ldev = null;
        SJmoExDPgInfo pgInfo = (SJmoExDPgInfo)dataList.get(0);
        if (pgInfo != null && pgInfo.getSNumOfLdev() != 0) {
            ldev = pgInfo.getStartLdevId();
        }
        if (ldev != null) {
            SJctrLdevUtility util = this.getTable().getComUtility().getLdevUtility();
            ret = util.toLdevDisplay(ldev);
        }
        return ret;
    }

    @Override
    public int getFilterType() {
        return 16;
    }

    @Override
    public int getSortType() {
        return 3;
    }

    @Override
    protected Comparator<Object> createObjectComparator() {
        return new SJctrLdevIndexComparator(){

            @Override
            public int compare(Object o1, Object o2) {
                boolean result = false;
                SJmoLdevIndex ldev1 = this.getCompareValue(o1);
                SJmoLdevIndex ldev2 = this.getCompareValue(o2);
                return super.compare(ldev1, ldev2);
            }

            private SJmoLdevIndex getCompareValue(Object obj) {
                SJmoExDPgInfo pg = SJctrTopLdevIDColumnFromExdVolumeInfo.this.exdPgMap.get(obj);
                SJmoLdevIndex ldev = pg.getStartLdevId();
                return ldev;
            }
        };
    }
}

