/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.uvm.com.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.comparator.SJctrSsidComparator_Ldev;
import sanproject.sn2.controller.wizard.cvs.com.SJctrCVSUtility;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrDefaultUvmManager;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrUvmManager;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetRscUtilSsid;
import sanproject.sn2.model.connector.kind.SJmoGetSsidDetail;
import sanproject.sn2.model.connector.kind.SJmoGetSsidSummary;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoSsidDetail;
import sanproject.sn2.model.data.volume.SJmoSsidSummary;
import sanproject.sn2.modelrc.util.SJmoRscUtilSsid;

public class SJctrSsidManager
extends SJctrDefaultUvmManager
implements SJctrUvmManager {
    public static final int NO_VALUE = -1;
    public static final Comparator<Object> SSID_COMP = new SJctrSsidComparator_Ldev();
    private SJmoSsidSummary ssidSummary;
    private List<SJmoSsidDetail> ssidDetailList;
    private SJmoRscUtilSsid rscSsidUtil;
    private List<SJmoSsidDetail> ssidDetailOrgList;
    private Map<Integer, SsidInfo> createSsidMap;

    public SJctrSsidManager() {
        this.initField();
    }

    private void initField() {
        this.ssidSummary = null;
        this.ssidDetailList = Collections.emptyList();
        this.ssidDetailOrgList = Collections.emptyList();
        this.createSsidMap = new TreeMap<Integer, SsidInfo>();
    }

    public SJmoSsidSummary getSsidSummary() {
        return this.ssidSummary;
    }

    public List<SJmoSsidDetail> getSsidDetailList() {
        return this.ssidDetailList;
    }

    public List<SJmoSsidDetail> getSsidDetailOrgList() {
        return this.ssidDetailOrgList;
    }

    @Override
    public List<SJctrGetDirectWrapper> getModelDirect() {
        ArrayList<SJctrGetDirectWrapper> retList = new ArrayList<SJctrGetDirectWrapper>();
        SJmoGetKind_IF kind = new SJmoGetSsidSummary();
        SJmoGetRange_IF range = null;
        List filterList = Collections.emptyList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        SJctrGetDirectWrapper wrapper = new SJctrGetDirectWrapper(direct);
        retList.add(wrapper);
        kind = new SJmoGetSsidDetail();
        range = null;
        filterList = Collections.emptyList();
        direct = new SJmoGetDirect(kind, range, filterList);
        wrapper = new SJctrGetDirectWrapper(direct);
        retList.add(wrapper);
        kind = new SJmoGetRscUtilSsid();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        wrapper = new SJctrGetDirectWrapper(direct);
        retList.add(wrapper);
        return retList;
    }

    @Override
    public void divideModelData(Map<String, List<?>> models) {
        List<?> getList = models.get(SJmoGetSsidSummary.class.getName());
        if (getList != null && getList.size() > 0) {
            this.ssidSummary = (SJmoSsidSummary)getList.get(0);
        }
        if ((getList = models.get(SJmoGetSsidDetail.class.getName())) != null && getList.size() > 0) {
            this.ssidDetailOrgList = getList;
        }
        if ((getList = models.get(SJmoGetRscUtilSsid.class.getName())) != null && getList.size() > 0) {
            this.rscSsidUtil = (SJmoRscUtilSsid)getList.get(0);
        }
    }

    @Override
    public List<Class<? extends SJctrUvmManager>> getRelatedManager() {
        return Collections.emptyList();
    }

    @Override
    public void initialize() throws SJcException {
        this.ssidDetailList = SJctrSsidManager.createCloneList(this.ssidDetailOrgList);
    }

    public int getSsid(SJmoLdevIndex ldevIndex) {
        List<SJmoSsidDetail> list = this.getSsidDetailList();
        int retSsid = SJctrCVSUtility.getSSID(ldevIndex.getSLdkc(), ldevIndex.getSCu(), ldevIndex.getSLdev(), list);
        if (retSsid == 0) {
            retSsid = -1;
        }
        return retSsid;
    }

    public int getUsableSsid(int ssid, SJmoLdevIndex ldevIndex) {
        int usableSsid = SJctrCVSUtility.getSpaceSSID(ssid, this.getSsidDetailList(), this.rscSsidUtil, ldevIndex);
        return usableSsid;
    }

    public boolean setSsid(SJmoLdevIndex ldevIndex, int ssid) {
        int configuredSsid = this.getSsid(ldevIndex);
        if (configuredSsid == -1) {
            List<SJmoSsidDetail> list = this.getSsidDetailList();
            int result = SJctrCVSUtility.checkSSID(ssid, list);
            if (result != ssid) {
                return false;
            }
            SJmoSsidSummary summary = this.getSsidSummary();
            short boundary = summary.getSSIDBoundary();
            this.setSsid(ldevIndex, ssid, boundary);
        } else {
            this.updateSsidMapCount(configuredSsid, ldevIndex);
        }
        return true;
    }

    public boolean setAutoSsid(List<SJmoLdevIndex> ldevList, int ssid) {
        int setSsid = ssid;
        SJmoSsidSummary summary = this.getSsidSummary();
        short boundary = summary.getSSIDBoundary();
        for (SJmoLdevIndex ldevIndex : ldevList) {
            int configuredSsid = this.getSsid(ldevIndex);
            if (configuredSsid == -1) {
                if ((setSsid = this.getUsableSsid(setSsid, ldevIndex)) == -1) {
                    return false;
                }
                this.setSsid(ldevIndex, setSsid, boundary);
                ++setSsid;
                continue;
            }
            this.updateSsidMapCount(configuredSsid, ldevIndex);
        }
        return true;
    }

    public void removeSsid(SJmoLdevIndex ldevIndex) {
        boolean result;
        int ssid = this.getSsid(ldevIndex);
        SsidInfo info = this.createSsidMap.get(ssid);
        if (info != null && !(result = info.decrement(ldevIndex))) {
            this.createSsidMap.remove(ssid);
            List<SJmoSsidDetail> list = this.getSsidDetailList();
            Collections.sort(list);
            int index = Collections.binarySearch(list, info.getSsidDetail());
            if (index >= 0) {
                list.remove(index);
                ArrayList rsvList = new ArrayList();
                ArrayList<SJmoSsidDetail> dtlList = new ArrayList<SJmoSsidDetail>();
                dtlList.add(info.getSsidDetail());
                rsvList.add(dtlList);
                this.rscSsidUtil.delRsvData(rsvList);
            }
        }
    }

    private void setSsid(SJmoLdevIndex ldevIndex, int ssid, short boundary) {
        ArrayList retList;
        List<SJmoSsidDetail> list = this.getSsidDetailList();
        Collections.sort(list, SSID_COMP);
        this.ssidDetailList = retList = SJctrCVSUtility.setSSID(ldevIndex.getSLdkc(), ldevIndex.getSCu(), ldevIndex.getSLdev(), ssid, list, boundary);
        this.makeUnconfiguredInfo(ldevIndex, list, retList);
    }

    private void makeUnconfiguredInfo(SJmoLdevIndex ldevIndex, List<SJmoSsidDetail> srcList, List<SJmoSsidDetail> dstList) {
        int size = srcList.size();
        for (int i = 0; i < size; ++i) {
            SJmoSsidDetail srcSsid = srcList.get(i);
            SJmoSsidDetail dstSsid = dstList.get(i);
            if (srcSsid.getSSID() == dstSsid.getSSID()) continue;
            dstSsid.setIDataMode(2);
            this.createSsidMap.put(dstSsid.getSSID(), new SsidInfo(dstSsid, ldevIndex));
            return;
        }
        SJmoSsidDetail dstSsid = dstList.get(dstList.size() - 1);
        this.createSsidMap.put(dstSsid.getSSID(), new SsidInfo(dstSsid, ldevIndex));
    }

    private void updateSsidMapCount(int ssid, SJmoLdevIndex ldevIndex) {
        SsidInfo info = this.createSsidMap.get(ssid);
        if (info != null) {
            info.increment(ldevIndex);
        }
    }

    public List<SJmoLdevIndex> getLdevListofSsid(int ssid) {
        List<SJmoLdevIndex> retList = Collections.emptyList();
        SsidInfo info = this.createSsidMap.get(ssid);
        if (info != null) {
            retList = info.getLdevList();
        }
        return retList;
    }

    public List<SJmoSsidDetail> getNewSsidList() {
        ArrayList<SJmoSsidDetail> retList = new ArrayList<SJmoSsidDetail>(this.createSsidMap.size());
        for (SsidInfo ssidInfo : this.createSsidMap.values()) {
            SJmoSsidDetail dtl = ssidInfo.getSsidDetail();
            retList.add(dtl);
        }
        return retList;
    }

    private static class SsidInfo {
        private final SJmoSsidDetail ssidDetail;
        private Map<String, SJmoLdevIndex> ldevMap;

        public SsidInfo(SJmoSsidDetail detail, SJmoLdevIndex ldevIndex) {
            this.ssidDetail = detail;
            this.ldevMap = new HashMap<String, SJmoLdevIndex>(256);
            this.ldevMap.put(ldevIndex.toString(), ldevIndex);
        }

        public SJmoSsidDetail getSsidDetail() {
            return this.ssidDetail;
        }

        public boolean increment(SJmoLdevIndex ldevIndex) {
            this.ldevMap.put(ldevIndex.toString(), ldevIndex);
            return this.ldevMap.size() > 0;
        }

        public boolean decrement(SJmoLdevIndex ldevIndex) {
            this.ldevMap.remove(ldevIndex.toString());
            return this.ldevMap.size() > 0;
        }

        public List<SJmoLdevIndex> getLdevList() {
            ArrayList<SJmoLdevIndex> retList = new ArrayList<SJmoLdevIndex>(this.ldevMap.values());
            Collections.sort(retList);
            return retList;
        }
    }
}

