/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.uvm.com.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.serverux.dataimpl.EXDSubsystem;
import sanproject.serverux.dataimpl.EXDSubsystemEx;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrDefaultUvmManager;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrUvmManager;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetExdProfileInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetExdSubsystemInfoMgr;
import sanproject.sn2.model.data.exdevice.SJmoExdProfileInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdSubsystemInfo;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdProfileInfoMgr;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdSubsystemInfoMgr;

public class SJctrSubsytemManager
extends SJctrDefaultUvmManager
implements SJctrUvmManager {
    private SJmoExdSubsystemInfoMgr exdSubsystemManager;
    private SJmoExdProfileInfoMgr exdProfileManager;
    private Map<Integer, SJmoExdSubsystemInfo> discoverySubsystemMap;

    public SJctrSubsytemManager() {
        this.initField();
    }

    private void initField() {
        this.exdSubsystemManager = null;
        this.exdProfileManager = null;
        this.discoverySubsystemMap = new HashMap<Integer, SJmoExdSubsystemInfo>();
    }

    private SJmoExdSubsystemInfoMgr getExdSubsystemManager() {
        return this.exdSubsystemManager;
    }

    private SJmoExdProfileInfoMgr getExdProfileManager() {
        return this.exdProfileManager;
    }

    @Override
    public List<SJctrGetDirectWrapper> getModelDirect() {
        ArrayList<SJctrGetDirectWrapper> retList = new ArrayList<SJctrGetDirectWrapper>();
        SJmoGetKind_IF kind = new SJmoGetExdSubsystemInfoMgr();
        SJmoGetRange_IF range = null;
        List filterList = Collections.emptyList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        SJctrGetDirectWrapper wrapper = new SJctrGetDirectWrapper(direct);
        retList.add(wrapper);
        kind = new SJmoGetExdProfileInfoMgr();
        range = null;
        filterList = Collections.emptyList();
        direct = new SJmoGetDirect(kind, range, filterList);
        wrapper = new SJctrGetDirectWrapper(direct);
        retList.add(wrapper);
        return retList;
    }

    @Override
    public void divideModelData(Map<String, List<?>> models) {
        List<?> getList = models.get(SJmoGetExdSubsystemInfoMgr.class.getName());
        if (getList != null && getList.size() > 0) {
            this.exdSubsystemManager = (SJmoExdSubsystemInfoMgr)getList.get(0);
        }
        if ((getList = models.get(SJmoGetExdProfileInfoMgr.class.getName())) != null && getList.size() > 0) {
            this.exdProfileManager = (SJmoExdProfileInfoMgr)getList.get(0);
        }
    }

    @Override
    public List<Class<? extends SJctrUvmManager>> getRelatedManager() {
        return Collections.emptyList();
    }

    @Override
    public void initialize() throws SJcException {
    }

    public SJmoExdSubsystemInfo getSubsystemInfo(int subsystemId) {
        SJmoExdSubsystemInfo retInfo = null;
        if (subsystemId >= 0) {
            SJmoExdSubsystemInfoMgr subsystemManager = this.getExdSubsystemManager();
            if (subsystemManager != null) {
                retInfo = subsystemManager.getExdSubsystemInfo(subsystemId);
            }
        } else {
            retInfo = this.discoverySubsystemMap.get(subsystemId);
        }
        return retInfo;
    }

    public List<SJmoExdSubsystemInfo> getSubsystemList() {
        ArrayList retList = Collections.emptyList();
        SJmoExdSubsystemInfoMgr subsystemManager = this.getExdSubsystemManager();
        if (subsystemManager != null) {
            retList = subsystemManager.getAlExdSubsystemInfo();
        }
        return retList;
    }

    public SJmoExdProfileInfo getProfileInfo(int profileId) {
        SJmoExdProfileInfo retInfo = null;
        SJmoExdProfileInfoMgr profileManager = this.getExdProfileManager();
        if (profileManager != null) {
            retInfo = profileManager.getExdProfileInfo(profileId);
        }
        return retInfo;
    }

    public List<SJmoExdProfileInfo> getProfileList() {
        ArrayList retList = Collections.emptyList();
        SJmoExdProfileInfoMgr profileManager = this.getExdProfileManager();
        if (profileManager != null) {
            retList = profileManager.getAlExdProfileInfo();
        }
        return retList;
    }

    public List<SJmoExdSubsystemInfo> getAllSubsystemList() {
        List<SJmoExdSubsystemInfo> retList = this.getUnmapSubsystemList();
        retList.addAll(this.getSubsystemList());
        Collections.sort(retList);
        return retList;
    }

    public List<SJmoExdSubsystemInfo> getUnmapSubsystemList() {
        ArrayList<SJmoExdSubsystemInfo> retList = new ArrayList<SJmoExdSubsystemInfo>(this.discoverySubsystemMap.values());
        Collections.sort(retList);
        return retList;
    }

    public SJmoExdSubsystemInfo createDiscoveryProductInfo(EXDSubsystem exdSubsystem) {
        SJmoExdSubsystemInfo ret = null;
        if (exdSubsystem.isConfigured()) {
            int id = exdSubsystem.getId();
            SJmoExdSubsystemInfo subsystem = this.getSubsystemInfo(id);
            if (subsystem != null && this.equalsEXDSubsystem(exdSubsystem, subsystem.getRmiExdSubsystemInfo())) {
                ret = subsystem;
            }
        } else {
            for (SJmoExdSubsystemInfo info : this.discoverySubsystemMap.values()) {
                if (!this.equalsEXDSubsystem(exdSubsystem, info.getRmiExdSubsystemInfo())) continue;
                ret = info;
                break;
            }
            if (ret == null) {
                List<SJmoExdSubsystemInfo> configerList = this.getSubsystemList();
                for (SJmoExdSubsystemInfo configer : configerList) {
                    if (!this.equalsEXDSubsystem(exdSubsystem, configer.getRmiExdSubsystemInfo())) continue;
                    return ret;
                }
                int id = -2 - this.discoverySubsystemMap.size();
                exdSubsystem.setId(id);
                ret = new SJmoExdSubsystemInfo(exdSubsystem);
                this.discoverySubsystemMap.put(id, ret);
            }
        }
        return ret;
    }

    private boolean equalsEXDSubsystem(EXDSubsystem o1, EXDSubsystem o2) {
        if (!o1.getSerialId().equals(o2.getSerialId())) {
            return false;
        }
        if (o1.referProfileId() != o2.referProfileId()) {
            return false;
        }
        if (o1.referProfileId() == 254) {
            EXDSubsystemEx subsystemEx1 = (EXDSubsystemEx)o1;
            EXDSubsystemEx subsystemEx2 = (EXDSubsystemEx)o2;
            if (!subsystemEx1.getVendor().equals(subsystemEx2.getVendor())) {
                return false;
            }
        }
        return true;
    }
}

