/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.uvm.comdialog.createextpathgrp;

import java.util.List;
import sanproject.sn2.controller.com.SJctrExtUtility;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.wizard.uvm.com.SJctrUvmDialogDataController;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrSubsytemManager;
import sanproject.sn2.controller.wizard.uvm.comdialog.createextpathgrp.SJctrCreateExtPathGrpDialogDC;
import sanproject.sn2.controller.wizard.uvm.editpolicy.SJctrExdPolicyData;
import sanproject.sn2.model.data.exdevice.SJmoExdProfileInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdSubsystemInfo;

public class SJctrExtStorageSystemDataModel
extends SJctrComboBoxDataModel {
    public static int INVALID_VALUE = -1;
    private SJctrExdPolicyData policyData = null;
    private boolean noData = true;

    public SJctrExtStorageSystemDataModel() {
        this.initListener();
    }

    private void initListener() {
        this.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                int id;
                if (event.isSelect() && (id = SJctrExtStorageSystemDataModel.this.getSelectId()) != INVALID_VALUE) {
                    SJctrCreateExtPathGrpDialogDC dc = (SJctrCreateExtPathGrpDialogDC)SJctrExtStorageSystemDataModel.this.getDataController();
                    dc.updateTable(id);
                }
            }
        });
    }

    @Override
    protected void makeDataObject() {
        SJctrExtUtility extUtil = this.getComUtility().getExtUtility();
        SJctrUvmDialogDataController dc = (SJctrUvmDialogDataController)this.getDataController();
        this.policyData = new SJctrExdPolicyData(dc.getOwner());
        SJctrSubsytemManager subsysMgr = dc.getManager(SJctrSubsytemManager.class);
        List<SJmoExdSubsystemInfo> subsysList = subsysMgr.getAllSubsystemList();
        for (SJmoExdSubsystemInfo subsys : subsysList) {
            int subsystemId = subsys.getRmiExdSubsystemInfo().getId();
            if (!this.policyData.isInternalUsage() && subsystemId == 0) continue;
            int profileId = subsys.getRmiExdSubsystemInfo().referProfileId();
            SJmoExdProfileInfo profile = subsysMgr.getProfileInfo(profileId);
            String name = String.valueOf(subsystemId);
            String label = extUtil.toSubSystemName(subsys, profile);
            this.addItem(name, label);
            this.noData = false;
        }
        this.setSelectedIndex(0);
    }

    public void upDateComboBoxItem(int subsystemId) {
        String name = String.valueOf(subsystemId);
        if (this.getItem(name) == null) {
            SJctrCreateExtPathGrpDialogDC dc = (SJctrCreateExtPathGrpDialogDC)this.getDataController();
            SJctrSubsytemManager subsysMgr = dc.getManager(SJctrSubsytemManager.class);
            SJctrExtUtility extUtil = dc.getOwner().getComUtility().getExtUtility();
            SJmoExdSubsystemInfo subsys = subsysMgr.getSubsystemInfo(subsystemId);
            if (subsys == null) {
                return;
            }
            int profileId = subsys.getRmiExdSubsystemInfo().referProfileId();
            if (!this.policyData.isInternalUsage() && subsystemId == 0) {
                return;
            }
            SJmoExdProfileInfo profile = subsysMgr.getProfileInfo(profileId);
            String label = extUtil.toSubSystemName(subsys, profile);
            this.addItem(name, label);
            if (this.noData) {
                this.setSelectedIndex(0);
                this.noData = false;
            }
            this.setDirty();
        }
    }

    public int getSelectId() {
        int id = INVALID_VALUE;
        String selection = this.getSelection();
        if (selection != null) {
            id = Integer.valueOf(selection);
        }
        return id;
    }
}

