/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.volumemigration.histories;

import java.util.ArrayList;
import java.util.List;
import sanproject.serverux.data.HIHsmMigrationHistoryEx;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrLicenseContainer;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrMessageDataController;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrSystemParamContainer;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.SJctrVolumeMigrationUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.com.model.event.SJctrObjectSetListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.replication.viewhistories.SJctrHistoriesPagingComponentDataModel;
import sanproject.sn2.controller.wizard.volumemigration.com.SJctrVMDialogDataController;
import sanproject.sn2.controller.wizard.volumemigration.com.SJctrVolumeMigrationMacro;
import sanproject.sn2.controller.wizard.volumemigration.deleteallhistories.SJctrDeleteAllHistoriesSubWizard;
import sanproject.sn2.controller.wizard.volumemigration.histories.SJctrVMHistoryInfo;
import sanproject.sn2.controller.wizard.volumemigration.histories.SJctrVMHistoryTableModel;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoPgIndex;

public class SJctrVMHistoriesDC
extends SJctrVMDialogDataController {
    public SJctrVMHistoriesDC() throws SJcException {
        super(34664533);
        this.initDataModel();
        this.initListener();
    }

    private void initDataModel() {
        if (!SJctrDataController.isHM()) {
            this.addDataObjectModel("COM_PAGING_COMPO", new SJctrHistoriesPagingComponentDataModel());
            this.getDataObjectModel("COM_PAGING_COMPO").addObjectSetListener(new SJctrObjectSetListener(){

                @Override
                public void doAction(Object setObject) {
                    SJctrVMHistoriesDC.this.fireMessageEvent(SJctrHistoriesPagingComponentDataModel.HISTORIES_PAGINGCOMP_MSG.PAGING_CHANGED);
                }
            });
        }
        this.addDataObjectModel("COM_TABLE", new SJctrVMHistoryTableModel());
        SJctrButtonDataModel exportButton = new SJctrButtonDataModel();
        this.addDataObjectModel("COM_EXPORT", exportButton);
        exportButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrVMHistoriesDC.this.fireMessageEvent(HIST_MSG.EXPORT);
            }
        });
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(SJctrFooterDataModel.BGO_CLOSE));
    }

    private void initListener() {
        if (!SJctrDataController.isHM()) {
            this.addMessageEventListener(SJctrHistoriesPagingComponentDataModel.HISTORIES_PAGINGCOMP_MSG.PAGING_CHANGED, new SJctrMessageEventListener(){

                @Override
                public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                    SJctrVMHistoriesDC.this.pageChangeEvent();
                }
            });
        }
        if (!SJctrDataController.isHM()) {
            this.addMessageEventListener(HIST_MSG.DEL_ALL_HIST, new SJctrMessageEventListener(){

                @Override
                public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                    SJctrVMHistoriesDC.this.delAllHistEvent();
                }
            });
        }
        this.addMessageEventListener(HIST_MSG.EXPORT, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrVMHistoriesDC.this.exportEvent();
            }
        });
    }

    @Override
    public boolean checkStartData() {
        boolean bRet = true;
        List<?> migHistList = this.getCache("KEY_HISTDATA");
        if (migHistList == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkStartData", "History List null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        if (migHistList.isEmpty()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkStartData", "History List size 0");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        HIHsmMigrationHistoryEx migHistData = (HIHsmMigrationHistoryEx)migHistList.get(0);
        if (migHistData == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkStartData", "History RMI Data null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        List<?> rsgInfoList = this.getCache(SJctrVolumeMigrationMacro.KEY_RSG_INFO);
        if (rsgInfoList == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkStartData", "RsgInfo List null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        if (rsgInfoList.isEmpty()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkStartData", "RsgInfo List size 0");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        SJmoRSGgetAllRsgs rsgData = (SJmoRSGgetAllRsgs)rsgInfoList.get(0);
        if (rsgData == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkStartData", "RsgInfo Data null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        return bRet;
    }

    @Override
    public boolean checkConstructData() {
        boolean bRet = true;
        List<?> migHistList = this.getCache("KEY_HISTDATA");
        List<?> rsgInfoList = this.getCache(SJctrVolumeMigrationMacro.KEY_RSG_INFO);
        SJctrResourceGroupUtility rsgUtil = SJctrVolumeMigrationUtility.makeRsgUtil(this, (SJmoRSGgetAllRsgs)rsgInfoList.get(0));
        List<SJmoLdevIndex> availableLdevList = SJctrVolumeMigrationUtility.getAvailableRsgLdevList(rsgUtil);
        this.putCache("KEY_AVAILABLE_RESOURCE_LDEV", availableLdevList);
        return bRet;
    }

    @Override
    public void makeDataModel() {
        List<SJctrVMHistoryInfo> basicDataList = this.makeBasicDataList();
        this.updateTableDisp(basicDataList);
        super.makeDataModel();
        if (!SJctrDataController.isHM()) {
            this.updatePageComp(1, this.getLastPageNum());
        }
    }

    private List<SJctrVMHistoryInfo> makeBasicDataList() {
        List<?> migHistList = this.getCache("KEY_HISTDATA");
        List<SJmoLdevIndex> availableLdevList = this.getCache("KEY_AVAILABLE_RESOURCE_LDEV");
        List<SJctrVMHistoryInfo> basicDataList = this.createHistDataList((HIHsmMigrationHistoryEx)migHistList.get(0), availableLdevList);
        return basicDataList;
    }

    private void pageChangeEvent() {
        SJcMessage msg = null;
        this.getRmiHistoryInfo(1);
        int iLastPageNum = this.getLastPageNum();
        SJctrHistoriesPagingComponentDataModel pageComp = (SJctrHistoriesPagingComponentDataModel)this.getDataObjectModel("COM_PAGING_COMPO");
        int iCurrentPage = pageComp.getCurrentPage();
        if (iCurrentPage != 1) {
            if (iLastPageNum >= iCurrentPage) {
                this.getRmiHistoryInfo(iCurrentPage);
            } else {
                msg = SJctrVolumeMigrationUtility.getMsgObject(206086);
                iCurrentPage = 1;
            }
        }
        List<SJctrVMHistoryInfo> basicDataList = this.makeBasicDataList();
        this.updateTableDisp(basicDataList);
        this.updatePageComp(iCurrentPage, iLastPageNum);
        if (msg != null) {
            SJctrRelatedDispDataObject related = this.createMsgDialog(msg);
            SJctrUserController uc = this.getOwner();
            SJctrMessageDataController msgDC = (SJctrMessageDataController)uc.getDataController(related);
            msgDC.addButton(SJctrMessageDataController.MD_OK);
            this.addUpdateDisp(related);
        }
        this.setDirtyAll();
    }

    private void exportEvent() {
        String strTsvFileName = this.getExportFileName();
        SJctrDataObjectModel<? extends SJctrDataObject> tblObj = this.getDataObjectModel("COM_TABLE");
        ArrayList<Object> transDataList = new ArrayList<Object>();
        transDataList.add(tblObj);
        transDataList.add(strTsvFileName);
        this.fireMessageEvent(SJctrDataController.NOTIFY_STATE.MAKE_EXPORT, transDataList);
    }

    private String getExportFileName() {
        StringBuffer tsvFileNameBuf = new StringBuffer();
        tsvFileNameBuf.append(this.getComUtility().getGuidance("HISTORIES"));
        tsvFileNameBuf.append("_");
        tsvFileNameBuf.append(this.getComUtility().getGuidance("VOLUMEMIGRATION"));
        if (!SJctrDataController.isHM()) {
            int iCurrentPage = ((SJctrHistoriesPagingComponentDataModel)this.getDataObjectModel("COM_PAGING_COMPO")).getCurrentPage();
            tsvFileNameBuf.append(SJctrComUtility.toPaddingZeroString(iCurrentPage, 2));
        }
        tsvFileNameBuf.append(this.getComUtility().getGuidance("VM", "HISTORIES_EXPORT"));
        return SJctrComUtility.getTsvFileName(tsvFileNameBuf.toString());
    }

    private void getRmiHistoryInfo(int iPageNum) {
        int iFrom = SJctrVolumeMigrationUtility.getHistFromIndex(iPageNum);
        int iTo = SJctrVolumeMigrationUtility.getHistToIndex(iPageNum);
        HIHsmMigrationHistoryEx rmiHistData = SJctrVolumeMigrationUtility.getHistoryInfoNotUsedCache(this, iFrom, iTo);
        ArrayList<HIHsmMigrationHistoryEx> rmiHIstList = new ArrayList<HIHsmMigrationHistoryEx>();
        rmiHIstList.add(rmiHistData);
        this.putCache("KEY_HISTDATA", rmiHIstList);
    }

    private void updatePageComp(int iCurrentPage, int iLastPage) {
        SJctrHistoriesPagingComponentDataModel pageComp = (SJctrHistoriesPagingComponentDataModel)this.getDataObjectModel("COM_PAGING_COMPO");
        pageComp.setCurrentPage(iCurrentPage);
        pageComp.setLastPageLabel(iLastPage);
    }

    private List<SJctrVMHistoryInfo> createHistDataList(HIHsmMigrationHistoryEx rmiHistData, List<SJmoLdevIndex> availableLdevList) {
        ArrayList<SJctrVMHistoryInfo> migHistDataList = new ArrayList<SJctrVMHistoryInfo>();
        int iElementCnt = rmiHistData.getSize();
        for (int iCnt = 0; iCnt < iElementCnt; ++iCnt) {
            SJmoLdevIndex srcLdev = new SJmoLdevIndex();
            SJmoLdevIndex targetLdev = new SJmoLdevIndex();
            srcLdev.setLdevIndex((short)rmiHistData.getSourceLDKC(iCnt), (short)rmiHistData.getSourceCU(iCnt), (short)rmiHistData.getSourceLDEV(iCnt));
            targetLdev.setLdevIndex((short)rmiHistData.getTargetLDKC(iCnt), (short)rmiHistData.getTargetCU(iCnt), (short)rmiHistData.getTargetLDEV(iCnt));
            if (!SJctrVolumeMigrationUtility.chkLdevRsgGrp(srcLdev, targetLdev, availableLdevList)) continue;
            SJmoPgIndex srcPg = new SJmoPgIndex();
            SJmoPgIndex targetPg = new SJmoPgIndex();
            srcPg.setFB4(rmiHistData.getSourceFB4(iCnt));
            srcPg.setPG(rmiHistData.getSourcePG(iCnt));
            targetPg.setFB4(rmiHistData.getTargetFB4(iCnt));
            targetPg.setPG(rmiHistData.getTargetPG(iCnt));
            SJctrVMHistoryInfo histInfo = new SJctrVMHistoryInfo(srcLdev, targetLdev, srcPg, targetPg, rmiHistData.getOwnerID(iCnt), rmiHistData.isHUVM(iCnt), rmiHistData.getAction(iCnt), rmiHistData.getMigrationDate(iCnt));
            migHistDataList.add(histInfo);
        }
        return migHistDataList;
    }

    private void updateTableDisp(List<SJctrVMHistoryInfo> histBasicDataList) {
        ((SJctrVMHistoryTableModel)this.getDataObjectModel("COM_TABLE")).setBasicDataList(histBasicDataList);
        ((SJctrVMHistoryTableModel)this.getDataObjectModel("COM_TABLE")).doRefresh();
    }

    private int getLastPageNum() {
        int iLastPageNum = 1;
        List<?> migHistList = this.getCache("KEY_HISTDATA");
        HIHsmMigrationHistoryEx rmiHistData = (HIHsmMigrationHistoryEx)migHistList.get(0);
        if (rmiHistData.getTotalCount() > 0) {
            double dTmp = (double)rmiHistData.getTotalCount() / 16384.0;
            iLastPageNum = (int)Math.ceil(dTmp);
        }
        return iLastPageNum;
    }

    private void delAllHistEvent() {
        if (!this.isEnablePP()) {
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(206094);
        }
        if (!this.isEnableRole()) {
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(206094);
        }
        SJctrUserController uc = this.getOwner();
        SJctrRelatedDispDataObject newRelated = this.createWizard(SJctrDeleteAllHistoriesSubWizard.class, null);
        SJctrRelatedDispDataObject removeRelated = uc.removeRelatedDispData(this.getuId());
        this.addUpdateDisp(removeRelated);
        this.addUpdateDisp(newRelated);
    }

    private boolean isEnablePP() {
        boolean bPPRet = true;
        SJctrSystemParamContainer sysCont = this.getOwner().getAuthorizeContainer().getSystemParamContainer();
        SJctrLicenseContainer licenseCont = this.getOwner().getAuthorizeContainer().getLisenceContainer();
        if (!sysCont.isLocalHost()) {
            bPPRet &= licenseCont.checkPP(SJctrLicenseContainer.PPID_SN);
        }
        return bPPRet;
    }

    private boolean isEnableRole() {
        boolean bRoleRet = true;
        return bRoleRet &= this.getOwner().getAuthorizeContainer().getRoleResourceContainer().checkAuthority(32);
    }

    public static enum HIST_MSG implements SJctrNotifyState
    {
        DEL_ALL_HIST,
        EXPORT;

    }
}

