/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.vpm.com;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrVpmUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;

public class SJctrClprResidentCacheArea
extends SJctrSimpleDataModel {
    public static final String KEY_CACHESIZE_CMB = "COM_CACHESIZE_CMB";
    public static final String KEY_MIN = "COM_MIN";
    public static final String KEY_MAX = "COM_MAX";
    private SJctrComUtility comUtil = null;
    protected SJctrComboBoxDataModel clprResidentCacheComboBox = new SJctrComboBoxDataModel();
    List<String> strValueList = null;
    int iValueMax = 0;
    int iValueMin = 0;

    public SJctrClprResidentCacheArea() {
        this.addDataModel(KEY_CACHESIZE_CMB, this.clprResidentCacheComboBox);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        this.comUtil = util;
    }

    public void initClprResidentCacheArea(int iCacheSizeMax, int iCacheSizeMin) {
        this.strValueList = new ArrayList<String>();
        if (!SJctrDataController.isHM()) {
            if (iCacheSizeMax < iCacheSizeMin || iCacheSizeMax % SJctrVpmUtility.CLPR_RESIDENT_CACHE_DEV_UNIT != 0 || iCacheSizeMin < 0 || iCacheSizeMin % SJctrVpmUtility.CLPR_RESIDENT_CACHE_DEV_UNIT != 0) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "initComboBox", "Illegal Prm. iCacheSizeMax:" + iCacheSizeMax + ",iCacheSizeMin:" + iCacheSizeMin);
                SJctrVpmUtility.makeErrorDialog(107002);
            }
            this.setActivityArea(true);
            this.clprResidentCacheComboBox.removeAllItems();
            for (int iValue = iCacheSizeMin; iCacheSizeMax >= iValue; iValue += SJctrVpmUtility.CLPR_RESIDENT_CACHE_DEV_UNIT) {
                this.strValueList.add(Float.toString(new Float(iValue).floatValue() / new Float(1024.0f).floatValue()));
            }
        } else {
            this.strValueList.add("0.0");
        }
        for (String strItem : this.strValueList) {
            this.clprResidentCacheComboBox.addItem(strItem);
        }
        this.iValueMax = this.strValueList.size();
        this.clprResidentCacheComboBox.setSelectedIndex(0);
        Object mngData = this.getManageData();
        ((SJctrDataObject)mngData).setData(KEY_MIN, this.strValueList.get(0));
        ((SJctrDataObject)mngData).setData(KEY_MAX, this.strValueList.get(this.strValueList.size() - 1));
    }

    public void updateClprResidentCacheArea(int iCacheSizeMax) {
        this.clprResidentCacheComboBox.clearSelection();
        this.clprResidentCacheComboBox.removeAllItems();
        List<Object> dataList = Collections.emptyList();
        int iCacheMaxIndex = this.getCacheSizeIndex(iCacheSizeMax);
        Object mngData = this.getManageData();
        if (0 <= iCacheMaxIndex && iCacheMaxIndex <= this.iValueMax) {
            if (this.iValueMin > iCacheMaxIndex) {
                this.iValueMin = iCacheMaxIndex;
            }
            dataList = this.strValueList.subList(this.iValueMin, iCacheMaxIndex + 1);
            ((SJctrDataObject)mngData).setData(KEY_MIN, dataList.get(0));
            ((SJctrDataObject)mngData).setData(KEY_MAX, dataList.get(dataList.size() - 1));
        } else {
            dataList = new ArrayList();
            dataList.add("");
            ((SJctrDataObject)mngData).setData(KEY_MIN, "0.0");
            ((SJctrDataObject)mngData).setData(KEY_MAX, "0.0");
        }
        for (String string : dataList) {
            this.clprResidentCacheComboBox.addItem(string);
        }
        this.clprResidentCacheComboBox.setSelectedIndex(0);
    }

    private int getCacheSizeIndex(int iCacheSize) {
        int ret = -1;
        if (iCacheSize >= 0) {
            ret = (iCacheSize - 0) / SJctrVpmUtility.CLPR_RESIDENT_CACHE_DEV_UNIT;
        }
        return ret;
    }

    public void setActivityArea(boolean bActivity) {
        this.clprResidentCacheComboBox.setEnable(bActivity);
    }

    public void setSelection(String strSelect) {
        this.clprResidentCacheComboBox.setSelection(strSelect);
    }

    public int getSelectCapa() {
        String selection = this.clprResidentCacheComboBox.getSelection();
        int ret = -1;
        try {
            Float value = Float.valueOf(selection);
            value = Float.valueOf(value.floatValue() * 1024.0f);
            ret = value.intValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public void setIValueMin(int iCacheSize) {
        this.iValueMin = this.getCacheSizeIndex(iCacheSize);
    }
}

