/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.httpcli.exec.com;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import java.util.Date;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.httpcli.com.SJhtclHttpCliUty;
import sanproject.sn2.model.SJmoModelMgr;
import sanproject.sn2.model.inf.SJmoKeyValueDefine_IF;

public class SJhtclRelocationLogApplyTask
extends Thread
implements SJmoKeyValueDefine_IF {
    private static final String LOG_FUNCTION = "HTTP_CLI";
    private static final String LOG_TITLE = SJhtclRelocationLogApplyTask.class.getSimpleName();
    public static final int TASK_STATUS_INIT = 0;
    public static final int TASK_STATUS_WAIT = 1;
    public static final int TASK_STATUS_EXEC = 2;
    public static final int TASK_STATUS_END = 3;
    public static final int TASK_STATUS_ERR = 4;
    private Object request = null;
    private String taskName = "";
    private Date startDate = null;
    private long startTime = 0L;
    private Date endDate = null;
    private int taskStatus = 0;
    private SJcMessage msg = null;
    private Object result = null;
    private static final int KEY_VALUE_NORMAL_END = 0;

    public SJhtclRelocationLogApplyTask(Object request, String taskName, Date startDate) {
        this.request = request;
        this.taskName = taskName;
        this.startDate = startDate;
        this.startTime = System.nanoTime();
    }

    public void init() {
        this.taskStatus = 2;
    }

    @Override
    public void run() {
        String LOG_SUBTITLE = "run";
        try {
            this.result = SJmoModelMgr.getModelMgr().getSupplierMgr().getAgent().getDataInf((SanRequest)this.request, false);
            SanResponse response = (SanResponse)this.result;
            if (response == null) {
                SJhtclRelocationLogApplyTask.putLogThrowExp("run", "Failed to apply.");
            }
            SJhtclRelocationLogApplyTask.checkErrorInfo(response);
            this.endDate = new Date();
            this.taskStatus = 3;
        }
        catch (SJcException ex) {
            this.endDate = new Date();
            SJhtclHttpCliUty.getHtclLogger().error(LOG_FUNCTION, LOG_TITLE, "run", this.taskName + " : The abnormal end of this execution processing was carried out.", ex);
            this.msg = ex.getMsg();
            this.taskStatus = 4;
        }
        catch (Exception ex) {
            this.endDate = new Date();
            SJhtclHttpCliUty.getHtclLogger().error(LOG_FUNCTION, LOG_TITLE, "run", this.taskName + "The abnormal end of this execution processing was carried out. (Internal Error)", ex);
            SJcException sjcEx = new SJcException("205", "25", "107010");
            this.msg = sjcEx.getMsg();
            this.taskStatus = 4;
        }
    }

    public String getTaskName() {
        return this.taskName;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public int getTaskStatus() {
        return this.taskStatus;
    }

    public SJcMessage getMsg() {
        return this.msg;
    }

    public void setMsg(SJcMessage msg) {
        this.msg = msg;
    }

    public Object getResult() {
        return this.result;
    }

    public void setTaskStatusEnd() {
        this.taskStatus = 3;
    }

    public void setTaskStatusError() {
        this.taskStatus = 4;
    }

    private static void checkErrorInfo(SanResponse response) {
        String LOG_SUBTITLE = "checkErrorInfo";
        try {
            int errCodeNum = response.errorCode();
            if (errCodeNum != 0) {
                SanObject errInfo = response.getObj("ErrorInfo");
                if (errInfo != null) {
                    int[] msgIdList = errInfo.getIntArray("MessageId");
                    if (msgIdList != null && msgIdList.length == 2) {
                        int errorCode = msgIdList[1];
                        if (errorCode != 0) {
                            SJhtclHttpCliUty.getHtclLogger().error(LOG_FUNCTION, LOG_TITLE, "checkErrorInfo", "errorCode is invalid");
                            String errCode = String.valueOf(errorCode);
                            SJcException sjcEx = new SJcException("205", "25", errCode);
                            throw sjcEx;
                        }
                    } else {
                        SJhtclRelocationLogApplyTask.putLogThrowExp("checkErrorInfo", "msgIdList is null or msgIdList length is invalid");
                    }
                } else {
                    SJhtclRelocationLogApplyTask.putLogThrowExp("checkErrorInfo", "errInfo is null");
                }
            }
        }
        catch (SanDataException e) {
            SJhtclRelocationLogApplyTask.putLogThrowExp("checkErrorInfo", "SanDataException is occured");
        }
    }

    private static void putLogThrowExp(String strMethodName, String strLog) {
        SJhtclHttpCliUty.getHtclLogger().error(LOG_FUNCTION, LOG_TITLE, strMethodName, strLog);
        SJcException sjcEx = new SJcException("205", "25", "107010");
        throw sjcEx;
    }
}

