/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.httpcli.exec.com;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Date;
import java.util.List;
import sanproject.common.Robj_interface_AuditUserInfo;
import sanproject.serverux.dataimpl.AuditUserInfo;
import sanproject.serverux.dataimpl.REPORTReportInfo;
import sanproject.serverux.dataimpl.REPORTcreateReportInfo_IN;
import sanproject.serverux.dataimpl.REPORTdeleteReportInfo_IN;
import sanproject.serverux.dataimpl.REPORTgetReportHistory;
import sanproject.serverux.dataimpl.REPORTgetReportHistory_OUT;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterfaceInternal;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.SJcBitSetUty;
import sanproject.sn2.com.utility.SJcSessionUty;
import sanproject.sn2.com.utility.account.SJcRoleResourceContainer;
import sanproject.sn2.controller.topwindow.report.SJctrGetReportInfo;
import sanproject.sn2.controller.topwindow.report.com.SJctrReportDef;
import sanproject.sn2.datasupplier.SJdsSupplierAgent;
import sanproject.sn2.httpcli.com.SJhtclHttpCliUty;
import sanproject.sn2.httpcli.exec.com.SJhtclReportApplyTaskManager;
import sanproject.sn2.model.SJmoGetAgent;
import sanproject.sn2.model.SJmoModelMgr;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.data.SJmoThroughRmiData;

public class SJhtclReportRMIUtility {
    private static final String LOG_FUNCTION = "HTTP_CLI";
    private static final String LOG_TITLE = SJhtclReportRMIUtility.class.getSimpleName();
    public static final long RESOURCE_LOCK_ID_INVALID = -1L;
    public static final int LOCKTYPE_SYSTEMLOCK = 0;
    public static final int LOCKTYPE_RESOURCELOCK = 1;

    private static Object applyReport(ArrayList<Object> applyList, String taskName, SJbaseUserSessionInterface session) throws SJcException {
        Object retObj = null;
        SJcRoleResourceContainer roleResource = session.getRoleResourceInfo();
        if (null == roleResource) {
            SJhtclHttpCliUty.getHtclLogger().error(LOG_FUNCTION, LOG_TITLE, "applyReport", "The role information does not exist. (Internal Error)");
            SJcException sjcEx = new SJcException("205", "25", "107010");
            throw sjcEx;
        }
        boolean[] resourceArray = roleResource.getResourceGroup();
        BitSet lockBit = SJcBitSetUty.booolean2bitset(resourceArray);
        long rscLockId = SJhtclReportRMIUtility.lock((SJbaseUserSessionInterfaceInternal)session, lockBit);
        try {
            retObj = SJmoModelMgr.getModelMgr().getSupplierMgr().getAgent().applyStart(rscLockId, applyList);
        }
        catch (SJcException sjcEx) {
            SJhtclHttpCliUty.getHtclLogger().error(LOG_FUNCTION, LOG_TITLE, "applyReport", "Failed to Apply.", sjcEx);
            throw sjcEx;
        }
        catch (Exception ex) {
            SJhtclHttpCliUty.getHtclLogger().error(LOG_FUNCTION, LOG_TITLE, "applyReport", "Failed to Apply. (Internal Error)", ex);
            SJcException sjcEx = new SJcException("205", "25", "107010");
            throw sjcEx;
        }
        finally {
            SJhtclReportRMIUtility.unlock(rscLockId, lockBit, roleResource);
        }
        return retObj;
    }

    public static Robj_interface_AuditUserInfo createAuditLogInfo(String taskName, SJbaseUserSessionInterface session) {
        AuditUserInfo info = new AuditUserInfo();
        info.setIConnectionID(session.getSessionIdentificationID());
        info.setStrGlblSessionID(session.getSessionID());
        info.setStrIPaddress(session.getAddress().getHostAddress());
        info.setStrTaskName(taskName);
        info.setStrUserName(session.getUserName());
        return info;
    }

    public static long lock(SJbaseUserSessionInterfaceInternal userSession, BitSet lockBit) throws SJcException {
        long rscLockId = -1L;
        SJdsSupplierAgent mAgent = SJmoModelMgr.getModelMgr().getSupplierMgr().getAgent();
        try {
            String ipAddress = SJcSessionUty.getIPAddress(userSession);
            int iAuthKind = SJcSessionUty.getSsoOption(userSession);
            if (ipAddress == null) {
                ipAddress = "";
            }
            rscLockId = userSession.getRoleResourceInfo().checkAllResourceGroup() ? mAgent.setDkcLock(-1L, userSession.getUserName(), userSession.getPassword(), null, 0, ipAddress, iAuthKind) : mAgent.setDkcLock(-1L, userSession.getUserName(), userSession.getPassword(), lockBit, 1, ipAddress, iAuthKind);
        }
        catch (SJcException sjcEx) {
            SJhtclHttpCliUty.getHtclLogger().error(LOG_FUNCTION, LOG_TITLE, "lock", "Failed to lock.", sjcEx);
            throw sjcEx;
        }
        catch (Exception ex) {
            SJhtclHttpCliUty.getHtclLogger().error(LOG_FUNCTION, LOG_TITLE, "lock", "Failed to lock. (Internal Error)", ex);
            SJcException sjcEx = new SJcException("205", "25", "107010");
            throw sjcEx;
        }
        return rscLockId;
    }

    public static void unlock(long rscLockId, BitSet lockBit, SJcRoleResourceContainer roleResource) {
        SJdsSupplierAgent mAgent = SJmoModelMgr.getModelMgr().getSupplierMgr().getAgent();
        try {
            if (roleResource.checkAllResourceGroup()) {
                mAgent.releaseDkcLock(rscLockId, null, 0);
            } else {
                mAgent.releaseDkcLock(rscLockId, lockBit, 1);
            }
        }
        catch (Exception ex) {
            SJhtclHttpCliUty.getHtclLogger().error(LOG_FUNCTION, LOG_TITLE, "unlock", "Failed to release DKC Lock.", ex);
        }
    }

    public static REPORTgetReportHistory getReportList() throws SJcException {
        SJmoModelMgr manager = SJmoModelMgr.getModelMgr();
        SJmoGetAgent getAgent = manager.getDataAgent();
        ArrayList<SJmoGetDirect> listDirect = new ArrayList<SJmoGetDirect>();
        SJctrGetReportInfo kind = new SJctrGetReportInfo();
        SJmoGetRange_IF range = null;
        List filterList = null;
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        listDirect.add(direct);
        List getList = getAgent.getDataInf(listDirect);
        List throughRmiList = (List)getList.get(0);
        SJmoThroughRmiData throughRmi = (SJmoThroughRmiData)throughRmiList.get(0);
        REPORTgetReportHistory_OUT rptObj = (REPORTgetReportHistory_OUT)throughRmi.getObjRmi();
        REPORTgetReportHistory reportHistory = rptObj.getDataObject();
        if (reportHistory == null) {
            SJhtclHttpCliUty.getHtclLogger().error(LOG_FUNCTION, LOG_TITLE, "getReportList", "The report history does not exist. (Internal Error)");
            SJcException sjcEx = new SJcException("205", "25", "107010");
            throw sjcEx;
        }
        REPORTReportInfo[] reportList = reportHistory.getReportList();
        if (reportList == null) {
            SJhtclHttpCliUty.getHtclLogger().error(LOG_FUNCTION, LOG_TITLE, "getReportList", "The report list does not exist. (Internal Error)");
            SJcException sjcEx = new SJcException("205", "25", "107010");
            throw sjcEx;
        }
        return reportHistory;
    }

    public static String createReport(String reportName, SJbaseUserSessionInterface session, Date date) throws SJcException {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        String submittedTime = df.format(date);
        String userName = session.getUserName();
        String reportOutDir = SJctrReportDef.DEFAULT_REPORT_PATH + submittedTime + "_" + reportName;
        REPORTcreateReportInfo_IN applyData = new REPORTcreateReportInfo_IN();
        REPORTReportInfo[] createReport = new REPORTReportInfo[]{new REPORTReportInfo()};
        createReport[0].setSzConfigDir(SJctrReportDef.DEFAULT_CONFIG_PATH);
        createReport[0].setOutputDir(reportOutDir);
        createReport[0].setSzReportName(reportName);
        createReport[0].setSzStartTime(submittedTime);
        createReport[0].setSzUserName(userName);
        createReport[0].setIReportNum(0);
        applyData.setObjPGData(createReport);
        ArrayList<Object> applyList = new ArrayList<Object>();
        applyList.add(applyData);
        SJhtclReportApplyTaskManager mgr = SJhtclReportApplyTaskManager.getReportApplyTaskMgr();
        String taskCode = mgr.execReportApplyTask(applyList, reportName, session, date);
        return taskCode;
    }

    public static void removeReport(String taskName, SJbaseUserSessionInterface session, ArrayList<REPORTReportInfo> delTarget) throws SJcException {
        REPORTdeleteReportInfo_IN applyData = new REPORTdeleteReportInfo_IN();
        REPORTReportInfo[] deleteReport = new REPORTReportInfo[delTarget.size()];
        for (int index = 0; index < delTarget.size(); ++index) {
            String delDir = delTarget.get(index).getOutputDir();
            deleteReport[index] = new REPORTReportInfo();
            deleteReport[index].setOutputDir(delDir);
        }
        applyData.setDataObject(deleteReport);
        ArrayList<Object> applyList = new ArrayList<Object>();
        applyList.add(applyData);
        SJhtclReportRMIUtility.applyReport(applyList, taskName, session);
    }
}

