/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.kms.kmip.client.convert;

import java.util.ArrayList;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.kms.kmip.client.convert.Converter;
import sanproject.sn2.kms.kmip.client.exception.KeyInfoBlankException;
import sanproject.sn2.kms.kmip.client.exception.RequestCommandException;
import sanproject.sn2.kms.kmip.client.exception.ResponseException;
import sanproject.sn2.kms.kmip.client.info.InputInfo;
import sanproject.sn2.kms.kmip.client.info.KeyInfo;
import sanproject.sn2.kms.kmip.client.info.OutputInfo;
import sanproject.sn2.kms.kmip.client.info.common.RequestHeaderContents;
import sanproject.sn2.kms.kmip.client.info.common.Revocation;
import sanproject.sn2.kms.kmip.client.ttlv.TTLV;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVDateTime;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVEnumeration;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVStructure;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVTextString;
import sanproject.sn2.kms.util.SJkmsLogUtil;

public class ConverterRevoke
extends Converter {
    private static final String module = "ConverterRevoke";

    @Override
    public TTLV makeSendTTLV(KeyInfo ki) throws RequestCommandException, KeyInfoBlankException {
        String method = "makeSendTTLV";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        InputInfo ii = ki.getInputInfo();
        ArrayList<Revocation> rvList = ii.getRevocationList();
        if (rvList == null || rvList.size() == 0) {
            STD_LOGGER.info(module, method, " - Revocation List", " - invalid");
            throw new KeyInfoBlankException();
        }
        TTLVStructure tReq = new TTLVStructure(120);
        RequestHeaderContents rhc = ii.getRequestHeaderContents();
        if (rhc != null) {
            rhc.setBatchCount(rvList.size());
        }
        tReq.addValue(this.getRequestHeader(rhc, rvList.size()));
        for (int i = 0; i < rvList.size(); ++i) {
            TTLVStructure tBI = new TTLVStructure(15);
            tReq.addValue(tBI);
            tBI.addValue(new TTLVEnumeration(92, 19));
            TTLVStructure tRP = new TTLVStructure(121);
            tBI.addValue(tRP);
            tRP.addValue(new TTLVTextString(-108, rvList.get((int)i).uid));
            TTLVStructure tRR = new TTLVStructure(-127);
            tRP.addValue(tRR);
            tRR.addValue(new TTLVEnumeration(-126, rvList.get((int)i).reasonCode));
            String msg = rvList.get((int)i).message;
            if (msg != null && msg.length() > 0) {
                tRR.addValue(new TTLVTextString(-128, msg));
            }
            tRP.addValue(new TTLVDateTime(33, rvList.get((int)i).date));
        }
        STD_LOGGER.info(module, method, " - ", " - end");
        return tReq;
    }

    @Override
    public void parseBatchItemList(TTLVStructure resvTTLV, KeyInfo ki) throws ResponseException {
        String method = "parseBatchItemList";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        ArrayList<OutputInfo> oiList = ki.getOutputInfoList();
        if (resvTTLV.getValueSize((byte)15) < 0) {
            return;
        }
        ArrayList<TTLV> al = resvTTLV.getValueList((byte)15);
        for (int i = 0; i < al.size(); ++i) {
            OutputInfo oi = new OutputInfo();
            if (al.get(i).getType() != 1) {
                STD_LOGGER.info(module, method, " - check Type of Batch Item", " - invalid");
                throw new ResponseException();
            }
            TTLVStructure tRP = this.checkBatchItem((TTLVStructure)al.get(i), oi);
            if (tRP != null) {
                this.checkValue(tRP, (byte)-108, (byte)7, 1);
                TTLVTextString tUI = (TTLVTextString)tRP.getValueList((byte)-108).get(0);
                ArrayList<String> uniqueIdentifierList = new ArrayList<String>();
                uniqueIdentifierList.add(tUI.getValue());
                oi.setUniqueIdentifierList(uniqueIdentifierList);
            }
            oiList.add(oi);
        }
        ki.setOutputInfo(oiList);
        STD_LOGGER.info(module, method, " - ", " - end");
    }
}

