/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.kms.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.kms.common.SJkmsConfiguration;
import sanproject.sn2.kms.common.SJkmsKmipConfiguration;
import sanproject.sn2.kms.exception.SJkmsCommunicationException;
import sanproject.sn2.kms.exception.SJkmsConfigTrialException;
import sanproject.sn2.kms.exception.SJkmsConfigUtyException;
import sanproject.sn2.kms.exception.SJkmsKeystoreUtyException;
import sanproject.sn2.kms.util.SJkmsCommunicationUty;
import sanproject.sn2.kms.util.SJkmsConfigUty;
import sanproject.sn2.kms.util.SJkmsKeystoreUty;
import sanproject.sn2.kms.util.SJkmsLogUtil;

public class SJkmsConfigTrial {
    private static final String LOG_FUNCTION = "Kms";
    private static final String LOG_TITLE = "SJkmsConfigTrial";
    private static final String TEST_PRODUCTID = "0000000000";

    private SJkmsConfigTrial() {
    }

    public static List<SJcMessage> kmsKmipConnect(List<SJkmsConfiguration> configs) throws SJkmsConfigTrialException {
        String LOG_SUBTITLE = "kmsKmipConnect";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "kmsKmipConnect", "start");
        ArrayList<SJcMessage> result = new ArrayList<SJcMessage>();
        if (configs == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "kmsKmipConnect", "Parameter is null");
            SJcMessage msg = new SJkmsCommunicationException("107001").getMsg();
            for (SJkmsConfiguration config : configs) {
                result.add(msg);
            }
            STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "kmsKmipConnect", "end");
            return result;
        }
        for (SJkmsConfiguration config : configs) {
            SJcMessage eachResult = null;
            String type = config.getServerType();
            if ("kmip".equals(type)) {
                ArrayList<SJkmsConfiguration> conflist = new ArrayList<SJkmsConfiguration>();
                SJkmsKmipConfiguration dmyConfig = new SJkmsKmipConfiguration();
                if (config.getServerName().equals("PrimaryServer")) {
                    dmyConfig.setServerName("SecondaryServer");
                    dmyConfig.setEnabled(false);
                    conflist.add(config);
                    conflist.add(dmyConfig);
                } else {
                    dmyConfig.setServerName("PrimaryServer");
                    dmyConfig.setHost("");
                    dmyConfig.setEnabled(true);
                    conflist.add(dmyConfig);
                    conflist.add(config);
                }
                Properties properties = null;
                try {
                    properties = SJkmsConfigUty.setKmipConfiguration(conflist);
                }
                catch (SJkmsConfigUtyException ex) {
                    STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "kmsKmipConnect", "Property file error");
                    eachResult = new SJkmsConfigTrialException(ex, "107001").getMsg();
                    result.add(eachResult);
                    continue;
                }
                SJkmsKmipConfiguration kmipconfig = (SJkmsKmipConfiguration)config;
                ArrayList<String> servernames = null;
                try {
                    servernames = new ArrayList<String>();
                    servernames.add(config.getServerName());
                }
                catch (SJcException ex) {
                    STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "kmsKmipConnect", "Property file error");
                    eachResult = new SJkmsConfigTrialException(ex, "107001").getMsg();
                    result.add(eachResult);
                    continue;
                }
                HashMap<String, KeyManager[]> keymanager = null;
                try {
                    keymanager = SJkmsKeystoreUty.getKeyManager(servernames, kmipconfig.getKeyupdate(), kmipconfig.getKeypassword());
                }
                catch (SJkmsKeystoreUtyException ex) {
                    eachResult = new SJkmsConfigTrialException(ex, "105002").getMsg();
                    result.add(eachResult);
                    continue;
                }
                catch (SJcException ex) {
                    eachResult = new SJkmsConfigTrialException(ex, "107001").getMsg();
                    result.add(eachResult);
                    continue;
                }
                String password = kmipconfig.getKeypassword();
                HashMap<String, TrustManager[]> trustmanager = null;
                try {
                    trustmanager = SJkmsKeystoreUty.getTrustManager(servernames, kmipconfig.getCertupdate());
                }
                catch (SJkmsKeystoreUtyException ex) {
                    eachResult = new SJkmsConfigTrialException(ex, "105003").getMsg();
                    result.add(eachResult);
                    continue;
                }
                catch (SJcException ex) {
                    eachResult = new SJkmsConfigTrialException(ex, "107001").getMsg();
                    result.add(eachResult);
                    continue;
                }
                if (dmyConfig.getServerName().equals("PrimaryServer")) {
                    String basekey = "kms.kmip.PrimaryServer.";
                    String key = basekey + "hostenabled";
                    properties.setProperty(key, "false");
                }
                try {
                    SJkmsCommunicationUty.check("kmip", TEST_PRODUCTID, properties, keymanager, kmipconfig.getKeyupdate(), trustmanager, kmipconfig.getCertupdate(), password);
                }
                catch (SJkmsCommunicationException ex) {
                    eachResult = ex.getMsg();
                }
            } else {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "kmsKmipConnect", "Illigal Server Type");
                eachResult = new SJkmsConfigTrialException("107001").getMsg();
            }
            result.add(eachResult);
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "kmsKmipConnect", "end");
        return result;
    }
}

