/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.model.data.lu;

import sanproject.serverux.dataimpl.RJiLUPathIndex;
import sanproject.sn2.model.SJmoException;
import sanproject.sn2.model.SJmoUtility;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.inf.SJmoData_IF;
import sanproject.sn2.model.inf.SJmoDataMacro_IF;

public class SJmoPortLunDetail
extends SJmoPortIndex
implements SJmoData_IF {
    static final long serialVersionUID = 4191298004401186868L;
    private short sHostGroup = (short)-1;
    private short sLUN = (short)-1;
    private short sLDKC = (short)-1;
    private short sCU = (short)-1;
    private short sLDEV = (short)-1;
    private String strLunIndexKey = "";
    private byte byAsymmetricAccessState = (byte)-1;

    public void setSHostGroup(short hostGroup) {
        this.sHostGroup = hostGroup;
    }

    public void setSLUN(short slun) {
        this.sLUN = slun;
    }

    public void setSLDKC(short sldkc) {
        this.sLDKC = sldkc;
    }

    public void setSCU(short scu) {
        this.sCU = scu;
    }

    public void setSLDEV(short sldev) {
        this.sLDEV = sldev;
    }

    public void setLdevIndex(short sLdkc, short sCu, short sLdev) {
        this.setSLDKC(sLdkc);
        this.setSCU(sCu);
        this.setSLDEV(sLdev);
    }

    public void setByAsymmetricAccessState(byte byAsymmetricAccessState) {
        this.byAsymmetricAccessState = byAsymmetricAccessState;
    }

    public short getSHostGroup() {
        return this.sHostGroup;
    }

    public short getSLUN() {
        return this.sLUN;
    }

    public short getSLDKC() {
        return this.sLDKC;
    }

    public short getSCU() {
        return this.sCU;
    }

    public short getSLDEV() {
        return this.sLDEV;
    }

    public byte getByAsymmetricAccessState() {
        return this.byAsymmetricAccessState;
    }

    public SJmoPortLunDetail() {
    }

    public SJmoPortLunDetail(RJiLUPathIndex rmiData) throws SJmoException {
        if (null == rmiData) {
            throw SJmoUtility.getException(201, 23, 107000, "SJmoPortLunDetail", "SJmoPortLunDetail");
        }
        this.setAllData(rmiData);
    }

    public SJmoPortLunDetail(byte byDataMode) {
        this.setIDataMode(byDataMode);
    }

    public void setAllData(RJiLUPathIndex rmiData) throws SJmoException {
        if (null == rmiData) {
            throw SJmoUtility.getException(201, 23, 107000, "SJmoPortLunDetail", "setAllData");
        }
        this.setSPort(rmiData.getSPort());
        this.setSHostGroup(rmiData.getSHostGroup());
        this.setSLUN(rmiData.getSLUN());
        this.setByAsymmetricAccessState(rmiData.getByAsymmetricAccessState());
        this.getIndexKey();
        this.setLdevIndex(rmiData.getSLDKC(), rmiData.getSCU(), rmiData.getSLDEV());
    }

    @Override
    public String getIndexKey() {
        if (0 == this.strLunIndexKey.length()) {
            this.strLunIndexKey = this.makeIndexKey();
        }
        return this.strLunIndexKey;
    }

    @Override
    public boolean isValidIndex() {
        boolean bRet = true;
        if (super.isValidIndex()) {
            if (0 > this.sHostGroup || SJmoDataMacro_IF.NUM_MAX_HTG < this.sHostGroup) {
                bRet = false;
            } else if (0 > this.sLUN || SJmoDataMacro_IF.NUM_MAX_LUN < this.sLUN) {
                bRet = false;
            }
        } else {
            bRet = false;
        }
        return bRet;
    }

    @Override
    public String makeIndexKey() {
        StringBuffer strBuf = new StringBuffer("");
        String strWork = "";
        if (this.isValidIndex()) {
            strWork = SJmoUtility.itoh(this.sPort, 2);
            strBuf.append(strWork);
            strWork = SJmoUtility.itoh(this.sHostGroup, 2);
            strBuf.append(strWork);
            strWork = SJmoUtility.itoh(this.sLUN, 4);
            strBuf.append(strWork);
        }
        return strBuf.toString();
    }

    @Override
    public int compareTo(Object KeyObj) {
        return this.getIndexKey().compareTo(KeyObj.toString());
    }

    @Override
    public String toString() {
        return this.getIndexKey();
    }
}

