/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.model.data.monitor;

import sanproject.sn2.model.SJmoUtility;
import sanproject.sn2.model.data.SJmoModelData_Base;
import sanproject.sn2.model.data.inf.SJmoData_IF;
import sanproject.sn2.model.inf.SJmoDataMacro_IF;

public abstract class SJmoBaseCompositionInfo
extends SJmoModelData_Base
implements SJmoData_IF {
    protected int cluster = -1;
    protected int number = -1;
    protected String name = "";
    protected String strMonCompKey = "";

    public int getCluster() {
        return this.cluster;
    }

    public void setCluster(int cluster) {
        this.cluster = cluster;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getKey() {
        if (0 == this.strMonCompKey.length()) {
            this.strMonCompKey = this.makeKey();
        }
        return this.strMonCompKey;
    }

    public String makeKey() {
        String strKey = "";
        if (this.isValidKey()) {
            strKey = SJmoUtility.itoh(this.getKeyIndex(), this.getDigit());
        }
        return strKey;
    }

    public abstract int getDigit();

    public boolean isValidKey() {
        boolean bRet = true;
        if (this.cluster < 1 || SJmoDataMacro_IF.NUM_MAX_CLASTER < this.cluster) {
            bRet = false;
        }
        if (this.number < this.getMinNumber() || this.getMaxNumber() < this.number) {
            bRet = false;
        }
        return bRet;
    }

    public abstract int getMinNumber();

    public abstract int getMaxNumber();

    public int getKeyIndex() {
        int iKey = -1;
        iKey = this.cluster << 8 | this.number;
        return iKey;
    }

    public boolean isNumKey() {
        return true;
    }

    @Override
    public int compareTo(Object KeyObj) {
        return this.getKey().compareTo(KeyObj.toString());
    }

    public String toString() {
        return this.getKey();
    }
}

