/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.model.data.replication.remote.manager;

import sanproject.sn2.model.SJmoUtility;
import sanproject.sn2.model.data.SJmoModelData_Base;
import sanproject.sn2.model.data.inf.SJmoDataMgr_IF;
import sanproject.sn2.model.data.replication.SJmoReplicationPairVolInfo;
import sanproject.sn2.model.data.util.SJmoLdevUtility;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.inf.SJmoDataMacro_IF;

public class SJmoTrueCopyPairVolInfoMgr
extends SJmoModelData_Base
implements SJmoDataMgr_IF {
    private static final long serialVersionUID = 5601295432245339546L;
    private SJmoReplicationPairVolInfo[] trueCopyPairVolInfoList = new SJmoReplicationPairVolInfo[SJmoDataMacro_IF.MAX_EQIP_LDEV_LDKC];

    public SJmoTrueCopyPairVolInfoMgr(SJmoReplicationPairVolInfo[] trueCopyPairVolInfoList) {
        if (trueCopyPairVolInfoList == null) {
            throw SJmoUtility.getException(201, 23, 107000, this.getClass().getSimpleName(), "Constructor");
        }
        this.trueCopyPairVolInfoList = trueCopyPairVolInfoList;
    }

    public SJmoReplicationPairVolInfo getTrueCopyPairVolInfo(int iLdevId) {
        SJmoReplicationPairVolInfo retTCPairVolInf = null;
        if (SJmoLdevUtility.isValidLdevId(iLdevId)) {
            retTCPairVolInf = this.trueCopyPairVolInfoList[iLdevId];
        }
        return retTCPairVolInf;
    }

    public SJmoReplicationPairVolInfo getTrueCopyPairVolInfo(SJmoLdevIndex ldevIdx) {
        return this.getTrueCopyPairVolInfo(ldevIdx.getIndex());
    }

    public void setTrueCopyPairVolInfo(SJmoReplicationPairVolInfo pairInfo) {
        if (SJmoLdevUtility.isValidLdevId(pairInfo.getIndex())) {
            this.trueCopyPairVolInfoList[pairInfo.getIndex()] = pairInfo;
        } else {
            SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "setTrueCopyPairVolInfo", "pairInfo LDEVIndex invalid:" + pairInfo.getIndex());
        }
    }

    public SJmoReplicationPairVolInfo[] getTrueCopyPairVolInfoList() {
        return this.trueCopyPairVolListCopy(this.trueCopyPairVolInfoList);
    }

    public void setTrueCopyPairVolInfoList(SJmoReplicationPairVolInfo[] trueCopyPairVolInfoList) {
        this.trueCopyPairVolInfoList = trueCopyPairVolInfoList;
    }

    private SJmoReplicationPairVolInfo[] getShallowTrueCopyPairVolInfoList() {
        return this.trueCopyPairVolInfoList;
    }

    private SJmoReplicationPairVolInfo[] trueCopyPairVolListCopy(SJmoReplicationPairVolInfo[] trueCopyPairVolList) {
        return this.trueCopyPairListClone(trueCopyPairVolList, false);
    }

    private SJmoReplicationPairVolInfo[] trueCopyPairVolListDeepCopy(SJmoReplicationPairVolInfo[] trueCopyPairVolList) {
        return this.trueCopyPairListClone(trueCopyPairVolList, true);
    }

    private SJmoReplicationPairVolInfo[] trueCopyPairListClone(SJmoReplicationPairVolInfo[] srcList, boolean bDeepCopy) {
        SJmoReplicationPairVolInfo[] retList = null;
        if (null != srcList) {
            retList = new SJmoReplicationPairVolInfo[srcList.length];
            for (int iListCnt = 0; iListCnt < srcList.length; ++iListCnt) {
                if (bDeepCopy) {
                    if (null == srcList[iListCnt]) continue;
                    try {
                        retList[iListCnt] = (SJmoReplicationPairVolInfo)srcList[iListCnt].clone();
                    }
                    catch (Exception e) {
                        SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "trueCopyPairListClone", "clone failed iListCnt =" + iListCnt + e.toString());
                    }
                    continue;
                }
                retList[iListCnt] = srcList[iListCnt];
            }
        } else {
            SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "trueCopyPairListClone", "srcList is null.");
        }
        return retList;
    }

    @Override
    public Object getToOutSideObj() {
        Object retObj = null;
        try {
            retObj = super.clone();
        }
        catch (Exception e) {
            SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "getToOutSideObj", "Exception " + e.toString());
        }
        return retObj;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SJmoTrueCopyPairVolInfoMgr retObj = (SJmoTrueCopyPairVolInfoMgr)super.clone();
        retObj.setTrueCopyPairVolInfoList(retObj.trueCopyPairVolListDeepCopy(retObj.getShallowTrueCopyPairVolInfoList()));
        return retObj;
    }

    @Override
    public Object clone(byte byDataMode) throws CloneNotSupportedException {
        SJmoModelData_Base retObj = (SJmoModelData_Base)this.clone();
        retObj.setIDataMode(byDataMode);
        return retObj;
    }
}

