/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.model.data.system;

import java.util.ArrayList;
import java.util.Collections;
import sanproject.serverux.dataimpl.PRMCLPRClass;
import sanproject.serverux.dataimpl.PRMDiskAddress;
import sanproject.sn2.model.SJmoException;
import sanproject.sn2.model.SJmoUtility;
import sanproject.sn2.model.data.SJmoModelData_Base;
import sanproject.sn2.model.data.inf.SJmoData_IF;
import sanproject.sn2.model.data.system.SJmoClprIndex;
import sanproject.sn2.model.data.system.SJmoDiskAddress;
import sanproject.sn2.model.data.util.SJmoDataUtility;

public class SJmoClprInfo
extends SJmoClprIndex
implements SJmoData_IF {
    static final long serialVersionUID = -4821029420289600794L;
    private String strClprName = "";
    private short sSLPRID = 0;
    private int iCacheCapacity = -1;
    private int iDCRCapacity = -1;
    private int iDCRExtentLimit = -1;
    private ArrayList<SJmoDiskAddress> diskAddressList = new ArrayList();

    public void setStrClprName(String strClprName) {
        this.strClprName = strClprName;
    }

    public void setSSLPRID(short sslprid) {
        this.sSLPRID = sslprid;
    }

    public void setICacheCapacity(int cacheCapacity) {
        this.iCacheCapacity = cacheCapacity;
    }

    public void setIDCRCapacity(int capacity) {
        this.iDCRCapacity = capacity;
    }

    public void setIDCRExtentLimit(int extentLimit) {
        this.iDCRExtentLimit = extentLimit;
    }

    public void setDiskAddressList(ArrayList<SJmoDiskAddress> diskAddressList) {
        this.diskAddressList = diskAddressList;
    }

    public String getStrClprName() {
        return this.strClprName;
    }

    public short getSSLPRID() {
        return this.sSLPRID;
    }

    public int getICacheCapacity() {
        return this.iCacheCapacity;
    }

    public int getIDCRCapacity() {
        return this.iDCRCapacity;
    }

    public int getIDCRExtentLimit() {
        return this.iDCRExtentLimit;
    }

    public ArrayList<SJmoDiskAddress> getDiskAddressList() {
        return this.diskAddressList;
    }

    public SJmoClprInfo() {
    }

    public SJmoClprInfo(PRMCLPRClass rmiData) throws SJmoException {
        if (null == rmiData) {
            throw SJmoUtility.getException(201, 23, 107000, "SJmoClprInfo", "SJmoClprInfo");
        }
        this.setAllData(rmiData);
    }

    public void setAllData(PRMCLPRClass rmiData) throws SJmoException {
        ArrayList<SJmoDiskAddress> alDiskAdrs;
        if (null != rmiData) {
            this.setSClpr(rmiData.getSCLPR());
            this.getIndexKey();
            if (null != rmiData.getCLPRName()) {
                this.setStrClprName(rmiData.getCLPRName());
            }
            this.setSSLPRID(rmiData.getSSLPR());
            this.setICacheCapacity(rmiData.getICacheCapacity());
            this.setIDCRCapacity(rmiData.getIDCRCapacity());
            this.setIDCRExtentLimit(rmiData.getIDCRExtentLimit());
            PRMDiskAddress[] rmiPrmDiskAdrs = rmiData.prmDiskAddress;
            alDiskAdrs = new ArrayList<SJmoDiskAddress>(rmiPrmDiskAdrs.length);
            for (int i = 0; i < rmiPrmDiskAdrs.length; ++i) {
                if (rmiPrmDiskAdrs[i] == null) continue;
                SJmoDiskAddress moDiskAdrs = new SJmoDiskAddress(rmiPrmDiskAdrs[i]);
                alDiskAdrs.add(moDiskAdrs);
            }
        } else {
            throw SJmoUtility.getException(201, 23, 107000, "SJmoClprInfo", "setAllData");
        }
        Collections.sort(alDiskAdrs);
        alDiskAdrs.trimToSize();
        this.setDiskAddressList(alDiskAdrs);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SJmoClprInfo cloneObj = (SJmoClprInfo)super.clone();
        cloneObj.setDiskAddressList(SJmoDataUtility.alDeepCopy(cloneObj.getDiskAddressList()));
        return cloneObj;
    }

    @Override
    public Object clone(byte byDataMode) throws CloneNotSupportedException {
        SJmoModelData_Base retObj = (SJmoModelData_Base)this.clone();
        retObj.setIDataMode(byDataMode);
        return retObj;
    }
}

