/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.model.update;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import java.io.Serializable;
import java.util.ArrayList;
import sanproject.serversx.data.RJiCUIndex;
import sanproject.serversx.data.RJiLDEVIndex;
import sanproject.serverux.dataimpl.MRCFgetPairLdev;
import sanproject.serverux.dataimpl.MRCFgetPairStatusEx;
import sanproject.serverux.dataimpl.MrcGetPairInf_Input;
import sanproject.serverux.dataimpl.MrcGetPairInf_Output;
import sanproject.serverux.dataimpl.SIgetPairFilter;
import sanproject.serverux.dataimpl.SIgetPairParam;
import sanproject.sn2.model.SJmoException;
import sanproject.sn2.model.SJmoUtility;
import sanproject.sn2.model.data.SJmoModelDataMgr;
import sanproject.sn2.model.data.util.SJmoDataUtility;
import sanproject.sn2.model.data.util.SJmoLdevUtility;
import sanproject.sn2.model.data.util.SJmoReplicationUtility;
import sanproject.sn2.model.inf.SJmoDataMacro_IF;
import sanproject.sn2.model.inf.SJmoKeyValueDefine_IF;
import sanproject.sn2.model.update.SJmoDataUpDateByPairVolInf;

public class SJmoLocalReplicationPairUpdate
extends SJmoDataUpDateByPairVolInf
implements SJmoKeyValueDefine_IF {
    protected ArrayList<Integer> alSiPairInfLdevIndex = new ArrayList();
    protected ArrayList<RJiLDEVIndex> alTiPairPLdevIndex = new ArrayList();
    protected ArrayList<RJiLDEVIndex> alTiPairSLdevIndex = new ArrayList();
    protected boolean bSiPairSizeZeroGetChk = false;
    protected boolean bQsPairSizeZeroGetChk = false;

    @Override
    protected ArrayList getRmiData() throws SJmoException {
        int[] iSiLdevIndex = null;
        ArrayList<Serializable> objRet = new ArrayList<Serializable>();
        ArrayList<MRCFgetPairLdev> alSiPairInfList = new ArrayList<MRCFgetPairLdev>();
        int iStartIndex = 0;
        int iPairInfGetCount = 0;
        boolean bSiPairSummaryInfGetChk = false;
        try {
            super.getVolPosInf();
            this.setPairInfoLdevIndex();
            SIgetPairParam siPairParam = new SIgetPairParam();
            siPairParam.setSTgtPp((short)-32754);
            SIgetPairFilter siPairFilter = new SIgetPairFilter();
            while (!bSiPairSummaryInfGetChk || this.alSiPairInfLdevIndex.size() > 0) {
                if (this.alSiPairInfLdevIndex.size() == 0) {
                    iSiLdevIndex = this.iMakeDummyLdevIndex();
                    this.bSiPairSizeZeroGetChk = true;
                } else {
                    int iLdevIndexSize = 0;
                    int iLdevSizeTmp = this.alSiPairInfLdevIndex.subList(iStartIndex, this.alSiPairInfLdevIndex.size()).size();
                    iLdevIndexSize = iLdevSizeTmp > 4096 ? 4096 : iLdevSizeTmp;
                    iSiLdevIndex = SJmoDataUtility.intArrayCast(this.alSiPairInfLdevIndex.subList(iStartIndex, iStartIndex + iLdevIndexSize));
                    if (iSiLdevIndex.length == 0) {
                        SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "getRmiData", "Acquisition demand LDEV list size = " + iSiLdevIndex.length);
                        break;
                    }
                }
                siPairFilter.setLDEVIndex(iSiLdevIndex);
                siPairParam.setSiFlt(siPairFilter);
                MrcGetPairInf_Input siInput = new MrcGetPairInf_Input(siPairParam);
                MrcGetPairInf_Output siOutput = (MrcGetPairInf_Output)this.m_supAgnt.getDataInf(siInput, false);
                if (siOutput != null) {
                    MRCFgetPairStatusEx PairInf = siOutput.getInf();
                    if (!bSiPairSummaryInfGetChk) {
                        objRet.add(PairInf);
                        bSiPairSummaryInfGetChk = true;
                    }
                    MRCFgetPairLdev[] pairLdevInfList = (MRCFgetPairLdev[])PairInf.getPairLdev();
                    for (int iPairLdevCnt = 0; iPairLdevCnt < pairLdevInfList.length; ++iPairLdevCnt) {
                        MRCFgetPairLdev pairLdevInf = pairLdevInfList[iPairLdevCnt];
                        if ((4 & pairLdevInf.getVolAtrb()) != 0) {
                            if (pairLdevInf.getAlPairInf().size() == 0) break;
                            alSiPairInfList.add(pairLdevInf);
                            continue;
                        }
                        int iFcRelation = pairLdevInf.getIFcRelation();
                        if ((0x80 & pairLdevInf.getVolAtrb()) == 0 && (iFcRelation & 1) == 0 && (iFcRelation & 2) == 0) continue;
                        alSiPairInfList.add(pairLdevInf);
                    }
                    if (alSiPairInfList.size() >= this.alSiPairInfLdevIndex.size()) break;
                    iStartIndex = alSiPairInfList.size();
                    if (++iPairInfGetCount < 25) continue;
                    this.m_strLog = "[SJmoLocalReplicationPairUpdate]getRmi:PairInfGetCount:25Over";
                    this.putLog(this.m_strLog);
                    throw this.throwExp("SJmoLocalReplicationPairUpdate", "getRmiData");
                }
                this.m_strLog = "[SJmoLocalReplicationPairUpdate]getRmi:getDataInf return is [siOutput]null";
                this.putLog(this.m_strLog);
                throw this.throwExp("SJmoLocalReplicationPairUpdate", "getRmiData");
            }
            objRet.add(alSiPairInfList);
            if (this.alTiPairPLdevIndex.size() == 0) {
                objRet.add(null);
            } else {
                SanResponse tiRootLdevRes = this.getRmiDataTiRootLdev();
                SJmoReplicationUtility.checkKeyValueErrorInfo(tiRootLdevRes);
                objRet.add((Serializable)tiRootLdevRes);
            }
            if (this.alTiPairSLdevIndex.size() == 0) {
                objRet.add(null);
            } else {
                SanResponse tiPairs = this.getRmiDataTiPairOfSecondaryVol();
                SJmoReplicationUtility.checkKeyValueErrorInfo(tiPairs);
                objRet.add((Serializable)tiPairs);
            }
        }
        catch (SJmoException moExp) {
            this.m_strLog = "[SJmoLocalReplicationPairUpdate]getRmiData[Catch SJmoException.]";
            this.putLog(this.m_strLog);
            throw moExp;
        }
        return objRet;
    }

    private SanResponse getRmiDataTiRootLdev() {
        try {
            SanRequest tiRootLdevReq = this.m_supAgnt.newRequest("MRCFreadSnapshotRootLdevInfo");
            SanList reqLdevsList = tiRootLdevReq.newList("RootLdevs");
            for (RJiLDEVIndex rjiLdev : this.alTiPairPLdevIndex) {
                int[] iLdevId = new int[]{rjiLdev.getSLDKC(), rjiLdev.getSCU(), rjiLdev.getSLDEV()};
                SanObject id = reqLdevsList.addObj();
                id.putIntArray("Id", iLdevId);
            }
            SanResponse tiRootLdevRes = this.m_supAgnt.getDataInf(tiRootLdevReq, false);
            return tiRootLdevRes;
        }
        catch (SanDataException ex) {
            SJmoUtility.putLogDetail("SJmoLocalReplicationPairUpdate", "getRmiDataTiRootLdev", "SanDataException:" + ex.getMessage());
            throw this.throwExp("SJmoLocalReplicationPairUpdate", "getRmiDataTiRootLdev");
        }
    }

    private SanResponse getRmiDataTiPairOfSecondaryVol() {
        try {
            SanRequest tiPairOfSvol = this.m_supAgnt.newRequest("MRCFreadTiPairOfSecondaryVolumes");
            SanList reqLdevsList = tiPairOfSvol.newList("SecondaryVolumes");
            for (RJiLDEVIndex rjiLdev : this.alTiPairSLdevIndex) {
                int[] iLdevId = new int[]{rjiLdev.getSLDKC(), rjiLdev.getSCU(), rjiLdev.getSLDEV()};
                SanObject ldev = reqLdevsList.addObj();
                SanObject id = ldev.newObj("Ldev");
                id.putIntArray("Id", iLdevId);
            }
            SanResponse tiPairs = this.m_supAgnt.getDataInf(tiPairOfSvol, false);
            return tiPairs;
        }
        catch (SanDataException ex) {
            SJmoUtility.putLogDetail("SJmoLocalReplicationPairUpdate", "getRmiDataTiPairOfSecondaryVol", "SanDataException:" + ex.getMessage());
            throw this.throwExp("SJmoLocalReplicationPairUpdate", "getRmiDataTiPairOfSecondaryVol");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean setModelData(SJmoModelDataMgr dataMgr, Object objRmi) throws SJmoException {
        boolean bRet = true;
        ArrayList alMrcfPairLdevList = new ArrayList();
        ArrayList alObjRmi = new ArrayList();
        MRCFgetPairStatusEx rmiSiPairSummary = null;
        MRCFgetPairLdev[] rmiSiPairVolInfo = null;
        SanResponse tiRootLdevRes = null;
        SanResponse tiPairsRes = null;
        if (objRmi == null) {
            this.m_strLog = "[SJmoLocalReplicationPairUpdate]setModelData:objRmi is null";
            this.putLog(this.m_strLog);
            throw this.throwExp("SJmoLocalReplicationPairUpdate", "setModelData");
        }
        if (!(objRmi instanceof ArrayList)) {
            this.m_strLog = "[SJmoLocalReplicationPairUpdate]setModelData:objRmi not cast ArrayList";
            this.putLog(this.m_strLog);
            throw this.throwExp("SJmoLocalReplicationPairUpdate", "setModelData");
        }
        alObjRmi = (ArrayList)objRmi;
        if (alObjRmi.size() != 4) {
            this.m_strLog = "[SJmoLocalReplicationPairUpdate]setModelData:alobjRmi is not Size";
            this.putLog(this.m_strLog);
            throw this.throwExp("SJmoLocalReplicationPairUpdate", "setModelData");
        }
        if (alObjRmi.get(0) == null) {
            this.m_strLog = "[SJmoLocalReplicationPairUpdate]setModelData:objRmi[0] is null";
            this.putLog(this.m_strLog);
            throw this.throwExp("SJmoLocalReplicationPairUpdate", "setModelData");
        }
        if (!(alObjRmi.get(0) instanceof MRCFgetPairStatusEx)) {
            this.m_strLog = "[SJmoLocalReplicationPairUpdate]setModelData:objRmi[0] not cast MRCFgetPairStatusEx";
            this.putLog(this.m_strLog);
            throw this.throwExp("SJmoLocalReplicationPairUpdate", "setModelData");
        }
        rmiSiPairSummary = (MRCFgetPairStatusEx)alObjRmi.get(0);
        if (alObjRmi.get(1) == null) {
            this.m_strLog = "[SJmoLocalReplicationPairUpdate]setModelData:objRmi[1] is null";
            this.putLog(this.m_strLog);
            throw this.throwExp("SJmoLocalReplicationPairUpdate", "setModelData");
        }
        if (!(alObjRmi.get(1) instanceof ArrayList)) {
            this.m_strLog = "[SJmoLocalReplicationPairUpdate]setModelData:objRmi[1] not cast ArrayList";
            this.putLog(this.m_strLog);
            throw this.throwExp("SJmoLocalReplicationPairUpdate", "setModelData");
        }
        alMrcfPairLdevList = (ArrayList)alObjRmi.get(1);
        rmiSiPairVolInfo = !this.bSiPairSizeZeroGetChk ? alMrcfPairLdevList.toArray(new MRCFgetPairLdev[alMrcfPairLdevList.size()]) : new MRCFgetPairLdev[]{};
        if (alObjRmi.get(2) != null) {
            if (!(alObjRmi.get(2) instanceof SanResponse)) {
                this.m_strLog = "[SJmoLocalReplicationPairUpdate]setModelData:objRmi[2] not cast SanResponse";
                this.putLog(this.m_strLog);
                throw this.throwExp("SJmoLocalReplicationPairUpdate", "setModelData");
            }
            tiRootLdevRes = (SanResponse)alObjRmi.get(2);
        }
        if (alObjRmi.get(3) != null) {
            if (!(alObjRmi.get(3) instanceof SanResponse)) {
                this.m_strLog = "[SJmoLocalReplicationPairUpdate]setModelData:objRmi[3] not cast SanResponse";
                this.putLog(this.m_strLog);
                throw this.throwExp("SJmoLocalReplicationPairUpdate", "setModelData");
            }
            tiPairsRes = (SanResponse)alObjRmi.get(3);
        }
        dataMgr.setRenewLocalReplicationTiPvolInfo(tiRootLdevRes, this.m_CUIndex);
        dataMgr.setRenewLocalReplicationSummary(rmiSiPairSummary);
        dataMgr.setRenewLocalReplicationPairInfo(rmiSiPairVolInfo, tiPairsRes, this.m_CUIndex);
        return bRet;
    }

    protected void setPairInfoLdevIndex() throws SJmoException {
        this.m_CUIndex = this.getDiffCuIndex();
        if (this.m_CUIndex != null) {
            for (int iCuCnt = 0; iCuCnt < this.m_CUIndex.length; ++iCuCnt) {
                RJiCUIndex cuIdx = this.m_CUIndex[iCuCnt];
                for (int iLdevCnt = 0; iLdevCnt < SJmoDataMacro_IF.MAX_LDEV_CU; ++iLdevCnt) {
                    RJiLDEVIndex ldIdx;
                    int iLdevIndex = SJmoLdevUtility.getLdevIndex((short)0, cuIdx.getSCU(), (short)iLdevCnt);
                    int iVolPosInf = this.volPosInf.getIVolPosBitMap(iLdevIndex);
                    if (this.bSISIMFPairVolPosChk(iVolPosInf)) {
                        this.alSiPairInfLdevIndex.add(iLdevIndex);
                    }
                    if (this.bQSPVolVolPosChk(iVolPosInf)) {
                        ldIdx = new RJiLDEVIndex();
                        ldIdx.setLDEVIndex((short)0, cuIdx.getSCU(), (short)iLdevCnt);
                        this.alTiPairPLdevIndex.add(ldIdx);
                    }
                    if (!this.bQSSVolVolPosChk(iVolPosInf)) continue;
                    ldIdx = new RJiLDEVIndex();
                    ldIdx.setLDEVIndex((short)0, cuIdx.getSCU(), (short)iLdevCnt);
                    this.alTiPairSLdevIndex.add(ldIdx);
                }
            }
        } else {
            this.m_strLog = "[SJmoLocalReplicationPairUpdate]m_cuIndex is null";
            this.putLog(this.m_strLog);
            throw this.throwExp("SJmoLocalReplicationPairUpdate", "setPairInfoLdevIndex");
        }
    }

    private int[] iMakeDummyLdevIndex() {
        return new int[]{1};
    }

    private boolean bSISIMFPairVolPosChk(int iVolPosInf) {
        boolean bRet = false;
        if ((iVolPosInf & 0x3000084) != 0) {
            bRet = true;
        }
        if (!bRet && (iVolPosInf & 8) == 0 && (iVolPosInf & 0x10) != 0) {
            bRet = true;
        }
        if (!bRet && (iVolPosInf & 0x100) == 0 && (iVolPosInf & 0x200) != 0) {
            bRet = true;
        }
        return bRet;
    }

    private boolean bQSPVolVolPosChk(int iVolPosInf) {
        boolean bRet = false;
        if ((iVolPosInf & 0x400000) != 0) {
            bRet = true;
        }
        return bRet;
    }

    private boolean bQSSVolVolPosChk(int iVolPosInf) {
        boolean bRet = false;
        if ((iVolPosInf & 0x800000) != 0) {
            bRet = true;
        }
        return bRet;
    }
}

