/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.modelrc.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import sanproject.sn2.model.SJmoUtility;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.kind.SJmoGetSsidDetail;
import sanproject.sn2.model.connector.kind.SJmoGetSsidSummary;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoSsidDetail;
import sanproject.sn2.model.data.volume.SJmoSsidSummary;
import sanproject.sn2.model.inf.SJmoDataMacro_IF;
import sanproject.sn2.modelrc.inf.SJmoRscMacro_IF;
import sanproject.sn2.modelrc.util.SJmoRscUtil;

public class SJmoRscUtilSsid
extends SJmoRscUtil {
    private ArrayList m_alSsidDetail_MBase = new ArrayList();
    private ArrayList m_alSsidDetail_MCtrl = new ArrayList();
    private ArrayList m_alSsidDetail_Rsv = new ArrayList();
    private ArrayList m_alSsidDetail_Diff = new ArrayList();
    private SJmoSsidSummary m_SsidSummary_MBase;
    private SJmoSsidSummary m_SsidSummary_MCtrl;
    private SJmoSsidDetail[] m_SsidDetail_Emu;
    private int[] m_ldevSsid_Emu;

    @Override
    public void setModelData(List lsModelData) {
        try {
            SJmoUtility.putLogDetail("SJmoRscUtilSsid", "setModelData", "start");
            block2: for (int iListCnt = 0; iListCnt < lsModelData.size(); ++iListCnt) {
                if (lsModelData.get(iListCnt) == null) continue;
                ArrayList arylstModel = new ArrayList();
                arylstModel = (ArrayList)lsModelData.get(iListCnt);
                for (int iAryListCnt = 0; iAryListCnt < arylstModel.size(); ++iAryListCnt) {
                    if (arylstModel.get(iAryListCnt) == null) continue;
                    if (arylstModel.get(iAryListCnt) instanceof SJmoSsidDetail && this.m_alSsidDetail_MCtrl.size() == 0) {
                        this.m_alSsidDetail_MBase = arylstModel;
                        this.m_alSsidDetail_MCtrl = arylstModel;
                        continue block2;
                    }
                    if (!(arylstModel.get(iAryListCnt) instanceof SJmoSsidSummary) || this.m_SsidSummary_MCtrl != null) continue;
                    this.m_SsidSummary_MBase = (SJmoSsidSummary)arylstModel.get(iAryListCnt);
                    this.m_SsidSummary_MCtrl = (SJmoSsidSummary)arylstModel.get(iAryListCnt);
                    continue block2;
                }
            }
            this.setRenewEmuData();
            SJmoUtility.putLogDetail("SJmoRscUtilSsid", "setModelData", "end");
        }
        catch (Exception e) {
            SJmoUtility.putLogDetail("SJmoRscUtilSsid", "setModelData", "err:" + e.toString());
            throw SJmoUtility.getException(201, 23, 107021, " SJmoRscUtilSsid", "setModelData");
        }
    }

    @Override
    public void setRsvData(List lsRsvData) {
        try {
            if (!this.delupdateRsvData(lsRsvData, 1)) {
                throw SJmoUtility.getException(201, 23, 107021, " SJmoRscUtilSsid", "setRsvData");
            }
        }
        catch (Exception e) {
            SJmoUtility.putLogDetail("SJmoRscUtilSsid", "setRsvData", "err:" + e.toString());
            throw SJmoUtility.getException(201, 23, 107021, " SJmoRscUtilSsid", "setRsvData");
        }
    }

    @Override
    public void delRsvData(List lsRsvData) {
        try {
            if (!this.delupdateRsvData(lsRsvData, 2)) {
                throw SJmoUtility.getException(201, 23, 107021, " SJmoRscUtilSsid", "delRsvData");
            }
        }
        catch (Exception e) {
            SJmoUtility.putLogDetail("SJmoRscUtilSsid", "delRsvData", "err:" + e.toString());
            throw SJmoUtility.getException(201, 23, 107021, " SJmoRscUtilSsid", "delRsvData");
        }
    }

    private boolean delupdateRsvData(List lsRsvData, int iexecflag) {
        boolean bRet = false;
        boolean iAddIndex = false;
        try {
            boolean bdatachange = false;
            Collections.sort(this.m_alSsidDetail_Rsv);
            for (int iListCnt = 0; iListCnt < lsRsvData.size(); ++iListCnt) {
                if (lsRsvData.get(iListCnt) == null) continue;
                ArrayList arylstRsv = new ArrayList();
                arylstRsv = (ArrayList)lsRsvData.get(iListCnt);
                for (int iAryListCnt = 0; iAryListCnt < arylstRsv.size(); ++iAryListCnt) {
                    if (arylstRsv.get(iAryListCnt) == null || !(arylstRsv.get(iAryListCnt) instanceof SJmoSsidDetail)) continue;
                    int iAryListIndex = Collections.binarySearch(this.m_alSsidDetail_Rsv, arylstRsv.get(iAryListCnt));
                    if (iAryListIndex >= 0) {
                        if (iexecflag == 1) {
                            this.m_alSsidDetail_Rsv.set(iAryListIndex, arylstRsv.get(iAryListCnt));
                            bdatachange = true;
                            continue;
                        }
                        this.m_alSsidDetail_Rsv.remove(iAryListIndex);
                        bdatachange = true;
                        continue;
                    }
                    if (iexecflag != 1) continue;
                    this.m_alSsidDetail_Rsv.add(arylstRsv.get(iAryListCnt));
                    bdatachange = true;
                }
            }
            if (bdatachange) {
                this.setRenewEmuData();
            }
            bRet = true;
        }
        catch (Exception e) {
            SJmoUtility.putLogDetail("SJmoRscUtilSsid", "delupdateRsvData", "err:" + e.toString());
            throw SJmoUtility.getException(201, 23, 107021, " SJmoRscUtilSsid", "delupdateRsvData");
        }
        return bRet;
    }

    @Override
    public void clearRsvData() {
        try {
            SJmoUtility.putLogDetail("SJmoRscUtilSsid", "clearRsvData", "start");
            this.m_alSsidDetail_Rsv.clear();
            this.setRenewEmuData();
            SJmoUtility.putLogDetail("SJmoRscUtilSsid", "clearRsvData", "end");
        }
        catch (Exception e) {
            SJmoUtility.putLogDetail("SJmoRscUtilSsid", "clearRsvData", "err:" + e.toString());
            throw SJmoUtility.getException(201, 23, 107021, " SJmoRscUtilSsid", "clearRsvData");
        }
    }

    @Override
    public List getRsvData() {
        ArrayList<ArrayList> lstlist = new ArrayList<ArrayList>();
        lstlist.add(this.m_alSsidDetail_Rsv);
        return lstlist;
    }

    @Override
    public void setDiffData(List lsDiffData) {
        try {
            SJmoUtility.putLogDetail("SJmoRscUtilSsid", "setDiffData", "start");
            boolean bdatachange = false;
            block2: for (int iListCnt = 0; iListCnt < lsDiffData.size(); ++iListCnt) {
                if (lsDiffData.get(iListCnt) == null) continue;
                ArrayList arylstDiff = new ArrayList();
                arylstDiff = (ArrayList)lsDiffData.get(iListCnt);
                for (int iAryListCnt = 0; iAryListCnt < arylstDiff.size(); ++iAryListCnt) {
                    if (arylstDiff.get(iAryListCnt) == null || !(arylstDiff.get(iAryListCnt) instanceof SJmoSsidDetail)) continue;
                    this.m_alSsidDetail_Diff = arylstDiff;
                    bdatachange = true;
                    continue block2;
                }
            }
            if (bdatachange) {
                this.setRenewEmuData();
            }
            SJmoUtility.putLogDetail("SJmoRscUtilSsid", "setDiffData", "end");
        }
        catch (Exception e) {
            SJmoUtility.putLogDetail("SJmoRscUtilSsid", "setDiffData", "err:" + e.toString());
            throw SJmoUtility.getException(201, 23, 107021, " SJmoRscUtilSsid", "setDiffData");
        }
    }

    @Override
    public List getNeccessityCls() {
        ArrayList<SJmoGetDirect> lsGetDirect = new ArrayList<SJmoGetDirect>();
        SJmoGetDirect direct = new SJmoGetDirect();
        direct.setGetKind(new SJmoGetSsidDetail());
        lsGetDirect.add(direct);
        direct = new SJmoGetDirect();
        direct.setGetKind(new SJmoGetSsidSummary());
        lsGetDirect.add(direct);
        return lsGetDirect;
    }

    private void setRenewEmuData() {
        try {
            short iSSIDBoundary = this.m_SsidSummary_MCtrl.getSSIDBoundary();
            if (iSSIDBoundary != 64 && iSSIDBoundary != 256) {
                SJmoUtility.putLogDetail("SJmoRscUtilSsid", "setRenewEmuData", "iSSIDBoundary = " + iSSIDBoundary);
            }
            int iSSIDBoundArray = SJmoDataMacro_IF.MAX_EQIP_LDEV_LDKC / iSSIDBoundary;
            this.m_ldevSsid_Emu = new int[iSSIDBoundArray];
            this.m_SsidDetail_Emu = new SJmoSsidDetail[SJmoDataMacro_IF.NUM_MAX_SSID + 1];
            this.CreateBound(this.m_alSsidDetail_MCtrl);
            this.CreateBound(this.m_alSsidDetail_Rsv);
            this.CreateBound(this.m_alSsidDetail_Diff);
        }
        catch (Exception e) {
            SJmoUtility.putLogDetail("SJmoRscUtilSsid", "setRenewEmuData", "err:" + e.toString());
            throw SJmoUtility.getException(201, 23, 107021, " SJmoRscUtilSsid", "setRenewEmuData");
        }
    }

    private void CreateBound(List lsListData) {
        try {
            short sSSIDBoundary = this.m_SsidSummary_MCtrl.getSSIDBoundary();
            if (sSSIDBoundary != 64 && sSSIDBoundary != 256) {
                SJmoUtility.putLogDetail("SJmoRscUtilSsid", "CreateBound", "sSSIDBoundary = " + sSSIDBoundary);
            }
            Iterator lstList = lsListData.iterator();
            while (lstList.hasNext()) {
                SJmoSsidDetail ssiddetail = new SJmoSsidDetail();
                ssiddetail = (SJmoSsidDetail)lstList.next();
                int iLDEVstartNo = ssiddetail.getStartLDEV();
                short iCu = ssiddetail.getCU();
                iLDEVstartNo = iCu * SJmoDataMacro_IF.MAX_LDEV_CU + iLDEVstartNo;
                if (iLDEVstartNo < 0 || iLDEVstartNo > SJmoRscMacro_IF.RSC_LDEVID_MAX) {
                    SJmoUtility.putLogDetail("SJmoRscUtilSsid", "CreateBound", "iLDEVstartNo = " + iLDEVstartNo);
                }
                int iIndexBound = iLDEVstartNo / sSSIDBoundary;
                this.m_ldevSsid_Emu[iIndexBound] = ssiddetail.getSSID();
                int iIndex = ssiddetail.getSSID();
                this.m_SsidDetail_Emu[iIndex] = ssiddetail;
            }
        }
        catch (Exception e) {
            SJmoUtility.putLogDetail("SJmoRscUtilSsid", "CreateBound", "err:" + e.toString());
            throw SJmoUtility.getException(201, 23, 107021, " SJmoRscUtilSsid", "CreateBound");
        }
    }

    public int chkSsid(int iSsid, SJmoLdevIndex ldevIndex) {
        int iRet = 2;
        try {
            if (ldevIndex == null) {
                iRet = 2;
                return iRet;
            }
            int iLdevIndex = ldevIndex.getIndex();
            if (iLdevIndex < 0 || iLdevIndex > SJmoRscMacro_IF.RSC_LDEVID_MAX) {
                throw SJmoUtility.getException(201, 23, 107022, "SJmoRscUtilSsid", "chkSsid:ldevIndex");
            }
            if (iSsid < 4 || iSsid > SJmoRscMacro_IF.RSC_SSID_MAX) {
                throw SJmoUtility.getException(201, 23, 107022, "SJmoRscUtilSsid", "chkSsid: iSsid ");
            }
            short iSSIDBoundary = this.m_SsidSummary_MCtrl.getSSIDBoundary();
            if (iSSIDBoundary != 64 && iSSIDBoundary != 256) {
                SJmoUtility.putLogDetail("SJmoRscUtilSsid", "setRenewEmuData", "iSSIDBoundary = " + iSSIDBoundary);
            }
            int iIndex = iLdevIndex / iSSIDBoundary;
            if (this.m_ldevSsid_Emu == null) {
                SJmoUtility.putLogDetail("SJmoRscUtilSsid", "chkSsid no1", "chkSsid: m_ldevSsid_Emu null");
                throw SJmoUtility.getException(201, 23, 107022, "SJmoRscUtilSsid", "chkSsid: m_ldevSsid_Emu null ");
            }
            int ichkSSID = this.m_ldevSsid_Emu[iIndex];
            iRet = ichkSSID == 0 ? (this.m_SsidDetail_Emu[iSsid] != null ? 1 : 0) : (ichkSSID == iSsid ? 0 : 2);
        }
        catch (Exception e) {
            SJmoUtility.putLogDetail("SJmoRscUtilSsid", "chkSsid no1", "err:" + e.toString());
            throw SJmoUtility.getException(201, 23, 107021, " SJmoRscUtilSsid", "chkSsid no1");
        }
        return iRet;
    }

    public int chkSsid(int iSsid, short sLdkc, short sCu, short sLdev) {
        try {
            int iRet = 2;
            SJmoLdevIndex idxTmp = new SJmoLdevIndex();
            idxTmp.setLdevIndex(sLdkc, sCu, sLdev);
            iRet = this.chkSsid(iSsid, idxTmp);
            return iRet;
        }
        catch (Exception e) {
            SJmoUtility.putLogDetail("SJmoRscUtilSsid", "chkSsid no2", "err:" + e.toString());
            throw SJmoUtility.getException(201, 23, 107021, " SJmoRscUtilSsid", "chkSsid no2 ");
        }
    }

    @Override
    protected List getModelData() {
        ArrayList lsModel = new ArrayList();
        ArrayList<SJmoSsidSummary> lsSumry = new ArrayList<SJmoSsidSummary>();
        SJmoUtility.putLogDetail("SJmoRscUtilSsid", "getModelData", "getModelData Start");
        try {
            lsModel.add(this.m_alSsidDetail_MBase);
            lsSumry.add(this.m_SsidSummary_MBase);
            lsModel.add(lsSumry);
        }
        catch (Exception moExp) {
            SJmoUtility.putLogDetail("SJmoRscUtilSsid", "getModelData", "err:" + moExp.toString());
            throw SJmoUtility.getException(201, 23, 107021, " SJmoRscUtilSsid", "getModelData");
        }
        SJmoUtility.putLogDetail("SJmoRscUtilSsid", "getModelData", "getModelData End");
        return lsModel;
    }

    @Override
    public void clearModelData() {
        SJmoUtility.putLogDetail("SJmoRscUtilSsid", "clearModelData", "clearModelData Start");
        this.m_alSsidDetail_MCtrl = this.m_alSsidDetail_MBase;
        this.m_SsidSummary_MCtrl = this.m_SsidSummary_MBase;
        SJmoUtility.putLogDetail("SJmoRscUtilSsid", "clearModelData", "clearModelData End");
    }

    public int getBoundarySsid(SJmoLdevIndex ldevId) {
        int iSsid = 0;
        try {
            int iLdevID = ldevId.getIndex();
            int iSsidBound = iLdevID / this.m_SsidSummary_MCtrl.getSSIDBoundary();
            if (iSsidBound < 0 || iSsidBound > this.m_ldevSsid_Emu.length - 1) {
                SJmoUtility.putLogDetail("SJmoRscUtilSsid", "getBoundarySsid", "iSsidBound = " + iSsidBound);
                throw SJmoUtility.getException(201, 23, 107022, "SJmoRscUtilSsid", "getBoundarySsid:iSsidBound");
            }
            iSsid = this.m_ldevSsid_Emu[iSsidBound];
        }
        catch (Exception e) {
            SJmoUtility.putLogDetail("SJmoRscUtilSsid", "getBoundarySsid", "err:" + e.toString());
            throw SJmoUtility.getException(201, 23, 107021, " SJmoRscUtilSsid", "getBoundarySsid");
        }
        return iSsid;
    }
}

