/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.modelver;

import java.util.ArrayList;
import sanproject.sn2.model.SJmoException;
import sanproject.sn2.model.SJmoModelMgr;
import sanproject.sn2.model.SJmoUtility;
import sanproject.sn2.modelver.SJmoVersionMgr;
import sanproject.sn2.modelver.SJmoVersionRMI;
import sanproject.sn2.modelver.data.SJmoDiffVersion;

public class SJmoNoticeRenew
extends Thread {
    private int m_iRequest;
    private boolean m_bAll;
    SJmoVersionRMI m_verRmi = new SJmoVersionRMI();
    SJmoDiffVersion m_DiffVer;

    public SJmoNoticeRenew(SJmoDiffVersion diffVer, int iRequest, boolean bAll) {
        this.m_DiffVer = diffVer;
        this.m_iRequest = iRequest;
    }

    @Override
    public void run() {
        SJmoUtility.putLogDetail("SJmoNoticeRenew", "run", "Start. Kind:" + this.m_iRequest);
        ArrayList updateList = new ArrayList();
        SJmoModelMgr modelMgr = SJmoModelMgr.getModelMgr();
        SJmoVersionMgr verMgr = modelMgr.getVersionMgr();
        try {
            int iStat = 1;
            modelMgr.delModelException();
            try {
                iStat = verMgr.getSvpConfStat();
            }
            catch (SJmoException cnfExp) {
                String strDetail = "getSvpConfStat failed FuncID=" + cnfExp.getMsg().getFunctionID() + " ModuleID=" + cnfExp.getMsg().getModuleID() + " MsgID=" + cnfExp.getMsg().getMsgID();
                SJmoUtility.putLogDetail("SJmoNoticeRenew", "run", strDetail);
            }
            if (1 != iStat) {
                if (0 != this.m_iRequest) {
                    SJmoUtility.putLogDetail("SJmoNoticeRenew", "run", "refresh demand failed");
                    modelMgr.setModelException(201, 23, 108004);
                } else {
                    SJmoUtility.putLogDetail("SJmoNoticeRenew", "run", "Config recovery action start.");
                    int iRetryCnt = verMgr.getSvpConfRetry();
                    while (3 > iRetryCnt) {
                        verMgr.setSvpConfRetry(++iRetryCnt);
                        SJmoUtility.putLogDetail("SJmoNoticeRenew", "run", "Try count:" + iRetryCnt);
                        try {
                            verMgr.renewRmiServer();
                            iStat = verMgr.getSvpConfStat();
                            if (1 != iStat) {
                                SJmoUtility.putLogDetail("SJmoNoticeRenew", "run", "System does not recovered.retry..");
                                continue;
                            }
                            SJmoUtility.putLogDetail("SJmoNoticeRenew", "run", "Recovery action success.");
                            break;
                        }
                        catch (SJmoException mdlExp) {
                            String strDetail = "Recovery action failed FuncID=" + mdlExp.getMsg().getFunctionID() + " ModuleID=" + mdlExp.getMsg().getModuleID() + " MsgID=" + mdlExp.getMsg().getMsgID();
                            SJmoUtility.putLogDetail("SJmoNoticeRenew", "run", strDetail);
                        }
                    }
                }
            }
            if (1 != iStat) {
                SJmoUtility.putLogDetail("SJmoNoticeRenew", "run", "Config inconsistent. renew skipped");
                verMgr.rsvResult(false, false, null, false, this.m_iRequest);
            } else {
                updateList = this.m_verRmi.getUpdateList(this.m_DiffVer);
                modelMgr.renewDataProc(this.m_iRequest, updateList);
            }
        }
        catch (SJmoException moe) {
            String strDetail = "SJmoException FuncID=" + moe.getMsg().getFunctionID() + " ModuleID=" + moe.getMsg().getModuleID() + " MsgID=" + moe.getMsg().getMsgID();
            SJmoUtility.putLogDetail("SJmoNoticeRenew", "run", strDetail);
            verMgr.rsvResult(false, false, null, false, this.m_iRequest);
        }
        catch (Exception exp) {
            SJmoUtility.putLogDetail("SJmoNoticeRenew", "run", "make RMI List Failed" + exp.toString());
            verMgr.rsvResult(false, false, null, false, this.m_iRequest);
        }
    }
}

