/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.servlet.execapp;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import sanproject.sn2.base.session.SJbaseUserSessionManager;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.SJcProductUty;
import sanproject.sn2.com.utility.SJcSingletonManagerUty;
import sanproject.sn2.sn2com.execapp.SJappDefConst;
import sanproject.sn2.sn2com.execapp.controller.SJapcAppControl;

public class SJsvlStartSVPServlet
extends HttpServlet {
    private final String LOG_FUNCTION = "SJsvlStartSVPServlet";
    private final String LOG_TITLE = ((Object)((Object)this)).getClass().getSimpleName();
    private static String szMsg;
    static final String BAT_PATH = "..\\..\\..\\..\\supervisor\\portmanager\\getmappportno.bat";
    static String HTTP_FUNC_NAME;
    static String HTTPS_FUNC_NAME;
    private static final String FORWARD_URL = "/jsp/jnlp/SJsvlAppStartSVP.jsp";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String LOG_SUBTITLE = "doPost";
        try {
            String globalSessionID = request.getParameter("GID");
            String ticketID = request.getParameter("TID");
            if (globalSessionID == null || globalSessionID.equals("") || ticketID == null || ticketID.equals("")) {
                SJcLogUty.getLogger().error("SJsvlStartSVPServlet", this.LOG_TITLE, "doPost", "param error");
                throw new SJcException();
            }
            SJapcAppControl appctl = this.getAppController(globalSessionID);
            if (appctl == null) {
                szMsg = "Not Found AppController <globalSessionID=" + globalSessionID + ">";
                SJcLogUty.getLogger().error("SJsvlStartSVPServlet", this.LOG_TITLE, "doPost", szMsg);
                throw new SJcException();
            }
            HashMap<String, Object> systemSts = appctl.execStage2(ticketID);
            if (systemSts == null) {
                szMsg = "Fail execStage2 <ticketID=" + ticketID + ">";
                SJcLogUty.getLogger().error("SJsvlStartSVPServlet", this.LOG_TITLE, "doPost", szMsg);
                throw new SJcException();
            }
            String appID = (String)systemSts.get(SJappDefConst.SVP_APP_APPID);
            String appPath = (String)systemSts.get(SJappDefConst.SVP_APP_PATH);
            String appArg = (String)systemSts.get(SJappDefConst.SVP_APP_ARG);
            String liveUrl = (String)systemSts.get(SJappDefConst.SVP_APP_LIVE_URL);
            String syncEnd = (String)systemSts.get(SJappDefConst.SVP_APP_SYNCEND);
            String vendor = SJcProductUty.getVenderName();
            String description = SJcProductUty.getProductName();
            if (appArg == null) {
                appArg = "";
            }
            String hostname = request.getServerName();
            Pattern p = Pattern.compile("((([0-9a-f]{1,4}:){7}([0-9a-f]{1,4}|:))|(([0-9a-f]{1,4}:){6}(:[0-9a-f]{1,4}|((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9a-f]{1,4}:){5}(((:[0-9a-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9a-f]{1,4}:){4}(((:[0-9a-f]{1,4}){1,3})|((:[0-9a-f]{1,4})?:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9a-f]{1,4}:){3}(((:[0-9a-f]{1,4}){1,4})|((:[0-9a-f]{1,4}){0,2}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9a-f]{1,4}:){2}(((:[0-9a-f]{1,4}){1,5})|((:[0-9a-f]{1,4}){0,3}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9a-f]{1,4}:){1}(((:[0-9a-f]{1,4}){1,6})|((:[0-9a-f]{1,4}){0,4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(:(((:[0-9a-f]{1,4}){1,7})|((:[0-9a-f]{1,4}){0,5}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:)))(%.+)?\\s*$");
            Matcher m = p.matcher(hostname);
            if (m.find()) {
                hostname = "[" + hostname + "]";
            }
            String prot = "http";
            String fullLiveUrl = prot + "://" + hostname + ":" + this.getPortNum() + SJappDefConst.URL_BASEHEAD + SJcEnvUty.getDkcRootName() + "/" + liveUrl;
            String codebase = prot + "://" + hostname + ":" + this.getPortNum() + request.getContextPath();
            request.setAttribute(SJappDefConst.SVP_APP_APPID, (Object)appID);
            request.setAttribute(SJappDefConst.SVP_APP_PATH, (Object)appPath);
            request.setAttribute(SJappDefConst.SVP_APP_ARG, (Object)appArg);
            request.setAttribute(SJappDefConst.SVP_APP_TICKETID, (Object)ticketID);
            request.setAttribute(SJappDefConst.SVP_APP_GLOBALID, (Object)globalSessionID);
            request.setAttribute(SJappDefConst.SVP_APP_HOST, (Object)request.getServerName());
            request.setAttribute(SJappDefConst.SVP_APP_CONTEXT, (Object)request.getContextPath());
            request.setAttribute(SJappDefConst.CODEBASE, (Object)codebase);
            request.setAttribute(SJappDefConst.SVP_APP_LIVE_URL, (Object)fullLiveUrl);
            request.setAttribute(SJappDefConst.SVP_APP_SYNCEND, (Object)syncEnd);
            request.setAttribute(SJappDefConst.vendor, (Object)vendor);
            request.setAttribute(SJappDefConst.description, (Object)description);
        }
        catch (Exception ex) {
            SJcLogUty.getLogger().error("SJsvlStartSVPServlet", this.LOG_TITLE, "doPost", "", ex);
            try {
                response.sendError(404);
                return;
            }
            catch (IOException e) {
                SJcLogUty.getLogger().error("SJsvlStartSVPServlet", this.LOG_TITLE, "doPost", "", e);
                return;
            }
        }
        RequestDispatcher dispatch = request.getRequestDispatcher(FORWARD_URL);
        dispatch.forward((ServletRequest)request, (ServletResponse)response);
    }

    protected SJapcAppControl getAppController(String globalSessionID) {
        SJapcAppControl clsRet = null;
        SJbaseUserSessionManager sessionManager = (SJbaseUserSessionManager)SJcSingletonManagerUty.getInstance(SJbaseUserSessionManager.class);
        SJbaseUserSessionInterface userSession = sessionManager.getUserSession(globalSessionID);
        if (userSession != null) {
            clsRet = (SJapcAppControl)userSession.getUserController(SJappDefConst.APPSYSTEM_NAME);
        }
        return clsRet;
    }

    String getPortNum() {
        String LOG_SUBTITLE = "getPortNum";
        String szPort = "80";
        byte[] buffer = new byte[6];
        String BatCmd = "..\\..\\..\\..\\supervisor\\portmanager\\getmappportno.bat " + HTTP_FUNC_NAME;
        try {
            Runtime runtime = Runtime.getRuntime();
            Process p = runtime.exec(BatCmd);
            int iRet = p.waitFor();
            if (iRet >= 0) {
                InputStream is = p.getInputStream();
                byte[] bData = new byte[6];
                int iDataLen = is.available();
                int iReadLen = is.read(bData, 0, iDataLen);
                String sb = new String(bData);
                szPort = sb.substring(0, sb.indexOf("\r\n"));
            }
            p.getInputStream().close();
            p.destroy();
            p = null;
        }
        catch (IOException ex) {
            SJcLogUty.getLogger().error("SJsvlStartSVPServlet", this.LOG_TITLE, "getPortNum", "IOException");
        }
        catch (InterruptedException ex) {
            SJcLogUty.getLogger().error("SJsvlStartSVPServlet", this.LOG_TITLE, "getPortNum", "InterruptedException");
        }
        return szPort;
    }

    static {
        HTTP_FUNC_NAME = "MAPPWebServer";
        HTTPS_FUNC_NAME = "MAPPWebServerHttps";
    }
}

