/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.sn2com.execapp.controller;

import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import sanproject.sn2.base.SJbaseConst;
import sanproject.sn2.base.session.SJbaseUserSession;
import sanproject.sn2.base.session.inf.SJbaseUserCtrInterface;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.plugin.SJcPluginItem;
import sanproject.sn2.com.plugin.SJcPluginList;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.SJcInstanceCreateUty;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.controller.com.data.SJctrRequestDataObject;
import sanproject.sn2.sn2com.execapp.SJappDefConst;
import sanproject.sn2.sn2com.execapp.controller.appdb.SJapcAppDB_Interface;

public class SJapcAppControl
implements SJbaseUserCtrInterface {
    private final String LOG_FUNCTION = "SJctrAppControl";
    private final String LOG_TITLE = this.getClass().getSimpleName();
    private final String LOG_FILENAME = "SN_AppControl.log";
    private static String szMsg;
    private SJbaseUserSessionInterface userSession = null;
    private HashMap<String, SJapcAppDB_Interface> appSystemMap = null;
    private HashMap<String, HashMap<String, Object>> appList = null;
    private HashMap<String, HashMap<String, Object>> stsList = null;
    private Timer timer = null;
    private boolean bTimeout = false;

    @Override
    public void initialize(SJbaseUserSessionInterface clsUserSession) {
        String LOG_SUBTITLE = "initialize";
        try {
            this.appSystemMap = new HashMap();
            this.stsList = new HashMap();
            this.appList = new HashMap();
            this.userSession = clsUserSession;
            String dataPath = SJcFileUty.concatFolderPath(SJcEnvUty.getProperty("SN_DataPath"), "data");
            String systemPath = SJcFileUty.concatFolderPath(dataPath, SJbaseConst.SN_DIRECTORY_BASE_SETTING_SYSTEM);
            String filePath = SJcFileUty.concatFolderPath(systemPath, "AppDB.properties");
            SJcPluginList pluginList = new SJcPluginList();
            pluginList.loadFile(filePath);
            ListIterator<SJcPluginItem> iterator = pluginList.getPluginList().listIterator();
            while (iterator.hasNext()) {
                SJcPluginItem item = iterator.next();
                String key = "";
                key = item.getKey();
                SJapcAppDB_Interface AppDB = (SJapcAppDB_Interface)SJcInstanceCreateUty.newInstance(item.getClassName());
                AppDB.initialize(this);
                this.appSystemMap.put(key, AppDB);
            }
            if (this.appSystemMap.isEmpty()) {
                szMsg = "NoEntry AppDB";
                SJcLogUty.getLogger("SN_AppControl.log").error("SJctrAppControl", this.LOG_TITLE, "initialize", szMsg);
                throw new SJcException();
            }
            this.startTimer();
        }
        catch (SJcException e) {
            throw e;
        }
        catch (Exception e) {
            SJcLogUty.getLogger("SN_AppControl.log").error("SJctrAppControl", this.LOG_TITLE, "initialize", "", e);
            throw new SJcException();
        }
    }

    @Override
    public void finish() {
        String LOG_SUBTITLE = "finish";
        try {
            this.finishTimer();
            this.appSystemMap.clear();
            this.appList.clear();
            this.stsList.clear();
        }
        catch (Exception e) {
            SJcLogUty.getLogger("SN_AppControl.log").error("SJctrAppControl", this.LOG_TITLE, "finish", "", e);
        }
    }

    @Override
    public SJctrRequestDataObject post(SJctrRequestDataObject dataObj) {
        String LOG_SUBTITLE = "post";
        szMsg = "Empty Method";
        SJcLogUty.getLogger("SN_AppControl.log").error("SJctrAppControl", this.LOG_TITLE, "post", szMsg);
        throw new SJcException();
    }

    public SJbaseUserSession getUserSession() {
        return (SJbaseUserSession)this.userSession;
    }

    public HashMap<String, Object> getExecAppInfo(String appID) {
        return this.execStage1(appID);
    }

    private synchronized HashMap<String, Object> execStage1(String appID) {
        String LOG_SUBTITLE = "execStage1";
        HashMap<String, Object> result = null;
        String retTicket = "";
        try {
            HashMap<String, Object> appData;
            String multiFlg;
            szMsg = "execStage1 Start <appID=" + appID + ">";
            SJcLogUty.getLogger("SN_AppControl.log").info("SJctrAppControl", this.LOG_TITLE, "execStage1", szMsg);
            if (appID == null || appID.equals("")) {
                szMsg = "Empty Parameter";
                SJcLogUty.getLogger("SN_AppControl.log").error("SJctrAppControl", this.LOG_TITLE, "execStage1", szMsg);
                throw new SJcException();
            }
            String ticketID = this.getTicketIDFromAppID(appID);
            if (ticketID != null && (multiFlg = (String)(appData = this.appList.get(ticketID)).get(SJappDefConst.SVP_APP_MULTI)).equals(SJappDefConst.SVP_MULTIEXEC_OFF)) {
                szMsg = "Application Exist <appID=" + appID + ">";
                SJcLogUty.getLogger("SN_AppControl.log").error("SJctrAppControl", this.LOG_TITLE, "execStage1", szMsg);
                throw new SJcException();
            }
            result = this.getAppInfo(appID);
            if (result == null) {
                szMsg = "Not Found ApplicationData <appID=" + appID + ">";
                SJcLogUty.getLogger("SN_AppControl.log").error("SJctrAppControl", this.LOG_TITLE, "execStage1", szMsg);
                throw new SJcException();
            }
            retTicket = (String)result.get(SJappDefConst.SVP_APP_TICKETID);
            HashMap<String, Object> stsMap = new HashMap<String, Object>();
            Long currentTime = new Long(System.currentTimeMillis());
            stsMap.put(SJappDefConst.SVP_APP_LIVE_RECENTTIME, currentTime);
            stsMap.put(SJappDefConst.SVP_APP_STS, SJappDefConst.SVP_STS_STAGE1);
            stsMap.put(SJappDefConst.SVP_APP_APPID, appID);
            this.stsList.put(retTicket, stsMap);
            this.appList.put(retTicket, result);
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        catch (SJcException e) {
            throw e;
        }
        catch (Exception e) {
            SJcLogUty.getLogger("SN_AppControl.log").error("SJctrAppControl", this.LOG_TITLE, "execStage1", "", e);
            throw new SJcException();
        }
        finally {
            szMsg = "execStage1 End <appID=" + appID + ", ticketID=" + retTicket + ">";
            SJcLogUty.getLogger("SN_AppControl.log").info("SJctrAppControl", this.LOG_TITLE, "execStage1", szMsg);
        }
    }

    public synchronized HashMap<String, Object> execStage2(String ticketID) {
        String LOG_SUBTITLE = "execStage2";
        HashMap<String, Object> result = null;
        try {
            szMsg = "execStage2 Start <ticketID=" + ticketID + ">";
            SJcLogUty.getLogger("SN_AppControl.log").info("SJctrAppControl", this.LOG_TITLE, "execStage2", szMsg);
            if (ticketID == null || ticketID.equals("")) {
                szMsg = "Empty Parameter";
                SJcLogUty.getLogger("SN_AppControl.log").error("SJctrAppControl", this.LOG_TITLE, "execStage2", szMsg);
                throw new SJcException();
            }
            HashMap<String, Object> stsMap = this.stsList.get(ticketID);
            if (stsMap == null) {
                szMsg = "Not Found ticketID <ticketID=" + ticketID + ">";
                SJcLogUty.getLogger("SN_AppControl.log").error("SJctrAppControl", this.LOG_TITLE, "execStage2", szMsg);
                this.clearAppInfo(ticketID);
                throw new SJcException();
            }
            String nowSts = (String)stsMap.get(SJappDefConst.SVP_APP_STS);
            if (!SJappDefConst.SVP_STS_STAGE1.equals(nowSts)) {
                szMsg = "Sequence Error";
                SJcLogUty.getLogger("SN_AppControl.log").error("SJctrAppControl", this.LOG_TITLE, "execStage2", szMsg);
                throw new SJcException();
            }
            result = this.appList.get(ticketID);
            if (result == null) {
                szMsg = "Not Found ApplicationData <ticketID=" + ticketID + ">";
                SJcLogUty.getLogger("SN_AppControl.log").error("SJctrAppControl", this.LOG_TITLE, "execStage2", szMsg);
                this.clearAppInfo(ticketID);
                throw new SJcException();
            }
            Long currentTime = new Long(System.currentTimeMillis());
            stsMap.put(SJappDefConst.SVP_APP_LIVE_RECENTTIME, currentTime);
            stsMap.put(SJappDefConst.SVP_APP_STS, SJappDefConst.SVP_STS_STAGE2);
            this.stsList.put(ticketID, stsMap);
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        catch (SJcException e) {
            throw e;
        }
        catch (Exception e) {
            SJcLogUty.getLogger("SN_AppControl.log").error("SJctrAppControl", this.LOG_TITLE, "execStage2", "", e);
            throw new SJcException();
        }
        finally {
            szMsg = "execStage2 End <ticketID=" + ticketID + ">";
            SJcLogUty.getLogger("SN_AppControl.log").info("SJctrAppControl", this.LOG_TITLE, "execStage2", szMsg);
        }
    }

    public synchronized String execLive(String ticketID, String sts) {
        String LOG_SUBTITLE = "execLive";
        String result = null;
        try {
            szMsg = "execLive Start <ticketID=" + ticketID + ">";
            SJcLogUty.getLogger("SN_AppControl.log").info("SJctrAppControl", this.LOG_TITLE, "execLive", szMsg);
            if (ticketID == null || ticketID.equals("") || sts == null || sts.equals("")) {
                szMsg = "Empty Parameter";
                SJcLogUty.getLogger("SN_AppControl.log").error("SJctrAppControl", this.LOG_TITLE, "execLive", szMsg);
                throw new SJcException();
            }
            HashMap<String, Object> stsMap = this.stsList.get(ticketID);
            if (stsMap == null) {
                szMsg = "Not Found ticketID <ticketID=" + ticketID + ">";
                SJcLogUty.getLogger("SN_AppControl.log").error("SJctrAppControl", this.LOG_TITLE, "execLive", szMsg);
                this.clearAppInfo(ticketID);
                throw new SJcException();
            }
            szMsg = "Receiving Status <Status=" + sts + ">";
            SJcLogUty.getLogger("SN_AppControl.log").info("SJctrAppControl", this.LOG_TITLE, "execLive", szMsg);
            String nowSts = (String)stsMap.get(SJappDefConst.SVP_APP_STS);
            if (sts.equals(SJappDefConst.SVP_STS_END)) {
                this.clearAppInfo(ticketID);
                result = SJappDefConst.SVP_STS_END;
            } else {
                if (SJappDefConst.SVP_STS_START.equals(sts)) {
                    if (!SJappDefConst.SVP_STS_STAGE2.equals(nowSts)) {
                        szMsg = "Sequence Error";
                        SJcLogUty.getLogger("SN_AppControl.log").error("SJctrAppControl", this.LOG_TITLE, "execLive", szMsg);
                        throw new SJcException();
                    }
                    result = SJappDefConst.SVP_STS_LIVE;
                } else if (SJappDefConst.SVP_STS_LIVE.equals(sts)) {
                    if (!SJappDefConst.SVP_STS_LIVE.equals(nowSts)) {
                        szMsg = "Sequence Error";
                        SJcLogUty.getLogger("SN_AppControl.log").error("SJctrAppControl", this.LOG_TITLE, "execLive", szMsg);
                        throw new SJcException();
                    }
                    result = SJappDefConst.SVP_STS_LIVE;
                } else {
                    szMsg = "Sequence Error:" + sts;
                    SJcLogUty.getLogger("SN_AppControl.log").error("SJctrAppControl", this.LOG_TITLE, "execLive", szMsg);
                    throw new SJcException();
                }
                stsMap.put(SJappDefConst.SVP_APP_STS, result);
                Long currentTime = new Long(System.currentTimeMillis());
                stsMap.put(SJappDefConst.SVP_APP_LIVE_RECENTTIME, currentTime);
                this.stsList.put(ticketID, stsMap);
            }
            szMsg = "Return Status <Status=" + result + ">";
            SJcLogUty.getLogger("SN_AppControl.log").info("SJctrAppControl", this.LOG_TITLE, "execLive", szMsg);
            String string = result;
            return string;
        }
        catch (SJcException e) {
            throw e;
        }
        catch (Exception e) {
            SJcLogUty.getLogger("SN_AppControl.log").error("SJctrAppControl", this.LOG_TITLE, "execLive", "", e);
            throw new SJcException();
        }
        finally {
            szMsg = "execLive End <ticketID=" + ticketID + ">";
            SJcLogUty.getLogger("SN_AppControl.log").info("SJctrAppControl", this.LOG_TITLE, "execLive", szMsg);
        }
    }

    public boolean isExecute() {
        String LOG_SUBTITLE = "isExecute";
        if (this.bTimeout) {
            this.bTimeout = false;
            szMsg = "Check Error.";
            SJcLogUty.getLogger("SN_AppControl.log").error("SJctrAppControl", this.LOG_TITLE, "isExecute", szMsg);
            throw new SJcException("200", "20", "108000");
        }
        return !this.stsList.isEmpty();
    }

    public String getAppStatus(String ticketID) {
        String LOG_SUBTITLE = "getAppStatus";
        String result = null;
        try {
            szMsg = "Start <ticketID=" + ticketID + ">";
            SJcLogUty.getLogger("SN_AppControl.log").info("SJctrAppControl", this.LOG_TITLE, "getAppStatus", szMsg);
            if (ticketID == null || ticketID.equals("")) {
                szMsg = "Empty Parameter";
                SJcLogUty.getLogger("SN_AppControl.log").error("SJctrAppControl", this.LOG_TITLE, "getAppStatus", szMsg);
                throw new SJcException();
            }
            HashMap<String, Object> stsMap = this.stsList.get(ticketID);
            result = stsMap == null ? SJappDefConst.SVP_STS_NONE : (String)stsMap.get(SJappDefConst.SVP_APP_STS);
            String string = result;
            return string;
        }
        catch (SJcException e) {
            throw e;
        }
        catch (Exception e) {
            SJcLogUty.getLogger("SN_AppControl.log").error("SJctrAppControl", this.LOG_TITLE, "getAppStatus", "", e);
            throw new SJcException();
        }
        finally {
            szMsg = "End <ticketID=" + ticketID + ">";
            SJcLogUty.getLogger("SN_AppControl.log").info("SJctrAppControl", this.LOG_TITLE, "getAppStatus", szMsg);
        }
    }

    private HashMap<String, Object> getAppInfo(String appID) {
        String key;
        SJapcAppDB_Interface sysInf;
        HashMap<String, Object> result = null;
        Set<String> set = this.appSystemMap.keySet();
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext() && (result = (sysInf = this.appSystemMap.get(key = iterator.next())).getExecAppInfo(appID)) == null) {
        }
        return result;
    }

    private String getTicketIDFromAppID(String appID) {
        String result = null;
        Set<String> set = this.stsList.keySet();
        for (String key : set) {
            HashMap<String, Object> buf = this.stsList.get(key);
            String appID2 = (String)buf.get(SJappDefConst.SVP_APP_APPID);
            if (!appID.equals(appID2)) continue;
            result = key;
            break;
        }
        return result;
    }

    private void clearAppInfo(String ticketID) {
        if (ticketID != null) {
            this.stsList.remove(ticketID);
            this.appList.remove(ticketID);
        }
    }

    private void startTimer() {
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new ChkTask(this), 0L, SJappDefConst.Live_Period);
    }

    private void finishTimer() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    class ChkTask
    extends TimerTask {
        SJapcAppControl m_appCtr = null;

        ChkTask(SJapcAppControl appCtr) {
            this.m_appCtr = appCtr;
        }

        @Override
        public void run() {
            this.execChk();
        }

        private void execChk() {
            String LOG_SUBTITLE = "execChk";
            try {
                Set set = SJapcAppControl.this.stsList.keySet();
                for (String key : set) {
                    HashMap stsMap = (HashMap)SJapcAppControl.this.stsList.get(key);
                    if (stsMap == null) {
                        szMsg = "Nothing stsMap <ticketID=" + key + ">";
                        SJcLogUty.getLogger("SN_AppControl.log").error("SJctrAppControl", SJapcAppControl.this.LOG_TITLE, "execChk", szMsg);
                        this.m_appCtr.clearAppInfo(key);
                        continue;
                    }
                    String sts = (String)stsMap.get(SJappDefConst.SVP_APP_STS);
                    Long recentTimeL = (Long)stsMap.get(SJappDefConst.SVP_APP_LIVE_RECENTTIME);
                    if (recentTimeL == null) {
                        szMsg = "Nothing RecentTime";
                        SJcLogUty.getLogger("SN_AppControl.log").error("SJctrAppControl", SJapcAppControl.this.LOG_TITLE, "execChk", szMsg);
                        this.m_appCtr.clearAppInfo(key);
                        continue;
                    }
                    long recentTime = recentTimeL;
                    long now = System.currentTimeMillis();
                    long noNotityTime = now - recentTime;
                    long allowTime = SJappDefConst.NoAccess_Allow_Time;
                    if (SJappDefConst.SVP_STS_STAGE1.equals(sts) || SJappDefConst.SVP_STS_STAGE2.equals(sts)) {
                        allowTime = SJappDefConst.NoAccess_Allow_Time_Neg;
                    }
                    if (noNotityTime <= allowTime) continue;
                    szMsg = "Receive Timeout <ticketID=" + key + ">";
                    SJcLogUty.getLogger("SN_AppControl.log").error("SJctrAppControl", SJapcAppControl.this.LOG_TITLE, "execChk", szMsg);
                    this.m_appCtr.clearAppInfo(key);
                    this.m_appCtr.bTimeout = true;
                }
            }
            catch (Exception e) {
                SJcLogUty.getLogger("SN_AppControl.log").error("SJctrAppControl", SJapcAppControl.this.LOG_TITLE, "execChk", "", e);
            }
        }
    }
}

