/*
 * Decompiled with CFR 0.152.
 */
package sanproject.session.server.common;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import sanproject.session.common.SJsessionUty;
import sanproject.session.server.store.SJsessionInfo;
import sanproject.session.server.store.SJsessionInfoApp;
import sanproject.sn2.base.authentication.inf.SJbaseAuthenticationModulePluginInterface;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.account.SJcRoleResourceContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SJsessionServerUty {
    private static final String LOG_FUNCTION = "SessionServer";
    private static final String LOG_TITLE = SJsessionServerUty.class.getSimpleName();

    public static SJcLoggerInterface getLogger() {
        return SJcLogUty.getLogger("SN_Session_Server.log");
    }

    public static boolean checkParams(HashMap<String, Object> info, Object[][] check_item) {
        String LOG_SUBTITLE = "checkParams";
        SJcLoggerInterface logger = SJsessionServerUty.getLogger();
        if (info == null || check_item == null) {
            return false;
        }
        for (Object[] paramObj : check_item) {
            String key = (String)paramObj[0];
            Object value = info.get(key);
            Boolean required = (Boolean)paramObj[2];
            boolean result = SJsessionUty.checkParameter(info, key, (Class)paramObj[1], required);
            if (result) continue;
            if ("AUTHENTICATION_PASSWORD".equals(key)) {
                logger.error(LOG_FUNCTION, LOG_TITLE, "checkParams", "invalid parameter.");
            } else {
                logger.error(LOG_FUNCTION, LOG_TITLE, "checkParams", "invalid parameter:" + key + " is " + value);
            }
            return false;
        }
        return true;
    }

    public static String getSessionPath() {
        String sessionPath = SJcEnvUty.getProperty("SN_SESSION_PATH", "session");
        sessionPath = SJcFileUty.setEndPathSeparator(sessionPath);
        return sessionPath;
    }

    public static String getSessionAbsoluetePath() {
        String dataPath = SJcFileUty.concatFolderPath(SJcEnvUty.getProperty("SN_DataPath"), "data");
        String sessionSubDir = SJcEnvUty.getProperty("SN_SESSION_PATH", "session");
        String sessionPath = SJcFileUty.concatFolderPath(dataPath, sessionSubDir);
        return sessionPath;
    }

    public static String getReceivePath() {
        String sessionPath = SJsessionServerUty.getSessionAbsoluetePath();
        String receivePath = SJcFileUty.concatFolderPath(sessionPath, SJcEnvUty.getProperty("SN_SESSION_RECEIVE_PATH", "receive"));
        return receivePath;
    }

    public static String getProcessPath() {
        String sessionPath = SJsessionServerUty.getSessionAbsoluetePath();
        String processPath = SJcFileUty.concatFolderPath(sessionPath, SJcEnvUty.getProperty("SN_SESSION_PROCESS_PATH", "process"));
        return processPath;
    }

    public static String getDefaultPluginKey() {
        String defaultKey = SJcEnvUty.getProperty("SN_SESSION_DEFAULT_PLUGIN");
        return defaultKey;
    }

    public static HashMap<String, Object> convertToHashMap(SJsessionInfo info) {
        HashMap<String, Object> map = SJsessionServerUty.convertToSessionMap(info);
        HashMap<String, SJsessionInfoApp> loginInfoMap = new HashMap<String, SJsessionInfoApp>(info.getLoginInfoMap());
        ArrayList<HashMap<String, Object>> loginList = new ArrayList<HashMap<String, Object>>();
        for (String appID : loginInfoMap.keySet()) {
            SJsessionInfoApp loginInfo = loginInfoMap.get(appID);
            HashMap<String, Object> storeLogin = SJsessionServerUty.convertToLoginInfoMap(loginInfo);
            loginList.add(storeLogin);
        }
        map.put("LOGININFO", loginList);
        return map;
    }

    public static HashMap<String, Object> convertToHashMap(SJsessionInfo info, String appID) {
        HashMap<String, Object> map = null;
        HashMap<String, Object> loginMap = null;
        SJsessionInfoApp loginInfo = info.getLoginInfo(appID);
        if (loginInfo == null) {
            return map;
        }
        map = SJsessionServerUty.convertToSessionMap(info);
        loginMap = SJsessionServerUty.convertToLoginInfoMap(loginInfo);
        ArrayList<HashMap<String, Object>> loginList = new ArrayList<HashMap<String, Object>>();
        loginList.add(loginMap);
        map.put("LOGININFO", loginList);
        return map;
    }

    private static HashMap<String, Object> convertToSessionMap(SJsessionInfo info) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GLOBALSESSIONID", info.getGlobalSessionID());
        map.put("DISPLAY_USERID", info.getDisplayUserID());
        map.put("USERGROUPS", info.getUserGroups());
        map.put("USER_ROLES", info.getRoleIDs());
        map.put("RESOURCE_GROUP_IDS", info.getRsgIDs());
        map.put("ALL_RSG_FLG", info.isAllRsg());
        map.put("RESOURCE_ROLE", info.getResourceRole());
        map.put("IDENTICAL_USERID", info.getConUniqID());
        map.put("LANG", info.getLang());
        return map;
    }

    private static HashMap<String, Object> convertToLoginInfoMap(SJsessionInfoApp loginInfo) {
        HashMap<String, Object> loginMap = new HashMap<String, Object>();
        loginMap.put("AUTHENTICATION_USERID", loginInfo.getUserID());
        loginMap.put("APPLICATIONID", loginInfo.getAppID());
        loginMap.put("LOGINTYPE", loginInfo.getLoginType());
        loginMap.put("USER_IDENTICALNAME", loginInfo.getUserUniqueID());
        loginMap.put("AUTHENTICATION_NAME", loginInfo.getAuthName());
        loginMap.put("ADDRESS", loginInfo.getAddress());
        loginMap.put("LOGINTIME", loginInfo.getLoginTime());
        loginMap.put("AUTHENTICATION_OBJECT", loginInfo.getAuthObject());
        return loginMap;
    }

    public static SJsessionInfo convertToSessionInfo(HashMap<String, Object> map, SJbaseAuthenticationModulePluginInterface authInstance, String password) {
        SJsessionInfo session = new SJsessionInfo();
        session.setGlobalSessionID((String)map.get("GLOBALSESSIONID"));
        session.setDisplayUserID((String)map.get("DISPLAY_USERID"));
        session.setUserGroups((String[])map.get("USERGROUPS"));
        session.setRoleIDs((String[])map.get("USER_ROLES"));
        session.setRsgIDs((boolean[])map.get("RESOURCE_GROUP_IDS"));
        Boolean allRsgFlg = (Boolean)map.get("ALL_RSG_FLG");
        if (allRsgFlg != null) {
            session.setAllRsg(allRsgFlg);
        }
        session.setResourceRole((SJcRoleResourceContainer)map.get("RESOURCE_ROLE"));
        session.setConUniqID((Integer)map.get("IDENTICAL_USERID"));
        session.setLang((String)map.get("LANG"));
        SJsessionInfoApp loginInfo = SJsessionServerUty.convertToLoginInfo(map, authInstance, password);
        session.setLoginInfo(loginInfo.getAppID(), loginInfo);
        return session;
    }

    public static SJsessionInfoApp convertToLoginInfo(HashMap<String, Object> map, SJbaseAuthenticationModulePluginInterface authInstance, String password) {
        SJsessionInfoApp loginInfo = new SJsessionInfoApp();
        loginInfo.setUserID((String)map.get("AUTHENTICATION_USERID"));
        loginInfo.setPassword(password);
        loginInfo.setAppID((String)map.get("APPLICATIONID"));
        loginInfo.setLoginType((String)map.get("LOGINTYPE"));
        loginInfo.setUserUniqueID((String)map.get("USER_IDENTICALNAME"));
        loginInfo.setAuthName((String)map.get("AUTHENTICATION_NAME"));
        loginInfo.setAuthInstance(authInstance);
        loginInfo.setAddress((String)map.get("ADDRESS"));
        loginInfo.setLoginTime((Date)map.get("LOGINTIME"));
        loginInfo.setAliveLastTime(SJsessionServerUty.getSystemTime());
        loginInfo.setReauthTime(new Date());
        loginInfo.setAuthObject(map.get("AUTHENTICATION_OBJECT"));
        return loginInfo;
    }

    public static SJsessionInfo changeSessionInfo(SJsessionInfo base, SJsessionInfo info) {
        base.setGlobalSessionID(info.getGlobalSessionID());
        base.setDisplayUserID(info.getDisplayUserID());
        base.setUserGroups(info.getUserGroups());
        base.setRoleIDs(info.getRoleIDs());
        base.setRsgIDs(info.getRsgIDs());
        base.setAllRsg(info.isAllRsg());
        base.setResourceRole(info.getResourceRole());
        base.setConUniqID(info.getConUniqID());
        base.setLang(info.getLang());
        return base;
    }

    public static long getSystemTime() {
        return System.nanoTime() / 1000000L;
    }
}

