/*
 * Decompiled with CFR 0.152.
 */
package sanproject.session.server.process;

import java.util.Date;
import java.util.HashMap;
import sanproject.session.common.exception.SJsessionAuthenticationException;
import sanproject.session.common.exception.SJsessionException;
import sanproject.session.server.common.SJsessionServerUty;
import sanproject.session.server.process.SJsessionProcessBase;
import sanproject.session.server.store.SJsessionInfo;
import sanproject.session.server.store.SJsessionInfoApp;
import sanproject.session.server.unique.SJsessionUniqueIDManager;
import sanproject.sn2.base.authentication.SJbaseAuthenticationSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SJsessionProcessSSOBase
extends SJsessionProcessBase {
    SJsessionInfo session = null;
    SJsessionInfoApp loginInfo = null;
    protected String SSO_AppID = "StorageNavigator2";

    public SJsessionProcessSSOBase(String appID, String loginType) {
        super(appID, loginType);
    }

    @Override
    protected boolean execAuthentication() throws SJsessionAuthenticationException {
        String LOG_SUBTITLE = "execAuthentication";
        this.logger.trace("SessionServer", this.LOG_TITLE, "execAuthentication", "Start.");
        boolean ret = false;
        String gsid = this.getGlocalSessionID();
        this.session = super.getSession(gsid);
        if (this.isReLogin()) {
            this.logger.trace("SessionServer", this.LOG_TITLE, "execAuthentication", "End.");
            return true;
        }
        if (this.session == null) {
            this.logger.error("SessionServer", this.LOG_TITLE, "execAuthentication", "Session not found. GSID:" + gsid);
            ret = false;
        } else {
            this.loginInfo = this.session.getLoginInfo(this.SSO_AppID);
            if (this.loginInfo == null) {
                this.logger.error("SessionServer", this.LOG_TITLE, "execAuthentication", "Parent's login info not found. GSID:" + gsid + " APP:" + this.SSO_AppID);
                ret = false;
            } else {
                this.logger.info("SessionServer", this.LOG_TITLE, "execAuthentication", "SSO login successful. GSID:" + gsid);
                ret = true;
            }
        }
        this.logger.trace("SessionServer", this.LOG_TITLE, "execAuthentication", "End.");
        return ret;
    }

    @Override
    protected SJbaseAuthenticationSystem getAuthBase() throws SJsessionAuthenticationException {
        return null;
    }

    @Override
    protected String getGlocalSessionID() {
        String gsid = null;
        gsid = this.isReLogin() ? (String)this.loginEntry.get("GLOBALSESSIONID") : (String)this.loginEntry.get("AUTHENTICATION_PASSWORD");
        return gsid;
    }

    @Override
    protected HashMap<String, Object> createLoginResultInfo(String gsid) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.isReLogin()) {
            result = new HashMap(this.loginEntry);
            result.remove("AUTHENTICATION_PASSWORD");
            return result;
        }
        result.put("AUTHENTICATION_USERID", this.loginInfo.getUserID());
        result.put("LOGINTYPE", this.loginEntry.get("LOGINTYPE"));
        result.put("LANG", this.session.getLang());
        result.put("ADDRESS", this.loginInfo.getAddress());
        result.put("APPLICATIONID", this.appID);
        result.put("GLOBALSESSIONID", gsid);
        result.put("USER_IDENTICALNAME", this.loginInfo.getUserUniqueID());
        result.put("DISPLAY_USERID", this.session.getDisplayUserID());
        result.put("LOGINTIME", new Date());
        result.put("AUTHENTICATION_NAME", this.getAuthName());
        String[] usergroupid = this.session.getUserGroups();
        String[] roleid = this.session.getRoleIDs();
        boolean[] rsgid = this.session.getRsgIDs();
        boolean allrsg = this.session.isAllRsg();
        if (null != roleid && null != rsgid) {
            result.put("USERGROUPS", new String[]{""});
            result.put("RESOURCE_ROLE", this.session.getResourceRole());
            result.put("USER_ROLES", roleid);
            result.put("RESOURCE_GROUP_IDS", rsgid);
            result.put("ALL_RSG_FLG", allrsg);
        } else if (null != usergroupid) {
            result.put("USERGROUPS", usergroupid);
            result.put("RESOURCE_ROLE", this.session.getResourceRole());
        }
        result.put("AUTHENTICATION_OBJECT", null);
        return result;
    }

    @Override
    protected int getUniqueID(String gsid) throws SJsessionException {
        String LOG_SUBTITLE = "getUniqueID";
        int uniqueID = 0;
        if (this.isReLogin()) {
            SJsessionUniqueIDManager idMgr = SJsessionUniqueIDManager.getIDManager(this.SSO_AppID);
            if (idMgr == null) {
                return uniqueID;
            }
            Integer uniqueIDI = (Integer)this.loginEntry.get("IDENTICAL_USERID");
            uniqueID = uniqueIDI;
            idMgr.reAssignment(uniqueID, gsid);
        } else {
            this.logger.warn("SessionServer", this.LOG_TITLE, "getUniqueID", "In SSO, new login cannot be performed.");
        }
        return uniqueID;
    }

    @Override
    protected void addSessionInfo(HashMap<String, Object> authResult, String password) throws SJsessionException {
        if (this.isSessionInsert()) {
            SJsessionInfo sesInfo = SJsessionServerUty.convertToSessionInfo(authResult, null, password);
            this.store.addSession(sesInfo);
        }
    }

    @Override
    protected void chgSessionInfo(String gsid, HashMap<String, Object> authResult, String password) throws SJsessionException {
        if (this.isSessionInsert()) {
            SJsessionInfoApp infoApp = SJsessionServerUty.convertToLoginInfo(authResult, null, password);
            this.store.chgSession(gsid, infoApp);
        }
    }

    @Override
    protected SJsessionInfo getSession(String gsid) {
        return this.session;
    }

    protected String getAuthName() {
        return null;
    }
}

