/*
 * Decompiled with CFR 0.152.
 */
package sanproject.session.server.process.plugin;

import java.util.HashMap;
import java.util.ListIterator;
import sanproject.session.server.common.SJsessionServerUty;
import sanproject.session.server.process.plugin.SJsessionProcessPluginItem;
import sanproject.session.server.process.plugin.SJsessionProcessPluginList;
import sanproject.sn2.com.plugin.SJcPluginItem;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SJsessionProcessPluginManager {
    private static final String LOG_FUNCTION = "SessionServer";
    private static final String LOG_TITLE = SJsessionProcessPluginManager.class.getSimpleName();
    private static SJcLoggerInterface logger = SJsessionServerUty.getLogger();
    private static HashMap<String, HashMap<String, SJsessionProcessPluginItem>> processModulePlugin = new HashMap();

    public static void registProcessModulePlugins(String appid) {
        String LOG_SUBTITLE = "registProcessModulePlugins";
        logger.trace(LOG_FUNCTION, LOG_TITLE, "registProcessModulePlugins", "Start.");
        String filePath = SJsessionProcessPluginManager.getFilePath(appid);
        SJsessionProcessPluginList pluginList = new SJsessionProcessPluginList();
        pluginList.loadFile(filePath);
        HashMap<String, SJsessionProcessPluginItem> processMap = new HashMap<String, SJsessionProcessPluginItem>();
        ListIterator<SJcPluginItem> iterator = pluginList.getPluginList().listIterator();
        while (iterator.hasNext()) {
            SJsessionProcessPluginItem item = null;
            try {
                item = (SJsessionProcessPluginItem)iterator.next();
            }
            catch (ClassCastException cce) {
                logger.error(LOG_FUNCTION, LOG_TITLE, "registProcessModulePlugins", "Item class is invald.", cce);
                continue;
            }
            if (!SJsessionProcessPluginManager.checkPluginItem(item)) continue;
            String loginType = item.getKey();
            processMap.put(loginType, item);
        }
        if (0 < processMap.size()) {
            processModulePlugin.put(appid, processMap);
        } else {
            logger.info(LOG_FUNCTION, LOG_TITLE, "registProcessModulePlugins", "Not found plugin info. -appid:" + appid);
        }
        logger.trace(LOG_FUNCTION, LOG_TITLE, "registProcessModulePlugins", "End.");
    }

    private static String getFilePath(String appid) {
        String fileName = appid + ".properties";
        String processPath = SJsessionServerUty.getProcessPath();
        String filePath = processPath + fileName;
        return filePath;
    }

    private static boolean checkPluginItem(SJsessionProcessPluginItem item) {
        String LOG_SUBTITLE = "checkPluginItem";
        logger.trace(LOG_FUNCTION, LOG_TITLE, "checkPluginItem", "Start.");
        if (item == null || item.getName() == null || item.getClassName() == null || item.getAuthName() == null) {
            logger.error(LOG_FUNCTION, LOG_TITLE, "checkPluginItem", "Plugin item is invald.");
            return false;
        }
        logger.trace(LOG_FUNCTION, LOG_TITLE, "checkPluginItem", "End.");
        return true;
    }

    public static HashMap<String, SJsessionProcessPluginItem> getPluginItemMap(String appID) {
        HashMap<String, SJsessionProcessPluginItem> map = processModulePlugin.get(appID);
        return map;
    }

    public static SJsessionProcessPluginItem getPluginItem(String appID, String loginType) {
        SJsessionProcessPluginItem item = null;
        String defaultKey = SJsessionServerUty.getDefaultPluginKey();
        HashMap<String, SJsessionProcessPluginItem> map = processModulePlugin.get(appID);
        if (map != null) {
            item = map.get(loginType);
        }
        if (item == null && defaultKey != null && (map = processModulePlugin.get(defaultKey)) != null) {
            item = map.get(defaultKey);
        }
        return item;
    }
}

